% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{degPlotCluster}
\alias{degPlotCluster}
\title{Plot clusters from degPattern function output}
\usage{
degPlotCluster(
  table,
  time,
  color = NULL,
  min_genes = 10,
  process = FALSE,
  points = TRUE,
  boxes = TRUE,
  smooth = TRUE,
  lines = TRUE,
  facet = TRUE,
  cluster_column = "cluster",
  prefix_title = "Group: "
)
}
\arguments{
\item{table}{\code{normalized} element from \code{\link[=degPatterns]{degPatterns()}} output.
It can be a data.frame with the following columns in there:
\verb{genes, sample, expression, cluster, xaxis_column, color_column}.}

\item{time}{column name to use in the x-axis.}

\item{color}{column name to use to color and divide the samples.}

\item{min_genes}{minimum number of genes to be added to the plot.}

\item{process}{whether to process the table if it is not
ready for plotting.}

\item{points}{Add points to the plot.}

\item{boxes}{Add boxplot to the plot.}

\item{smooth}{Add regression line to the plot.}

\item{lines}{Add gene lines to the plot.}

\item{facet}{Split figures based on cluster ID.}

\item{cluster_column}{column name if cluster is in a column
with a different name. Usefull, to plot cluster with different
cutoffs used when grouping genes from the clustering step.}

\item{prefix_title}{text to add before the cluster ID in the figure title.}
}
\value{
\link{ggplot2} object.
}
\description{
This function helps to format the cluster plots from \code{\link[=degPatterns]{degPatterns()}}.
It allows to control the layers and it returns a ggplot object that
can accept more ggplot functions to allow customization.
}
\examples{
data(humanGender)
library(SummarizedExperiment)
library(ggplot2)
ma <- assays(humanGender)[[1]][1:100,]
des <- colData(humanGender)
des[["other"]] <- sample(c("a", "b"), 85, replace = TRUE)
res <- degPatterns(ma, des, time="group", col = "other", plot = FALSE)
degPlotCluster(res$normalized, "group", "other")
degPlotCluster(res$normalized, "group", "other", lines = FALSE)

library(dplyr)
library(tidyr)
library(tibble)
table <- rownames_to_column(as.data.frame(ma), "genes") \%>\%
    gather("sample", "expression", -genes) \%>\%
    right_join(distinct(res$df[,c("genes", "cluster")]),
               by = "genes") \%>\%
    left_join(rownames_to_column(as.data.frame(des), "sample"),
              by = "sample") \%>\% 
              as.data.frame()
degPlotCluster(table, "group", "other", process = TRUE)
}
