% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\docType{methods}
\name{fpm}
\alias{fpm}
\title{FPM: fragments per million mapped fragments}
\usage{
fpm(object, robust = TRUE)
}
\arguments{
\item{object}{a \code{DESeqDataSet}}

\item{robust}{whether to use size factors to normalize
rather than taking the column sums of the raw counts.
If TRUE, the size factors and the geometric mean of
column sums are multiplied to create a robust library size estimate.
Robust normalization is not used if average transcript lengths are present.}
}
\value{
a matrix which is normalized per million of mapped fragments,
either using the robust median ratio method (robust=TRUE, default)
or using raw counts (robust=FALSE).
}
\description{
Calculates either a robust version (default)
or the traditional matrix of fragments/counts per million mapped
fragments (FPM/CPM).
Note: this function is written very simply and
can be easily altered to produce other behavior by examining the source code.
}
\examples{

# generate a dataset with size factors: .5, 1, 1, 2
dds <- makeExampleDESeqDataSet(m = 4, n = 1000,
                               interceptMean=log2(1e3),
                               interceptSD=0,
                               sizeFactors=c(.5,1,1,2),
                               dispMeanRel=function(x) .01)

# add a few rows with very high count
counts(dds)[4:10,] <- 2e5L

# in this robust version, the counts are comparable across samples
round(head(fpm(dds), 3))

# in this column sum version, the counts are still skewed:
# sample1 < sample2 & 3 < sample 4
round(head(fpm(dds, robust=FALSE), 3))

# the column sums of the robust version
# are not equal to 1e6, but the
# column sums of the non-robust version
# are equal to 1e6 by definition

colSums(fpm(dds))/1e6
colSums(fpm(dds, robust=FALSE))/1e6

}
\seealso{
\code{\link{fpkm}}
}
