% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeExampleData.R
\name{makeExampleData}
\alias{makeExampleData}
\title{make an example multi-view data set for illustration of MOFA}
\usage{
makeExampleData(n_views = 3, n_features = 100, n_samples = 50,
  n_factors = 5, likelihood = "gaussian")
}
\arguments{
\item{n_views}{number of views}

\item{n_features}{number of features in each view}

\item{n_samples}{number of samples}

\item{n_factors}{number of factors}

\item{likelihood}{likelihood for each view, one of "gaussian", "bernoulli", "poisson",
or a character vector of length n_views}
}
\value{
Returns an untrained \code{\link{MOFAmodel}} containing simulated data as training data.
}
\description{
Function to simulate an example multi-view data set according to the generative model of MOFA.
}
\examples{

# Generate a data set
MOFAexample <- makeExampleData()
str(MOFAexample)
}
