% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsce.R
\name{ggcells}
\alias{ggcells}
\alias{ggfeatures}
\title{Create a ggplot from a SingleCellExperiment}
\usage{
ggcells(
  x,
  mapping = aes(),
  features = NULL,
  exprs_values = "logcounts",
  use_dimred = TRUE,
  use_altexps = FALSE,
  prefix_altexps = FALSE,
  check_names = TRUE,
  extract_mapping = TRUE,
  ...
)

ggfeatures(
  x,
  mapping = aes(),
  cells = NULL,
  exprs_values = "logcounts",
  check_names = TRUE,
  extract_mapping = TRUE,
  ...
)
}
\arguments{
\item{x}{A \linkS4class{SingleCellExperiment} object.
This is expected to have row names for \code{ggcells} and column names for \code{ggfeatures}.}

\item{mapping}{A list containing aesthetic mappings, usually the output of \code{\link{aes}} or related functions.}

\item{features}{Character vector specifying the features for which to extract expression profiles across cells.
May also include features in alternative Experiments if permitted by \code{use_altexps}.}

\item{exprs_values}{Soft-deprecated equivalents of the arguments described above.}

\item{use_dimred}{Soft-deprecated equivalents of the arguments described above.}

\item{use_altexps}{Soft-deprecated equivalents of the arguments described above.}

\item{prefix_altexps}{Soft-deprecated equivalents of the arguments described above.}

\item{check_names}{Soft-deprecated equivalents of the arguments described above.}

\item{extract_mapping}{Logical scalar indicating whether \code{features} or \code{cells} should be automatically expanded to include variables referenced in \code{mapping}.}

\item{...}{Further arguments to pass to \link{ggplot}.}

\item{cells}{Character vector specifying the features for which to extract expression profiles across cells.}
}
\value{
A \link{ggplot} object containing the specified contents of \code{x}.
}
\description{
Create a base \link{ggplot} object from a \linkS4class{SingleCellExperiment},
the contents of which can be directly referenced in subsequent layers without prior specification.
}
\details{
These functions generate a data.frame from the contents of a \linkS4class{SingleCellExperiment} and pass it to \code{\link{ggplot}}.
Rows, columns or metadata fields in the \code{x} can then be referenced in subsequent \pkg{ggplot2} commands.

\code{ggcells} treats cells as the data values so users can reference row names of \code{x} (if provided in \code{features}), column metadata variables and dimensionality reduction results.
They can also reference row names and metadata variables for alternative Experiments.

\code{ggfeatures} treats features as the data values so users can reference column names of \code{x} (if provided in \code{cells}) and row metadata variables.

If \code{mapping} is supplied, the function will automatically expand \code{features} or \code{cells} for any features or cells requested in the mapping.
This is convenient as features/cells do not have to specified twice (once in data.frame construction and again in later \code{geom} or \code{stat} layers).
Developers may wish to turn this off with \code{extract_mapping=FALSE} for greater control.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)
example_sce <- runPCA(example_sce)

ggcells(example_sce, aes(x=PCA.1, y=PCA.2, color=Gene_0001)) +
    geom_point()

ggcells(example_sce, aes(x=Mutation_Status, y=Gene_0001)) +
    geom_violin() +
    facet_wrap(~Cell_Cycle)

rowData(example_sce)$GC <- runif(nrow(example_sce))
ggfeatures(example_sce, aes(x=GC, y=Cell_001)) +
    geom_point() +
    stat_smooth()

}
\seealso{
\code{\link{makePerCellDF}} and \code{\link{makePerFeatureDF}}, for the construction of the data.frame.
}
\author{
Aaron Lun
}
