% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark.R
\name{summary.bench_mark}
\alias{summary.bench_mark}
\title{Summarize \link{mark} results.}
\usage{
\method{summary}{bench_mark}(object, filter_gc = TRUE, relative = FALSE, time_unit = NULL, ...)
}
\arguments{
\item{object}{\link{bench_mark} object to summarize.}

\item{filter_gc}{If \code{TRUE} remove iterations that contained at least one
garbage collection before summarizing. If \code{TRUE} but an expression had
a garbage collection in every iteration, filtering is disabled, with a warning.}

\item{relative}{If \code{TRUE} all summaries are computed relative to the minimum
execution time rather than absolute time.}

\item{time_unit}{If \code{NULL} the times are reported in a human readable
fashion depending on each value. If one of 'ns', 'us', 'ms', 's', 'm', 'h',
'd', 'w' the time units are instead expressed as nanoseconds, microseconds,
milliseconds, seconds, hours, minutes, days or weeks respectively.}

\item{...}{Additional arguments ignored.}
}
\value{
A \link[tibble:tibble]{tibble} with the additional summary columns.
The following summary columns are computed
\itemize{
\item \code{expression} - \code{bench_expr} The deparsed expression that was evaluated
(or its name if one was provided).
\item \code{min} - \code{bench_time} The minimum execution time.
\item \code{median} - \code{bench_time} The sample median of execution time.
\item \code{itr/sec} - \code{double} The estimated number of executions performed per
second.
\item \code{mem_alloc} - \code{bench_bytes} Total amount of memory allocated by R while
running the expression. Memory allocated \emph{outside} the R heap, e.g. by
\code{malloc()} or \code{new} directly is \emph{not} tracked, take care to avoid
misinterpreting the results if running code that may do this.
\item \code{gc/sec} - \code{double} The number of garbage collections per second.
\item \code{n_itr} - \code{integer} Total number of iterations after filtering
garbage collections (if \code{filter_gc == TRUE}).
\item \code{n_gc} - \code{double} Total number of garbage collections performed over all
iterations. This is a psudo-measure of the pressure on the garbage collector, if
it varies greatly between to alternatives generally the one with fewer
collections will cause fewer allocation in real usage.
\item \code{total_time} - \code{bench_time} The total time to perform the benchmarks.
\item \code{result} - \code{list} A list column of the object(s) returned by the
evaluated expression(s).
\item \code{memory} - \code{list} A list column with results from \code{\link[=Rprofmem]{Rprofmem()}}.
\item \code{time} - \code{list} A list column of \code{bench_time} vectors for each evaluated
expression.
\item \code{gc} - \code{list} A list column with tibbles containing the level of
garbage collection (0-2, columns) for each iteration (rows).
}
}
\description{
Summarize \link{mark} results.
}
\details{
If \code{filter_gc == TRUE} (the default) runs that contain a garbage
collection will be removed before summarizing. This is most useful for fast
expressions when the majority of runs do not contain a gc. Call
\code{summary(filter_gc = FALSE)} if you would like to compute summaries \emph{with}
these times, such as expressions with lots of allocations when all or most
runs contain a gc.
}
\examples{
dat <- data.frame(x = runif(10000, 1, 1000), y=runif(10000, 1, 1000))

# `bench::mark()` implicitly calls summary() automatically
results <- bench::mark(
  dat[dat$x > 500, ],
  dat[which(dat$x > 500), ],
  subset(dat, x > 500))

# However you can also do so explicitly to filter gc differently.
summary(results, filter_gc = FALSE)

# Or output relative times
summary(results, relative = TRUE)
}
