% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accordion.R
\name{accordion}
\alias{accordion}
\alias{accordion_panel}
\title{Create a vertically collapsing accordion}
\usage{
accordion(
  ...,
  id = NULL,
  open = NULL,
  multiple = TRUE,
  class = NULL,
  width = NULL,
  height = NULL
)

accordion_panel(title, ..., value = title, icon = NULL)
}
\arguments{
\item{...}{Named arguments become attributes on the \verb{<div class="accordion">}
element. Unnamed arguments should be \code{accordion_panel()}s.}

\item{id}{If provided, you can use \code{input$id} in your server logic to
determine which of the \code{accordion_panel()}s are currently active. The value
will correspond to the \code{accordion_panel()}'s \code{value} argument.}

\item{open}{A character vector of \code{accordion_panel()} \code{value}s to open
(i.e., show) by default. The default value of \code{NULL} will open the first
\code{accordion_panel()}. Use a value of \code{TRUE} to open all (or \code{FALSE} to
open none) of the items. It's only possible to open more than one panel
when \code{multiple=TRUE}.}

\item{multiple}{Whether multiple \code{accordion_panel()} can be \code{open} at once.}

\item{class}{Additional CSS classes to include on the accordion div.}

\item{width, height}{Any valid CSS unit; for example, height="100\%".}

\item{title}{A title to appear in the \code{accordion_panel()}'s header.}

\item{value}{A character string that uniquely identifies this panel.}

\item{icon}{A \link[htmltools:builder]{htmltools::tag} child (e.g., \code{\link[bsicons:bs_icon]{bsicons::bs_icon()}}) which is positioned just before the \code{title}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

An accordion can be used to organize UI elements and content in a limited
space. It comprises multiple, vertically stacked panels that expand or
collapse when clicked, providing a compact layout that works well for
grouping input elements in a \code{\link[=sidebar]{sidebar()}} or for organizing detailed
context-specific information.
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
items <- lapply(LETTERS, function(x) {
  accordion_panel(paste("Section", x), paste("Some narrative for section", x))
})

# First shown by default
accordion(!!!items)
# Nothing shown by default
accordion(!!!items, open = FALSE)
# Everything shown by default
accordion(!!!items, open = TRUE)

# Show particular sections
accordion(!!!items, open = "Section B")
accordion(!!!items, open = c("Section A", "Section B"))

# Provide an id to create a shiny input binding
library(shiny)

ui <- page_fluid(
  accordion(!!!items, id = "acc")
)

server <- function(input, output) {
  observe(print(input$acc))
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\references{
bslib's accordion component is derived from the \href{https://getbootstrap.com/docs/5.3/components/accordion/}{Bootstrap Accordion component}.
Accordions are also featured on the bslib website:
\itemize{
\item \href{https://rstudio.github.io/bslib/articles/dashboards/index.html#accordions}{Get Started: Dashboards}
\item \href{https://rstudio.github.io/bslib/articles/dashboards/index.html#accordions}{Sidebars: Accordions}
}
}
\seealso{
\code{\link[=accordion_panel_set]{accordion_panel_set()}}, \code{\link[=accordion_panel_open]{accordion_panel_open()}} and
\code{\link[=accordion_panel_close]{accordion_panel_close()}} programmatically interact with the state of an
accordion panel.

\code{\link[=accordion_panel_insert]{accordion_panel_insert()}}, \code{\link[=accordion_panel_remove]{accordion_panel_remove()}} and
\code{\link[=accordion_panel_update]{accordion_panel_update()}} add or remove accordion panels from an
accordion.

Other Components: 
\code{\link{card}()},
\code{\link{popover}()},
\code{\link{tooltip}()},
\code{\link{value_box}()}
}
\concept{Components}
