% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_diverging.R
\name{scale_colour_continuous_diverging}
\alias{scale_colour_continuous_diverging}
\alias{scale_color_continuous_diverging}
\alias{scale_fill_continuous_diverging}
\title{HCL-Based Continuous Diverging Color Scales for ggplot2}
\usage{
scale_colour_continuous_diverging(palette = NULL, c1 = NULL,
  cmax = NULL, l1 = NULL, l2 = NULL, h1 = NULL, h2 = NULL,
  p1 = NULL, p2 = NULL, rev = FALSE, mid = 0,
  na.value = "grey50", guide = "colourbar", n_interp = 11,
  aesthetics = "colour", ...)

scale_color_continuous_diverging(palette = NULL, c1 = NULL,
  cmax = NULL, l1 = NULL, l2 = NULL, h1 = NULL, h2 = NULL,
  p1 = NULL, p2 = NULL, rev = FALSE, mid = 0,
  na.value = "grey50", guide = "colourbar", n_interp = 11,
  aesthetics = "colour", ...)

scale_fill_continuous_diverging(..., aesthetics = "fill")
}
\arguments{
\item{palette}{The name of the palette to be used. Run \code{hcl_palettes(type = "diverging")} for available options.}

\item{c1}{Chroma value at the scale endpoints.}

\item{cmax}{Maximum chroma value.}

\item{l1}{Luminance value at the scale endpoints.}

\item{l2}{Luminance value at the scale midpoint.}

\item{h1}{Hue value at the first endpoint.}

\item{h2}{Hue value at the second endpoint.}

\item{p1}{Control parameter determining how chroma should vary (1 = linear, 2 = quadratic, etc.).}

\item{p2}{Control parameter determining how luminance should vary (1 = linear, 2 = quadratic, etc.).}

\item{rev}{If \code{TRUE}, reverses the order of the colors in the color scale.}

\item{mid}{Data value that should be mapped to the mid-point of the diverging color scale.}

\item{na.value}{Color to be used for missing data points.}

\item{guide}{Type of legend. Use \code{"colourbar"} for continuous color bar.}

\item{n_interp}{Number of discrete colors that should be used to interpolate the continuous color scale.
It is important to use an odd number to capture the color at the midpoint.}

\item{aesthetics}{The ggplot2 aesthetics to which this scale should be applied.}

\item{...}{common continuous scale parameters: `name`, `breaks`, `labels`, and `limits`. See
\code{\link[ggplot2]{continuous_scale}} for more details.}
}
\description{
Continuous ggplot2 color scales using the color palettes generated by \code{\link{diverging_hcl}}.
}
\details{
If both a valid palette name and palette parameters are provided then the provided palette parameters overwrite the parameters in the
named palette. This enables easy customization of named palettes.
}
\examples{
# adapted from stackoverflow: https://stackoverflow.com/a/20127706/4975218

library("ggplot2")

# generate dataset and base plot
set.seed(100)
df <- data.frame(country = LETTERS, V = runif(26, -40, 40))
df$country = factor(LETTERS, LETTERS[order(df$V)]) # reorder factors
gg <- ggplot(df, aes(x = country, y = V, fill = V)) +
  geom_bar(stat = "identity") +
  labs(y = "Under/over valuation in \%", x = "Country") +
  coord_flip() + theme_minimal()
  
# plot with default diverging scale
gg + scale_fill_continuous_diverging()

# plot with alternative scale
gg + scale_fill_continuous_diverging(palette = "Purple-Green")

# plot with modified alternative scale
gg + scale_fill_continuous_diverging(palette = "Blue-Red 3", l1 = 30, l2 = 100, p1 = .9, p2 = 1.2)
}
