% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-fill.R
\name{fill.tbl_lazy}
\alias{fill.tbl_lazy}
\title{Fill in missing values with previous or next value}
\usage{
\method{fill}{tbl_lazy}(.data, ..., .direction = c("down", "up", "updown", "downup"))
}
\arguments{
\item{.data}{A lazy data frame backed by a database query.}

\item{...}{Columns to fill.}

\item{.direction}{Direction in which to fill missing values. Currently
either "down" (the default) or "up". Note that "up" does not work when
\code{.data} is sorted by non-numeric columns. As a workaround revert the order
yourself beforehand; for example replace \code{arrange(x, desc(y))} by
\code{arrange(desc(x), y)}.}
}
\description{
Fill in missing values with previous or next value
}
\examples{
\dontshow{if (rlang::is_installed("tidyr", version = "1.0.0")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
squirrels <- tibble::tribble(
  ~group,    ~name,     ~role,     ~n_squirrels, ~ n_squirrels2,
  1,      "Sam",    "Observer",   NA,                 1,
  1,     "Mara", "Scorekeeper",    8,                NA,
  1,    "Jesse",    "Observer",   NA,                NA,
  1,      "Tom",    "Observer",   NA,                 4,
  2,     "Mike",    "Observer",   NA,                NA,
  2,  "Rachael",    "Observer",   NA,                 6,
  2,  "Sydekea", "Scorekeeper",   14,                NA,
  2, "Gabriela",    "Observer",   NA,                NA,
  3,  "Derrick",    "Observer",   NA,                NA,
  3,     "Kara", "Scorekeeper",    9,                 10,
  3,    "Emily",    "Observer",   NA,                NA,
  3, "Danielle",    "Observer",   NA,                NA
)
squirrels$id <- 1:12

tbl_memdb(squirrels) \%>\%
  window_order(id) \%>\%
  tidyr::fill(
    n_squirrels,
    n_squirrels2,
  )
\dontshow{\}) # examplesIf}
}
