% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R, R/print.effectsize_table.R
\name{plot.effectsize_table}
\alias{plot.effectsize_table}
\alias{print.effectsize_table}
\alias{print_md.effectsize_table}
\alias{print_html.effectsize_table}
\alias{format.effectsize_table}
\alias{print.effectsize_difference}
\title{Methods for \code{{effectsize}} Tables}
\usage{
\method{plot}{effectsize_table}(x, ...)

\method{print}{effectsize_table}(x, digits = 2, use_symbols = getOption("es.use_symbols", FALSE), ...)

\method{print_md}{effectsize_table}(x, digits = 2, use_symbols = getOption("es.use_symbols", FALSE), ...)

\method{print_html}{effectsize_table}(
  x,
  digits = 2,
  use_symbols = getOption("es.use_symbols", FALSE),
  ...
)

\method{format}{effectsize_table}(
  x,
  digits = 2,
  output = c("text", "markdown", "html"),
  use_symbols = getOption("es.use_symbols", FALSE),
  ...
)

\method{print}{effectsize_difference}(x, digits = 2, append_CLES = NULL, ...)
}
\arguments{
\item{x}{Object to print.}

\item{...}{Arguments passed to or from other functions.}

\item{digits}{Number of digits for rounding or significant figures. May also
be \code{"signif"} to return significant figures or \code{"scientific"}
to return scientific notation. Control the number of digits by adding the
value as suffix, e.g. \code{digits = "scientific4"} to have scientific
notation with 4 decimal places, or \code{digits = "signif5"} for 5
significant figures (see also \code{\link[=signif]{signif()}}).}

\item{use_symbols}{Should proper symbols be printed (\code{TRUE}) instead of
transliterated effect size names (\code{FALSE}). See \link{effectsize_options}.}

\item{output}{Which output is the formatting intended for? Affects how title
and footers are formatted.}

\item{append_CLES}{Which Common Language Effect Sizes should be printed as
well? Only applicable to Cohen's \emph{d}, Hedges' \emph{g} for independent samples
of equal variance (pooled sd) or for the rank-biserial correlation for
independent samples (See \link{d_to_cles}).}
}
\description{
Printing, formatting and plotting methods for \code{effectsize} tables.
}
\section{Plotting with \code{see}}{

The \code{see} package contains relevant plotting functions. See the \href{https://easystats.github.io/see/articles/effectsize.html}{plotting vignette in the \code{see} package}.
}

\seealso{
\code{\link[insight:display]{insight::display()}}
}
