test_that("max_flow works", {
  E <- rbind(c(1, 3, 3), c(3, 4, 1), c(4, 2, 2), c(1, 5, 1), c(5, 6, 2), c(6, 2, 10))
  colnames(E) <- c("from", "to", "capacity")
  g1 <- graph_from_data_frame(as.data.frame(E))
  fl <- max_flow(g1, source = "1", target = "2")
  expect_equal(fl$value, 2)
  expect_equal(as.vector(fl$flow), rep(1, 6))
  expect_equal(sort(as.vector(fl$cut)), c(2, 4))
  expect_equal(sort(as.vector(fl$partition1)), 1:2)
  expect_equal(sort(as.vector(fl$partition2)), 3:6)
})
