% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warning.R
\name{last_lifecycle_warnings}
\alias{last_lifecycle_warnings}
\title{Display last deprecation warnings}
\usage{
last_lifecycle_warnings()
}
\description{
\code{last_lifecycle_warnings()} returns a list of all warnings that
occurred during the last top-level R command, along with a
backtrace.

Use \code{print(last_lifecycle_warnings(), simplify = level)} to control
the verbosity of the backtrace. The \code{simplify} argument supports
one of \code{"branch"} (the default), \code{"collapse"}, and \code{"none"} (in
increasing order of verbosity).
}
\examples{
# These examples are not run because `last_lifecycle_warnings()` does not
# work well within knitr and pkgdown
\dontrun{

f <- function() invisible(g())
g <- function() list(h(), i())
h <- function() deprecate_warn("1.0.0", "this()")
i <- function() deprecate_warn("1.0.0", "that()")
f()

# Print all the warnings that occurred during the last command:
last_lifecycle_warnings()


# By default, the backtraces are printed in their simplified form.
# Use `simplify` to control the verbosity:
print(last_lifecycle_warnings(), simplify = "none")

}
}
