#' @title parameters: Extracting, Computing and Exploring the Parameters of Statistical Models using R
#'
#' @description
#'
#' **parameters**' primary goal is to provide utilities for processing the
#' parameters of various statistical models (see [here](https://easystats.github.io/insight/)
#' for a list of supported models). Beyond computing *p-values*, *CIs*,
#' *Bayesian indices* and other measures for a wide variety of models, this
#' package implements features like *bootstrapping* of parameters and models,
#' *feature reduction* (feature extraction and variable selection), or tools for
#' data reduction like functions to perform cluster, factor or principal
#' component analysis.
#'
#' Another important goal of the **parameters** package is to facilitate and
#' streamline the process of reporting results of statistical models, which
#' includes the easy and intuitive calculation of standardized estimates or
#' robust standard errors and p-values. **parameters** therefor offers a
#' simple and unified syntax to process a large variety of (model) objects
#' from many different packages.
#'
#' References: Lüdecke et al. (2020) \doi{10.21105/joss.02445}
#'
#' @docType package
#' @aliases parameters-package
#' @name parameters-package
#' @keywords internal
"_PACKAGE"
