\name{randpop.nb}
\alias{randpop.nb}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Simulation of presence-absence matrices (non-clustered)}
\description{
  Generates a simulated matrix where the rows are interpreted as regions
  and the columns as species, 1 means that a species is present in the
  region and 0 means that the species is absent. Species are generated
  i.i.d.. Spatial autocorrelation of a species' presences is governed by
  the parameter \code{p.nb} and a list of neighbors for each region.
}
\usage{
randpop.nb(neighbors, p.nb = 0.5, n.species, n.regions =
length(neighbors), vector.species = rep(1, n.species),
species.fixed = FALSE, pdf.regions = rep(1/n.regions, n.regions),
count = TRUE, pdfnb = FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{neighbors}{A list with a component for every region. The
    components are vectors of integers indicating
    neighboring regions. A region without neighbors (e.g., an island)
    should be assigned a list \code{numeric(0)}.}
  \item{p.nb}{numerical between 0 and 1. The probability that a new
    region is drawn from the non-neighborhood of the previous regions
    belonging to a species under generation. Note that for a given
    presence-absence matrix, this parameter can be estimated by
    \code{autoconst} (called \code{pd} there).}
  \item{n.species}{integer. Number of species.}
  \item{n.regions}{integer. Number of regions.}
  \item{vector.species}{vector of integers. If
    \code{species.fixed=TRUE}, \code{vector.species} must have length
    \code{n.species} and gives the sizes (i.e., numbers of regions) of
    the species to generate. Else, the sizes are generated randomly from
    the empirical distribution of \code{vector.species}.}
  \item{species.fixed}{logical. See \code{vector.species}.}
  \item{pdf.regions}{numerical vector of length \code{n.species}. The
    entries must sum up to 1 and give probabilities for the regions to
    be drawn during the generation of a species. These probabilities are
    used conditional on the new region being a neighbor or a
    non-neighbor of the previous regions of the species, see
    \code{p.nb}.}
  \item{count}{logical. If \code{TRUE}, the number of the currently
    generated species is printed.}
  \item{pdfnb}{logical. If \code{TRUE}, the probabilities of the regions
    are modified according to the number of neighboring regions by
    dividing them relative to the others by min(1,number of neighbors).}
}
\details{
  The principle is that a single species with given size is generated
  one-by-one region. The first region is drawn according to
  \code{pdf.regions}. For all following regions, a neighbor or
  non-neighbor of the previous configuration is added (if possible),
  as explained in \code{pdf.regions}, \code{p.nb}.  
}
\value{
  A 0-1-matrix, rows are regions, columns are species.
}
\references{
Hennig, C. and Hausdorf, B. (2004) Distance-based parametric bootstrap
tests for clustering of species ranges. \emph{Computational Statistics
  and
  Data Analysis} 45, 875-896.
\url{http://stat.ethz.ch/Research-Reports/110.html}.

Hausdorf, B. and Hennig, C. (2003)  Biotic Element Analysis in
Biogeography. \emph{Systematic Biology} 52, 717-723.

Hausdorf, B. and Hennig, C. (2003) Nestedness of nerth-west European
land snail ranges as a consequence of differential immigration from
Pleistocene glacial refuges. \emph{Oecologia} 135, 102-109.

}

\author{Christian Hennig
  \email{christian.hennig@unibo.it}
  \url{https://www.unibo.it/sitoweb/christian.hennig/en}}

\seealso{
  \code{\link{autoconst}} estimates \code{p.nb} from matrices of class
  \code{prab}. These are generated by \code{\link{prabinit}}.
  
  \code{\link{prabtest}} uses \code{randpop.nb} as a null model for
  tests of clustering. An alternative model is given by
  \code{\link{cluspop.nb}}.  
}

\examples{
data(nb)
set.seed(2346)
randpop.nb(nb, p.nb=0.1, n.species=5, vector.species=c(1,10,20,30,34))
}
\keyword{spatial}% at least one, from doc/KEYWORDS

