% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazyFactorCoding.R
\name{lazyFactorCoding}
\alias{lazyFactorCoding}
\title{Efficient coding of factor levels}
\usage{
lazyFactorCoding(data, max.levels = 10)
}
\arguments{
\item{data}{Data frame in which to search for categorical variables.}

\item{max.levels}{Treat non-factor variables only if the number of unique values less than max.levels. Defaults to 10.}
}
\value{
R-code one line for each variable.
}
\description{
This function eases the process of generating factor variables
with relevant labels. All variables in a data.frame with less than
a user set number of levels result in a line which suggests levels and
labels. The result can then be modified for use.
}
\details{
The code needs to be copy-and-pasted from the R-output
buffer into the R-code buffer. This can be customized
for the really efficiently working people e.g. in emacs.
}
\examples{
data(Diabetes)
lazyFactorCoding(Diabetes)

}
\author{
Thomas Alexander Gerds
}
