% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep.R
\name{keep_at}
\alias{keep_at}
\alias{discard_at}
\title{Keep/discard elements based on their name/position}
\usage{
keep_at(x, at)

discard_at(x, at)
}
\arguments{
\item{x}{A list or atomic vector.}

\item{at}{A logical, integer, or character vector giving the elements
to select. Alternatively, a function that takes a vector of names,
and returns a logical, integer, or character vector of elements to select.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}: if the tidyselect package is
installed, you can use \code{vars()} and tidyselect helpers to select
elements.}
}
\description{
Keep/discard elements based on their name/position
}
\examples{
x <- c(a = 1, b = 2, cat = 10, dog = 15, elephant = 5, e = 10)
x \%>\% keep_at(letters)
x \%>\% discard_at(letters)

# Can also use a function
x \%>\% keep_at(~ nchar(.x) == 3)
x \%>\% discard_at(~ nchar(.x) == 3)
}
\seealso{
\code{\link[=keep]{keep()}}/\code{\link[=discard]{discard()}} to keep/discard elements by value.
}
