% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{dbGetInfo}
\alias{dbGetInfo}
\alias{dbGetInfo,SQLiteConnection-method}
\alias{dbGetInfo,SQLiteDriver-method}
\alias{dbGetInfo,SQLiteResult-method}
\title{Get metadata about a database object.}
\usage{
\S4method{dbGetInfo}{SQLiteDriver}(dbObj)

\S4method{dbGetInfo}{SQLiteConnection}(dbObj)

\S4method{dbGetInfo}{SQLiteResult}(dbObj)
}
\arguments{
\item{dbObj}{An object of class \code{\linkS4class{SQLiteDriver}},
\code{\linkS4class{SQLiteConnection}} or
\code{\linkS4class{SQLiteResult}}}
}
\description{
Get metadata about a database object.
}
\examples{
dbGetInfo(SQLite())

con <- dbConnect(SQLite())
dbGetInfo(con)

dbWriteTable(con, "mtcars", mtcars)
rs <- dbSendQuery(con, "SELECT * FROM mtcars")
dbGetInfo(rs)
dbFetch(rs, 1)
dbGetInfo(rs)

dbClearResult(rs)
dbDisconnect(con)
}

