% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{Progress}
\alias{Progress}
\title{Reporting progress (object-oriented API)}
\description{
Reporting progress (object-oriented API)

Reporting progress (object-oriented API)
}
\details{
Reports progress to the user during long-running operations.

This package exposes two distinct programming APIs for working with
progress. \code{\link[=withProgress]{withProgress()}} and \code{\link[=setProgress]{setProgress()}}
together provide a simple function-based interface, while the
\code{Progress} reference class provides an object-oriented API.

Instantiating a \code{Progress} object causes a progress panel to be
created, and it will be displayed the first time the \code{set}
method is called. Calling \code{close} will cause the progress panel
to be removed.

As of version 0.14, the progress indicators use Shiny's new notification API.
If you want to use the old styling (for example, you may have used customized
CSS), you can use \code{style="old"} each time you call
\code{Progress$new()}. If you don't want to set the style each time
\code{Progress$new} is called, you can instead call
\code{\link[=shinyOptions]{shinyOptions(progress.style="old")}} just once, inside the server
function.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  plotOutput("plot")
)

server <- function(input, output, session) {
  output$plot <- renderPlot({
    progress <- Progress$new(session, min=1, max=15)
    on.exit(progress$close())

    progress$set(message = 'Calculation in progress',
                 detail = 'This may take a while...')

    for (i in 1:15) {
      progress$set(value = i)
      Sys.sleep(0.5)
    }
    plot(cars)
  })
}

shinyApp(ui, server)
}
}
\seealso{
\code{\link[=withProgress]{withProgress()}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Progress-new}{\code{Progress$new()}}
\item \href{#method-Progress-set}{\code{Progress$set()}}
\item \href{#method-Progress-inc}{\code{Progress$inc()}}
\item \href{#method-Progress-getMin}{\code{Progress$getMin()}}
\item \href{#method-Progress-getMax}{\code{Progress$getMax()}}
\item \href{#method-Progress-getValue}{\code{Progress$getValue()}}
\item \href{#method-Progress-close}{\code{Progress$close()}}
\item \href{#method-Progress-clone}{\code{Progress$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Progress-new"></a>}}
\if{latex}{\out{\hypertarget{method-Progress-new}{}}}
\subsection{Method \code{new()}}{
Creates a new progress panel (but does not display it).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Progress$new(
  session = getDefaultReactiveDomain(),
  min = 0,
  max = 1,
  style = getShinyOption("progress.style", default = "notification")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{The Shiny session object, as provided by \code{shinyServer} to
the server function.}

\item{\code{min}}{The value that represents the starting point of the progress
bar. Must be less than \code{max}.}

\item{\code{max}}{The value that represents the end of the progress bar. Must be
greater than \code{min}.}

\item{\code{style}}{Progress display style. If \code{"notification"} (the default),
the progress indicator will show using Shiny's notification API. If
\code{"old"}, use the same HTML and CSS used in Shiny 0.13.2 and below (this
is for backward-compatibility).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Progress-set"></a>}}
\if{latex}{\out{\hypertarget{method-Progress-set}{}}}
\subsection{Method \code{set()}}{
Updates the progress panel. When called the first time, the
progress panel is displayed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Progress$set(value = NULL, message = NULL, detail = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Single-element numeric vector; the value at which to set the
progress bar, relative to \code{min} and \code{max}. \code{NULL} hides the progress
bar, if it is currently visible.}

\item{\code{message}}{A single-element character vector; the message to be
displayed to the user, or \code{NULL} to hide the current message (if any).}

\item{\code{detail}}{A single-element character vector; the detail message to be
displayed to the user, or \code{NULL} to hide the current detail message (if
any). The detail message will be shown with a de-emphasized appearance
relative to \code{message}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Progress-inc"></a>}}
\if{latex}{\out{\hypertarget{method-Progress-inc}{}}}
\subsection{Method \code{inc()}}{
Like \code{set}, this updates the progress panel. The difference
is that \code{inc} increases the progress bar by \code{amount}, instead of
setting it to a specific value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Progress$inc(amount = 0.1, message = NULL, detail = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{amount}}{For the \code{inc()} method, a numeric value to increment the
progress bar.}

\item{\code{message}}{A single-element character vector; the message to be
displayed to the user, or \code{NULL} to hide the current message (if any).}

\item{\code{detail}}{A single-element character vector; the detail message to be
displayed to the user, or \code{NULL} to hide the current detail message (if
any). The detail message will be shown with a de-emphasized appearance
relative to \code{message}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Progress-getMin"></a>}}
\if{latex}{\out{\hypertarget{method-Progress-getMin}{}}}
\subsection{Method \code{getMin()}}{
Returns the minimum value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Progress$getMin()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Progress-getMax"></a>}}
\if{latex}{\out{\hypertarget{method-Progress-getMax}{}}}
\subsection{Method \code{getMax()}}{
Returns the maximum value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Progress$getMax()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Progress-getValue"></a>}}
\if{latex}{\out{\hypertarget{method-Progress-getValue}{}}}
\subsection{Method \code{getValue()}}{
Returns the current value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Progress$getValue()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Progress-close"></a>}}
\if{latex}{\out{\hypertarget{method-Progress-close}{}}}
\subsection{Method \code{close()}}{
Removes the progress panel. Future calls to \code{set} and
\code{close} will be ignored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Progress$close()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Progress-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Progress-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Progress$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
