% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple-encrypt.R
\name{Simple encryption}
\alias{Simple encryption}
\alias{simple_encrypt}
\alias{simple_decrypt}
\title{Anonymous Public-key Encryption (Sealed Box)}
\usage{
simple_encrypt(msg, pubkey)

simple_decrypt(bin, key)
}
\arguments{
\item{msg}{message to be encrypted}

\item{pubkey}{public key of the receiver}

\item{bin}{encrypted ciphertext}

\item{key}{private key of the receiver}
}
\description{
Create an encrypted message (sealed box) from a curve25519 public key.
}
\details{
Simple public key encryption allows for sending anonymous encrypted messages to
a recipient given its public key. Only the recipient can decrypt these messages,
using its private key.

While the recipient can verify the integrity of the message, it cannot verify the
identity of the sender. For sending authenticated encrypted messages, use
\link{auth_encrypt} and \link{auth_decrypt}.
}
\examples{
# Generate keypair
key <- keygen()
pub <- pubkey(key)

# Encrypt message with pubkey
msg <- serialize(iris, NULL)
ciphertext <- simple_encrypt(msg, pub)

# Decrypt message with private key
out <- simple_decrypt(ciphertext, key)
stopifnot(identical(out, msg))
}
\references{
\url{http://doc.libsodium.org/public-key_cryptography/sealed_boxes.html}
}
