% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pad.R
\name{stri_pad_both}
\alias{stri_pad_both}
\alias{stri_pad_left}
\alias{stri_pad_right}
\alias{stri_pad}
\title{Pad (Center/Left/Right Align) a String}
\usage{
stri_pad_both(
  str,
  width = floor(0.9 * getOption("width")),
  pad = " ",
  use_length = FALSE
)

stri_pad_left(
  str,
  width = floor(0.9 * getOption("width")),
  pad = " ",
  use_length = FALSE
)

stri_pad_right(
  str,
  width = floor(0.9 * getOption("width")),
  pad = " ",
  use_length = FALSE
)

stri_pad(
  str,
  width = floor(0.9 * getOption("width")),
  side = c("left", "right", "both"),
  pad = " ",
  use_length = FALSE
)
}
\arguments{
\item{str}{character vector}

\item{width}{integer vector giving minimal output string lengths}

\item{pad}{character vector giving padding code points}

\item{use_length}{single logical value; should the number of code
points be used instead of the total code point width
 (see \code{\link{stri_width}})?}

\item{side}{[\code{stri_pad} only] single character string;
sides on which padding character is added
(\code{left}, \code{right}, or \code{both})}
}
\value{
Returns a character vector.
}
\description{
Add multiple \code{pad} characters at the given \code{side}(s) of each string
so that each output string is of total width of at least \code{width}.
These functions may be used to center or left/right-align each string.
}
\details{
Vectorized over \code{str}, \code{width}, and \code{pad}.
Each string in \code{pad} should consist of a code points of total width
equal to 1 or, if \code{use_length} is \code{TRUE}, exactly one code point.

\code{stri_pad} is a convenience function, which dispatches
to \code{stri_pad_*}.

Note that Unicode code points may have various widths when
printed on the console and that, by default, the function takes that
into account. By changing the state of the \code{use_length}
argument, this function starts acting like each code point
was of width 1. This feature should rather be used with
text in Latin script.

See \code{\link{stri_trim_left}} (among others) for reverse operation.
Also check out \code{\link{stri_wrap}} for line wrapping.
}
\examples{
stri_pad_left("stringi", 10, pad="#")
stri_pad_both("stringi", 8:12, pad="*")
# center on screen:
cat(stri_pad_both(c("the", "string", "processing", "package"),
   getOption("width")*0.9), sep='\n')
cat(stri_pad_both(c("\ud6c8\ubbfc\uc815\uc74c", # takes width into account
   stri_trans_nfkd("\ud6c8\ubbfc\uc815\uc74c"), "abcd"),
   width=10), sep="\n")
}
