% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wormsid.R
\name{get_wormsid}
\alias{get_wormsid}
\alias{as.wormsid}
\alias{as.wormsid.wormsid}
\alias{as.wormsid.character}
\alias{as.wormsid.list}
\alias{as.wormsid.numeric}
\alias{as.wormsid.data.frame}
\alias{as.data.frame.wormsid}
\alias{get_wormsid_}
\title{Get Worms ID for a taxon name}
\usage{
get_wormsid(query, searchtype = "scientific", accepted = FALSE,
  ask = TRUE, verbose = TRUE, rows = NA, ...)

as.wormsid(x, check = TRUE)

\method{as.wormsid}{wormsid}(x, check = TRUE)

\method{as.wormsid}{character}(x, check = TRUE)

\method{as.wormsid}{list}(x, check = TRUE)

\method{as.wormsid}{numeric}(x, check = TRUE)

\method{as.wormsid}{data.frame}(x, check = TRUE)

\method{as.data.frame}{wormsid}(x, ...)

get_wormsid_(query, verbose = TRUE, searchtype = "scientific",
  accepted = TRUE, rows = NA, ...)
}
\arguments{
\item{query}{character; A vector of common or scientific names.}

\item{searchtype}{character; One of 'scientific' or 'common', or any unique
abbreviation}

\item{accepted}{logical; If TRUE, removes names that are not accepted valid
names by WORMS. Set to \code{FALSE} (default) to give back both accepted
and unaccepted names.}

\item{ask}{logical; should get_wormsid be run in interactive mode?
If \code{TRUE} and more than one wormsid is found for the species, the
user is asked for input. If \code{FALSE} NA is returned for
multiple matches.}

\item{verbose}{logical; should progress be printed?}

\item{rows}{numeric; Any number from 1 to infinity. If the default NaN, all
rows are considered. Note that this function still only gives back a wormsid
class object with one to many identifiers. See
\code{\link[taxize]{get_wormsid_}} to get back all, or a subset, of the raw
data that you are presented during the ask process.}

\item{...}{Ignored}

\item{x}{Input to as.wormsid}

\item{check}{logical; Check if ID matches any existing on the DB, only
used in \code{\link{as.wormsid}}}
}
\value{
A vector of taxonomic identifiers as an S3 class.
If a taxon is not found an \code{NA} is given. If more than one identifier
is found the function asks for user input if \code{ask = TRUE}, otherwise
returns \code{NA}. If \code{ask=FALSE} and \code{rows} does not equal
\code{NA}, then a data.frame is given back, but not of the uid class, which
you can't pass on to other functions as you normally can.

See \code{\link{get_id_details}} for further details including
attributes and exceptions
}
\description{
Retrieve Worms ID of a taxon from World Register of Marine
Species (WORMS).
}
\examples{
\dontrun{
(x <- get_wormsid('Platanista gangetica'))
attributes(x)
attr(x, "match")
attr(x, "multiple_matches")
attr(x, "pattern_match")
attr(x, "uri")

get_wormsid('Gadus morhua')
get_wormsid('Pomatomus saltatrix')
get_wormsid(c("Platanista gangetica", "Lichenopora neapolitana"))

# by common name
get_wormsid("dolphin", 'common')
get_wormsid("clam", 'common')

# specify rows to limit choices available
get_wormsid('Plat')
get_wormsid('Plat', rows=1)
get_wormsid('Plat', rows=1:2)

# When not found
get_wormsid("howdy")
get_wormsid(c('Gadus morhua', "howdy"))

# Convert a wormsid without class information to a wormsid class
# already a wormsid, returns the same
as.wormsid(get_wormsid('Gadus morhua'))
# same
as.wormsid(get_wormsid(c('Gadus morhua', 'Pomatomus saltatrix')))
# numeric
as.wormsid(126436)
# numeric vector, length > 1
as.wormsid(c(126436,151482))
# character
as.wormsid("126436")
# character vector, length > 1
as.wormsid(c("126436","151482"))
# list, either numeric or character
as.wormsid(list("126436","151482"))
## dont check, much faster
as.wormsid("126436", check=FALSE)
as.wormsid(126436, check=FALSE)
as.wormsid(c("126436","151482"), check=FALSE)
as.wormsid(list("126436","151482"), check=FALSE)

(out <- as.wormsid(c(126436,151482)))
data.frame(out)
as.wormsid( data.frame(out) )

# Get all data back
get_wormsid_("Plat")
get_wormsid_("Plat", rows=1)
get_wormsid_("Plat", rows=1:2)
get_wormsid_("Plat", rows=1:75)
# get_wormsid_(c("asdfadfasd","Plat"), rows=1:5)
}
}
\seealso{
\code{\link[taxize]{classification}}

Other taxonomic-ids: \code{\link{get_boldid}},
  \code{\link{get_colid}}, \code{\link{get_eolid}},
  \code{\link{get_gbifid}}, \code{\link{get_ids}},
  \code{\link{get_iucn}}, \code{\link{get_natservid}},
  \code{\link{get_nbnid}}, \code{\link{get_tolid}},
  \code{\link{get_tpsid}}, \code{\link{get_tsn}},
  \code{\link{get_uid}}, \code{\link{get_wiki}}
}
