% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/first.R, R/last.R
\name{first}
\alias{first}
\alias{first.default}
\alias{first.xts}
\alias{last}
\alias{last.default}
\alias{last.xts}
\title{Return First or Last n Elements of A Data Object}
\usage{
first(x, ...)

\method{first}{default}(x, n = 1, keep = FALSE, ...)

\method{first}{xts}(x, n = 1, keep = FALSE, ...)

last(x, ...)

\method{last}{default}(x, n = 1, keep = FALSE, ...)

\method{last}{xts}(x, n = 1, keep = FALSE, ...)
}
\arguments{
\item{x}{An object.}

\item{\dots}{Arguments passed to other methods.}

\item{n}{Number of observations to return.}

\item{keep}{Should removed values be kept as an attribute on the result?}
}
\value{
A subset of elements/rows of the original data.
}
\description{
Generic functions to return the first or last elements or rows of a vector
or two-dimensional data object.
}
\details{
A more advanced subsetting is available for zoo objects with indexes
inheriting from POSIXt or Date classes.

Quickly and easily extract the first or last \code{n} observations of an object.
When \code{n} is a number, these functions are similar to \code{\link[=head]{head()}} and
\code{\link[=tail]{tail()}}, but only return the \emph{first} or \emph{last} observation by default.

\code{n} can be a character string if \code{x} is an xts object or coerceable to xts.
It must be of the form \sQuote{n period}, where 'n' is a numeric value
(1 if not provided) describing the number of periods to return. Valid
periods are: secs, seconds, mins, minutes, hours, days, weeks, months,
quarters, and years.

The 'period' portion can be any frequency greater than or equal to the
frequency of the object's time index. For example, \code{first(x, "2 months")}
will return the first 2 months of data even if \code{x} is hourly frequency.
Attempts to set 'period' to a frequency less than the object's frequency
will throw an error.

\code{n} may be positive or negative, whether it's a number or character string.
When \code{n} is positive, the functions return the obvious result. For example,
\code{first(x, "1 month")} returns the first month's data. When \code{n} is negative,
all data \emph{except} first month's is returned.

Requesting more data than is in \code{x} will throw a warning and simply return
\code{x}.
}
\examples{

first(1:100)
last(1:100)

data(LakeHuron)
first(LakeHuron,10)
last(LakeHuron)

x <- xts(1:100, Sys.Date()+1:100)
first(x, 10)
first(x, '1 day')
first(x, '4 days')
first(x, 'month')
last(x, '2 months')
last(x, '6 weeks')

}
\author{
Jeffrey A. Ryan
}
\keyword{utilities}
