#define _GNU_SOURCE
#include <string.h>
#include <stdio.h>
#include <stddef.h>
#include <errno.h>
#include <assert.h>

#include "cgen.h"
#include "buf.h"
#include "config/debug.h"

int main() {
  char init[] = "aaaa";
  char buf[] = "aaaa";
  char good5[] = "b\0aa";
  char good2[] = "b\0aa";
  char good1[] = "\0aaa";
  char good0[] = "aaaa";

  char* ptr;
  size_t len, old_len, i;
  int ret;

  ptr = buf;
  old_len = len = sizeof(buf);
  ret = format_buf(&ptr, &len, "b");

  assert(ret == 0 && errno == 0);
  assert(len == old_len - 2);
  assert(ptr == buf+2);
  for(i = 0; i < sizeof(buf); i++)
    assert(buf[i] == good5[i]);

  for(i = 0; i < sizeof(buf); i++)
    buf[i] = init[i];

  ptr = buf;
  old_len = len = 2;
  ret = format_buf(&ptr, &len, "b");

  assert(ret == 0 && errno == 0);
  assert(len == old_len - 2);
  assert(ptr == buf+2);
  for(i = 0; i < sizeof(buf); i++)
    assert(buf[i] == good2[i]);

  for(i = 0; i < sizeof(buf); i++)
    buf[i] = init[i];

  ptr = buf;
  old_len = len = 1;
  ret = format_buf(&ptr, &len, "b");

  assert(ret == 1 && errno == ERANGE);
  assert(len == old_len);
  assert(ptr == buf);
  for(i = 0; i < sizeof(buf); i++)
    assert(buf[i] == good1[i]);

  for(i = 0; i < sizeof(buf); i++)
    buf[i] = init[i];

  ptr = buf;
  old_len = len = 0;
  ret = format_buf(&ptr, &len, "b");

  assert(ret == 1 && errno == ERANGE);
  assert(len == old_len);
  assert(ptr == buf);
  for(i = 0; i < sizeof(buf); i++)
    assert(buf[i] == good0[i]);

  for(i = 0; i < sizeof(buf); i++)
    buf[i] = init[i];

  return 0;
}

