///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef/field_vf_assembly.h"
namespace rheolef {

// TODO: could replace space::dis_idof(K, dis_idx)
template <class T, class M>
void
assembly_dis_idof (
  const space_basic<T,M>&              X,
  const geo_basic<T,M>&                dom,
  const geo_element&                   bgd_K,
  std::vector<geo_element::size_type>& dis_idx)
{
  typedef geo_element::size_type size_type;
  size_type map_d = bgd_K.dimension();

  // space defined on dom : goes from bgd_K to K=dom_K
  const geo_element* K_ptr = 0;
  bool have_bgd_dom = (X.get_geo().variant() == geo_abstract_base_rep<T>::geo_domain && X.get_geo().name() != dom.name());
  if (!have_bgd_dom) {
    K_ptr = &bgd_K;
  } else {
#ifdef TO_CLEAN
    const geo_element& dom_K = bgd2dom_geo_element (X.get_geo(), bgd_K);
#endif // TO_CLEAN
    const geo_element& dom_K = X.get_geo().bgd2dom_geo_element (bgd_K);
    K_ptr = &dom_K;
  }
  const geo_element& K = *K_ptr;

  // non-DG case:
  bool is_dg = (!X.get_numbering().is_continuous() && map_d < X.get_geo().map_dimension());
  if (!is_dg) {
    X.dis_idof (K, dis_idx);
    return;
  }
  // DG case:
  size_type dis_ie0 = K.master(0),
            dis_ie1 = K.master(1);
  check_macro (dis_ie0 != std::numeric_limits<size_type>::max(),
          "unexpected isolated mesh side K="<<K);
  if (dis_ie1 == std::numeric_limits<size_type>::max()) {
    // boundary side K
    const geo_element& L = X.get_geo().dis_get_geo_element (map_d+1, dis_ie0);
    X.dis_idof (L, dis_idx);
  } else {
    // internal side K
    const geo_element& L0 = X.get_geo().dis_get_geo_element (map_d+1, dis_ie0);
    const geo_element& L1 = X.get_geo().dis_get_geo_element (map_d+1, dis_ie1);
    std::vector<size_type> dis_idx0, dis_idx1;
    X.dis_idof (L0, dis_idx0);
    X.dis_idof (L1, dis_idx1);
    size_t loc_ndof0 = dis_idx0.size(),
           loc_ndof1 = dis_idx1.size();
    dis_idx.resize (loc_ndof0 + loc_ndof1);
    for (size_t iloc = 0; iloc < loc_ndof0; iloc++) dis_idx[iloc]           = dis_idx0[iloc];
    for (size_t iloc = 0; iloc < loc_ndof1; iloc++) dis_idx[loc_ndof0+iloc] = dis_idx1[iloc];
  }
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
#define _RHEOLEF_instanciation(T,M)                             \
template 							\
void								\
assembly_dis_idof (						\
  const space_basic<T,M>&              X,			\
  const geo_basic<T,M>&                dom,			\
  const geo_element&                   bgd_K,			\
  std::vector<geo_element::size_type>& dis_idx);

_RHEOLEF_instanciation(Float,sequential)
#ifdef _RHEOLEF_HAVE_MPI
_RHEOLEF_instanciation(Float,distributed)
#endif // _RHEOLEF_HAVE_MPI

}// namespace rheolef
