///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/skit.h"
#include "rheolef/ldlt_seq_builtin.h"
using namespace std;
using namespace rheolef;
int main(int argc, char**argv) {
  environment rheolef(argc, argv); 
  Float tol = (argc > 1) ? atof(argv[1]) : 1e3*numeric_limits<Float>::epsilon();
  bool dump = (argc > 2);
  csr<Float,sequential> a;
  din >> a;
  a.set_symmetry(true);
  ldlt_seq_builtin<Float> c(a.data());
  if (dump) dout << c;
  assert (!c.is_singular());
  vec<Float,sequential> xe(a.nrow());
  for (size_t i = 0, n = xe.size(); i < n; ++i)
    xe[i] = 1.0*(i+1)/n;
  vec<Float,sequential> b = a*xe;
  vec<Float,sequential> x = c.solve(b);
  vec<Float,sequential> r = a*x - b;
  vec<Float,sequential> e = x - xe;
  cerr << "nnz     = " << c.nnz() << endl 
       << "flops   = " << c.flops() << endl
       << "error   = " << norm(e) << endl
       << "residue = " << norm(r) << endl
       << "tol     = " << tol << endl;
  return (norm(e) < tol) ? 0 : 1;
}
