//slfi.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2019
 *
 *  This file is part of libroar a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this lib
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

// SLFI = Simple Light Filter Infrastructure

#ifndef _LIBROARLIGHT_SLFI_H_
#define _LIBROARLIGHT_SLFI_H_

#include "libroarlight.h"

enum roar_slfi_command {
 ROAR_SLFI_CMD_NONE = 0x00000000U,
 ROAR_SLFI_CMD_PUSH = 0x00000001U, /* push a new filter into the container */
 ROAR_SLFI_CMD_MAX  = 0xFFFFFFFFU
};

#define ROAR_SLFI_FLAG_NONE        0x00000000U  /* no flags */
#define ROAR_SLFI_FLAG_ON_UPDATE   0x00000001U  /* update() only needs to be run if there is an actual update */

struct roar_slfi_inst;

struct roar_slfi_filter {
 const char * name;
 const char * description;
 const uint32_t flags;
 // init
 int (*init)(struct roar_slfi_inst * inst, const struct roar_keyval * para, ssize_t paralen);
 // uninit
 int (*uninit)(struct roar_slfi_inst * inst);
 // update
 int (*update)(struct roar_slfi_inst * inst, uint8_t * universe, ssize_t size_of_universe, int32_t usecspassed, const uint8_t * event, size_t eventlen);
 // ctl
 int (*ctl)(struct roar_slfi_inst * inst, enum roar_slfi_command command, void * argp);
};

#define ROAR_DL_FILTER_VERSION_SLFI   0
#define ROAR_DL_FILTER_SIZE_SLFI      sizeof(struct roar_slfi_filter)

#define ROAR_DL_PLUGIN_REG_SLFI(obj) \
static int _roaraudio_library_ROAR_DL_FN_FILTER(struct roar_dl_librarypara * para, struct roar_dl_libraryinst * lib) { \
 size_t i; \
 (void)para, (void)lib; \
 for (i = 0; i < (sizeof((obj))/sizeof(*(obj))); i++) { \
  ROAR_DL_PLUGIN_REG_FN(ROAR_DL_FILTER_SUBTYPE_SLFI, (obj)[i], ROAR_DL_FILTER_VERSION_SLFI); \
 } \
 return 0; \
}

struct roar_slfi_inst {
 size_t refc;
 const struct roar_slfi_filter * impl;
 uint32_t flags; // same as flags on *impl. just runtime updateable.
 void * userdata;
 struct roar_dl_lhandle * lhandle; // used in case we autoload this as plugin.
 int (*cb_event_add)(struct roar_slfi_inst * inst, void * userdata, uint8_t event);
 void * cb_event_add_userdata;
};

struct roar_slfi_inst * roar_slfi_new(const char * name, int autoload, const struct roar_keyval * para, ssize_t paralen);
int roar_slfi_ref(struct roar_slfi_inst * inst);
int roar_slfi_unref(struct roar_slfi_inst * inst);
int roar_slfi_update(struct roar_slfi_inst * inst, uint8_t * universe, ssize_t size_of_universe, int32_t usecspassed, const uint8_t * event, size_t eventlen);
int roar_slfi_ctl(struct roar_slfi_inst * inst, enum roar_slfi_command command, void * argp);

int roar_slfi_event_add(struct roar_slfi_inst * inst, uint8_t event); // does not perform any context switching.
int roar_slfi_cb_set_event_add(struct roar_slfi_inst * inst, int (*cb)(struct roar_slfi_inst * inst, void * userdata, uint8_t event), void * userdata);

#endif

//ll
