# Licensed to Elasticsearch B.V. under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Elasticsearch B.V. licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#	http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

require 'active_record'

require 'support/app/question'
require 'support/app/answer'
require 'support/app/parent_and_child_searchable'
require 'support/app/article_with_custom_serialization'
require 'support/app/import_article'
require 'support/app/namespaced_book'
require 'support/app/article_for_pagination'
require 'support/app/article_with_dynamic_index_name'
require 'support/app/episode'
require 'support/app/series'
require 'support/app/article'
require 'support/app/article_no_type'
require 'support/app/searchable'
require 'support/app/category'
require 'support/app/author'
require 'support/app/authorship'
require 'support/app/comment'
require 'support/app/post'


# Mongoid models
begin
  require 'support/app/image'
  require 'support/app/mongoid_article'
rescue
  $stderr.puts("'mongoid' gem is not installed, could not load Mongoid models")
end