
#line 1 "ragel/i18n/ca.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/ca.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_ca/gherkin_lexer_ca.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 20, 21, 22, 41, 42, 43, 
	45, 47, 52, 57, 62, 67, 71, 75, 
	77, 78, 79, 80, 81, 82, 83, 84, 
	85, 86, 87, 88, 89, 90, 91, 92, 
	93, 95, 97, 102, 109, 114, 117, 118, 
	119, 120, 121, 122, 123, 124, 125, 126, 
	127, 128, 129, 130, 131, 132, 133, 134, 
	135, 136, 152, 154, 156, 158, 160, 162, 
	164, 166, 168, 170, 172, 174, 176, 178, 
	180, 182, 201, 202, 204, 205, 206, 207, 
	208, 209, 210, 211, 212, 213, 214, 215, 
	216, 217, 218, 219, 231, 233, 235, 237, 
	239, 241, 243, 245, 247, 249, 251, 253, 
	255, 257, 259, 261, 263, 265, 267, 269, 
	271, 273, 275, 277, 279, 281, 283, 285, 
	287, 289, 291, 293, 295, 297, 299, 301, 
	303, 305, 307, 309, 312, 315, 317, 319, 
	321, 323, 325, 327, 329, 331, 333, 335, 
	337, 339, 341, 343, 345, 347, 349, 351, 
	353, 355, 357, 359, 361, 363, 365, 367, 
	369, 371, 373, 375, 377, 379, 381, 383, 
	385, 387, 389, 391, 393, 395, 397, 398, 
	399, 400, 402, 403, 405, 407, 408, 409, 
	410, 411, 412, 413, 414, 415, 432, 434, 
	436, 438, 440, 442, 444, 446, 448, 450, 
	452, 454, 456, 458, 460, 462, 466, 468, 
	470, 472, 474, 476, 478, 480, 482, 484, 
	486, 488, 490, 492, 494, 496, 498, 500, 
	503, 505, 507, 509, 511, 514, 516, 518, 
	520, 522, 524, 526, 528, 530, 532, 534, 
	536, 538, 540, 542, 544, 547, 549, 552, 
	554, 556, 558, 560, 562, 564, 566, 568, 
	570, 572, 574, 576, 578, 580, 582, 584, 
	586, 588, 590, 592, 594, 596, 598, 600, 
	602, 604, 606, 608, 610, 612, 614, 616, 
	618, 620, 622, 624, 626, 628, 630, 632, 
	634, 636, 638, 639, 640, 641, 642, 643, 
	644, 645, 646, 647, 648, 649, 650, 651, 
	652, 653, 654, 655, 656, 657, 658, 659, 
	675, 677, 679, 681, 683, 685, 687, 689, 
	691, 693, 695, 697, 699, 701, 703, 705, 
	708, 710, 712, 714, 716, 718, 720, 722, 
	725, 727, 729, 731, 733, 736, 738, 740, 
	742, 744, 746, 748, 750, 752, 754, 756, 
	758, 760, 762, 764, 766, 768, 771, 773, 
	775, 777, 779, 781, 783, 785, 787, 789, 
	791, 793, 795, 797, 799, 801, 803, 805, 
	807, 809, 811, 813, 815, 817, 819, 821, 
	823, 824, 825, 826, 827, 828, 829, 830, 
	831, 832, 840, 842, 844, 846, 848, 850, 
	852, 854, 856, 858, 860, 862, 864, 866, 
	868, 870, 872, 874, 876, 878, 880, 882, 
	884, 886, 888, 890, 892, 894, 895, 896, 
	897, 898, 899, 900, 901, 902, 903, 904, 
	905, 906, 907, 908, 909, 910, 911, 912, 
	913, 914, 915, 916, 917, 918, 919, 923, 
	929, 932, 934, 940, 959, 962, 964, 966, 
	968, 970, 972, 974, 976, 979, 981, 983, 
	985, 987, 990, 992, 994, 996, 998, 1000, 
	1002, 1004, 1006, 1008, 1010, 1012, 1014, 1016, 
	1018, 1020, 1022, 1025, 1027, 1030, 1032, 1034, 
	1036, 1038, 1040, 1042, 1044, 1046, 1048, 1050, 
	1052, 1054, 1056, 1058, 1060, 1062, 1064, 1066, 
	1068, 1070, 1072, 1074, 1076, 1078, 1080, 1082, 
	1084, 1086, 1088, 1090, 1092, 1094, 1096, 1098, 
	1100, 1102, 1104, 1106, 1107, 1108
};

static const char _lexer_trans_keys[] = {
	-17, 10, 32, 34, 35, 37, 42, 64, 
	65, 67, 68, 69, 70, 73, 80, 81, 
	82, 124, 9, 13, -69, -65, 10, 32, 
	34, 35, 37, 42, 64, 65, 67, 68, 
	69, 70, 73, 80, 81, 82, 124, 9, 
	13, 34, 34, 10, 13, 10, 13, 10, 
	32, 34, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 9, 13, 10, 
	32, 9, 13, 10, 13, 10, 95, 70, 
	69, 65, 84, 85, 82, 69, 95, 69, 
	78, 68, 95, 37, 32, 10, 13, 10, 
	13, 13, 32, 64, 9, 10, 9, 10, 
	13, 32, 64, 11, 12, 10, 32, 64, 
	9, 13, 108, 110, 116, 101, 115, 104, 
	111, 114, 101, 115, 116, 101, 99, 101, 
	100, 101, 110, 116, 115, 58, 10, 10, 
	10, 32, 35, 37, 42, 64, 65, 67, 
	68, 69, 70, 73, 80, 81, 9, 13, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, 10, 32, 10, 32, 
	34, 35, 37, 42, 64, 65, 67, 68, 
	69, 70, 73, 80, 81, 82, 124, 9, 
	13, 97, 108, 114, 97, 99, 116, 101, 
	114, -61, -83, 115, 116, 105, 99, 97, 
	58, 10, 10, 10, 32, 35, 37, 64, 
	65, 67, 69, 70, 82, 9, 13, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, 10, 110, 10, 116, 10, 
	101, 10, 99, 10, 101, 10, 100, 10, 
	101, 10, 110, 10, 116, 10, 115, 10, 
	58, 10, 97, 10, 114, 10, 97, 10, 
	99, 10, 116, 10, 101, 10, 114, -61, 
	10, -83, 10, 10, 115, 10, 116, 10, 
	105, 10, 99, 10, 97, 10, 115, 120, 
	10, 99, 113, 10, 101, 10, 110, 10, 
	97, 10, 114, 10, 105, 10, 117, 10, 
	101, 10, 109, 10, 97, 10, 32, 10, 
	100, 10, 101, 10, 32, 10, 108, 10, 
	39, 10, 101, 10, 115, 10, 99, 10, 
	101, 10, 109, 10, 112, 10, 108, 10, 
	101, 10, 117, 10, 110, 10, 99, 10, 
	105, 10, 111, 10, 110, 10, 97, 10, 
	108, 10, 105, 10, 116, 10, 97, 10, 
	116, 10, 101, 10, 114, 10, 101, 10, 
	102, 10, 111, 10, 110, 111, 110, 97, 
	100, 116, 97, 115, 120, 99, 113, 101, 
	110, 97, 114, 105, 58, 10, 10, 10, 
	32, 35, 37, 42, 64, 65, 67, 68, 
	69, 70, 73, 80, 81, 82, 9, 13, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, 10, 32, 10, 108, 
	110, 116, 10, 101, 10, 115, 10, 104, 
	10, 111, 10, 114, 10, 101, 10, 115, 
	10, 116, 10, 101, 10, 99, 10, 101, 
	10, 100, 10, 101, 10, 110, 10, 116, 
	10, 115, 10, 58, -61, 10, 101, -88, 
	10, 10, 115, 10, 97, 10, 97, 10, 
	108, 114, 10, 97, 10, 99, 10, 116, 
	10, 101, 10, 114, -61, 10, -83, 10, 
	10, 115, 10, 116, 10, 105, 10, 99, 
	10, 97, 10, 111, 10, 110, 10, 97, 
	10, 100, 116, 10, 115, 10, 99, 113, 
	10, 101, 10, 110, 10, 97, 10, 114, 
	10, 105, 10, 117, 10, 101, 10, 109, 
	10, 97, 10, 32, 10, 100, 10, 101, 
	10, 32, 10, 108, 10, 39, 10, 101, 
	10, 115, 10, 99, 10, 117, 10, 110, 
	10, 99, 10, 105, 10, 111, 10, 110, 
	10, 97, 10, 108, 10, 105, 10, 116, 
	10, 97, 10, 116, 10, 101, 10, 114, 
	-61, 10, -78, 10, 10, 117, 10, 97, 
	10, 110, 10, 101, 10, 114, 10, 101, 
	10, 102, 10, 111, 10, 110, 117, 101, 
	109, 97, 32, 100, 101, 32, 108, 39, 
	101, 115, 99, 101, 110, 97, 114, 105, 
	58, 10, 10, 10, 32, 35, 37, 42, 
	64, 65, 67, 68, 69, 70, 73, 80, 
	81, 9, 13, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, 10, 
	32, 10, 108, 116, 10, 101, 10, 115, 
	10, 104, 10, 111, 10, 114, 10, 101, 
	10, 115, -61, 10, 101, -88, 10, 10, 
	115, 10, 97, 10, 97, 10, 108, 114, 
	10, 97, 10, 99, 10, 116, 10, 101, 
	10, 114, -61, 10, -83, 10, 10, 115, 
	10, 116, 10, 105, 10, 99, 10, 97, 
	10, 58, 10, 111, 10, 110, 10, 97, 
	10, 100, 116, 10, 115, 10, 99, 10, 
	101, 10, 110, 10, 97, 10, 114, 10, 
	105, 10, 117, 10, 110, 10, 99, 10, 
	105, 10, 111, 10, 110, 10, 97, 10, 
	108, 10, 105, 10, 116, 10, 97, 10, 
	116, 10, 101, 10, 114, -61, 10, -78, 
	10, 10, 117, 10, 97, 10, 110, 101, 
	109, 112, 108, 101, 115, 58, 10, 10, 
	10, 32, 35, 67, 70, 124, 9, 13, 
	10, 97, 10, 114, 10, 97, 10, 99, 
	10, 116, 10, 101, 10, 114, -61, 10, 
	-83, 10, 10, 115, 10, 116, 10, 105, 
	10, 99, 10, 97, 10, 58, 10, 117, 
	10, 110, 10, 99, 10, 105, 10, 111, 
	10, 110, 10, 97, 10, 108, 10, 105, 
	10, 116, 10, 97, 10, 116, 117, 110, 
	99, 105, 111, 110, 97, 108, 105, 116, 
	97, 116, 101, 114, -61, -78, 117, 97, 
	110, 101, 114, 101, 102, 111, 110, 32, 
	124, 9, 13, 10, 32, 92, 124, 9, 
	13, 10, 92, 124, 10, 92, 10, 32, 
	92, 124, 9, 13, 10, 32, 34, 35, 
	37, 42, 64, 65, 67, 68, 69, 70, 
	73, 80, 81, 82, 124, 9, 13, 10, 
	108, 116, 10, 101, 10, 115, 10, 104, 
	10, 111, 10, 114, 10, 101, 10, 115, 
	-61, 10, 101, -88, 10, 10, 115, 10, 
	97, 10, 97, 10, 108, 114, 10, 97, 
	10, 99, 10, 116, 10, 101, 10, 114, 
	-61, 10, -83, 10, 10, 115, 10, 116, 
	10, 105, 10, 99, 10, 97, 10, 58, 
	10, 111, 10, 110, 10, 97, 10, 100, 
	116, 10, 115, 10, 99, 113, 10, 101, 
	10, 110, 10, 97, 10, 114, 10, 105, 
	10, 117, 10, 101, 10, 109, 10, 97, 
	10, 32, 10, 100, 10, 101, 10, 32, 
	10, 108, 10, 39, 10, 101, 10, 115, 
	10, 99, 10, 117, 10, 110, 10, 99, 
	10, 105, 10, 111, 10, 110, 10, 97, 
	10, 108, 10, 105, 10, 116, 10, 97, 
	10, 116, 10, 101, 10, 114, -61, 10, 
	-78, 10, 10, 117, 10, 97, 10, 110, 
	-61, 101, -88, 115, 0
};

static const char _lexer_single_lengths[] = {
	0, 18, 1, 1, 17, 1, 1, 2, 
	2, 3, 3, 3, 3, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 2, 3, 5, 3, 3, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 14, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 17, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 10, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	1, 2, 1, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 15, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 4, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 14, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 6, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 2, 4, 
	3, 2, 4, 17, 3, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 1, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	0, 0, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 20, 22, 24, 43, 45, 47, 
	50, 53, 58, 63, 68, 73, 77, 81, 
	84, 86, 88, 90, 92, 94, 96, 98, 
	100, 102, 104, 106, 108, 110, 112, 114, 
	116, 119, 122, 127, 134, 139, 143, 145, 
	147, 149, 151, 153, 155, 157, 159, 161, 
	163, 165, 167, 169, 171, 173, 175, 177, 
	179, 181, 197, 200, 203, 206, 209, 212, 
	215, 218, 221, 224, 227, 230, 233, 236, 
	239, 242, 261, 263, 266, 268, 270, 272, 
	274, 276, 278, 280, 282, 284, 286, 288, 
	290, 292, 294, 296, 308, 311, 314, 317, 
	320, 323, 326, 329, 332, 335, 338, 341, 
	344, 347, 350, 353, 356, 359, 362, 365, 
	368, 371, 374, 377, 380, 383, 386, 389, 
	392, 395, 398, 401, 404, 407, 410, 413, 
	416, 419, 422, 425, 429, 433, 436, 439, 
	442, 445, 448, 451, 454, 457, 460, 463, 
	466, 469, 472, 475, 478, 481, 484, 487, 
	490, 493, 496, 499, 502, 505, 508, 511, 
	514, 517, 520, 523, 526, 529, 532, 535, 
	538, 541, 544, 547, 550, 553, 556, 558, 
	560, 562, 565, 567, 570, 573, 575, 577, 
	579, 581, 583, 585, 587, 589, 606, 609, 
	612, 615, 618, 621, 624, 627, 630, 633, 
	636, 639, 642, 645, 648, 651, 656, 659, 
	662, 665, 668, 671, 674, 677, 680, 683, 
	686, 689, 692, 695, 698, 701, 704, 707, 
	711, 714, 717, 720, 723, 727, 730, 733, 
	736, 739, 742, 745, 748, 751, 754, 757, 
	760, 763, 766, 769, 772, 776, 779, 783, 
	786, 789, 792, 795, 798, 801, 804, 807, 
	810, 813, 816, 819, 822, 825, 828, 831, 
	834, 837, 840, 843, 846, 849, 852, 855, 
	858, 861, 864, 867, 870, 873, 876, 879, 
	882, 885, 888, 891, 894, 897, 900, 903, 
	906, 909, 912, 914, 916, 918, 920, 922, 
	924, 926, 928, 930, 932, 934, 936, 938, 
	940, 942, 944, 946, 948, 950, 952, 954, 
	970, 973, 976, 979, 982, 985, 988, 991, 
	994, 997, 1000, 1003, 1006, 1009, 1012, 1015, 
	1019, 1022, 1025, 1028, 1031, 1034, 1037, 1040, 
	1044, 1047, 1050, 1053, 1056, 1060, 1063, 1066, 
	1069, 1072, 1075, 1078, 1081, 1084, 1087, 1090, 
	1093, 1096, 1099, 1102, 1105, 1108, 1112, 1115, 
	1118, 1121, 1124, 1127, 1130, 1133, 1136, 1139, 
	1142, 1145, 1148, 1151, 1154, 1157, 1160, 1163, 
	1166, 1169, 1172, 1175, 1178, 1181, 1184, 1187, 
	1190, 1192, 1194, 1196, 1198, 1200, 1202, 1204, 
	1206, 1208, 1216, 1219, 1222, 1225, 1228, 1231, 
	1234, 1237, 1240, 1243, 1246, 1249, 1252, 1255, 
	1258, 1261, 1264, 1267, 1270, 1273, 1276, 1279, 
	1282, 1285, 1288, 1291, 1294, 1297, 1299, 1301, 
	1303, 1305, 1307, 1309, 1311, 1313, 1315, 1317, 
	1319, 1321, 1323, 1325, 1327, 1329, 1331, 1333, 
	1335, 1337, 1339, 1341, 1343, 1345, 1347, 1351, 
	1357, 1361, 1364, 1370, 1389, 1393, 1396, 1399, 
	1402, 1405, 1408, 1411, 1414, 1418, 1421, 1424, 
	1427, 1430, 1434, 1437, 1440, 1443, 1446, 1449, 
	1452, 1455, 1458, 1461, 1464, 1467, 1470, 1473, 
	1476, 1479, 1482, 1486, 1489, 1493, 1496, 1499, 
	1502, 1505, 1508, 1511, 1514, 1517, 1520, 1523, 
	1526, 1529, 1532, 1535, 1538, 1541, 1544, 1547, 
	1550, 1553, 1556, 1559, 1562, 1565, 1568, 1571, 
	1574, 1577, 1580, 1583, 1586, 1589, 1592, 1595, 
	1598, 1601, 1604, 1607, 1609, 1611
};

static const short _lexer_trans_targs[] = {
	2, 4, 4, 5, 15, 17, 31, 34, 
	37, 74, 174, 179, 421, 31, 433, 437, 
	440, 446, 4, 0, 3, 0, 4, 0, 
	4, 4, 5, 15, 17, 31, 34, 37, 
	74, 174, 179, 421, 31, 433, 437, 440, 
	446, 4, 0, 6, 0, 7, 0, 9, 
	8, 8, 9, 8, 8, 10, 10, 11, 
	10, 10, 10, 10, 11, 10, 10, 10, 
	10, 12, 10, 10, 10, 10, 13, 10, 
	10, 4, 14, 14, 0, 4, 14, 14, 
	0, 4, 16, 15, 4, 0, 18, 0, 
	19, 0, 20, 0, 21, 0, 22, 0, 
	23, 0, 24, 0, 25, 0, 26, 0, 
	27, 0, 28, 0, 29, 0, 30, 0, 
	525, 0, 32, 0, 4, 16, 33, 4, 
	16, 33, 0, 0, 0, 0, 35, 36, 
	4, 36, 36, 34, 35, 35, 4, 36, 
	34, 36, 0, 38, 45, 522, 0, 39, 
	0, 40, 0, 41, 0, 42, 0, 43, 
	0, 44, 0, 31, 0, 46, 0, 47, 
	0, 48, 0, 49, 0, 50, 0, 51, 
	0, 52, 0, 53, 0, 54, 0, 55, 
	0, 57, 56, 57, 56, 57, 57, 4, 
	58, 72, 4, 452, 464, 479, 483, 503, 
	72, 515, 519, 57, 56, 57, 59, 56, 
	57, 60, 56, 57, 61, 56, 57, 62, 
	56, 57, 63, 56, 57, 64, 56, 57, 
	65, 56, 57, 66, 56, 57, 67, 56, 
	57, 68, 56, 57, 69, 56, 57, 70, 
	56, 57, 71, 56, 57, 4, 56, 57, 
	73, 56, 4, 4, 5, 15, 17, 31, 
	34, 37, 74, 174, 179, 421, 31, 433, 
	437, 440, 446, 4, 0, 75, 0, 31, 
	76, 0, 77, 0, 78, 0, 79, 0, 
	80, 0, 81, 0, 82, 0, 83, 0, 
	84, 0, 85, 0, 86, 0, 87, 0, 
	88, 0, 89, 0, 91, 90, 91, 90, 
	91, 91, 4, 92, 4, 106, 117, 131, 
	156, 168, 91, 90, 91, 93, 90, 91, 
	94, 90, 91, 95, 90, 91, 96, 90, 
	91, 97, 90, 91, 98, 90, 91, 99, 
	90, 91, 100, 90, 91, 101, 90, 91, 
	102, 90, 91, 103, 90, 91, 104, 90, 
	91, 105, 90, 91, 4, 90, 91, 107, 
	90, 91, 108, 90, 91, 109, 90, 91, 
	110, 90, 91, 111, 90, 91, 112, 90, 
	91, 113, 90, 91, 114, 90, 91, 115, 
	90, 91, 116, 90, 91, 73, 90, 91, 
	118, 90, 91, 119, 90, 91, 120, 90, 
	91, 121, 90, 91, 122, 90, 91, 123, 
	90, 91, 124, 90, 125, 91, 90, 126, 
	91, 90, 91, 127, 90, 91, 128, 90, 
	91, 129, 90, 91, 130, 90, 91, 116, 
	90, 91, 132, 151, 90, 91, 133, 138, 
	90, 91, 134, 90, 91, 135, 90, 91, 
	136, 90, 91, 137, 90, 91, 116, 90, 
	91, 139, 90, 91, 140, 90, 91, 141, 
	90, 91, 142, 90, 91, 143, 90, 91, 
	144, 90, 91, 145, 90, 91, 146, 90, 
	91, 147, 90, 91, 148, 90, 91, 149, 
	90, 91, 150, 90, 91, 133, 90, 91, 
	152, 90, 91, 153, 90, 91, 154, 90, 
	91, 155, 90, 91, 115, 90, 91, 157, 
	90, 91, 158, 90, 91, 159, 90, 91, 
	160, 90, 91, 161, 90, 91, 162, 90, 
	91, 163, 90, 91, 164, 90, 91, 165, 
	90, 91, 166, 90, 91, 167, 90, 91, 
	116, 90, 91, 169, 90, 91, 170, 90, 
	91, 171, 90, 91, 172, 90, 91, 173, 
	90, 91, 115, 90, 175, 0, 176, 0, 
	177, 0, 178, 31, 0, 31, 0, 180, 
	384, 0, 181, 290, 0, 182, 0, 183, 
	0, 184, 0, 185, 0, 186, 0, 187, 
	0, 189, 188, 189, 188, 189, 189, 4, 
	190, 204, 4, 205, 227, 241, 245, 265, 
	204, 277, 281, 284, 189, 188, 189, 191, 
	188, 189, 192, 188, 189, 193, 188, 189, 
	194, 188, 189, 195, 188, 189, 196, 188, 
	189, 197, 188, 189, 198, 188, 189, 199, 
	188, 189, 200, 188, 189, 201, 188, 189, 
	202, 188, 189, 203, 188, 189, 4, 188, 
	189, 73, 188, 189, 206, 213, 223, 188, 
	189, 207, 188, 189, 208, 188, 189, 209, 
	188, 189, 210, 188, 189, 211, 188, 189, 
	212, 188, 189, 204, 188, 189, 214, 188, 
	189, 215, 188, 189, 216, 188, 189, 217, 
	188, 189, 218, 188, 189, 219, 188, 189, 
	220, 188, 189, 221, 188, 189, 222, 188, 
	189, 73, 188, 224, 189, 225, 188, 212, 
	189, 188, 189, 226, 188, 189, 204, 188, 
	189, 228, 188, 189, 204, 229, 188, 189, 
	230, 188, 189, 231, 188, 189, 232, 188, 
	189, 233, 188, 189, 234, 188, 235, 189, 
	188, 236, 189, 188, 189, 237, 188, 189, 
	238, 188, 189, 239, 188, 189, 240, 188, 
	189, 222, 188, 189, 242, 188, 189, 243, 
	188, 189, 244, 188, 189, 226, 204, 188, 
	189, 246, 188, 189, 247, 252, 188, 189, 
	248, 188, 189, 249, 188, 189, 250, 188, 
	189, 251, 188, 189, 222, 188, 189, 253, 
	188, 189, 254, 188, 189, 255, 188, 189, 
	256, 188, 189, 257, 188, 189, 258, 188, 
	189, 259, 188, 189, 260, 188, 189, 261, 
	188, 189, 262, 188, 189, 263, 188, 189, 
	264, 188, 189, 247, 188, 189, 266, 188, 
	189, 267, 188, 189, 268, 188, 189, 269, 
	188, 189, 270, 188, 189, 271, 188, 189, 
	272, 188, 189, 273, 188, 189, 274, 188, 
	189, 275, 188, 189, 276, 188, 189, 222, 
	188, 189, 278, 188, 189, 279, 188, 280, 
	189, 188, 204, 189, 188, 189, 282, 188, 
	189, 283, 188, 189, 204, 188, 189, 285, 
	188, 189, 286, 188, 189, 287, 188, 189, 
	288, 188, 189, 289, 188, 189, 221, 188, 
	291, 0, 292, 0, 293, 0, 294, 0, 
	295, 0, 296, 0, 297, 0, 298, 0, 
	299, 0, 300, 0, 301, 0, 302, 0, 
	303, 0, 304, 0, 305, 0, 306, 0, 
	307, 0, 308, 0, 309, 0, 311, 310, 
	311, 310, 311, 311, 4, 312, 326, 4, 
	327, 339, 354, 358, 365, 326, 377, 381, 
	311, 310, 311, 313, 310, 311, 314, 310, 
	311, 315, 310, 311, 316, 310, 311, 317, 
	310, 311, 318, 310, 311, 319, 310, 311, 
	320, 310, 311, 321, 310, 311, 322, 310, 
	311, 323, 310, 311, 324, 310, 311, 325, 
	310, 311, 4, 310, 311, 73, 310, 311, 
	328, 335, 310, 311, 329, 310, 311, 330, 
	310, 311, 331, 310, 311, 332, 310, 311, 
	333, 310, 311, 334, 310, 311, 326, 310, 
	336, 311, 337, 310, 334, 311, 310, 311, 
	338, 310, 311, 326, 310, 311, 340, 310, 
	311, 326, 341, 310, 311, 342, 310, 311, 
	343, 310, 311, 344, 310, 311, 345, 310, 
	311, 346, 310, 347, 311, 310, 348, 311, 
	310, 311, 349, 310, 311, 350, 310, 311, 
	351, 310, 311, 352, 310, 311, 353, 310, 
	311, 73, 310, 311, 355, 310, 311, 356, 
	310, 311, 357, 310, 311, 338, 326, 310, 
	311, 359, 310, 311, 360, 310, 311, 361, 
	310, 311, 362, 310, 311, 363, 310, 311, 
	364, 310, 311, 353, 310, 311, 366, 310, 
	311, 367, 310, 311, 368, 310, 311, 369, 
	310, 311, 370, 310, 311, 371, 310, 311, 
	372, 310, 311, 373, 310, 311, 374, 310, 
	311, 375, 310, 311, 376, 310, 311, 353, 
	310, 311, 378, 310, 311, 379, 310, 380, 
	311, 310, 326, 311, 310, 311, 382, 310, 
	311, 383, 310, 311, 326, 310, 385, 0, 
	386, 0, 387, 0, 388, 0, 389, 0, 
	390, 0, 391, 0, 393, 392, 393, 392, 
	393, 393, 4, 394, 409, 4, 393, 392, 
	393, 395, 392, 393, 396, 392, 393, 397, 
	392, 393, 398, 392, 393, 399, 392, 393, 
	400, 392, 393, 401, 392, 402, 393, 392, 
	403, 393, 392, 393, 404, 392, 393, 405, 
	392, 393, 406, 392, 393, 407, 392, 393, 
	408, 392, 393, 73, 392, 393, 410, 392, 
	393, 411, 392, 393, 412, 392, 393, 413, 
	392, 393, 414, 392, 393, 415, 392, 393, 
	416, 392, 393, 417, 392, 393, 418, 392, 
	393, 419, 392, 393, 420, 392, 393, 408, 
	392, 422, 0, 423, 0, 424, 0, 425, 
	0, 426, 0, 427, 0, 428, 0, 429, 
	0, 430, 0, 431, 0, 432, 0, 88, 
	0, 434, 0, 435, 0, 436, 0, 31, 
	0, 438, 0, 439, 0, 31, 0, 441, 
	0, 442, 0, 443, 0, 444, 0, 445, 
	0, 53, 0, 446, 447, 446, 0, 451, 
	450, 449, 447, 450, 448, 0, 449, 447, 
	448, 0, 449, 448, 451, 450, 449, 447, 
	450, 448, 451, 451, 5, 15, 17, 31, 
	34, 37, 74, 174, 179, 421, 31, 433, 
	437, 440, 446, 451, 0, 57, 453, 460, 
	56, 57, 454, 56, 57, 455, 56, 57, 
	456, 56, 57, 457, 56, 57, 458, 56, 
	57, 459, 56, 57, 72, 56, 461, 57, 
	462, 56, 459, 57, 56, 57, 463, 56, 
	57, 72, 56, 57, 465, 56, 57, 72, 
	466, 56, 57, 467, 56, 57, 468, 56, 
	57, 469, 56, 57, 470, 56, 57, 471, 
	56, 472, 57, 56, 473, 57, 56, 57, 
	474, 56, 57, 475, 56, 57, 476, 56, 
	57, 477, 56, 57, 478, 56, 57, 73, 
	56, 57, 480, 56, 57, 481, 56, 57, 
	482, 56, 57, 463, 72, 56, 57, 484, 
	56, 57, 485, 490, 56, 57, 486, 56, 
	57, 487, 56, 57, 488, 56, 57, 489, 
	56, 57, 478, 56, 57, 491, 56, 57, 
	492, 56, 57, 493, 56, 57, 494, 56, 
	57, 495, 56, 57, 496, 56, 57, 497, 
	56, 57, 498, 56, 57, 499, 56, 57, 
	500, 56, 57, 501, 56, 57, 502, 56, 
	57, 485, 56, 57, 504, 56, 57, 505, 
	56, 57, 506, 56, 57, 507, 56, 57, 
	508, 56, 57, 509, 56, 57, 510, 56, 
	57, 511, 56, 57, 512, 56, 57, 513, 
	56, 57, 514, 56, 57, 478, 56, 57, 
	516, 56, 57, 517, 56, 518, 57, 56, 
	72, 57, 56, 57, 520, 56, 57, 521, 
	56, 57, 72, 56, 523, 524, 0, 44, 
	0, 178, 0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	0, 54, 0, 5, 1, 0, 29, 1, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 35, 0, 43, 0, 43, 0, 43, 
	54, 0, 5, 1, 0, 29, 1, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	35, 0, 43, 0, 43, 0, 43, 139, 
	48, 9, 106, 11, 0, 134, 45, 45, 
	45, 3, 122, 33, 33, 33, 0, 122, 
	33, 33, 33, 0, 122, 33, 0, 33, 
	0, 102, 7, 7, 43, 54, 0, 0, 
	43, 114, 25, 0, 54, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 149, 126, 57, 110, 
	23, 0, 43, 43, 43, 43, 0, 27, 
	118, 27, 27, 51, 27, 0, 54, 0, 
	1, 0, 43, 0, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 54, 0, 72, 
	33, 84, 72, 84, 84, 84, 84, 84, 
	84, 84, 84, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 15, 0, 54, 
	15, 0, 130, 31, 60, 57, 31, 63, 
	57, 63, 63, 63, 63, 63, 63, 63, 
	63, 63, 66, 31, 43, 0, 43, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 144, 57, 54, 0, 
	54, 0, 69, 33, 69, 84, 84, 84, 
	84, 84, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 13, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 13, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 43, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 54, 0, 75, 
	33, 84, 75, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 17, 0, 
	54, 17, 0, 54, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 17, 0, 0, 54, 0, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 144, 57, 
	54, 0, 54, 0, 78, 33, 84, 78, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 19, 0, 54, 19, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 19, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 144, 57, 54, 0, 
	54, 0, 81, 84, 84, 81, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 21, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 0, 0, 43, 54, 
	37, 37, 87, 37, 37, 43, 0, 39, 
	0, 43, 0, 0, 54, 0, 0, 39, 
	0, 0, 54, 0, 93, 90, 41, 96, 
	90, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 99, 0, 43, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 15, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 0, 43, 0, 
	43, 0, 43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 525;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/ca.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1185 "ext/gherkin_lexer_ca/gherkin_lexer_ca.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/ca.c.rl"
    
#line 1192 "ext/gherkin_lexer_ca/gherkin_lexer_ca.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/ca.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/ca.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/ca.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/ca.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/ca.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/ca.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/ca.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/ca.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/ca.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/ca.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/ca.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/ca.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/ca.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/ca.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/ca.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/ca.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/ca.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/ca.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/ca.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/ca.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/ca.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/ca.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/ca.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/ca.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1482 "ext/gherkin_lexer_ca/gherkin_lexer_ca.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/ca.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1545 "ext/gherkin_lexer_ca/gherkin_lexer_ca.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/ca.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_ca()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Ca", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

