// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Message, MessageHeaders};
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "SoupMultipartInputStream")]
    pub struct MultipartInputStream(Object<ffi::SoupMultipartInputStream, ffi::SoupMultipartInputStreamClass>) @extends gio::FilterInputStream, gio::InputStream, @implements gio::PollableInputStream;

    match fn {
        type_ => || ffi::soup_multipart_input_stream_get_type(),
    }
}

impl MultipartInputStream {
    #[doc(alias = "soup_multipart_input_stream_new")]
    pub fn new(msg: &Message, base_stream: &impl IsA<gio::InputStream>) -> MultipartInputStream {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::soup_multipart_input_stream_new(
                msg.to_glib_none().0,
                base_stream.as_ref().to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`MultipartInputStream`] objects.
    ///
    /// This method returns an instance of [`MultipartInputStreamBuilder`](crate::builders::MultipartInputStreamBuilder) which can be used to create [`MultipartInputStream`] objects.
    pub fn builder() -> MultipartInputStreamBuilder {
        MultipartInputStreamBuilder::new()
    }

    #[doc(alias = "soup_multipart_input_stream_get_headers")]
    #[doc(alias = "get_headers")]
    pub fn headers(&self) -> Option<MessageHeaders> {
        unsafe {
            from_glib_none(ffi::soup_multipart_input_stream_get_headers(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_multipart_input_stream_next_part")]
    pub fn next_part(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Option<gio::InputStream>, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::soup_multipart_input_stream_next_part(
                self.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    pub fn message(&self) -> Option<Message> {
        ObjectExt::property(self, "message")
    }
}

impl Default for MultipartInputStream {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`MultipartInputStream`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct MultipartInputStreamBuilder {
    builder: glib::object::ObjectBuilder<'static, MultipartInputStream>,
}

impl MultipartInputStreamBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn message(self, message: &Message) -> Self {
        Self {
            builder: self.builder.property("message", message.clone()),
        }
    }

    pub fn base_stream(self, base_stream: &impl IsA<gio::InputStream>) -> Self {
        Self {
            builder: self
                .builder
                .property("base-stream", base_stream.clone().upcast()),
        }
    }

    pub fn close_base_stream(self, close_base_stream: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("close-base-stream", close_base_stream),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`MultipartInputStream`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> MultipartInputStream {
        self.builder.build()
    }
}
