use rustc_abi::Endian;

use crate::spec::{
    Abi, Arch, Cc, LinkerFlavor, Lld, StackProbeType, Target, TargetMetadata, TargetOptions, base,
};

pub(crate) fn target() -> Target {
    let mut base = base::linux_gnu::opts();
    base.cpu = "ppc64".into();
    base.add_pre_link_args(LinkerFlavor::Gnu(Cc::Yes, Lld::No), &["-m64"]);
    base.max_atomic_width = Some(64);
    base.stack_probes = StackProbeType::Inline;
    base.abi = Abi::ElfV1;
    base.llvm_abiname = "elfv1".into();

    Target {
        llvm_target: "powerpc64-unknown-linux-gnu".into(),
        metadata: TargetMetadata {
            description: Some("PowerPC Linux (kernel 3.2, glibc 2.17)".into()),
            tier: Some(2),
            host_tools: Some(true),
            std: Some(true),
        },
        pointer_width: 64,
        data_layout: "E-m:e-Fi64-i64:64-i128:128-n32:64-S128-v256:256:256-v512:512:512".into(),
        arch: Arch::PowerPC64,
        options: TargetOptions { endian: Endian::Big, mcount: "_mcount".into(), ..base },
    }
}
