/* rygel-media-export-extract.c generated by valac 0.36.6, the Vala compiler
 * generated from rygel-media-export-extract.vala, do not modify */

/*
 * Copyright (C) 2015 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gst/gst.h>
#include <unistd.h>
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR (rygel_media_export_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))

typedef struct _RygelMediaExportExtractor RygelMediaExportExtractor;
typedef struct _RygelMediaExportExtractorClass RygelMediaExportExtractorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _RunData RunData;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

typedef enum  {
	METADATA_EXTRACTOR_ERROR_GENERAL
} MetadataExtractorError;
#define METADATA_EXTRACTOR_ERROR metadata_extractor_error_quark ()
typedef enum  {
	DVD_PARSER_ERROR_GENERAL,
	DVD_PARSER_ERROR_NOT_AVAILABLE
} DVDParserError;
#define DVD_PARSER_ERROR dvd_parser_error_quark ()
struct _RunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	gchar* line;
	GDataInputStream* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	gchar* data;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** parts;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GFile* file;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	GFile* _tmp17_;
	RygelMediaExportExtractor* extractor;
	GFile* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp20_;
	gboolean _tmp21_;
	RygelMediaExportExtractor* _tmp22_;
	RygelMediaExportExtractor* _tmp23_;
	GFile* _tmp24_;
	RygelMediaExportExtractor* _tmp25_;
	GVariant* _tmp26_;
	GVariant* _tmp27_;
	GError* _error_;
	GError* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	const gchar* _tmp30_;
	GFile* _tmp31_;
	GFile* _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	const gchar* _tmp34_;
	GError* _tmp35_;
	const gchar* _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	const gchar* _tmp38_;
	GFile* _tmp39_;
	GFile* _tmp40_;
	GError* _tmp41_;
	const gchar* _tmp42_;
	gboolean _tmp43_;
	gchar* command;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	const gchar* _tmp49_;
	gboolean _tmp50_;
	const gchar* _tmp51_;
	gboolean _tmp52_;
	const gchar* _tmp53_;
	gboolean _tmp54_;
	GError* _vala1__error_;
	GError* _tmp55_;
	const gchar* _tmp56_;
	GMainLoop* _tmp57_;
	GError * _inner_error_;
};


extern gint in_fd;
gint in_fd = 0;
extern gint out_fd;
gint out_fd = 1;
extern gboolean metadata;
gboolean metadata = FALSE;
extern GMainLoop* loop;
GMainLoop* loop = NULL;
extern GDataInputStream* input_stream;
GDataInputStream* input_stream = NULL;
extern GOutputStream* output_stream;
GOutputStream* output_stream = NULL;

#define UPNP_CLASS_PHOTO "object.item.imageItem.photo"
#define UPNP_CLASS_MUSIC "object.item.audioItem.musicTrack"
#define UPNP_CLASS_VIDEO "object.item.videoItem"
#define UPNP_CLASS_PLAYLIST "object.item.playlistItem"
#define UPNP_CLASS_PLAYLIST_CONTAINER_DVD "object.container.playlistContainer.DVD"
#define UPNP_CLASS_DVD_TRACK UPNP_CLASS_VIDEO ".dvdTrack"
#define STATUS_LINE_TEMPLATE "RESULT|%s|%" G_GSIZE_FORMAT "|%s\n"
#define ERROR_LINE_TEMPLATE "ERROR|%s|%d|%s\n"
#define SKIPPED_LINE_TEMPLATE "SKIP|%s|-1|0\n"
GQuark metadata_extractor_error_quark (void);
static void run_data_free (gpointer _data);
static void run_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
void run (GAsyncReadyCallback _callback_, gpointer _user_data_);
void run_finish (GAsyncResult* _res_);
static gboolean run_co (RunData* _data_);
static void run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_media_export_extractor_get_type (void) G_GNUC_CONST;
RygelMediaExportExtractor* rygel_media_export_extractor_create_for_file (GFile* file, const gchar* content_type, gboolean extract_metadata);
void rygel_media_export_extractor_run (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_extractor_run_finish (RygelMediaExportExtractor* self, GAsyncResult* _res_, GError** error);
void send_extraction_done (GFile* file, GVariant* v, GError** error);
GVariant* rygel_media_export_extractor_get (RygelMediaExportExtractor* self);
GQuark dvd_parser_error_quark (void);
void send_skip (GFile* file);
void send_error (GFile* file, GError* err);
gboolean vaapi_filter (GstPluginFeature* feature);
gint _vala_main (gchar** args, int args_length1);
static gboolean _vaapi_filter_gst_plugin_feature_filter (GstPluginFeature* feature, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[4] = {{"input-fd", 'i', 0, G_OPTION_ARG_INT, &in_fd, "File descriptor used for input", NULL}, {"output-fd", 'o', 0, G_OPTION_ARG_INT, &out_fd, "File descriptor used for output", NULL}, {"extract-metadata", 'm', 0, G_OPTION_ARG_NONE, &metadata, "Whether to extract all metadata from the files or just basic informati" \
"on", NULL}, {NULL}};

GQuark metadata_extractor_error_quark (void) {
	return g_quark_from_static_string ("metadata_extractor_error-quark");
}


static void run_data_free (gpointer _data) {
	RunData* _data_;
	_data_ = _data;
	g_slice_free (RunData, _data_);
}


static void run_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RunData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


void run (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RunData* _data_;
	_data_ = g_slice_new0 (RunData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, NULL, run_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, run_data_free);
	run_co (_data_);
}


void run_finish (GAsyncResult* _res_) {
	RunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	run_co (_data_);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean run_co (RunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	while (TRUE) {
		{
			_data_->_tmp0_ = input_stream;
			_data_->_state_ = 1;
			g_data_input_stream_read_line_async (_data_->_tmp0_, G_PRIORITY_DEFAULT, NULL, run_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp1_ = g_data_input_stream_read_line_finish (_data_->_tmp0_, _data_->_res_, NULL, &_data_->_inner_error_);
			_data_->line = _data_->_tmp1_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp2_ = _data_->line;
			if (_data_->_tmp2_ == NULL) {
				_g_free0 (_data_->line);
				break;
			}
			_data_->_tmp3_ = _data_->line;
			_data_->_tmp4_ = g_str_has_prefix (_data_->_tmp3_, "EXTRACT ");
			if (_data_->_tmp4_) {
				_data_->_tmp5_ = _data_->line;
				g_debug ("rygel-media-export-extract.vala:69: Got command to extract file: %s", _data_->_tmp5_);
				_data_->_tmp6_ = _data_->line;
				_data_->_tmp7_ = string_replace (_data_->_tmp6_, "EXTRACT ", "");
				_data_->_tmp8_ = _data_->_tmp7_;
				_data_->_tmp9_ = string_strip (_data_->_tmp8_);
				_data_->_tmp10_ = _data_->_tmp9_;
				_g_free0 (_data_->_tmp8_);
				_data_->data = _data_->_tmp10_;
				_data_->_tmp11_ = _data_->data;
				_data_->_tmp13_ = _data_->_tmp12_ = g_strsplit (_data_->_tmp11_, "|", 0);
				_data_->parts = _data_->_tmp13_;
				_data_->parts_length1 = _vala_array_length (_data_->_tmp12_);
				_data_->_parts_size_ = _data_->parts_length1;
				_data_->_tmp14_ = _data_->parts;
				_data_->_tmp14__length1 = _data_->parts_length1;
				if (_data_->_tmp14__length1 != 2) {
					g_warning ("rygel-media-export-extract.vala:73: %s", _ ("Invalid command received, ignoring"));
					_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->data);
					_g_free0 (_data_->line);
					continue;
				}
				{
					_data_->_tmp15_ = _data_->parts;
					_data_->_tmp15__length1 = _data_->parts_length1;
					_data_->_tmp16_ = _data_->_tmp15_[0];
					_data_->_tmp17_ = g_file_new_for_uri (_data_->_tmp16_);
					_data_->file = _data_->_tmp17_;
					_data_->_tmp18_ = _data_->file;
					_data_->_tmp19_ = _data_->parts;
					_data_->_tmp19__length1 = _data_->parts_length1;
					_data_->_tmp20_ = _data_->_tmp19_[1];
					_data_->_tmp21_ = metadata;
					_data_->_tmp22_ = rygel_media_export_extractor_create_for_file (_data_->_tmp18_, _data_->_tmp20_, _data_->_tmp21_);
					_data_->extractor = _data_->_tmp22_;
					_data_->_tmp23_ = _data_->extractor;
					_data_->_state_ = 2;
					rygel_media_export_extractor_run (_data_->_tmp23_, run_ready, _data_);
					return FALSE;
					_state_2:
					rygel_media_export_extractor_run_finish (_data_->_tmp23_, _data_->_res_, &_data_->_inner_error_);
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						_g_object_unref0 (_data_->extractor);
						_g_object_unref0 (_data_->file);
						goto __catch2_g_error;
					}
					_data_->_tmp24_ = _data_->file;
					_data_->_tmp25_ = _data_->extractor;
					_data_->_tmp26_ = rygel_media_export_extractor_get (_data_->_tmp25_);
					_data_->_tmp27_ = _data_->_tmp26_;
					send_extraction_done (_data_->_tmp24_, _data_->_tmp27_, &_data_->_inner_error_);
					_g_variant_unref0 (_data_->_tmp27_);
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						_g_object_unref0 (_data_->extractor);
						_g_object_unref0 (_data_->file);
						goto __catch2_g_error;
					}
					_g_object_unref0 (_data_->extractor);
					_g_object_unref0 (_data_->file);
				}
				goto __finally2;
				__catch2_g_error:
				{
					_data_->_error_ = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp28_ = _data_->_error_;
					if (g_error_matches (_data_->_tmp28_, DVD_PARSER_ERROR, DVD_PARSER_ERROR_NOT_AVAILABLE)) {
						_data_->_tmp29_ = _data_->parts;
						_data_->_tmp29__length1 = _data_->parts_length1;
						_data_->_tmp30_ = _data_->_tmp29_[0];
						_data_->_tmp31_ = g_file_new_for_uri (_data_->_tmp30_);
						_data_->_tmp32_ = _data_->_tmp31_;
						send_skip (_data_->_tmp32_);
						_g_object_unref0 (_data_->_tmp32_);
					} else {
						_data_->_tmp33_ = _data_->parts;
						_data_->_tmp33__length1 = _data_->parts_length1;
						_data_->_tmp34_ = _data_->_tmp33_[0];
						_data_->_tmp35_ = _data_->_error_;
						_data_->_tmp36_ = _data_->_tmp35_->message;
						g_warning (_ ("Failed to discover URI %s: %s"), _data_->_tmp34_, _data_->_tmp36_);
						_data_->_tmp37_ = _data_->parts;
						_data_->_tmp37__length1 = _data_->parts_length1;
						_data_->_tmp38_ = _data_->_tmp37_[0];
						_data_->_tmp39_ = g_file_new_for_uri (_data_->_tmp38_);
						_data_->_tmp40_ = _data_->_tmp39_;
						_data_->_tmp41_ = _data_->_error_;
						send_error (_data_->_tmp40_, _data_->_tmp41_);
						_g_object_unref0 (_data_->_tmp40_);
					}
					_g_error_free0 (_data_->_error_);
				}
				__finally2:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->data);
					_g_free0 (_data_->line);
					goto __catch0_g_error;
				}
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->data);
			} else {
				_data_->_tmp42_ = _data_->line;
				_data_->_tmp43_ = g_str_has_prefix (_data_->_tmp42_, "METADATA ");
				if (_data_->_tmp43_) {
					_data_->_tmp44_ = _data_->line;
					_data_->_tmp45_ = string_replace (_data_->_tmp44_, "METADATA ", "");
					_data_->_tmp46_ = _data_->_tmp45_;
					_data_->_tmp47_ = string_strip (_data_->_tmp46_);
					_data_->_tmp48_ = _data_->_tmp47_;
					_g_free0 (_data_->_tmp46_);
					_data_->command = _data_->_tmp48_;
					_data_->_tmp49_ = _data_->command;
					_data_->_tmp50_ = bool_parse (_data_->_tmp49_);
					metadata = _data_->_tmp50_;
					_data_->_tmp52_ = metadata;
					if (_data_->_tmp52_) {
						_data_->_tmp51_ = "enabled";
					} else {
						_data_->_tmp51_ = "disabled";
					}
					g_debug ("rygel-media-export-extract.vala:99: Meta-data extraction was %s", _data_->_tmp51_);
					_g_free0 (_data_->command);
				} else {
					_data_->_tmp53_ = _data_->line;
					_data_->_tmp54_ = g_str_has_prefix (_data_->_tmp53_, "QUIT");
					if (_data_->_tmp54_) {
						_g_free0 (_data_->line);
						break;
					}
				}
			}
			_g_free0 (_data_->line);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_vala1__error_ = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp55_ = _data_->_vala1__error_;
			_data_->_tmp56_ = _data_->_tmp55_->message;
			g_warning (_ ("Failed to read from pipe: %s"), _data_->_tmp56_);
			_g_error_free0 (_data_->_vala1__error_);
			break;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp57_ = loop;
	g_main_loop_quit (_data_->_tmp57_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void send_extraction_done (GFile* file, GVariant* v, GError** error) {
	GBytes* data = NULL;
	GVariant* _tmp0_;
	GBytes* _tmp1_;
	gsize bytes_written = 0UL;
	gchar* status = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GBytes* _tmp5_;
	gsize _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GOutputStream* _tmp12_;
	const gchar* _tmp13_;
	guint8* _tmp14_;
	gint _tmp14__length1;
	guint8* _tmp15_;
	gint _tmp15__length1;
	gsize _tmp16_ = 0UL;
	GOutputStream* _tmp17_;
	GBytes* _tmp18_;
	gsize _tmp19_;
	guint8* _tmp20_;
	gsize _tmp21_ = 0UL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_get_data_as_bytes (_tmp0_);
	data = _tmp1_;
	bytes_written = (gsize) 0;
	_tmp2_ = file;
	_tmp3_ = g_file_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = data;
	_tmp6_ = g_bytes_get_size (_tmp5_);
	_tmp7_ = file;
	_tmp8_ = g_file_get_uri (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf (STATUS_LINE_TEMPLATE, _tmp4_, _tmp6_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp4_);
	status = _tmp11_;
	_tmp12_ = output_stream;
	_tmp13_ = status;
	_tmp14_ = string_get_data (_tmp13_, &_tmp14__length1);
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _tmp14__length1;
	g_output_stream_write_all (_tmp12_, _tmp15_, (gsize) _tmp15__length1, &_tmp16_, NULL, &_inner_error_);
	bytes_written = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (status);
		_g_bytes_unref0 (data);
		return;
	}
	_tmp17_ = output_stream;
	_tmp18_ = data;
	_tmp20_ = g_bytes_get_data (_tmp18_, &_tmp19_);
	g_output_stream_write_all (_tmp17_, _tmp20_, (gsize) _tmp19_, &_tmp21_, NULL, &_inner_error_);
	bytes_written = _tmp21_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (status);
		_g_bytes_unref0 (data);
		return;
	}
	_g_free0 (status);
	_g_bytes_unref0 (data);
}


void send_skip (GFile* file) {
	gsize bytes_written = 0UL;
	gchar* status = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	bytes_written = (gsize) 0;
	_tmp0_ = file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (SKIPPED_LINE_TEMPLATE, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	status = _tmp4_;
	{
		GOutputStream* _tmp5_;
		guint8* _tmp6_;
		gint _tmp6__length1;
		guint8* _tmp7_;
		gint _tmp7__length1;
		gsize _tmp8_ = 0UL;
		_tmp5_ = output_stream;
		_tmp6_ = string_get_data (status, &_tmp6__length1);
		_tmp7_ = _tmp6_;
		_tmp7__length1 = _tmp6__length1;
		g_output_stream_write_all (_tmp5_, _tmp7_, (gsize) _tmp7__length1, &_tmp8_, NULL, &_inner_error_);
		bytes_written = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = _error_;
		_tmp10_ = _tmp9_->message;
		g_warning (_ ("Failed to send error to parent: %s"), _tmp10_);
		_g_error_free0 (_error_);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (status);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (status);
}


void send_error (GFile* file, GError* err) {
	gsize bytes_written = 0UL;
	gchar* status = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _tmp3_;
	gint _tmp4_;
	GError* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	bytes_written = (gsize) 0;
	_tmp0_ = file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = err;
	_tmp4_ = _tmp3_->code;
	_tmp5_ = err;
	_tmp6_ = _tmp5_->message;
	_tmp7_ = g_strdup_printf (ERROR_LINE_TEMPLATE, _tmp2_, _tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp2_);
	status = _tmp8_;
	{
		GOutputStream* _tmp9_;
		guint8* _tmp10_;
		gint _tmp10__length1;
		guint8* _tmp11_;
		gint _tmp11__length1;
		gsize _tmp12_ = 0UL;
		_tmp9_ = output_stream;
		_tmp10_ = string_get_data (status, &_tmp10__length1);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _tmp10__length1;
		g_output_stream_write_all (_tmp9_, _tmp11_, (gsize) _tmp11__length1, &_tmp12_, NULL, &_inner_error_);
		bytes_written = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = _error_;
		_tmp14_ = _tmp13_->message;
		g_warning (_ ("Failed to send error to parent: %s"), _tmp14_);
		_g_error_free0 (_error_);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (status);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (status);
}


gboolean vaapi_filter (GstPluginFeature* feature) {
	gboolean result = FALSE;
	GstPluginFeature* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (feature != NULL, FALSE);
	_tmp0_ = feature;
	_tmp1_ = gst_object_get_name ((GstObject*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_str_has_prefix (_tmp2_, "vaapi");
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _vaapi_filter_gst_plugin_feature_filter (GstPluginFeature* feature, gpointer self) {
	gboolean result;
	result = vaapi_filter (feature);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* ctx = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	GOptionGroup* _tmp3_;
	gint _tmp8_;
	GstRegistry* registry = NULL;
	GstRegistry* _tmp9_;
	GstRegistry* _tmp10_;
	GList* features = NULL;
	GstRegistry* _tmp11_;
	GList* _tmp12_;
	GList* _tmp13_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GUnixInputStream* _tmp23_;
	GUnixInputStream* _tmp24_;
	GDataInputStream* _tmp25_;
	gint _tmp26_;
	GUnixOutputStream* _tmp27_;
	GMainLoop* _tmp28_;
	GMainLoop* _tmp29_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new (_ ("— helper binary for Rygel to extract metadata"));
	ctx = _tmp0_;
	_tmp1_ = ctx;
	g_option_context_add_main_entries (_tmp1_, options, NULL);
	_tmp2_ = ctx;
	_tmp3_ = gst_init_get_option_group ();
	g_option_context_add_group (_tmp2_, _tmp3_);
	{
		GOptionContext* _tmp4_;
		_tmp4_ = ctx;
		g_option_context_parse (_tmp4_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_warning (_ ("Failed to parse commandline args: %s"), _tmp6_);
		result = EXIT_FAILURE;
		_g_error_free0 (_error_);
		_g_option_context_free0 (ctx);
		return result;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp7_ = 0;
		_g_option_context_free0 (ctx);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp7_;
	}
	_tmp8_ = nice (19);
	if (_tmp8_ < 0) {
		g_debug ("rygel-media-export-extract.vala:170: Failed to reduce nice level of th" \
"umbnailer, continuing anyway");
	}
	_tmp9_ = gst_registry_get ();
	_tmp10_ = _g_object_ref0 (_tmp9_);
	registry = _tmp10_;
	_tmp11_ = registry;
	_tmp12_ = gst_registry_feature_filter (_tmp11_, _vaapi_filter_gst_plugin_feature_filter, FALSE, NULL);
	features = _tmp12_;
	_tmp13_ = features;
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
		feature_collection = _tmp13_;
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
			GstPluginFeature* _tmp14_;
			GstPluginFeature* feature = NULL;
			_tmp14_ = _g_object_ref0 ((GstPluginFeature*) feature_it->data);
			feature = _tmp14_;
			{
				GstPluginFeature* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				GstRegistry* _tmp18_;
				GstPluginFeature* _tmp19_;
				_tmp15_ = feature;
				_tmp16_ = gst_object_get_name ((GstObject*) _tmp15_);
				_tmp17_ = _tmp16_;
				g_debug ("rygel-media-export-extract.vala:176: Removing registry feature %s", _tmp17_);
				_g_free0 (_tmp17_);
				_tmp18_ = registry;
				_tmp19_ = feature;
				gst_registry_remove_feature (_tmp18_, _tmp19_);
				_g_object_unref0 (feature);
			}
		}
	}
	_tmp20_ = in_fd;
	_tmp21_ = out_fd;
	g_message ("rygel-media-export-extract.vala:180: Started with descriptors %d (in) " \
"%d (out)", _tmp20_, _tmp21_);
	_tmp22_ = in_fd;
	_tmp23_ = (GUnixInputStream*) g_unix_input_stream_new (_tmp22_, TRUE);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_data_input_stream_new ((GInputStream*) _tmp24_);
	_g_object_unref0 (input_stream);
	input_stream = _tmp25_;
	_g_object_unref0 (_tmp24_);
	_tmp26_ = out_fd;
	_tmp27_ = (GUnixOutputStream*) g_unix_output_stream_new (_tmp26_, TRUE);
	_g_object_unref0 (output_stream);
	output_stream = (GOutputStream*) _tmp27_;
	_tmp28_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (loop);
	loop = _tmp28_;
	run (NULL, NULL);
	_tmp29_ = loop;
	g_main_loop_run (_tmp29_);
	result = 0;
	__g_list_free__g_object_unref0_0 (features);
	_g_object_unref0 (registry);
	_g_option_context_free0 (ctx);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



