// ============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2017-2017 - Gsoc 2017 - Siddhartha Gairola
//
//  This file is distributed under the same license as the Scilab package.
// ============================================================================
//
// <-- ENGLISH IMPOSED -->
// <-- CLI SHELL MODE -->
//
// ============================================================================
// Unitary tests for mxFree mex function
// ============================================================================

cd(TMPDIR);
ilib_verbose(0);

mputl(["#include ""mex.h""";
"void mexFunction(int nlhs, mxArray *plhs[], int nrhs, mxArray *prhs[])";
"{";
" char *buf = NULL;";
" int buflen;";
" int status;";
" int check = 0;";
"    if (mxIsChar(prhs[0])) {";
"        check = 1;";
"        buflen = mxGetN(prhs[0])+1;";
"        buf = mxCalloc(buflen, sizeof(char));";
"        status = mxGetString(prhs[0], buf, buflen);";
"        mxFree(buf);}";
"    else {";
"        check = 0;}";
" mxArray* pOut = mxCreateLogicalScalar(check);";
" plhs[0] = pOut;";
"}"],"mxFree.c");
ilib_mex_build("libmextest",["mxFree","mxFree","cmex"], "mxFree.c",[]);
exec("loader.sce");

res1 = mxFree(["Hello World"]);
assert_checktrue(res1);
res2 = mxFree([1]);
assert_checkfalse(res2);
