module SiSU_Po4a_Actions
  @@source=@@targets=nil
  def project_details
    def name
      'SiSU translations under po4a management'
    end
    def name_warning
      <<-WOK
#{name}

WARNING all sisu markup files (.ssm, .sst, .ssi) in languages other than #{language.source_language_selected}
are managed by po4a, through translations of the source language to other languages.

#{language.info_on_selection}
      WOK
    end
    def setup_project
      "Setup file for placing #{name}"
    end
    self
  end
  def query
    def selections_available_(selections=:strict)
      short_options=(selections == :strict) ? '' : '; [ynqx]'
      %{'yes', 'no', 'quit' or 'exit'#{short_options}}
    end
    def selection_options
      def response_strict(resp)
        case resp
        when /^(?:yes)$/          then true
        when /^(?:no)$/           then false
        when /^(?:quit|exit)$/    then exit
        else
          puts %{response was: #{resp}}
          puts %{[please type to select: #{selections_available_(:strict)}]}
          answer?('',:strict)
        end
      end
      def response_short(resp)
        case resp
        when /^(?:y|yes)$/          then true
        when /^(?:n|no)$/           then false
        when /^(?:[qx]|quit|exit)$/ then exit
        else
          puts %{response was: #{resp}}
          puts %{[please type to select: #{selections_available_(:short)}]}
          answer?('',:short)
        end
      end
      self
    end
    def answer?(ask,selections=:strict)
      resp='redo'
      print ask + %{PROCEED? [#{selections_available_(selections)}]: }
      resp=File.new('/dev/tty').gets.strip
      (selections==:strict) \
      ? selection_options.response_strict(resp)
      : selection_options.response_short(resp)
    end
    self
  end
  def notice
    def warn_and_proceed?
      '*WARNING* this software module creates, destroys, overwrites directories' + "\n" \
      + '*WARNING*: Use this Software at your own risk!'
    end
    def default(selection=nil)
      selections=:strict #selections=:short
      ans=if selection
        case selection
        when selection.is_a?(String)
          selections=:strict
          <<-WOK
  #{project_details.setup_project}
    Default action selected - "#{selection} #{project_details.name}"
#{warn_and_proceed?}
          WOK
        when :make
          selections=:strict
          <<-WOK
  #{project_details.setup_project}
    "--#{selection}" selected - #{selection} #{project_details.name}
    selected (or configured) languages to be used
      source language: #{language.source_language_available_str}
      target languages: #{language.translation_languages_available.inspect}

    WARNING: this action assumes (and places) this project is under po4a
    (translation) management. It will create sub-directories for the
    selected (or configured) target languages:
      #{language.translation_languages_available.inspect}
    & the po4a configuration file: #{filename.po4a_cfg}
    in the current directory:
      #{Dir.pwd}
    It will populate the sub-directories with translation files created from
    the pot and po files found under the corresponding language
    sub-directories, (under #{dir.pot}/ & #{dir.po}/).
    (OVERWRITING any existing translated .ssm .sst .ssi files
    in language subdirectories that are not under po4a management).

    You should backup the current directory:
      #{Dir.pwd}

#{warn_and_proceed?}
          WOK
        when :clean
          selections=:strict
          <<-WOK
  #{project_details.setup_project}
    "--#{selection}" selected - #{selection} #{project_details.name}
#{warn_and_proceed?}
          WOK
        when :distclean
          selections=:strict
          <<-WOK
  #{project_details.setup_project}
    "--#{selection}" selected - #{selection} #{project_details.name}
    WARNING: this action assumes (and places) this project is under po4a
    (translation) management. It will remove the sub-directories (if they exist):
      #{language.possible_translations.inspect}

      #{language.translation_languages_available.inspect}
    & file: #{filename.po4a_cfg}
    in the current directory:
      #{Dir.pwd}
    Note: these sub-directories & the config file #{filename.po4a_cfg}
    should be auto-generated from pot and po files if this project translation
    is under po4a management.
    This query is to give you the chance to make sure you know what you are doing.
#{warn_and_proceed?}
          WOK
        when :rebuild
          selections=:strict
          <<-WOK
  #{project_details.setup_project}
    "--#{selection}" selected - #{selection} #{project_details.name}
    WARNING: this action assumes (and places) this project is under po4a
    (translation) management. It will destroy/clobber and then create again the
    sub-directories:
      #{language.translation_languages_available.inspect}
    populating them with translation files created from the pot and po files
    found under the corresponding language sub-directories in (#{dir.pot}/
    & #{dir.po}/).
    It will also generate the file: #{filename.po4a_cfg}
    These actions will be taken in the current directory:
      #{Dir.pwd}
    This query is to give you the chance to make sure you know what you are doing.
#{warn_and_proceed?}
          WOK
        else
          selections=:strict
          <<-WOK
  #{project_details.setup_project}
    Default action selected - "#{selection} #{project_details.name}"
#{warn_and_proceed?}
          WOK
        end
      else
        selections=:strict
        <<-WOK
  #{project_details.setup_project}
    Default action selected - "install and to setup #{project_details.name}"
#{warn_and_proceed?}
        WOK
      end
      exit unless query.answer?(ans)
    end
    def project_help
      puts <<-WOK
#{project_details.name}
#{project_details.setup_project}

This setup file is primarily to assist with having sisu markup files under po4a
translation management. It assumes that the source language files are placed
under the sub-directory identifying the source language set, which is currently
#{language.source_language_selected}
The files there are used to make the source translation file in the directory #{dir.pot}/
Which is then used to create files for translation under the directory #{dir.po}/
in sub-directories bearing the translation languages ISO code.

The current language translation selection is:  #{translation_languages_selected_str}
The languages selected are located in the file: #{filename.languages_src_tgt}

sisu available language list: #{sisu_languages_available_str}

      WOK
    end
    self
  end
  def generate
    def readme
      system(%{ruby ../../../../../bin/sisu6 --txt -v --no-manifest --dump='../../../../../..' en/README.ssm})
    end
    def manpage
      system(%{ruby ../../../../../bin/sisu6 --manpage -v --no-manifest --dump='../../../../../../man/man1' en/sisu.ssm})
    end
    self
  end
  def filename
    def languages_src_tgt
      #'translation_languages'
      'languages_source_and_targets'
    end
    def po4a_cfg
      'po4a.cfg'
    end
    self
  end
  def dir
    def pwd
      Dir.pwd
    end
    def po4a_
      'po4a/' # ''
    end
    def pot
      po4a_ + 'pot'
    end
    def po
      po4a_ + 'po'
    end
    self
  end
  def dir_mk(dir)
    FileUtils::mkdir_p(dir) unless FileTest.directory?(dir)
  end
  def po4a_flags
    def debug
      '-d -v'
    end
    def normal
      ''
    end
    def quiet
      '-q'
    end
    self
  end
  def languages_from_file
    def language_source
      if @@source.is_a?(String) \
      and @@source =~ /w{2,4}/
      else languages_extract_from_file
      end
      @@source
    end
    def language_targets
      if @@targets.is_a?(Array) \
      and @@targets.length > 0
      else languages_extract_from_file
      end
      @@targets
    end
    def languages_extract_from_file
      if (@@source.is_a?(String) \
      and @@source =~/\w{2,4}/) \
      and (@@targets.is_a?(Array) \
      and @@targets.length > 0)
      else
        if FileTest.file?(filename.languages_src_tgt)
          puts 'file: "' + filename.languages_src_tgt + '" found and used (unless overridden)'
          langs=IO.read(filename.languages_src_tgt, mode: 'r:utf-8').scan(/source:\s+\w+|target:\s+\w.+/)
          langs.each do |sel|
            case sel
            when /source:/
              source=sel.split(/source:\s*|\s+/).join
              source=(source =~/\w{2,4}/) ? source : nil
              @@source=unless @@source.is_a?(String) \
              and @@source =~/\w{2,4}/
                source
              else @@source
              end
            when /target:/
              @@targets=unless @@targets.is_a?(Array)
                sel.split(/targets?:\s*|\s+/) - ['']
              else @@targets
              end
            end
          end
        else puts 'no po target languages found' ; exit
        end
      end
    end
    self
  end
  def language
    def source_language_selected(src=nil)
      @@source=if not @@source.nil? \
      and @@source.is_a?(String) \
      and @@source =~/\w{2,4}/
        @@source
      elsif (src \
      && src.is_a?(String) \
      && src.length > 1)
        src
      else
        src=languages_from_file.language_source
      end
    end
    def translation_languages_selected(targets=nil) #translation_languages
      @@targets=if not @@targets.nil? \
      and @@targets.is_a?(Array) \
      and @@targets.length > 0
        @@targets
      elsif (targets \
      && targets.is_a?(Array) \
      && targets.length > 0)
        targets
      else
        targets=languages_from_file.language_targets
      end
    end
    def source_language_available
      [source_language_selected] & sisu_languages_available
    end
    def translation_languages_available
      translation_languages_selected & sisu_languages_available
    end
    def info_on_selection
      if translation_languages_selected != translation_languages_available
        <<-WOK
WARNING: language selections mismatch

The current language translation selection appears to be: #{translation_languages_selected_str}
Of which the following are valid (available) selections:  #{translation_languages_available_str}

sisu available language list: #{sisu_languages_available_str}

the following will be used: #{translation_languages_available_str}
The languages selected are located in the file:    #{filename.languages_src_tgt}
        WOK
      else
        <<-WOK
The current language translation selection is:  #{translation_languages_selected_str}
The languages selected are located in the file: #{filename.languages_src_tgt}

sisu available language list: #{sisu_languages_available_str}
        WOK
      end
    end
    def sisu_languages_available
      $SiSU_Language_Codes.language_list.codes
    end
    def possible_translations
      sisu_languages_available - [source_language_selected]
    end
    def translation_languages_selected_str
      language.translation_languages_selected.join(' ')
    end
    def source_language_available_str
      source_language_available.join
    end
    def translation_languages_available_str
      language.translation_languages_available.join(' ')
    end
    def sisu_languages_available_str
      language.sisu_languages_available.join(' ')
    end
    def posible_translations_str
      language.posible_translations.join(' ')
    end
    self
  end
  def files_src
    def ssm
      Dir.glob("#{language.source_language_selected}/*.ssm").sort
    end
    def sst
      Dir.glob("#{language.source_language_selected}/*.sst").sort
    end
    def ssi
      Dir.glob("#{language.source_language_selected}/*.ssi").sort
    end
    def all
      Dir.glob("#{language.source_language_selected}/*{.ssm,.sst,.ssi}").sort
    end
    self
  end
  def po4a_cfg_file
    File.open("#{Dir.pwd}/#{filename.po4a_cfg}",'w')
  end
  def po4a_create
    def configure #po4a_cfg
      po4a_cfg_arr=[]
      po4a_cfg_arr << "[po4a_langs] #{language.translation_languages_available_str}"
      po4a_cfg_arr << "[po4a_paths] #{dir.pot}/$master.pot $lang:#{dir.po}/$lang/$master.po"
      files_src.ssm.each do |file_src|
        file_src_fn=file_src.gsub(/#{language.source_language_selected}\//,'')
        po4a_cfg_arr << "[type: text] #{file_src} $lang:$lang/#{file_src_fn}"
      end
      files_src.sst.each do |file_src|
        file_src_fn=file_src.gsub(/#{language.source_language_selected}\//,'')
        po4a_cfg_arr << "[type: text] #{file_src} $lang:$lang/#{file_src_fn}"
      end
      files_src.ssi.each do |file_src|
        file_src_fn=file_src.gsub(/#{language.source_language_selected}\//,'')
        po4a_cfg_arr << "[type: text] #{file_src} $lang:$lang/#{file_src_fn}"
      end
      file=po4a_cfg_file
      po4a_cfg_arr.each do |txt|
      puts txt
        file << txt << "\n"
      end
      file.close
      cmd='po4a --keep 0 ' \
      + po4a_flags.normal + ' ' \
      + filename.po4a_cfg
      #cmd='po4a --keep 0 --no-backups --package-name ' \
      #+ 'sisu-manual' + ' ' \
      #+ po4a_flags.normal + ' ' \
      #+ filename.po4a_cfg
      system(cmd); puts cmd
    end
    self
  end
  def project
    def make
      dir_mk(dir.pot)
      language.translation_languages_available.each do |lang_dir|
        dir_lang="#{Dir.pwd}/#{dir.po}/#{lang_dir}"
        dir_mk(dir_lang)
      end
      po4a_create.configure
    end
    def clean
      #rm -f po/*/*.po~
      #rm -rf ../build
      FileUtils.rm_f Dir.glob("./#{dir.po}/*/*.po~")
    end
    def distclean
      #rm -f po4a.cfg
      #rm -rf $(LANGUAGES)
      FileUtils::rm_f(filename.po4a_cfg)
      FileUtils::rm_r(language.possible_translations,:force => true)
      #FileUtils::rm_r(language.translation_languages_available,:force => true)
    end
    self
  end
end
__END__
