/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
import QtQuick 1.1
import org.kde.plasma.components 0.1 as PlasmaComponents
import org.kde.plasma.core 0.1 as PlasmaCore

Item {
    id: mainWidget
    property int minimumWidth: 300
    property int minimumHeight: 200
    
    // Connect to our dataengine
    PlasmaCore.DataSource {
        id: banksSource
        engine: "skgdataengine"
        interval: 0
        connectedSources: ["Accounts"]
    }
    
    // Use a modelProxy for easy filtering / sorting
    PlasmaCore.SortFilterModel {
        id: banksModel
        sourceModel: PlasmaCore.DataModel {
            dataSource: banksSource
            keyRoleFilter: "[\\d]*"
        }
        sortRole: "type"
    }
    
    // A component for displaying the account with its balance in a row
    // The account name is a ToolButton that opens the account
    // tab on click
    
    // Put all accounts in a Column
    ListView {
        model: banksModel
        anchors {
            top: parent.top
            bottom: parent.bottom
            left: parent.left
            right: parent.right
        }
        delegate: PlasmaComponents.ListItem {
            id: accountItem
            
            Row {
                id: accountsRow
                    
                // The ToolButton for the account name
                PlasmaComponents.ToolButton{
                    id: nameButton
                    width: buttonText.implicitWidth + 10
                    height: buttonText.implicitHeight + 10
                    Text {
                        id: buttonText
                        text: name
                        anchors.centerIn: nameButton
                    }
                    onClicked: {
                        // TODO open the account tab
                    }
                }
                
                // The account Balance
                Text {
                    // TODO use the skrooge C++ formatMoney function
                    id: amountLabel
                    text: amount + " €"
                    horizontalAlignment: Text.AlignRight
                    anchors{
                        verticalCenter: nameButton.verticalCenter
                        right: accountItem.right
                    }
                    color: {
                        if (amount <= 0) {
                            "red"
                        } else {
                            theme.textColor
                        }
                    }
                    width: accountItem.width - nameButton.width
                }
            }
        }

        // Group all accounts per account type
        // TODO Group per type or bank, depending on settings
        section {
            property:"type"
            criteria: ViewSection.FullString
            delegate: Text { 
                horizontalAlignment: Text.AlignLeft
                font.bold: true
                text: section
            }
        }
    } 
}
