2.4 Durate e inviluppi

# Durate e inviluppi

Nelle sezioni precedenti, abbiamo visto come usare il comando `sleep` per controllare l’attacco della nota,  ma non siamo ancora in grado di controllare la durata dei suoni.  

Per dotarci di uno strumento semplice ma potente per *controllare le durate* dei suoni, Sonic Pi implementa il concetto di *inviluppo ADSR* (ci occuperemo più oltre in questa stessa sezione di cosa voglia dire ADSR). Un inviluppo di ampiezza permette di gestire due utili aspetti del controllo:
* controllo della durata di un suono
* controllo dell’ampiezza

## Durata

La durata è il tempo che un suono...dura! Una durata più lunga significa che sentirai il suono per un tempo più lungo. Tutti i suoni in Sonic Pi hanno un inviluppo di ampiezza controllabile, e la durata di tale inviluppo corrisponde alla durata del suono. Quindi, controllando l’inviluppo, controlli allo stesso tempo la durata.

## Ampiezza

L’inviluppo ADSR non controlla soltanto la durata, ma fornisce anche un *controllo accurato dell’ampiezza del suono*. Tutti i suoni udibili iniziano dal silenzio e finiscono nel silenzio, e contengono una parte non-silenziosa nel mezzo. Gli inviluppi ti permettono di variare e mantenere l’ampiezza della parte non-silenziosa del suono. È come dare a qualcuno istruzioni su come e quanto alzare e abbassare il volume dell’amplificatore della chitarra. Per esempio, potresti chiedere a questa persona di *iniziare dal silenzio, alzare il volume lentamente fino al massimo, mantenerlo per un po’ e riabbassarlo di colpo*. Sonic Pi ti permette di controllare con precisione questo tipo di comportamento mediante gli inviluppi.

Tanto per riassumere: come abbiamo visto prima, una ampiezza di 0 equivale a silenzio e un’ampiezza 1 è il volume normale (cioè il volume massimo che il computer può esprimere senza distorcere il segnale).. 
Ora, diamo un’occhiata alle parti da cui l’inviluppo è composto.

## Fase di rilascio (Release)

L’unica parte dell’inviluppo che viene usata di default è il rilascio (release). Si tratta del tempo che il suono di un synth impiega a dissolvere. Tutti i synth hanno un tempo di rilascio impostato a 1, il che vuol dire che, di default, hanno la durata di 1 beat (che a sua volta, al tempo di default di 60BPM, equivale a 1 secondo):

```
play 70
```

La nota resterà udibile per 1 secondo. Prova a verificare tu stesso. Questa era la forma breve in luogo di quella più lunga ed esplicita:

```
play 70, release: 1
```

Nota come il suono abbia esattamente la stessa durata di prima (il suono dura un secondo). Ma ora è molto facile cambiare la durata modificando il valore dell’opzione `release:` 

```
play 60, release: 2
```

Possiamo anche far suonare il synth per una durata molto breve usando un valore molto piccolo del tempo di rilascio:

```
play 60, release: 0.2
```

La durata del rilascio di un suono è chiamata *fase di rilascio* e, di default, è una transizione lineare (cioè segue una linea retta), Il seguente diagramma illustra questa transizione:

![release envelope](../images/tutorial/env-release.png)

La linea verticale sulla sinistra del diagramma indica che il suono comincia ad ampiezza 0, ma sale ad ampiezza massima immediatamente (questa è la fase di attacco, di cui ci occuperemo dopo). Raggiunta l’ampiezza massima, scende con una linea diritta fino a zero, e per fare questo impiega esattamente il tempo specificato da `release:`. *Valori di release più lunghi producono dissolvenze più lente*.

Ora poi cambiare la durata dei suoni cambiando il tempo di rilascio. Divertiti ad aggiungere i tempi di rilascio alle note della tua musica.

## Fase d’attacco

Di default, la *fase d’attacco* è 0 per tutti i synth, il che significa che questi salgono da ampiezza 0 a 1 immediatamente. Ciò conferisce ai synth un timbro percussivo. Tuttavia, potresti volere che il suono raggiunga l’ampiezza 1 più lentamente (*fade in*). Puoi ottenere questo risultato con l’opzione `attack:` 

```
play 60, attack: 2
sleep 3
play 65, attack: 0.5
```

Puoi usare opzioni multiple contemporaneamente. Per esempio, per un attacco corto e un rilascio lungo, prova così:

```
play 60, attack: 0.7, release: 4
```

Un inviluppo con attacco corto e rilascio lungo è illustrato nel diagramma seguente: 
![attack release envelope](../images/tutorial/env-attack-release.png)

È ovvio che puoi fare anche l’inverso. Prova un attacco lungo e un rilascio corto:

```
play 60, attack: 4, release: 0.7
```

![long attack short release envelope](../images/tutorial/env-long-attack-short-release.png)

Infine, puoi anche impostare un tempo corto sia per l’attacco che per il rilascio, per avere suoni più brevi:

```
play 60, attack: 0.5, release: 0.5
```

![short attack short release envelope](../images/tutorial/env-short-attack-short-release.png)

## Fase di sostegno (Sustain)

Oltre ai tempi di attacco e rilascio, puoi specificare anche un tempo di sostegno (sustain) per controllare la *fase di sostegno*. Essa corrisponde al tempo in cui il suono è mantenuto ad ampiezza fissa dopo l’attacco e prima del rilascio:

```
play 60, attack: 0.3, sustain: 1, release: 1
```

![ASR envelope](../images/tutorial/env-attack-sustain-release.png)

Il tempo di sostegno è utile per suoni a cui vuoi dare maggior presenza nel mix prima di inserire una fase, opzionale, di rilascio. Naturalmente, è del tutto valido anche impostare sia l’attacco che il rilascio a 0 per non avere alcun tipo di dissolvenza né in entrata né in uscita. Bada però che un tempo di rilascio uguale a 0 genera dei click, ed è meglio usare valori molto piccoli come 0.2.

## Decay Phase
## Fase di decadimento (Decay)

Per un ulteriore livello di controllo, puoi specificare anche un tempo di decadimento. Si tratta di una fase dell’inviluppo che si trova tra attacco e sostegno e specifica il tempo in cui l’ampiezza cade da `attack_level:` (livello d’attacco) a `decay_level:` (livello di decadimento). Di default, l’opzione `decay:` ha valore 0 e sia il livello di attacco che il livello di sostegno sono impostati su 1, e ciò significa che dovrai impostarne il valore in modo esplicito se vuoi che il tempo di decadimento sortisca qualche effetto: 

```
play 60, attack: 0.1, attack_level: 1, decay: 0.2, sustain_level: 0.4, sustain: 1, release: 0.5
```

![ADSR envelope](../images/tutorial/env-attack-decay-sustain-release.png)


## Livello di decadimento

Un’altra possibilità è impostare esplicitamente i valori di `decay_level:` e `sustain_level:` (anche se di default sono uguali) per avere pieno controllo sull’inviluppo. Ciò consente di creare inviluppi nel modo seguente:
```
play 60, attack: 0.1, attack_level: 1, decay: 0.2, decay_level: 0.3, sustain: 1, sustain_level: 0.4, release: 0.5
```

![ASR envelope](../images/tutorial/env-decay-level.png)

È possibile anche impostare un `decay_level:` più alto del  `sustain_level:`
```
play 60, attack: 0.1, attack_level: 0.1, decay: 0.2, decay_level: 1, sustain: 0.5, sustain_level: 0.8, release: 1.5
```

![ASR envelope](../images/tutorial/env-decay-level-2.png)

## ADSR Envelopes

Riassumendo, gli inviluppi di Sonic Pi hanno le seguenti fasi:

1. tempo di *attacco* per transitare da ampiezza 0 a `attack_level`,
2. tempo di *decadimento* per transitare da `attack_level` a `decay_level`,
3. tempo di *sostegno* per transitare da `decay_level` a `sustain_level`,
4. tempo di  *rilascio* per transitare da `sustain_level` a 0

È importante sottolineare che la durata di un suono è pari alla somma dei tempi di ciascuna di queste quattro fasi. Quindi, il suono seguente avrà una durata pari a 0.5 + 1 + 2 + 0.5 beat:

```
play 60, attack: 0.5, attack_level: 1, decay: 1, sustain_level: 0.4, sustain: 2, release: 0.5
```

E adesso datti da fare ad aggiungere gli inviluppi ai tuoi suoni...