-- GIFI codes as set by the Canadian Government
-- It's a dirty job, but it seems somebody allready did it
-- PDF Tammes, Tue , 02 Apr 2002
-- remarks or questions to finance@bermuda-holding.com
--
-- From the GIFI documentation: 
--
-- The GIFI information has to balance. We use the following rules to verify the information you provide.
-- total assets = total liabilities + total shareholder equity
-- total revenue - total expenses = net non-farming income
-- total farm revenue - total farm expenses = net farm income
-- 
-- You have to provide certain line items so that we can verify the above equations. Each GIFI must include:
-- balance sheet
-- Item 2599  Total assets
-- Item 3499  Total liabilities
-- Item 3620  Total shareholder equity
-- non-farming income and expenses
-- Item 8299  Total revenue
-- Item 9368  Total expenses 
-- and/or 
-- farming income and expenses
-- Item 9659  Total farm revenue
-- Item 9898  Total farm expenses
-- when reporting a breakdown of retained earnings
-- Item 3849  Retained earnings/deficit end
-- extraordinary items and income taxes
-- Item 9999  Net income/loss after taxes and extraordinary items
-- If the amount of a required item is NIL, you have to enter 0.
--
INSERT INTO gifi (accno,description) VALUES ('1000', 'Cash & Deposits');
INSERT INTO gifi (accno,description) VALUES ('1001', 'Cash');
INSERT INTO gifi (accno,description) VALUES ('1002', 'Deposits In Canadian Banks And Institutions - Canadian Currency');
INSERT INTO gifi (accno,description) VALUES ('1003', 'Deposits In Canadian Banks And Institutions - Foreign Currency');
INSERT INTO gifi (accno,description) VALUES ('1004', 'Deposits In Foreign Banks - Canadian Currency');
INSERT INTO gifi (accno,description) VALUES ('1005', 'Deposits In Foreign Banks - Foreign Currency');
INSERT INTO gifi (accno,description) VALUES ('1006', 'Credit Union Central Deposits');
INSERT INTO gifi (accno,description) VALUES ('1007', 'Other Cash Like Instruments - Gold Bullion, Silver Bullion');
INSERT INTO gifi (accno,description) VALUES ('1060', 'Accounts Receivable');
INSERT INTO gifi (accno,description) VALUES ('1061', 'Allowance For Doubtfull Accounts Receivable');
INSERT INTO gifi (accno,description) VALUES ('1062', 'Trade Accounts Receivable');
INSERT INTO gifi (accno,description) VALUES ('1063', 'Allowance For Doubtfull Trade Accounts Receivable');
INSERT INTO gifi (accno,description) VALUES ('1064', 'Trade Accounts Receivable Related Parties');
INSERT INTO gifi (accno,description) VALUES ('1065', 'Allowance For Doubtfull Trade Accounts Receivable Related Parties');
INSERT INTO gifi (accno,description) VALUES ('1066', 'Taxes Receivable');
INSERT INTO gifi (accno,description) VALUES ('1067', 'Intrest Receivable');
INSERT INTO gifi (accno,description) VALUES ('1068', 'Holdbacks Receivable');
INSERT INTO gifi (accno,description) VALUES ('1069', 'Leases Receivable');
INSERT INTO gifi (accno,description) VALUES ('1070', 'Allowance For Doubtfull Leases Receivable');
INSERT INTO gifi (accno,description) VALUES ('1071', 'Accounts Receivable Employees');
INSERT INTO gifi (accno,description) VALUES ('1072', 'Allowance For Doubtfull Accounts Receivable Employees');
INSERT INTO gifi (accno,description) VALUES ('1073', 'Accounts Receivable From Members Of NPO');
INSERT INTO gifi (accno,description) VALUES ('1120', 'Inventories');
INSERT INTO gifi (accno,description) VALUES ('1121', 'Inventory Of Goods For Sale/Finished Goods');
INSERT INTO gifi (accno,description) VALUES ('1122', 'Inventory Of Parts And Supplies');
INSERT INTO gifi (accno,description) VALUES ('1123', 'Inventory Properties');
INSERT INTO gifi (accno,description) VALUES ('1124', 'Inventory of Aggregates');
INSERT INTO gifi (accno,description) VALUES ('1125', 'Work In Progress');
INSERT INTO gifi (accno,description) VALUES ('1126', 'Raw Materials');
INSERT INTO gifi (accno,description) VALUES ('1127', 'Inventory of Securities');
INSERT INTO gifi (accno,description) VALUES ('1180', 'Short Term Investments');
INSERT INTO gifi (accno,description) VALUES ('1181', 'Canadian Term Deposits');
INSERT INTO gifi (accno,description) VALUES ('1182', 'Canadian Shares');
INSERT INTO gifi (accno,description) VALUES ('1183', 'Canadian Bonds');
INSERT INTO gifi (accno,description) VALUES ('1184', 'Canadian Treasury Bills');
INSERT INTO gifi (accno,description) VALUES ('1185', 'Securities Purchased Under Resale Agreement');
INSERT INTO gifi (accno,description) VALUES ('1186', 'Other Short Term Canadian Investments');
INSERT INTO gifi (accno,description) VALUES ('1187', 'Short Term Foreign Investments');
INSERT INTO gifi (accno,description) VALUES ('1240', 'Loans & Notes Receivable');
INSERT INTO gifi (accno,description) VALUES ('1241', 'Demand Loans Receivable');
INSERT INTO gifi (accno,description) VALUES ('1242', 'Other Loans Receivable');
INSERT INTO gifi (accno,description) VALUES ('1243', 'Notes Receivable');
INSERT INTO gifi (accno,description) VALUES ('1244', 'Mortgages Receivable');
INSERT INTO gifi (accno,description) VALUES ('1300', 'Due From Shareholder(s)/Director(s)');
INSERT INTO gifi (accno,description) VALUES ('1301', 'Due From Individual Shareholder(s)');
INSERT INTO gifi (accno,description) VALUES ('1302', 'Due From Corporate Shareholder(s)');
INSERT INTO gifi (accno,description) VALUES ('1303', 'Due From Director(s)');
INSERT INTO gifi (accno,description) VALUES ('1360', 'Investment In Joint Venture(s)/Partnership(s)');
INSERT INTO gifi (accno,description) VALUES ('1380', 'Due From Joint Venture(s)/Partnership(s)');
INSERT INTO gifi (accno,description) VALUES ('1400', 'Due From/Investment In Related Parties');
INSERT INTO gifi (accno,description) VALUES ('1401', 'Demand Notes From Related Parties');
INSERT INTO gifi (accno,description) VALUES ('1402', 'Interest Receivable From Related Parties');
INSERT INTO gifi (accno,description) VALUES ('1403', 'Loans/Advances Due From Related Parties');
INSERT INTO gifi (accno,description) VALUES ('1460', 'Customer\'s Liability under Acceptances');
INSERT INTO gifi (accno,description) VALUES ('1480', 'Other Current Assets');
INSERT INTO gifi (accno,description) VALUES ('1481', 'Deferred Income Taxes');
INSERT INTO gifi (accno,description) VALUES ('1482', 'Accrued Investment Income');
INSERT INTO gifi (accno,description) VALUES ('1483', 'Taxes Recoverable/Refundable');
INSERT INTO gifi (accno,description) VALUES ('1484', 'Prepaid Expenses');
INSERT INTO gifi (accno,description) VALUES ('1485', 'Drilling Advances');
INSERT INTO gifi (accno,description) VALUES ('1486', 'Security Deposits');
INSERT INTO gifi (accno,description) VALUES ('1599', 'Total Current Assets');
INSERT INTO gifi (accno,description) VALUES ('1600', 'Land');
INSERT INTO gifi (accno,description) VALUES ('1601', 'Land Improvement');
INSERT INTO gifi (accno,description) VALUES ('1602', 'Accumulated Amortization Of Land & Land Improvement');
INSERT INTO gifi (accno,description) VALUES ('1620', 'Depletable Assets');
INSERT INTO gifi (accno,description) VALUES ('1621', 'Accumulated Amortization Of Depletable Assets');
INSERT INTO gifi (accno,description) VALUES ('1622', 'Petroleum & Natural Gas Properties');
INSERT INTO gifi (accno,description) VALUES ('1623', 'Accumulated Amortization Of Petroleum & Natural Gas Properties');
INSERT INTO gifi (accno,description) VALUES ('1624', 'Mining Properties');
INSERT INTO gifi (accno,description) VALUES ('1625', 'Accumulated Amortization Of Mining Properties');
INSERT INTO gifi (accno,description) VALUES ('1626', 'Deferred Exporation & Development charges');
INSERT INTO gifi (accno,description) VALUES ('1627', 'Accumulated Amortization Of Petroleum & Deferred Exporation & Development charges');
INSERT INTO gifi (accno,description) VALUES ('1628', 'Quarries');
INSERT INTO gifi (accno,description) VALUES ('1629', 'Accumulated Amortization Of Quarries');
INSERT INTO gifi (accno,description) VALUES ('1630', 'Gravel Pits');
INSERT INTO gifi (accno,description) VALUES ('1631', 'Accumulated Amortization Of Gravel Pits');
INSERT INTO gifi (accno,description) VALUES ('1632', 'Timber Limits');
INSERT INTO gifi (accno,description) VALUES ('1633', 'Accumulated Amortization Of Timber Limits');
INSERT INTO gifi (accno,description) VALUES ('1680', 'Buildings');
INSERT INTO gifi (accno,description) VALUES ('1681', 'Accumulated Amortization Of Buildings');
INSERT INTO gifi (accno,description) VALUES ('1682', 'Manufacturing And Processing Plant');
INSERT INTO gifi (accno,description) VALUES ('1683', 'Accumulated Amortization Of Manufacturing and Processing Plant');
INSERT INTO gifi (accno,description) VALUES ('1684', 'Buildings Under Construction');
INSERT INTO gifi (accno,description) VALUES ('1740', 'Machinery, Equipment, furniture & fixtures');
INSERT INTO gifi (accno,description) VALUES ('1741', 'Accumulated Amortization Of Machinery, Equipment, furniture & fixtures');
INSERT INTO gifi (accno,description) VALUES ('1742', 'Motor Vehicles');
INSERT INTO gifi (accno,description) VALUES ('1743', 'Accumulated Amortization Of Motor Vehicles');
INSERT INTO gifi (accno,description) VALUES ('1744', 'Tools and Dies');
INSERT INTO gifi (accno,description) VALUES ('1745', 'Accumulated Amortization Of Tools and Dies');
INSERT INTO gifi (accno,description) VALUES ('1746', 'Construction & Excavating Equipment');
INSERT INTO gifi (accno,description) VALUES ('1747', 'Accumulated Amortization Of Construction & Excavating Equipment');
INSERT INTO gifi (accno,description) VALUES ('1748', 'Forestry & Logging Equipment');
INSERT INTO gifi (accno,description) VALUES ('1749', 'Accumulated Amortization Of Forestry & Logging Equipment');
INSERT INTO gifi (accno,description) VALUES ('1750', 'Fishing Gear & Nets');
INSERT INTO gifi (accno,description) VALUES ('1751', 'Accumulated Amortization Of Fishing Gear & Nets');
INSERT INTO gifi (accno,description) VALUES ('1752', 'Mining Equipment');
INSERT INTO gifi (accno,description) VALUES ('1753', 'Accumulated Amortization Of Mining Equipment');
INSERT INTO gifi (accno,description) VALUES ('1754', 'Oil & Gas Systems');
INSERT INTO gifi (accno,description) VALUES ('1755', 'Accumulated Amortization Of Oil & Gas Systems');
INSERT INTO gifi (accno,description) VALUES ('1756', 'Production Equipment for resource industries');
INSERT INTO gifi (accno,description) VALUES ('1757', 'Accumulated Amortization Of Production Equipment for resource industries');
INSERT INTO gifi (accno,description) VALUES ('1758', 'Production Equipment for other industries');
INSERT INTO gifi (accno,description) VALUES ('1759', 'Accumulated Amortization Of Production Equipment for other industries');
INSERT INTO gifi (accno,description) VALUES ('1760', 'Exploration Equipment');
INSERT INTO gifi (accno,description) VALUES ('1761', 'Accumulated Amortization Of Exploration Equipment');
INSERT INTO gifi (accno,description) VALUES ('1762', 'Shipping Equipment');
INSERT INTO gifi (accno,description) VALUES ('1763', 'Accumulated Amortization Of Shipping Equipment');
INSERT INTO gifi (accno,description) VALUES ('1764', 'Ships & Boats');
INSERT INTO gifi (accno,description) VALUES ('1765', 'Accumulated Amortization Of Ships & Boats');
INSERT INTO gifi (accno,description) VALUES ('1766', 'Aircraft');
INSERT INTO gifi (accno,description) VALUES ('1767', 'Accumulated Amortization Of Aircraft');
INSERT INTO gifi (accno,description) VALUES ('1768', 'Signs');
INSERT INTO gifi (accno,description) VALUES ('1769', 'Accumulated Amortization Of Signs');
INSERT INTO gifi (accno,description) VALUES ('1770', 'Small Tools');
INSERT INTO gifi (accno,description) VALUES ('1771', 'Accumulated Amortization Of Small Tools');
INSERT INTO gifi (accno,description) VALUES ('1772', 'Radio & Communication Equipment');
INSERT INTO gifi (accno,description) VALUES ('1773', 'Accumulated Amortization Of Radio & Communication Equipment');
INSERT INTO gifi (accno,description) VALUES ('1774', 'Computer Equipment/Software');
INSERT INTO gifi (accno,description) VALUES ('1775', 'Accumulated Amortization Of Computer Equipment/software');
INSERT INTO gifi (accno,description) VALUES ('1776', 'Musical Instruments');
INSERT INTO gifi (accno,description) VALUES ('1777', 'Accumulated Amortization Of Musical Instruments');
INSERT INTO gifi (accno,description) VALUES ('1778', 'Satellites');
INSERT INTO gifi (accno,description) VALUES ('1779', 'Accumulated Amortization Of Satellites');
INSERT INTO gifi (accno,description) VALUES ('1780', 'Earth Stations');
INSERT INTO gifi (accno,description) VALUES ('1781', 'Accumulated Amortization Of Earth Stations');
INSERT INTO gifi (accno,description) VALUES ('1782', 'Machinery & Equipment Under Construction');
INSERT INTO gifi (accno,description) VALUES ('1783', 'Transportation Equipment');
INSERT INTO gifi (accno,description) VALUES ('1784', 'Accumulated Amortization Of Transportation Equipment');
INSERT INTO gifi (accno,description) VALUES ('1785', 'Other Machinery & Equipment');
INSERT INTO gifi (accno,description) VALUES ('1786', 'Accumulated Amortization Of Other Machinery & Equipment');
INSERT INTO gifi (accno,description) VALUES ('1787', 'Furniture & Fixtures');
INSERT INTO gifi (accno,description) VALUES ('1788', 'Accumulated Amortization Of Furniture & Fixtures');
INSERT INTO gifi (accno,description) VALUES ('1900', 'Other Tangible Capital Assets');
INSERT INTO gifi (accno,description) VALUES ('1901', 'Accumulated Amortization Of Other Tangible Capital Assets');
INSERT INTO gifi (accno,description) VALUES ('1902', 'Logging Roads');
INSERT INTO gifi (accno,description) VALUES ('1903', 'Accumulated Amortization Of Logging Roads');
INSERT INTO gifi (accno,description) VALUES ('1904', 'Asphalt & Parking Areas');
INSERT INTO gifi (accno,description) VALUES ('1905', 'Accumulated Amortization Of Asphalt & Parking Areas');
INSERT INTO gifi (accno,description) VALUES ('1906', 'Wharves, Docks & Marinas');
INSERT INTO gifi (accno,description) VALUES ('1907', 'Accumulated Amortization Of Wharves, Docks & Marinas');
INSERT INTO gifi (accno,description) VALUES ('1908', 'Fences');
INSERT INTO gifi (accno,description) VALUES ('1909', 'Accumulated Amortization Of Fences');
INSERT INTO gifi (accno,description) VALUES ('1910', 'Capital Leases - Buildings');
INSERT INTO gifi (accno,description) VALUES ('1911', 'Accumulated Amortization Of Capital Leases - Buildings');
INSERT INTO gifi (accno,description) VALUES ('1912', 'Capital Leases - Equipment');
INSERT INTO gifi (accno,description) VALUES ('1913', 'Accumulated Amortization Of Capital Leases - Equipment');
INSERT INTO gifi (accno,description) VALUES ('1914', 'Capital Leases - Vehicles');
INSERT INTO gifi (accno,description) VALUES ('1915', 'Accumulated Amortization Of Capital Leases - Vehicles');
INSERT INTO gifi (accno,description) VALUES ('1916', 'Capital Leases - Other');
INSERT INTO gifi (accno,description) VALUES ('1917', 'Accumulated Amortization Of Capital Leases - Other');
INSERT INTO gifi (accno,description) VALUES ('1918', 'Leasehold Improvements');
INSERT INTO gifi (accno,description) VALUES ('1919', 'Accumulated Amortization Of Leasehold Improvements');
INSERT INTO gifi (accno,description) VALUES ('1920', 'Other Capital Assets Under Construction');
INSERT INTO gifi (accno,description) VALUES ('1921', 'Campsites');
INSERT INTO gifi (accno,description) VALUES ('1922', 'Accumulated Amortization Of Campsites');
INSERT INTO gifi (accno,description) VALUES ('2008', 'Total Tangible Capital Assets');
INSERT INTO gifi (accno,description) VALUES ('2009', 'Total Accumulated Amortization Of Tangible Capital Assets');
INSERT INTO gifi (accno,description) VALUES ('2010', 'Intangible Assets');
INSERT INTO gifi (accno,description) VALUES ('2011', 'Accumulated Amortization Of Intangible Assets');
INSERT INTO gifi (accno,description) VALUES ('2012', 'Goodwill');
INSERT INTO gifi (accno,description) VALUES ('2013', 'Accumulated Amortization Of Goodwill');
INSERT INTO gifi (accno,description) VALUES ('2014', 'Quota');
INSERT INTO gifi (accno,description) VALUES ('2015', 'Accumulated Amortization Of Quota');
INSERT INTO gifi (accno,description) VALUES ('2016', 'Licences');
INSERT INTO gifi (accno,description) VALUES ('2017', 'Accumulated Amortization Of Licences');
INSERT INTO gifi (accno,description) VALUES ('2018', 'Incorporation Costs');
INSERT INTO gifi (accno,description) VALUES ('2019', 'Accumulated Amortization Of Incorporation Costs');
INSERT INTO gifi (accno,description) VALUES ('2020', 'Trademarks & Patents');
INSERT INTO gifi (accno,description) VALUES ('2021', 'Accumulated Amortization Of Trademarks & Patents');
INSERT INTO gifi (accno,description) VALUES ('2022', 'Customer Lists');
INSERT INTO gifi (accno,description) VALUES ('2023', 'Accumulated Amortization Of Customer Lists');
INSERT INTO gifi (accno,description) VALUES ('2024', 'Rights');
INSERT INTO gifi (accno,description) VALUES ('2025', 'Accumulated Amortization Of Rights');
INSERT INTO gifi (accno,description) VALUES ('2026', 'Research & Development');
INSERT INTO gifi (accno,description) VALUES ('2027', 'Accumulated Amortization Of Research & Development');
INSERT INTO gifi (accno,description) VALUES ('2070', 'Resource Rights');
INSERT INTO gifi (accno,description) VALUES ('2071', 'Accumulated Amortization Of Resource Rights');
INSERT INTO gifi (accno,description) VALUES ('2072', 'Timber Rights');
INSERT INTO gifi (accno,description) VALUES ('2073', 'Accumulated Amortization Of Timber Rights');
INSERT INTO gifi (accno,description) VALUES ('2074', 'Mining Rights');
INSERT INTO gifi (accno,description) VALUES ('2075', 'Accumulated Amortization Of Mining Rights');
INSERT INTO gifi (accno,description) VALUES ('2076', 'Oil & Gas Rights');
INSERT INTO gifi (accno,description) VALUES ('2077', 'Accumulated Amortization Of Oil & Gas Rights');
INSERT INTO gifi (accno,description) VALUES ('2178', 'Total Intangible Capital Assets');
INSERT INTO gifi (accno,description) VALUES ('2179', 'Total Accumulated Amortization Of Intangible Capital Assets');
INSERT INTO gifi (accno,description) VALUES ('2180', 'Due From Shareholder(s)/Director(s)');
INSERT INTO gifi (accno,description) VALUES ('2181', 'Due From Individual Shareholder(s)');
INSERT INTO gifi (accno,description) VALUES ('2182', 'Due From Corporate Shareholder(s)');
INSERT INTO gifi (accno,description) VALUES ('2183', 'Due From Director(s)');
INSERT INTO gifi (accno,description) VALUES ('2190', 'Due from Members');
INSERT INTO gifi (accno,description) VALUES ('2200', 'Investment In Joint Venture(s)/Partnership(s)');
INSERT INTO gifi (accno,description) VALUES ('2220', 'Due From Joint Venture(s)/Partnership(s)');
INSERT INTO gifi (accno,description) VALUES ('2240', 'Due From/Investment In Related Parties');
INSERT INTO gifi (accno,description) VALUES ('2241', 'Due From/Investment In Canadian Related Parties');
INSERT INTO gifi (accno,description) VALUES ('2242', 'Shares In Canadian Related Corporations');
INSERT INTO gifi (accno,description) VALUES ('2243', 'Loans/Advances To Canadian Related Corporations');
INSERT INTO gifi (accno,description) VALUES ('2244', 'Investment In Canadian Related Corporations At Cost');
INSERT INTO gifi (accno,description) VALUES ('2245', 'Investment In Canadian Related Corporations At Equity');
INSERT INTO gifi (accno,description) VALUES ('2246', 'Due From/Investment In Foreign Related Parties');
INSERT INTO gifi (accno,description) VALUES ('2247', 'Shares In Foreign Related Corporations');
INSERT INTO gifi (accno,description) VALUES ('2248', 'Loans/Advances To Foreign Related Corporations');
INSERT INTO gifi (accno,description) VALUES ('2249', 'Investment In Foreign Related Corporations At Cost');
INSERT INTO gifi (accno,description) VALUES ('2250', 'Investment In Foreign Related Corporations At Equity');
INSERT INTO gifi (accno,description) VALUES ('2280', 'Investment In Co-Tenancy');
INSERT INTO gifi (accno,description) VALUES ('2300', 'Long Term Investments');
INSERT INTO gifi (accno,description) VALUES ('2301', 'Foreign Shares');
INSERT INTO gifi (accno,description) VALUES ('2302', 'Other Type Of Foreign Investments');
INSERT INTO gifi (accno,description) VALUES ('2303', 'Canadian Shares');
INSERT INTO gifi (accno,description) VALUES ('2304', 'Government Of Canada Debt');
INSERT INTO gifi (accno,description) VALUES ('2305', 'Canadian Provinvial & Municipal Government Debt');
INSERT INTO gifi (accno,description) VALUES ('2306', 'Canadian Corporate Bonds & Debentures');
INSERT INTO gifi (accno,description) VALUES ('2307', 'Debt Securities');
INSERT INTO gifi (accno,description) VALUES ('2308', 'Equity Securities');
INSERT INTO gifi (accno,description) VALUES ('2309', 'Securities Purchased Under Resale Agreements');
INSERT INTO gifi (accno,description) VALUES ('2310', 'Central Credit Union Shares');
INSERT INTO gifi (accno,description) VALUES ('2311', 'Other Long Term Canadian Investments');
INSERT INTO gifi (accno,description) VALUES ('2360', 'Long Term Loans');
INSERT INTO gifi (accno,description) VALUES ('2361', 'Mortgages');
INSERT INTO gifi (accno,description) VALUES ('2362', 'Personal & Credit Card Loans');
INSERT INTO gifi (accno,description) VALUES ('2363', 'Business & Government Loans');
INSERT INTO gifi (accno,description) VALUES ('2364', 'Line Of Credit');
INSERT INTO gifi (accno,description) VALUES ('2420', 'Other Long Term Assets');
INSERT INTO gifi (accno,description) VALUES ('2421', 'Deferred Income Taxes / Tax Reserves');
INSERT INTO gifi (accno,description) VALUES ('2422', 'Deferred Pension Charges');
INSERT INTO gifi (accno,description) VALUES ('2423', 'Deferred Unrealized Exchange Losses');
INSERT INTO gifi (accno,description) VALUES ('2424', 'Other Deferred Items/Charges');
INSERT INTO gifi (accno,description) VALUES ('2425', 'Accumulated Amortization Of Deferred Charges');
INSERT INTO gifi (accno,description) VALUES ('2426', 'Reserve Fund');
INSERT INTO gifi (accno,description) VALUES ('2427', 'Cash Surrender Value Of Life Insurance');
INSERT INTO gifi (accno,description) VALUES ('2589', 'Total Long Term Assets');
INSERT INTO gifi (accno,description) VALUES ('2590', 'Assets Held In Trust');
INSERT INTO gifi (accno,description) VALUES ('2599', 'Total Assets');
INSERT INTO gifi (accno,description) VALUES ('2600', 'Bank Overdraft');
INSERT INTO gifi (accno,description) VALUES ('2620', 'Amounts Payable & Accrued Liabilities');
INSERT INTO gifi (accno,description) VALUES ('2621', 'Accounts Payable Trade');
INSERT INTO gifi (accno,description) VALUES ('2622', 'Accounts Payable To Related Parties');
INSERT INTO gifi (accno,description) VALUES ('2623', 'Holdbacks Payable');
INSERT INTO gifi (accno,description) VALUES ('2624', 'Wages Payable');
INSERT INTO gifi (accno,description) VALUES ('2625', 'Management Fees Payable');
INSERT INTO gifi (accno,description) VALUES ('2626', 'Bonuses Payable');
INSERT INTO gifi (accno,description) VALUES ('2627', 'Employee Deductions Payable');
INSERT INTO gifi (accno,description) VALUES ('2628', 'Withholding Taxes Payable');
INSERT INTO gifi (accno,description) VALUES ('2629', 'Intrest Payable');
INSERT INTO gifi (accno,description) VALUES ('2680', 'Taxes Payable');
INSERT INTO gifi (accno,description) VALUES ('2681', 'Capital Taxes Payable');
INSERT INTO gifi (accno,description) VALUES ('2682', 'Foreign Taxes Payable');
INSERT INTO gifi (accno,description) VALUES ('2683', 'Federal Taxes Payable');
INSERT INTO gifi (accno,description) VALUES ('2684', 'Provincial Taxes Payable');
INSERT INTO gifi (accno,description) VALUES ('2685', 'GST Payable');
INSERT INTO gifi (accno,description) VALUES ('2686', 'PST Payable');
INSERT INTO gifi (accno,description) VALUES ('2700', 'Short Term Debt');
INSERT INTO gifi (accno,description) VALUES ('2701', 'Loans From Canadian Banks');
INSERT INTO gifi (accno,description) VALUES ('2702', 'Liability For Securities Sold Short');
INSERT INTO gifi (accno,description) VALUES ('2703', 'Liability For Securities Sold Under Repurchase Agreements');
INSERT INTO gifi (accno,description) VALUES ('2704', 'Gold & Silver Certificates');
INSERT INTO gifi (accno,description) VALUES ('2705', 'Cheques & Other Items In Transit');
INSERT INTO gifi (accno,description) VALUES ('2706', 'Lien Notes');
INSERT INTO gifi (accno,description) VALUES ('2770', 'Deferred Income');
INSERT INTO gifi (accno,description) VALUES ('2780', 'Due To Shareholder(s)/Director(s)');
INSERT INTO gifi (accno,description) VALUES ('2781', 'Due To Individual Shareholder(s)');
INSERT INTO gifi (accno,description) VALUES ('2782', 'Due To Corporate Shareholder(s)');
INSERT INTO gifi (accno,description) VALUES ('2783', 'Due To Director(s)');
INSERT INTO gifi (accno,description) VALUES ('2840', 'Due To Joint Venture(s)/Partnership(s)');
INSERT INTO gifi (accno,description) VALUES ('2860', 'Due To Related Parties');
INSERT INTO gifi (accno,description) VALUES ('2861', 'Demand Notes Due To Related Parties');
INSERT INTO gifi (accno,description) VALUES ('2862', 'Interest Payable To Related Parties');
INSERT INTO gifi (accno,description) VALUES ('2863', 'Advances Due To Related Parties');
INSERT INTO gifi (accno,description) VALUES ('2920', 'Current Portion Of Long Term Liability');
INSERT INTO gifi (accno,description) VALUES ('2960', 'Other Current Liabilities');
INSERT INTO gifi (accno,description) VALUES ('2961', 'Deposits Received');
INSERT INTO gifi (accno,description) VALUES ('2962', 'Dividends Payable');
INSERT INTO gifi (accno,description) VALUES ('2963', 'Deferred Income Taxes');
INSERT INTO gifi (accno,description) VALUES ('2964', 'Reserves For Guarantees, Warranties Or Indemnities');
INSERT INTO gifi (accno,description) VALUES ('2965', 'General Reserves / Provisions');
INSERT INTO gifi (accno,description) VALUES ('2966', 'Crew Shares');
INSERT INTO gifi (accno,description) VALUES ('3139', 'Total Current Liabilities');
INSERT INTO gifi (accno,description) VALUES ('3140', 'Long Term Debt');
INSERT INTO gifi (accno,description) VALUES ('3141', 'Mortgages');
INSERT INTO gifi (accno,description) VALUES ('3142', 'Farm Credit Corporation Loan');
INSERT INTO gifi (accno,description) VALUES ('3143', 'Chartered Bank Loan');
INSERT INTO gifi (accno,description) VALUES ('3144', 'Credit Union/Caisse Populaire Loan');
INSERT INTO gifi (accno,description) VALUES ('3145', 'Provincial Government Loan');
INSERT INTO gifi (accno,description) VALUES ('3146', 'Supply Company Loan');
INSERT INTO gifi (accno,description) VALUES ('3147', 'Private Loan');
INSERT INTO gifi (accno,description) VALUES ('3148', 'Central, Leagues And Federation Loans');
INSERT INTO gifi (accno,description) VALUES ('3149', 'Line Of Credit');
INSERT INTO gifi (accno,description) VALUES ('3150', 'Liability For Securities Sold Short');
INSERT INTO gifi (accno,description) VALUES ('3151', 'Liability For Securities Sold Under Repurchase Agreements');
INSERT INTO gifi (accno,description) VALUES ('3152', 'Lien Notes');
INSERT INTO gifi (accno,description) VALUES ('3210', 'Bonds And Debentures');
INSERT INTO gifi (accno,description) VALUES ('3220', 'Deferred Income');
INSERT INTO gifi (accno,description) VALUES ('3240', 'Deferred Income Taxes');
INSERT INTO gifi (accno,description) VALUES ('3260', 'Long Term Due To Shareholder(s)/Director(s)');
INSERT INTO gifi (accno,description) VALUES ('3261', 'Long Term Due To Individual Shareholder(s)');
INSERT INTO gifi (accno,description) VALUES ('3262', 'Long Term Due To Corporate Shareholder(s)');
INSERT INTO gifi (accno,description) VALUES ('3263', 'Long Term Due To Director(s)');
INSERT INTO gifi (accno,description) VALUES ('3280', 'Long Term Due To Joint Venture(s)/Partnership(s)');
INSERT INTO gifi (accno,description) VALUES ('3300', 'Long Term Due To Related Parties');
INSERT INTO gifi (accno,description) VALUES ('3301', 'Amounts Owing To Related Canadian Parties');
INSERT INTO gifi (accno,description) VALUES ('3302', 'Amounts Owing To Related Foreign Parties');
INSERT INTO gifi (accno,description) VALUES ('3320', 'Other Long Term Liabilities');
INSERT INTO gifi (accno,description) VALUES ('3321', 'Long Term Obligations/Commitments/Leases');
INSERT INTO gifi (accno,description) VALUES ('3322', 'Reserves For Guarantees, Warranties Or Indemnities');
INSERT INTO gifi (accno,description) VALUES ('3323', 'Provision For Site Restoration');
INSERT INTO gifi (accno,description) VALUES ('3324', 'Contributions To Qualifying Environmental Trust');
INSERT INTO gifi (accno,description) VALUES ('3325', 'General Provisions / Reserves');
INSERT INTO gifi (accno,description) VALUES ('3326', 'Preference Shares Restated');
INSERT INTO gifi (accno,description) VALUES ('3327', 'Member Allocations');
INSERT INTO gifi (accno,description) VALUES ('3328', 'Deferred Income From Incomplete Contracts');
INSERT INTO gifi (accno,description) VALUES ('3450', 'Total Long Term Liabilities');
INSERT INTO gifi (accno,description) VALUES ('3460', 'Subordinated Debt');
INSERT INTO gifi (accno,description) VALUES ('3470', 'Amounts Held In Trust');
INSERT INTO gifi (accno,description) VALUES ('3499', 'Total Liabilities');
INSERT INTO gifi (accno,description) VALUES ('3500', 'Common Shares');
INSERT INTO gifi (accno,description) VALUES ('3520', 'Preferred Shares');
INSERT INTO gifi (accno,description) VALUES ('3540', 'Contributed & Other Surplus');
INSERT INTO gifi (accno,description) VALUES ('3541', 'Contributed Surplus');
INSERT INTO gifi (accno,description) VALUES ('3542', 'Appraisal Surplus');
INSERT INTO gifi (accno,description) VALUES ('3543', 'General Reserve');
INSERT INTO gifi (accno,description) VALUES ('3570', 'Head Office Account');
INSERT INTO gifi (accno,description) VALUES ('3600', 'Retained Earnings/Deficit');
INSERT INTO gifi (accno,description) VALUES ('3620', 'Total Shareholder Equity');
INSERT INTO gifi (accno,description) VALUES ('3640', 'Total Liabilities & Shareholder Equity');
INSERT INTO gifi (accno,description) VALUES ('3660', 'Retained Earnings/Deficit Start');
INSERT INTO gifi (accno,description) VALUES ('3680', 'Net Income/Loss');
INSERT INTO gifi (accno,description) VALUES ('3700', 'Dividend Declared');
INSERT INTO gifi (accno,description) VALUES ('3701', 'Cash Dividend');
INSERT INTO gifi (accno,description) VALUES ('3702', 'Patronage Dividend');
INSERT INTO gifi (accno,description) VALUES ('3720', 'Prior Year Adjustments');
INSERT INTO gifi (accno,description) VALUES ('3740', 'Other Items Affecting Retained Earnings');
INSERT INTO gifi (accno,description) VALUES ('3741', 'Share Redemptions');
INSERT INTO gifi (accno,description) VALUES ('3742', 'Special Reserves');
INSERT INTO gifi (accno,description) VALUES ('3743', 'Currency Adjustments');
INSERT INTO gifi (accno,description) VALUES ('3744', 'Unusual Revenue Items');
INSERT INTO gifi (accno,description) VALUES ('3745', 'Interfund Transfers (NPO)');
INSERT INTO gifi (accno,description) VALUES ('3849', 'Retained Earnings/Deficit End');
INSERT INTO gifi (accno,description) VALUES ('8000', 'Trade Sales of Goods and Services');
INSERT INTO gifi (accno,description) VALUES ('8020', 'Sales To Related Parties');
INSERT INTO gifi (accno,description) VALUES ('8030', 'Interdivisional Sales');
INSERT INTO gifi (accno,description) VALUES ('8040', 'Sales From Resource Properties');
INSERT INTO gifi (accno,description) VALUES ('8041', 'Petroleum & Natural Gas Sales');
INSERT INTO gifi (accno,description) VALUES ('8042', 'Petroleum & Natural Gas Sales To Related Parties');
INSERT INTO gifi (accno,description) VALUES ('8043', 'Gas Marketing');
INSERT INTO gifi (accno,description) VALUES ('8044', 'Processing Revenue');
INSERT INTO gifi (accno,description) VALUES ('8045', 'Pipeline Revenue');
INSERT INTO gifi (accno,description) VALUES ('8046', 'Seismic Sales');
INSERT INTO gifi (accno,description) VALUES ('8047', 'Mining Revenue');
INSERT INTO gifi (accno,description) VALUES ('8048', 'Coal Revenue');
INSERT INTO gifi (accno,description) VALUES ('8049', 'Oil Sands Revenue');
INSERT INTO gifi (accno,description) VALUES ('8050', 'Royalty Income');
INSERT INTO gifi (accno,description) VALUES ('8051', 'Oil & Gas Partnership/Joint Venture Income/Loss');
INSERT INTO gifi (accno,description) VALUES ('8052', 'Mining Partnership/Joint Venture Income/Loss');
INSERT INTO gifi (accno,description) VALUES ('8053', 'Other Production Revenue');
INSERT INTO gifi (accno,description) VALUES ('8089', 'Total Sales Of Goods And Services');
INSERT INTO gifi (accno,description) VALUES ('8090', 'Investment Revenue');
INSERT INTO gifi (accno,description) VALUES ('8091', 'Interest From Foreign Sources');
INSERT INTO gifi (accno,description) VALUES ('8092', 'Interest From Canadian Bonds And Debentures');
INSERT INTO gifi (accno,description) VALUES ('8093', 'Interest From Canadian Mortgage Loans');
INSERT INTO gifi (accno,description) VALUES ('8094', 'Interest From Other Canadian Sources');
INSERT INTO gifi (accno,description) VALUES ('8095', 'Dividend Income');
INSERT INTO gifi (accno,description) VALUES ('8096', 'Dividend From Canadian Sources');
INSERT INTO gifi (accno,description) VALUES ('8097', 'Interest From Foreign Sources');
INSERT INTO gifi (accno,description) VALUES ('8120', 'Commission Revenue');
INSERT INTO gifi (accno,description) VALUES ('8121', 'Commission Income On Real Estate Transactions');
INSERT INTO gifi (accno,description) VALUES ('8140', 'Rental Revenue');
INSERT INTO gifi (accno,description) VALUES ('8141', 'Real Estate Rental Revenue');
INSERT INTO gifi (accno,description) VALUES ('8150', 'Vehicle Leasing');
INSERT INTO gifi (accno,description) VALUES ('8160', 'Fishing Revenue');
INSERT INTO gifi (accno,description) VALUES ('8161', 'Fish Products');
INSERT INTO gifi (accno,description) VALUES ('8162', 'Other Marine Products');
INSERT INTO gifi (accno,description) VALUES ('8163', 'Fishing Grants, Credits & Rebates');
INSERT INTO gifi (accno,description) VALUES ('8164', 'Fishing Subsidies');
INSERT INTO gifi (accno,description) VALUES ('8165', 'Compensation For Loss Of Fishing Income/Property');
INSERT INTO gifi (accno,description) VALUES ('8166', 'Sharesman Income');
INSERT INTO gifi (accno,description) VALUES ('8210', 'Realized Gains/Losses On Disposal Of Assets');
INSERT INTO gifi (accno,description) VALUES ('8211', 'Realized Gains/Losses On Sale Of Investments');
INSERT INTO gifi (accno,description) VALUES ('8212', 'Realized Gains/Losses On Sale Of Resource Properties');
INSERT INTO gifi (accno,description) VALUES ('8220', 'NPO Amounts Received');
INSERT INTO gifi (accno,description) VALUES ('8221', 'Membership Fees');
INSERT INTO gifi (accno,description) VALUES ('8222', 'Assessments');
INSERT INTO gifi (accno,description) VALUES ('8223', 'Gifts');
INSERT INTO gifi (accno,description) VALUES ('8224', 'Gross Sales And Revenues From Organizational Activities');
INSERT INTO gifi (accno,description) VALUES ('8230', 'Other Revenue');
INSERT INTO gifi (accno,description) VALUES ('8231', 'Foreign Exchange Gains/Losses');
INSERT INTO gifi (accno,description) VALUES ('8232', 'Income/Loss Of Subsidiaries/Affiliates');
INSERT INTO gifi (accno,description) VALUES ('8233', 'Income/Loss Of Other Divisions');
INSERT INTO gifi (accno,description) VALUES ('8234', 'Income/Loss Of Joint Ventures');
INSERT INTO gifi (accno,description) VALUES ('8235', 'Income/Loss Of Partnerships');
INSERT INTO gifi (accno,description) VALUES ('8236', 'RealizaTion Of Deferred Revenues');
INSERT INTO gifi (accno,description) VALUES ('8237', 'Royalty Income Other Than Resource');
INSERT INTO gifi (accno,description) VALUES ('8238', 'Alberta Royalty Tax Credits');
INSERT INTO gifi (accno,description) VALUES ('8239', 'Management & Administration Fees');
INSERT INTO gifi (accno,description) VALUES ('8240', 'Telecommunications Revenues');
INSERT INTO gifi (accno,description) VALUES ('8241', 'Consulting Fees');
INSERT INTO gifi (accno,description) VALUES ('8242', 'Subsidies & Grants');
INSERT INTO gifi (accno,description) VALUES ('8243', 'Sale Of By-Products');
INSERT INTO gifi (accno,description) VALUES ('8244', 'Deposit Services');
INSERT INTO gifi (accno,description) VALUES ('8245', 'Credit Services');
INSERT INTO gifi (accno,description) VALUES ('8246', 'Card Services');
INSERT INTO gifi (accno,description) VALUES ('8247', 'Patronage Dividends');
INSERT INTO gifi (accno,description) VALUES ('8248', 'Insurance Recoveries');
INSERT INTO gifi (accno,description) VALUES ('8249', 'Expense Recoveries');
INSERT INTO gifi (accno,description) VALUES ('8250', 'Bad Debt Recoveries');
INSERT INTO gifi (accno,description) VALUES ('8299', 'Total Revenue');
INSERT INTO gifi (accno,description) VALUES ('8300', 'Opening Inventory');
INSERT INTO gifi (accno,description) VALUES ('8301', 'Opening Inventory - finished goods');
INSERT INTO gifi (accno,description) VALUES ('8302', 'Opening Inventory - raw materials');
INSERT INTO gifi (accno,description) VALUES ('8303', 'Opening Inventory - goods in process');
INSERT INTO gifi (accno,description) VALUES ('8304', 'Opening Inventory - work in process');
INSERT INTO gifi (accno,description) VALUES ('8320', 'Purchases / Cost of Materials');
INSERT INTO gifi (accno,description) VALUES ('8321', 'Purchases Product A');
INSERT INTO gifi (accno,description) VALUES ('8322', 'Purchases Product B');
INSERT INTO gifi (accno,description) VALUES ('8331', 'Price Differences & Discounts On Purchases');
INSERT INTO gifi (accno,description) VALUES ('8340', 'Direct Wages');
INSERT INTO gifi (accno,description) VALUES ('8350', 'Benefits On Direct Wages');
INSERT INTO gifi (accno,description) VALUES ('8360', 'Trades & Sub-contracts');
INSERT INTO gifi (accno,description) VALUES ('8370', 'Production Costs Other Than Resource');
INSERT INTO gifi (accno,description) VALUES ('8400', 'Resource Production Costs');
INSERT INTO gifi (accno,description) VALUES ('8401', 'Pipeline Operations');
INSERT INTO gifi (accno,description) VALUES ('8402', 'Drilling');
INSERT INTO gifi (accno,description) VALUES ('8403', 'Site Restoration Costs');
INSERT INTO gifi (accno,description) VALUES ('8404', 'Gross Overriding Royalty');
INSERT INTO gifi (accno,description) VALUES ('8405', 'Freehold Royalties');
INSERT INTO gifi (accno,description) VALUES ('8406', 'Other Producing Properties Rental');
INSERT INTO gifi (accno,description) VALUES ('8407', 'Prospect & Geological');
INSERT INTO gifi (accno,description) VALUES ('8408', 'Well Operating, Fuel & Equipment');
INSERT INTO gifi (accno,description) VALUES ('8409', 'Well Abandonment & Dry Holes');
INSERT INTO gifi (accno,description) VALUES ('8410', 'Other Lease Rentals');
INSERT INTO gifi (accno,description) VALUES ('8411', 'Exploration Expenses, Aerial Surveys');
INSERT INTO gifi (accno,description) VALUES ('8412', 'Development Expenses, stripping costs');
INSERT INTO gifi (accno,description) VALUES ('8435', 'Crown Charges');
INSERT INTO gifi (accno,description) VALUES ('8436', 'Crown royalties');
INSERT INTO gifi (accno,description) VALUES ('8437', 'Crown lease rentals');
INSERT INTO gifi (accno,description) VALUES ('8438', 'Freehold mineral tax');
INSERT INTO gifi (accno,description) VALUES ('8439', 'Mining taxes');
INSERT INTO gifi (accno,description) VALUES ('8440', 'Oil and Sand leases');
INSERT INTO gifi (accno,description) VALUES ('8441', 'Saskatchewan resource surcharge');
INSERT INTO gifi (accno,description) VALUES ('8450', 'Other Direct Costs');
INSERT INTO gifi (accno,description) VALUES ('8451', 'Equipment Hire & Operation');
INSERT INTO gifi (accno,description) VALUES ('8452', 'Log Yard');
INSERT INTO gifi (accno,description) VALUES ('8453', 'Forestry costs');
INSERT INTO gifi (accno,description) VALUES ('8454', 'Logging Road costs');
INSERT INTO gifi (accno,description) VALUES ('8455', 'Stumpage costs');
INSERT INTO gifi (accno,description) VALUES ('8456', 'Royalty costs');
INSERT INTO gifi (accno,description) VALUES ('8457', 'Freight In & Customs Duty');
INSERT INTO gifi (accno,description) VALUES ('8458', 'Inventory Write Down');
INSERT INTO gifi (accno,description) VALUES ('8459', 'Direct cost amortization of tangible assets');
INSERT INTO gifi (accno,description) VALUES ('8460', 'Direct cost amortization of natural resource assets');
INSERT INTO gifi (accno,description) VALUES ('8461', 'Overhead expenses allocated to cost of sales');
INSERT INTO gifi (accno,description) VALUES ('8500', 'Closing Inventory');
INSERT INTO gifi (accno,description) VALUES ('8501', 'Closing Inventory - Finished Goods');
INSERT INTO gifi (accno,description) VALUES ('8502', 'Closing Inventory - Raw Materials');
INSERT INTO gifi (accno,description) VALUES ('8503', 'Closing Inventory - Goods In Process');
INSERT INTO gifi (accno,description) VALUES ('8504', 'Closing Inventory - Work In Process');
INSERT INTO gifi (accno,description) VALUES ('8518', 'Cost Of Sales');
INSERT INTO gifi (accno,description) VALUES ('8519', 'Gross Profit/Loss');
INSERT INTO gifi (accno,description) VALUES ('8520', 'Advertising & Promotion');
INSERT INTO gifi (accno,description) VALUES ('8521', 'Advertising');
INSERT INTO gifi (accno,description) VALUES ('8522', 'Donations');
INSERT INTO gifi (accno,description) VALUES ('8523', 'Meals & Entertainment');
INSERT INTO gifi (accno,description) VALUES ('8524', 'Promotion');
INSERT INTO gifi (accno,description) VALUES ('8570', 'Amortization Of Intangible Assets');
INSERT INTO gifi (accno,description) VALUES ('8590', 'Bad Debt Expense');
INSERT INTO gifi (accno,description) VALUES ('8610', 'Loan Losses');
INSERT INTO gifi (accno,description) VALUES ('8611', 'Provision for Loan Losses');
INSERT INTO gifi (accno,description) VALUES ('8620', 'Employee Benefits');
INSERT INTO gifi (accno,description) VALUES ('8621', 'Group Insurance Benefits');
INSERT INTO gifi (accno,description) VALUES ('8622', 'Employers Portion Of Employee Benefits');
INSERT INTO gifi (accno,description) VALUES ('8623', 'Contributions To Deferred Income Plans');
INSERT INTO gifi (accno,description) VALUES ('8650', 'Amortization Of Natural Resource Assets');
INSERT INTO gifi (accno,description) VALUES ('8670', 'Amortization Of Tangible Assets');
INSERT INTO gifi (accno,description) VALUES ('8690', 'Insurance');
INSERT INTO gifi (accno,description) VALUES ('8691', 'Life Insurance On Executives');
INSERT INTO gifi (accno,description) VALUES ('8710', 'Interest & Bank Charges');
INSERT INTO gifi (accno,description) VALUES ('8711', 'Interest On Short Term Debt');
INSERT INTO gifi (accno,description) VALUES ('8712', 'Interest On Bonds And Debentures');
INSERT INTO gifi (accno,description) VALUES ('8713', 'Interest On Mortgages');
INSERT INTO gifi (accno,description) VALUES ('8714', 'Interest On Long Term Debt');
INSERT INTO gifi (accno,description) VALUES ('8715', 'Bank Charges');
INSERT INTO gifi (accno,description) VALUES ('8716', 'Credit Card Charges');
INSERT INTO gifi (accno,description) VALUES ('8717', 'Collection & Credit costs');
INSERT INTO gifi (accno,description) VALUES ('8760', 'Business Taxes, Licences & Memberships');
INSERT INTO gifi (accno,description) VALUES ('8761', 'Memberships');
INSERT INTO gifi (accno,description) VALUES ('8762', 'Business Taxes');
INSERT INTO gifi (accno,description) VALUES ('8763', 'Franchise Fees');
INSERT INTO gifi (accno,description) VALUES ('8764', 'Government Fees');
INSERT INTO gifi (accno,description) VALUES ('8780', 'New Brunswick Tax On Large Corporations');
INSERT INTO gifi (accno,description) VALUES ('8790', 'Nova Scotia Tax On Large Corporations');
INSERT INTO gifi (accno,description) VALUES ('8810', 'Office Expenses');
INSERT INTO gifi (accno,description) VALUES ('8811', 'Office Stationary And Supplies');
INSERT INTO gifi (accno,description) VALUES ('8812', 'Office Utilities');
INSERT INTO gifi (accno,description) VALUES ('8813', 'Data Processing');
INSERT INTO gifi (accno,description) VALUES ('8860', 'Professional Fees');
INSERT INTO gifi (accno,description) VALUES ('8861', 'Legal Fees');
INSERT INTO gifi (accno,description) VALUES ('8862', 'Accounting Fees');
INSERT INTO gifi (accno,description) VALUES ('8863', 'Consulting Fees');
INSERT INTO gifi (accno,description) VALUES ('8864', 'Architect Fees');
INSERT INTO gifi (accno,description) VALUES ('8865', 'Appraisal Fees');
INSERT INTO gifi (accno,description) VALUES ('8866', 'Laboratory Fees');
INSERT INTO gifi (accno,description) VALUES ('8867', 'Medical Fees');
INSERT INTO gifi (accno,description) VALUES ('8868', 'Veterinary Fees');
INSERT INTO gifi (accno,description) VALUES ('8869', 'Brokerage Fees');
INSERT INTO gifi (accno,description) VALUES ('8870', 'Transfer Fees');
INSERT INTO gifi (accno,description) VALUES ('8871', 'Management & Administration Fees');
INSERT INTO gifi (accno,description) VALUES ('8872', 'Refining & Assay');
INSERT INTO gifi (accno,description) VALUES ('8873', 'Registrar & Transfer Agent Fees');
INSERT INTO gifi (accno,description) VALUES ('8874', 'Restructuring Costs');
INSERT INTO gifi (accno,description) VALUES ('8875', 'Security & Exchange Commission Fees');
INSERT INTO gifi (accno,description) VALUES ('8876', 'Training Expense');
INSERT INTO gifi (accno,description) VALUES ('8877', 'Studio & Recording');
INSERT INTO gifi (accno,description) VALUES ('8910', 'Rental');
INSERT INTO gifi (accno,description) VALUES ('8911', 'Real Estate Rental');
INSERT INTO gifi (accno,description) VALUES ('8912', 'Occupancy Costs');
INSERT INTO gifi (accno,description) VALUES ('8913', 'Condominium Fees');
INSERT INTO gifi (accno,description) VALUES ('8914', 'Equipment Rental');
INSERT INTO gifi (accno,description) VALUES ('8915', 'Motor Vehicle Rental');
INSERT INTO gifi (accno,description) VALUES ('8916', 'Moorage (Boat)');
INSERT INTO gifi (accno,description) VALUES ('8917', 'Storage');
INSERT INTO gifi (accno,description) VALUES ('8918', 'Quota Rental');
INSERT INTO gifi (accno,description) VALUES ('8960', 'Repairs & Maintenance - Aircraft');
INSERT INTO gifi (accno,description) VALUES ('8961', 'Repairs & Maintenance - Buildings');
INSERT INTO gifi (accno,description) VALUES ('8962', 'Repairs & Maintenance - Vehicles');
INSERT INTO gifi (accno,description) VALUES ('8963', 'Repairs & Maintenance - Boats');
INSERT INTO gifi (accno,description) VALUES ('8964', 'Repairs & Maintenance - Machinery & Equipment');
INSERT INTO gifi (accno,description) VALUES ('9010', 'Other Repairs & Maintenance - Janitor & Yard');
INSERT INTO gifi (accno,description) VALUES ('9011', 'Machine Shop Expense');
INSERT INTO gifi (accno,description) VALUES ('9012', 'Road Costs');
INSERT INTO gifi (accno,description) VALUES ('9013', 'Security');
INSERT INTO gifi (accno,description) VALUES ('9014', 'Garbage Removal');
INSERT INTO gifi (accno,description) VALUES ('9060', 'Salaries & Wages');
INSERT INTO gifi (accno,description) VALUES ('9061', 'Commissions');
INSERT INTO gifi (accno,description) VALUES ('9062', 'Crew Share');
INSERT INTO gifi (accno,description) VALUES ('9063', 'Bonuses');
INSERT INTO gifi (accno,description) VALUES ('9064', 'Director\'s Fees');
INSERT INTO gifi (accno,description) VALUES ('9065', 'Management Salaries');
INSERT INTO gifi (accno,description) VALUES ('9066', 'Employee Salaries');
INSERT INTO gifi (accno,description) VALUES ('9110', 'Sub-Contracts');
INSERT INTO gifi (accno,description) VALUES ('9130', 'Supplies');
INSERT INTO gifi (accno,description) VALUES ('9131', 'Small Tools');
INSERT INTO gifi (accno,description) VALUES ('9132', 'Shop Expense');
INSERT INTO gifi (accno,description) VALUES ('9133', 'Uniforms');
INSERT INTO gifi (accno,description) VALUES ('9134', 'Laundry');
INSERT INTO gifi (accno,description) VALUES ('9135', 'Food & Catering');
INSERT INTO gifi (accno,description) VALUES ('9136', 'Fishing Gear');
INSERT INTO gifi (accno,description) VALUES ('9137', 'Nets & Traps');
INSERT INTO gifi (accno,description) VALUES ('9138', 'Salt, Bait & Ice');
INSERT INTO gifi (accno,description) VALUES ('9139', 'Camp Supplies');
INSERT INTO gifi (accno,description) VALUES ('9150', 'Computer Related Expenses');
INSERT INTO gifi (accno,description) VALUES ('9151', 'Upgrade');
INSERT INTO gifi (accno,description) VALUES ('9152', 'Internet');
INSERT INTO gifi (accno,description) VALUES ('9180', 'Property Taxes');
INSERT INTO gifi (accno,description) VALUES ('9200', 'Travel Expenses');
INSERT INTO gifi (accno,description) VALUES ('9201', 'Meetings & Conventions');
INSERT INTO gifi (accno,description) VALUES ('9220', 'Utilities');
INSERT INTO gifi (accno,description) VALUES ('9221', 'Electricity');
INSERT INTO gifi (accno,description) VALUES ('9222', 'Water');
INSERT INTO gifi (accno,description) VALUES ('9223', 'Heat');
INSERT INTO gifi (accno,description) VALUES ('9224', 'Fuel Costs');
INSERT INTO gifi (accno,description) VALUES ('9225', 'Telephone & Communications');
INSERT INTO gifi (accno,description) VALUES ('9270', 'Other Expenses');
INSERT INTO gifi (accno,description) VALUES ('9271', 'Cash Over/Short');
INSERT INTO gifi (accno,description) VALUES ('9272', 'Reimbursement Of Parent Company Expense');
INSERT INTO gifi (accno,description) VALUES ('9273', 'Selling Expenses');
INSERT INTO gifi (accno,description) VALUES ('9274', 'Shipping & Warehouse Expenses');
INSERT INTO gifi (accno,description) VALUES ('9275', 'Delivery, Freight & Express');
INSERT INTO gifi (accno,description) VALUES ('9276', 'Warranty Expenses');
INSERT INTO gifi (accno,description) VALUES ('9277', 'Royalty Expenses - Resident');
INSERT INTO gifi (accno,description) VALUES ('9278', 'Royalty Expenses - Non-Resident');
INSERT INTO gifi (accno,description) VALUES ('9279', 'Dumping Charges');
INSERT INTO gifi (accno,description) VALUES ('9280', 'Land Fill Fees');
INSERT INTO gifi (accno,description) VALUES ('9281', 'Vehicle Expenses');
INSERT INTO gifi (accno,description) VALUES ('9282', 'Research & Development');
INSERT INTO gifi (accno,description) VALUES ('9283', 'Withholding Taxes');
INSERT INTO gifi (accno,description) VALUES ('9284', 'General & Administrative Expenses');
INSERT INTO gifi (accno,description) VALUES ('9285', 'Interdivisional Expenses');
INSERT INTO gifi (accno,description) VALUES ('9286', 'Interfund Transfer (NPO)');
INSERT INTO gifi (accno,description) VALUES ('9367', 'Total Operating Expenses');
INSERT INTO gifi (accno,description) VALUES ('9368', 'Total Expenses');
INSERT INTO gifi (accno,description) VALUES ('9369', 'Net Non-Farming Income');
INSERT INTO gifi (accno,description) VALUES ('9370', 'Grains And Oilseeds');
INSERT INTO gifi (accno,description) VALUES ('9371', 'Wheat');
INSERT INTO gifi (accno,description) VALUES ('9372', 'Oats');
INSERT INTO gifi (accno,description) VALUES ('9373', 'Barley');
INSERT INTO gifi (accno,description) VALUES ('9374', 'Mixed Grains');
INSERT INTO gifi (accno,description) VALUES ('9375', 'Corn');
INSERT INTO gifi (accno,description) VALUES ('9376', 'Canola');
INSERT INTO gifi (accno,description) VALUES ('9377', 'Flaxseed');
INSERT INTO gifi (accno,description) VALUES ('9378', 'Soya Beans');
INSERT INTO gifi (accno,description) VALUES ('9379', 'Wheat Board Payments');
INSERT INTO gifi (accno,description) VALUES ('9420', 'Other Crop Revenues');
INSERT INTO gifi (accno,description) VALUES ('9321', 'Fruit');
INSERT INTO gifi (accno,description) VALUES ('9322', 'Potatoes');
INSERT INTO gifi (accno,description) VALUES ('9323', 'Vegetables');
INSERT INTO gifi (accno,description) VALUES ('9324', 'Tobacco');
INSERT INTO gifi (accno,description) VALUES ('9325', 'Greenhouse & Nursery Products');
INSERT INTO gifi (accno,description) VALUES ('9326', 'Forage Crops');
INSERT INTO gifi (accno,description) VALUES ('9470', 'Livestock & Animal Products Revenue');
INSERT INTO gifi (accno,description) VALUES ('9471', 'Cattle');
INSERT INTO gifi (accno,description) VALUES ('9472', 'Swine');
INSERT INTO gifi (accno,description) VALUES ('9473', 'Poultry');
INSERT INTO gifi (accno,description) VALUES ('9474', 'Sheep & Lambs');
INSERT INTO gifi (accno,description) VALUES ('9475', 'Pregnant Mare Urine (PMU)');
INSERT INTO gifi (accno,description) VALUES ('9476', 'Milk & Cream - Excluding Dairy Subsidies');
INSERT INTO gifi (accno,description) VALUES ('9477', 'Eggs For Consumption');
INSERT INTO gifi (accno,description) VALUES ('9478', 'Hatching Eggs');
INSERT INTO gifi (accno,description) VALUES ('9479', 'Aquaculture');
INSERT INTO gifi (accno,description) VALUES ('9480', 'Horses - Breeding & Meat');
INSERT INTO gifi (accno,description) VALUES ('9520', 'Other Commodities');
INSERT INTO gifi (accno,description) VALUES ('9521', 'Maple Products');
INSERT INTO gifi (accno,description) VALUES ('9522', 'Artificial Insemination (AI)');
INSERT INTO gifi (accno,description) VALUES ('9523', 'Semen Production');
INSERT INTO gifi (accno,description) VALUES ('9524', 'Embryo Production');
INSERT INTO gifi (accno,description) VALUES ('9540', 'Program Payment Revenues');
INSERT INTO gifi (accno,description) VALUES ('9541', 'Dairy Subsidies');
INSERT INTO gifi (accno,description) VALUES ('9542', 'Crop Insurance');
INSERT INTO gifi (accno,description) VALUES ('9543', 'NISA Payments');
INSERT INTO gifi (accno,description) VALUES ('9544', 'Disaster Assistance Program Payments');
INSERT INTO gifi (accno,description) VALUES ('9570', 'Rebates');
INSERT INTO gifi (accno,description) VALUES ('9571', 'Rebates - Fuel');
INSERT INTO gifi (accno,description) VALUES ('9572', 'Rebates - Interest');
INSERT INTO gifi (accno,description) VALUES ('9573', 'Rebates - Property Taxes');
INSERT INTO gifi (accno,description) VALUES ('9574', 'Resales, Rebates, GST For NISA Eligible Expenses');
INSERT INTO gifi (accno,description) VALUES ('9575', 'Rebates, GST For NISA Non-Eligible Expenses');
INSERT INTO gifi (accno,description) VALUES ('9600', 'Other Farm Revenues/Losses');
INSERT INTO gifi (accno,description) VALUES ('9601', 'Custom Or Contract Work');
INSERT INTO gifi (accno,description) VALUES ('9602', 'Wood Sales');
INSERT INTO gifi (accno,description) VALUES ('9603', 'Horse Racing');
INSERT INTO gifi (accno,description) VALUES ('9604', 'Insurance Proceeds');
INSERT INTO gifi (accno,description) VALUES ('9605', 'Patronage Dividends');
INSERT INTO gifi (accno,description) VALUES ('9606', 'Rental Income');
INSERT INTO gifi (accno,description) VALUES ('9607', 'Interest Income');
INSERT INTO gifi (accno,description) VALUES ('9608', 'Dividend Income');
INSERT INTO gifi (accno,description) VALUES ('9609', 'Gains/Losses On Disposal Of Assets');
INSERT INTO gifi (accno,description) VALUES ('9610', 'Gravel');
INSERT INTO gifi (accno,description) VALUES ('9611', 'Trucking');
INSERT INTO gifi (accno,description) VALUES ('9612', 'Resale Of Commodities Purchased');
INSERT INTO gifi (accno,description) VALUES ('9613', 'Leases');
INSERT INTO gifi (accno,description) VALUES ('9614', 'Machine Rentals');
INSERT INTO gifi (accno,description) VALUES ('9615', 'Farming Partnership Income/Loss');
INSERT INTO gifi (accno,description) VALUES ('9616', 'Farming Joint Venture Income/Loss');
INSERT INTO gifi (accno,description) VALUES ('9650', 'Non-Farming Income');
INSERT INTO gifi (accno,description) VALUES ('9659', 'Total Farm Revenue');
INSERT INTO gifi (accno,description) VALUES ('9660', 'Crop Expenses');
INSERT INTO gifi (accno,description) VALUES ('9661', 'Containers, Twine And Baling Wire');
INSERT INTO gifi (accno,description) VALUES ('9662', 'Fertilizers And Lime');
INSERT INTO gifi (accno,description) VALUES ('9663', 'Pesticides');
INSERT INTO gifi (accno,description) VALUES ('9664', 'Seeds & Plants');
INSERT INTO gifi (accno,description) VALUES ('9665', 'Insurance Premiums (Crop) NISA ACS');
INSERT INTO gifi (accno,description) VALUES ('9710', 'Livestock Expenses');
INSERT INTO gifi (accno,description) VALUES ('9711', 'Feed, Supplements, Straw & Bedding');
INSERT INTO gifi (accno,description) VALUES ('9712', 'Livestock Purchases');
INSERT INTO gifi (accno,description) VALUES ('9713', 'Veterinary Fees, Medicine & Breeding Fees');
INSERT INTO gifi (accno,description) VALUES ('9760', 'Machinery Expenses');
INSERT INTO gifi (accno,description) VALUES ('9761', 'Machinery Insurance');
INSERT INTO gifi (accno,description) VALUES ('9762', 'Machinery Licences');
INSERT INTO gifi (accno,description) VALUES ('9763', 'Machinery Repairs');
INSERT INTO gifi (accno,description) VALUES ('9764', 'Machinery Fuel');
INSERT INTO gifi (accno,description) VALUES ('9765', 'Machinery Lease');
INSERT INTO gifi (accno,description) VALUES ('9790', 'General Farm Expenses');
INSERT INTO gifi (accno,description) VALUES ('9791', 'Amortization Of Tangible Assets');
INSERT INTO gifi (accno,description) VALUES ('9792', 'Advertising, Marketing Costs & Promotion');
INSERT INTO gifi (accno,description) VALUES ('9793', 'Bad Debt');
INSERT INTO gifi (accno,description) VALUES ('9794', 'Benefits Related To Employee Salaries');
INSERT INTO gifi (accno,description) VALUES ('9795', 'Building Repairs & Maintenance');
INSERT INTO gifi (accno,description) VALUES ('9796', 'Clearing, Levelling & Draining Land');
INSERT INTO gifi (accno,description) VALUES ('9797', 'Crop Insurance, GRIP and Stabilization Premiums');
INSERT INTO gifi (accno,description) VALUES ('9798', 'Custom Or Contract Work');
INSERT INTO gifi (accno,description) VALUES ('9799', 'Electricity');
INSERT INTO gifi (accno,description) VALUES ('9800', 'Fence Repairs & Maintenance');
INSERT INTO gifi (accno,description) VALUES ('9801', 'Freight & Trucking');
INSERT INTO gifi (accno,description) VALUES ('9802', 'Heating Fuel & Curing Fuel');
INSERT INTO gifi (accno,description) VALUES ('9803', 'Insurance Program Overpayment Recapture');
INSERT INTO gifi (accno,description) VALUES ('9804', 'Other Insurance Premiums');
INSERT INTO gifi (accno,description) VALUES ('9805', 'Interest & Bank Charges');
INSERT INTO gifi (accno,description) VALUES ('9806', 'Marketing Board Fees');
INSERT INTO gifi (accno,description) VALUES ('9807', 'Membership/Subscription Fees');
INSERT INTO gifi (accno,description) VALUES ('9808', 'Office Expenses');
INSERT INTO gifi (accno,description) VALUES ('9809', 'Professional Fees');
INSERT INTO gifi (accno,description) VALUES ('9810', 'Property Taxes');
INSERT INTO gifi (accno,description) VALUES ('9811', 'Rent - Land & Buildings');
INSERT INTO gifi (accno,description) VALUES ('9812', 'Rent - Machinery');
INSERT INTO gifi (accno,description) VALUES ('9813', 'Other Rental Expenses');
INSERT INTO gifi (accno,description) VALUES ('9814', 'Salaries & Wages');
INSERT INTO gifi (accno,description) VALUES ('9815', 'Salaries & Wages Other Than Spouse Or Dependants');
INSERT INTO gifi (accno,description) VALUES ('9816', 'Salaries & Wages Paid To Dependants');
INSERT INTO gifi (accno,description) VALUES ('9817', 'Selling Costs');
INSERT INTO gifi (accno,description) VALUES ('9818', 'Supplies');
INSERT INTO gifi (accno,description) VALUES ('9819', 'Motor Vehicle Expenses');
INSERT INTO gifi (accno,description) VALUES ('9820', 'Small Tools');
INSERT INTO gifi (accno,description) VALUES ('9821', 'Soil Testing');
INSERT INTO gifi (accno,description) VALUES ('9822', 'Storage/Drying');
INSERT INTO gifi (accno,description) VALUES ('9823', 'Licences/Permits');
INSERT INTO gifi (accno,description) VALUES ('9824', 'Telephone');
INSERT INTO gifi (accno,description) VALUES ('9825', 'Quota Rental');
INSERT INTO gifi (accno,description) VALUES ('9826', 'Gravel');
INSERT INTO gifi (accno,description) VALUES ('9827', 'Purchases Of Commodities Resold');
INSERT INTO gifi (accno,description) VALUES ('9828', 'Salaries & Wages Paid To Spouse');
INSERT INTO gifi (accno,description) VALUES ('9829', 'Motor Vehicle Interest And Leasing Costs');
INSERT INTO gifi (accno,description) VALUES ('9830', 'Prepared Feed');
INSERT INTO gifi (accno,description) VALUES ('9831', 'Custom Feed');
INSERT INTO gifi (accno,description) VALUES ('9832', 'Amortization Of Intangible Assets');
INSERT INTO gifi (accno,description) VALUES ('9833', 'Amortization Of Milk Quota');
INSERT INTO gifi (accno,description) VALUES ('9834', 'Travel Expenses');
INSERT INTO gifi (accno,description) VALUES ('9835', 'Capital/Business Taxes');
INSERT INTO gifi (accno,description) VALUES ('9850', 'Non-Farming Expenses');
INSERT INTO gifi (accno,description) VALUES ('9870', 'Net Inventory Adjustment');
INSERT INTO gifi (accno,description) VALUES ('9898', 'Total Farm Expenses');
INSERT INTO gifi (accno,description) VALUES ('9899', 'Net Farm Income');
INSERT INTO gifi (accno,description) VALUES ('9970', 'Net Income/Loss Before Taxes And Extraordinary Items');
INSERT INTO gifi (accno,description) VALUES ('9975', 'Extraordinary Items');
INSERT INTO gifi (accno,description) VALUES ('9976', 'Legal Settlements');
INSERT INTO gifi (accno,description) VALUES ('9980', 'Unrealized Gains/Losses');
INSERT INTO gifi (accno,description) VALUES ('9985', 'Unusual Items');
INSERT INTO gifi (accno,description) VALUES ('9990', 'Current Income Taxes');
INSERT INTO gifi (accno,description) VALUES ('9995', 'Deferred Income Tax Provision');
INSERT INTO gifi (accno,description) VALUES ('9999', 'Net Income/Loss After Taxes And Extraordinary Items');
-- This item represents the net amount of:
-- Item 9970 - Net income/loss before taxes and extraordinary items minus 
-- Item 9975 - Extraordinary item(s) minus 
-- Item 9976 - Legal settlements plus
-- Item 9980 - Unrealized gains/losses minus
-- Item 9985 - Unusual items minus
-- Item 9990 - Current income taxes minus
-- Item 9995 - Deferred income tax provision
-- and must be reported.
-- Any amount reported in this item should be equal to the amount reported at Item 3680 - Net income/loss, 
-- in the retained earnings section. 
--
