/*===========================================================================
*
*                            Public Domain Notice
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
*/

#ifndef _h_kfs_path_priv_
#define _h_kfs_path_priv_

#ifndef _h_kfs_extern_
#include <kfs/extern.h>
#endif

#ifndef _h_klib_defs_
#include <klib/defs.h>
#endif

#include <kfs/path.h>

#ifdef __cplusplus
extern "C" {
#endif

/* options for a KPath possibly obtained from a query string on an URI */
typedef uint32_t KPOption_t;
enum eKPOption_t
{
    kpopt_encrypted,
    kpopt_pwpath,
    kpopt_pwfd,
    kpopt_count
};


/* =====
 * Much of what follows is expected to move into the interface kfs/path.h
 * once it becomes supported.
 */

/* MakeFmt
 *  make a path object from a format string plus arguments
 *
 *  "new_path" [ OUT ] - a reference to the new object.
 *
 *  "fmt" [ IN ] and "args" [ IN ] - arguments to string_printf
 *  ( see <klib/text.h> ) to build a NUL-terminated string
 *  that conforms with the rules for "posix_path"
 *
 * NB - SECURITY RISK IF USED DIRECTLY FROM EXTERNAL STRINGS.
 *      ALSO, FMT IS **NOT** PRINTF COMPATIBLE - see string_printf.
 */
KFS_EXTERN rc_t CC KPathMakeFmt ( KPath ** new_path, const char * fmt, ... );
KFS_EXTERN rc_t CC KPathMakeVFmt ( KPath ** new_path, const char * fmt, va_list args );


/* Bill - I don't know that we're ready to export these yet */
KFS_EXTERN rc_t CC KPathMakeRelative ( KPath ** new_path, const KPath * base_path,
                                       const char * relative_path );
KFS_EXTERN rc_t CC KPathMakeRelativeFmt ( KPath ** new_path, const KPath * base_path,
                                          const char * fmt, ... );
KFS_EXTERN rc_t CC KPathVMakeRelativeFmt ( KPath ** new_path, const KPath * base_path,
                                           const char * fmt, va_list args );
KFS_EXTERN rc_t CC KPathMakeCurrentPath ( KPath ** new_path );

KFS_EXTERN rc_t CC KPathMakeURI ( KPath ** new_path, const char * uri );


KFS_EXTERN rc_t CC KPathReadPath (const struct  KPath * self, char * buffer,
                                  size_t buffer_size, size_t * num_read);

KFS_EXTERN rc_t CC KPathOption (const KPath * self, KPOption_t option,
                                char * buffer, size_t buffer_size,
                                size_t * num_read);



#ifdef __cplusplus
}
#endif

#endif /* _h_kfs_path_priv_ */
