/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.AngularDistanceComputer;
import cds.healpix.common.math.Math;
import cds.healpix.common.sphgeom.CooXYZ;
import cds.healpix.common.sphgeom.Vect3D;
import java.util.ArrayList;
import java.util.List;

final class NewtonMethod {
    private static final double SQRT_2_OVER_3 = 0.816496580927726;

    NewtonMethod() {
    }

    public static List<CooXYZ> arcSpecialPoints(CooXYZ p1, CooXYZ p2, double zEpsMax, int nIterMax) {
        if (p1.z() > p2.z()) {
            CooXYZ tmp = p1;
            p1 = p2;
            p2 = tmp;
        }
        ArrayList<CooXYZ> res = new ArrayList<CooXYZ>();
        if (0.6666666666666666 <= p1.z() || p2.z() <= -0.6666666666666666) {
            CooXYZ r = NewtonMethod.arcSpecialPointInPc(p1, p2, zEpsMax, nIterMax);
            if (r != null) {
                res.add(r);
            }
        } else if (-0.6666666666666666 <= p1.z() && p2.z() <= 0.6666666666666666) {
            CooXYZ r = NewtonMethod.arcSpecialPointInEqr(p1, p2, zEpsMax, nIterMax);
            if (r != null) {
                res.add(r);
            }
        } else if (p1.z() < -0.6666666666666666) {
            CooXYZ vEqrSouth = new CooXYZ(NewtonMethod.intersectWithTransitionLatSpc(p1, p2));
            CooXYZ r = NewtonMethod.arcSpecialPointInPc(p1, vEqrSouth, zEpsMax, nIterMax);
            if (r != null) {
                res.add(r);
            }
            if (p2.z() <= 0.6666666666666666) {
                r = NewtonMethod.arcSpecialPointInEqr(vEqrSouth, p2, zEpsMax, nIterMax);
                if (r != null) {
                    res.add(r);
                }
            } else {
                CooXYZ vEqrNorth = new CooXYZ(NewtonMethod.intersectWithTransitionLatNpc(p1, p2));
                r = NewtonMethod.arcSpecialPointInEqr(vEqrSouth, vEqrNorth, zEpsMax, nIterMax);
                if (r != null) {
                    res.add(r);
                }
                if ((r = NewtonMethod.arcSpecialPointInPc(vEqrNorth, p2, zEpsMax, nIterMax)) != null) {
                    res.add(r);
                }
            }
        } else {
            CooXYZ vEqrNorth = new CooXYZ(NewtonMethod.intersectWithTransitionLatNpc(p1, p2));
            CooXYZ r = NewtonMethod.arcSpecialPointInEqr(p1, vEqrNorth, zEpsMax, nIterMax);
            if (r != null) {
                res.add(r);
            }
            if ((r = NewtonMethod.arcSpecialPointInPc(vEqrNorth, p2, zEpsMax, nIterMax)) != null) {
                res.add(r);
            }
        }
        return res;
    }

    public static double newtonSolveEquatorialZone(double zStart, double sinOfConeCenterLat, double twoSineOfHalfConeRadius, boolean positiveSlope, double zEpsMax, int nIterMax) {
        double w0 = 1.0 - sinOfConeCenterLat * sinOfConeCenterLat;
        double r = 1.0 - 0.5 * twoSineOfHalfConeRadius * twoSineOfHalfConeRadius;
        double z0 = sinOfConeCenterLat;
        double cte = 1.5 * (positiveSlope ? 0.7853981633974483 : -0.7853981633974483);
        double zEps = 1.0;
        double z = zStart;
        for (int i = 0; i < nIterMax && Math.abs(zEps) > zEpsMax; ++i) {
            zEps = NewtonMethod.fOverDfEqr(z, z0, w0, cte, r);
            z -= zEps;
        }
        return z;
    }

    static CooXYZ arcSpecialPointInEqr(CooXYZ p1, CooXYZ p2, double zEpsMax, int nIterMax) {
        double d2;
        Vect3D coneCenter = CooXYZ.crossProd(p1, p2).normalized();
        double z0 = coneCenter.z();
        double z1 = p1.z();
        double z2 = p2.z();
        boolean north_point = z0 < 0.0;
        double cte = (north_point ? -1.5 : 1.5) * 0.7853981633974483;
        double w0 = 1.0 - NewtonMethod.pow2(z0);
        double d1 = NewtonMethod.fEqr(z1, z0, w0, cte, 0.0);
        if (NewtonMethod.haveSameSign(d1, d2 = NewtonMethod.fEqr(z2, z0, w0, cte, 0.0))) {
            return null;
        }
        zEpsMax = java.lang.Math.min(zEpsMax, 0.02 * Math.abs(z2 - z1));
        zEpsMax = java.lang.Math.max(zEpsMax, 1.0E-15);
        double z = 0.5 * (z1 + z2);
        double zEps = 1.0;
        for (int nIter = 0; nIter < nIterMax && Math.abs(zEps) > zEpsMax; ++nIter) {
            zEps = NewtonMethod.fOverDfEqr(z, z0, w0, cte, 0.0);
            z -= zEps;
        }
        if (Math.abs(z) < 0.6666666666666666 && (z1 <= z2 && z1 <= z && z <= z2 || z2 < z1 && z2 <= z && z <= z1)) {
            Vect3D v = NewtonMethod.intersectSmallCircle(p1, p2, z);
            return new CooXYZ(v);
        }
        return null;
    }

    private static double fEqr(double z, double z0, double w0, double cte, double r) {
        double w = 1.0 - NewtonMethod.pow2(z);
        double q = z / w;
        double n = r - z * z0;
        return (z0 - q * n) / Math.sqrt(w0 * w - NewtonMethod.pow2(n)) - cte;
    }

    private static double fOverDfEqr(double z, double z0, double w0, double cte, double r) {
        double w = 1.0 - z * z;
        double q = z / w;
        double n = r - z * z0;
        double sqrtD2MinusN2 = Math.sqrt(w0 * w - n * n);
        double qn = q * n;
        double dalphadz = (z0 - qn) / sqrtD2MinusN2;
        double f = dalphadz - cte;
        double df = (q * (2.0 * z0 - 3.0 * qn) - n * (1.0 / w + dalphadz * dalphadz)) / sqrtD2MinusN2;
        return f / df;
    }

    public static double newtonSolveEquatorialZone(double latStart, double coneCenterLat, double cosOfConeCenterLat, double squareOfSinOfHalfRadius, boolean positiveSlope, double latEpsMax, int nIterMax, AngularDistanceComputer c) {
        double cte = 1.5 * (positiveSlope ? 0.7853981633974483 : -0.7853981633974483);
        double prevLat = 4.0;
        double lat = latStart;
        int nIter = 0;
        int i = 0;
        while (i < nIterMax && java.lang.Math.abs(lat - prevLat) > latEpsMax) {
            double deltaLat = lat - coneCenterLat;
            double sinDeltaLat = c.sin(deltaLat);
            double sinHalfDeltaLat = c.sin(0.5 * deltaLat);
            double cosLat = Math.cos(lat);
            double tanLat = Math.tan(lat);
            double n = squareOfSinOfHalfRadius - sinHalfDeltaLat * sinHalfDeltaLat;
            double d = cosOfConeCenterLat * cosLat;
            double oneOverd2 = 1.0 / Math.sqrt(n * (d - n));
            double oneOverCosLat = 1.0 / cosLat;
            double n2 = tanLat * n - 0.5 * sinDeltaLat;
            double np2 = (n * oneOverCosLat - 0.5 * cosOfConeCenterLat) * oneOverCosLat;
            double dp2 = 0.5 * (sinDeltaLat * (n - 0.5 * d) - tanLat * d * n) * oneOverd2;
            double dalpha = n2 * oneOverd2;
            double d2alpha = np2 * oneOverd2 - dp2 * n2 * oneOverd2 * oneOverd2;
            double f = dalpha - cte * cosLat;
            double df = tanLat * dalpha + d2alpha;
            prevLat = lat;
            lat -= f / df;
            ++i;
            ++nIter;
        }
        return lat;
    }

    public static double newtonSolveNorthPolarCapZone(double zStart, boolean eastValue, double coneCenterLonModHalfPi, double sinOfConeCenterLat, double twoSineOfHalfConeRadius, boolean positiveSlope, double zEpsMax, int nIterMax) {
        double cte = (positiveSlope ? 0.5 : -0.5) * 0.7853981633974483;
        double w0 = 1.0 - sinOfConeCenterLat * sinOfConeCenterLat;
        double r = 1.0 - 0.5 * twoSineOfHalfConeRadius * twoSineOfHalfConeRadius;
        double z0 = sinOfConeCenterLat;
        double direction = eastValue ? 1.0 : -1.0;
        double zEps = 1.0;
        double z = zStart;
        zEpsMax = java.lang.Math.max(1.0E-15, java.lang.Math.min(zEpsMax, (zStart - sinOfConeCenterLat) * 1.0E-4));
        for (int i = 0; i < nIterMax && java.lang.Math.abs(zEps) > zEpsMax; ++i) {
            zEps = NewtonMethod.fOverDfNpc(z, coneCenterLonModHalfPi, z0, w0, cte, direction, r);
            z -= zEps;
        }
        return z;
    }

    private static CooXYZ arcSpecialPointInPc(CooXYZ p1, CooXYZ p2, double zEpsMax, int nIterMax) {
        if (p1.lon() > p2.lon()) {
            CooXYZ tmp = p1;
            p1 = p2;
            p2 = tmp;
        }
        assert (p1.lon() % 1.5707963267948966 >= 0.0);
        assert (p2.lon() % 1.5707963267948966 >= 0.0);
        int lon1DivHalfPi = (int)(p1.lon() / 1.5707963267948966);
        int lon2DivHalfPi = (int)(p2.lon() / 1.5707963267948966);
        assert (lon1DivHalfPi < 4);
        assert (lon2DivHalfPi < 4);
        assert (lon1DivHalfPi <= lon2DivHalfPi);
        if (lon1DivHalfPi != lon2DivHalfPi) {
            CooXYZ resZ1 = null;
            CooXYZ resZ2 = null;
            if (p2.lon() - p1.lon() > java.lang.Math.PI) {
                Vect3D p2p1N = CooXYZ.crossProd(p2, p1).normalized();
                if (p2.lon() % 1.5707963267948966 > 0.0) {
                    assert (lon2DivHalfPi > 0);
                    int n2Y = lon2DivHalfPi & 1;
                    Vect3D n2 = new Vect3D(n2Y ^ 1, n2Y, 0.0);
                    CooXYZ intersect2 = new CooXYZ(NewtonMethod.intersectPointPc(p1, p2, p2p1N, n2));
                    assert (p2.lon() < intersect2.lon() || lon2DivHalfPi == 3) : p2.lon() + " " + intersect2.lon();
                    resZ2 = NewtonMethod.arcSpecialPointInPcSameQuarter(p2, intersect2, zEpsMax, nIterMax);
                }
                assert (lon1DivHalfPi < 3);
                int n1X = lon1DivHalfPi & 1;
                Vect3D n1 = new Vect3D(n1X, n1X ^ 1, 0.0);
                CooXYZ intersect1 = new CooXYZ(NewtonMethod.intersectPointPc(p1, p2, p2p1N, n1));
                assert (intersect1.lon() < p1.lon()) : "p1.lon: " + p1.lon() + " vs " + intersect1.lon() + " :int.lon and p2.lon: " + p2.lon();
                resZ1 = NewtonMethod.arcSpecialPointInPcSameQuarter(intersect1, p1, zEpsMax, nIterMax);
            } else {
                Vect3D p1p2N = CooXYZ.crossProd(p1, p2).normalized();
                if (p1.lon() % 1.5707963267948966 > 0.0) {
                    assert (lon1DivHalfPi < 3);
                    int n1Y = lon1DivHalfPi & 1;
                    Vect3D n1 = new Vect3D(n1Y ^ 1, n1Y, 0.0);
                    CooXYZ intersect1 = new CooXYZ(NewtonMethod.intersectPointPc(p1, p2, p1p2N, n1));
                    assert (p1.lon() < intersect1.lon());
                    resZ1 = NewtonMethod.arcSpecialPointInPcSameQuarter(p1, intersect1, zEpsMax, nIterMax);
                }
                assert (lon2DivHalfPi > 0);
                int n2X = lon2DivHalfPi & 1;
                Vect3D n2 = new Vect3D(n2X, n2X ^ 1, 0.0);
                CooXYZ intersect2 = new CooXYZ(NewtonMethod.intersectPointPc(p1, p2, p1p2N, n2));
                assert (intersect2.lon() < p2.lon());
                resZ2 = NewtonMethod.arcSpecialPointInPcSameQuarter(intersect2, p2, zEpsMax, nIterMax);
            }
            if (resZ1 != null) {
                return resZ1;
            }
            return resZ2;
        }
        return NewtonMethod.arcSpecialPointInPcSameQuarter(p1, p2, zEpsMax, nIterMax);
    }

    private static CooXYZ arcSpecialPointInPcSameQuarter(CooXYZ p1, CooXYZ p2, double zEpsMax, int nIterMax) {
        double dz;
        double d2;
        double direction;
        boolean spc;
        CooXYZ v2;
        CooXYZ v1;
        Vect3D coneCenter;
        if (p1.lon() > p2.lon()) {
            CooXYZ tmp = p1;
            p1 = p2;
            p2 = tmp;
        }
        assert (p1.lon() <= p2.lon()) : p1.lon() + " " + p2.lon();
        int p1DivHalfPi = (int)(p1.lon() / 1.5707963267948966);
        double p2ModHalfPi = p2.lon() % 1.5707963267948966;
        if (p2ModHalfPi == 0.0) {
            p2ModHalfPi = 1.5707963267948966;
        }
        if ((coneCenter = CooXYZ.crossProd(v1 = new CooXYZ(p1.lon() % 1.5707963267948966, p1.lat()), v2 = new CooXYZ(p2ModHalfPi, p2.lat())).normalized()).toLon() > java.lang.Math.PI) {
            coneCenter = coneCenter.opposite();
        }
        double coneCenterLon = coneCenter.toLon();
        double z0 = coneCenter.z();
        double z1 = v1.z();
        double z2 = v2.z();
        boolean northValue = z0 < 0.0;
        boolean eastValue = v1.lat() > v2.lat() ^ v1.lon() > v2.lon() ^ !northValue;
        double z = 0.5 * (z1 + z2);
        boolean bl = spc = z < 0.0;
        if (spc) {
            z = -z;
            z1 = -z1;
            z2 = -z2;
            z0 = -z0;
            northValue = !northValue;
        }
        double cte = 0.5 * (northValue ? -0.7853981633974483 : 0.7853981633974483);
        double w0 = 1.0 - NewtonMethod.pow2(z0);
        double d1 = NewtonMethod.fNpc(z1, coneCenterLon, z0, w0, cte, direction = eastValue ? 1.0 : -1.0, 0.0);
        if (NewtonMethod.haveSameSign(d1, d2 = NewtonMethod.fNpc(z2, coneCenterLon, z0, w0, cte, direction, 0.0))) {
            return null;
        }
        if (!(z1 < (z -= (dz = NewtonMethod.fOverDfNpc(z, coneCenterLon, z0, w0, cte, direction, 0.0))) && z < z2 || z2 < z && z < z1 || z1 < (z = z2 - NewtonMethod.fOverDfNpc(z2, coneCenterLon, z0, w0, cte, direction, 0.0)) && z < z2 || z2 < z && z < z1)) {
            z = z1 - NewtonMethod.fOverDfNpc(z1, coneCenterLon, z0, w0, cte, direction, 0.0);
        }
        zEpsMax = java.lang.Math.max(java.lang.Math.min(zEpsMax, 0.02 * Math.abs(z2 - z1)), 1.0E-15);
        double zEps = 1.0;
        for (int nIter = 0; nIter < nIterMax && Math.abs(zEps) > zEpsMax; ++nIter) {
            zEps = NewtonMethod.fOverDfNpc(z, coneCenterLon, z0, w0, cte, direction, 0.0);
            z -= zEps;
        }
        if (NewtonMethod.isFinite(z) && z > 0.6666666666666666 && (z1 < z && z < z2 || z2 < z && z < z1)) {
            if (spc) {
                Vect3D v = NewtonMethod.intersectSmallCircle(p1, p2, -z);
                return new CooXYZ(v);
            }
            Vect3D v = NewtonMethod.intersectSmallCircle(p1, p2, z);
            return new CooXYZ(v);
        }
        return null;
    }

    private static Vect3D intersectPointPc(CooXYZ p1, CooXYZ p2, Vect3D p1Xp2, Vect3D n) {
        assert (Math.abs(p1.z()) >= 0.6666666666666666 && Math.abs(p2.z()) >= 0.6666666666666666);
        assert (p1.z() > 0.0 == p2.z() > 0.0);
        Vect3D intersect = Vect3D.crossProd(p1Xp2, n).normalized();
        if (!NewtonMethod.haveSameSign(intersect.z(), p1.z())) {
            return intersect.opposite();
        }
        return intersect;
    }

    private static double fNpc(double z, double coneCenterLonModHalfPi, double z0, double w0, double cte, double direction, double r) {
        double w = 1.0 - z;
        double w2 = 1.0 - NewtonMethod.pow2(z);
        double q = z / w2;
        double n = r - z * z0;
        double d2 = w0 * w2;
        double sqrtD2MinusN2 = java.lang.Math.sqrt(d2 - n * n);
        double qn = q * n;
        double arccos = java.lang.Math.acos(n / java.lang.Math.sqrt(d2));
        double dalphadz = (z0 - qn) / sqrtD2MinusN2;
        return direction * w * dalphadz - 0.5 * (direction * arccos + coneCenterLonModHalfPi - 0.7853981633974483) + cte;
    }

    private static double fOverDfNpc(double z, double coneCenterLonModHalfPi, double z0, double w0, double cte, double direction, double r) {
        double w = 1.0 - z;
        double w2 = 1.0 - NewtonMethod.pow2(z);
        double q = z / w2;
        double n = r - z * z0;
        double d2 = w0 * w2;
        double sqrtD2MinusN2 = java.lang.Math.sqrt(d2 - n * n);
        double qn = q * n;
        double arccos = java.lang.Math.acos(n / java.lang.Math.sqrt(d2));
        double dalphadz = (z0 - qn) / sqrtD2MinusN2;
        double f = direction * w * dalphadz - 0.5 * (direction * arccos + coneCenterLonModHalfPi - 0.7853981633974483) + cte;
        double df = -1.5 * direction * dalphadz + direction * w / sqrtD2MinusN2 * (q * (2.0 * z0 - 3.0 * qn) - n * (1.0 / w2 + dalphadz * dalphadz));
        return f / df;
    }

    public static double newtonSolveNorthPolarCapZone(double latStart, boolean eastValue, double coneCenterLonModHalfPi, double coneCenterLat, double cosOfConeCenterLat, double squareOfSinOfHalfRadius, boolean positiveSlope, double latEpsMax, int nIterMax, AngularDistanceComputer c) {
        double cte = positiveSlope ? 1.5707963267948966 : 0.0;
        double direction = eastValue ? 1.0 : -1.0;
        double prevLat = 4.0;
        double lat = latStart;
        int nIter = 0;
        int i = 0;
        while (i < nIterMax && java.lang.Math.abs(lat - prevLat) > latEpsMax) {
            double deltaLat = lat - coneCenterLat;
            double sinDeltaLat = c.sin(deltaLat);
            double sinHalfDeltaLat = c.sin(0.5 * deltaLat);
            double cosLat = Math.cos(lat);
            double tanLat = Math.tan(lat);
            double n = squareOfSinOfHalfRadius - sinHalfDeltaLat * sinHalfDeltaLat;
            double d = cosOfConeCenterLat * cosLat;
            double oneOverd2 = 1.0 / Math.sqrt(n * (d - n));
            double oneOverCosLat = 1.0 / cosLat;
            double oneOverCosLatminTanLat = oneOverCosLat - tanLat;
            double n2 = tanLat * n - 0.5 * sinDeltaLat;
            double np2 = (n * oneOverCosLat - 0.5 * cosOfConeCenterLat) * oneOverCosLat;
            double dp2 = 0.5 * (sinDeltaLat * (n - 0.5 * d) - tanLat * d * n) * oneOverd2;
            double alpha = coneCenterLonModHalfPi + direction * 2.0 * c.asin(Math.sqrt(n / d));
            double dalpha = direction * n2 * oneOverd2;
            double d2alpha = direction * (np2 * oneOverd2 - dp2 * n2 * oneOverd2 * oneOverd2);
            double f = 2.0 * oneOverCosLatminTanLat * dalpha - alpha + cte;
            double df = 2.0 * oneOverCosLatminTanLat * (d2alpha - dalpha * oneOverCosLat) - dalpha;
            prevLat = lat;
            lat -= f / df;
            ++i;
            ++nIter;
        }
        return lat;
    }

    public static Vect3D intersectSmallCircle(CooXYZ p1, CooXYZ p2, double z) {
        assert (-1.0 <= z && z <= 1.0);
        if (p1.z() < z && z < p2.z() || p2.z() < z && z < p1.z()) {
            double p1p2 = p1.scalarProd(p2);
            Vect3D p1Xp2 = CooXYZ.crossProd(p1, p2).normalized();
            double x0 = p1Xp2.x();
            double y0 = p1Xp2.y();
            double z0 = p1Xp2.z();
            if (Math.abs(y0) <= 1.0E-14) {
                double x = -(z * z0) / x0;
                double y1 = Math.sqrt(1.0 - (NewtonMethod.pow2(x) + NewtonMethod.pow2(z)));
                double y2 = -y1;
                if (p1.x() * x + p1.y() * y1 + p1.z() * z >= p1p2 && p2.x() * x + p2.y() * y1 + p2.z() * z >= p1p2) {
                    return new Vect3D(x, y1, z);
                }
                if (p1.x() * x + p1.y() * y2 + p1.z() * z >= p1p2 && p2.x() * x + p2.y() * y2 + p2.z() * z >= p1p2) {
                    return new Vect3D(x, y2, z);
                }
                assert (false);
                return null;
            }
            double x0_y0 = x0 / y0;
            double zz0_y0 = z * z0 / y0;
            double a = 1.0 + NewtonMethod.pow2(x0_y0);
            double b = 2.0 * x0_y0 * zz0_y0;
            double c = NewtonMethod.pow2(zz0_y0) + NewtonMethod.pow2(z) - 1.0;
            double sqrt_delta = Math.sqrt(NewtonMethod.pow2(b) - 4.0 * a * c);
            double x1 = (-b + sqrt_delta) / NewtonMethod.twice(a);
            double y1 = -x1 * x0_y0 - zz0_y0;
            double x2 = (-b - sqrt_delta) / NewtonMethod.twice(a);
            double y2 = -x2 * x0_y0 - zz0_y0;
            if (p1.x() * x1 + p1.y() * y1 + p1.z() * z >= p1p2 && p2.x() * x1 + p2.y() * y1 + p2.z() * z >= p1p2) {
                return new Vect3D(x1, y1, z);
            }
            if (p1.x() * x2 + p1.y() * y2 + p1.z() * z >= p1p2 && p2.x() * x2 + p2.y() * y2 + p2.z() * z >= p1p2) {
                return new Vect3D(x2, y2, z);
            }
            assert (false);
            return null;
        }
        return null;
    }

    private static Vect3D intersectWithTransitionLatNpc(CooXYZ p1, CooXYZ p2) {
        return NewtonMethod.intersectSmallCircle(p1, p2, 0.6666666666666666);
    }

    private static Vect3D intersectWithTransitionLatSpc(CooXYZ p1, CooXYZ p2) {
        return NewtonMethod.intersectSmallCircle(p1, p2, -0.6666666666666666);
    }

    private static boolean haveSameSign(double d1, double d2) {
        return d1 == 0.0 || d2 == 0.0 || d1 > 0.0 == d2 > 0.0;
    }

    private static final double twice(double x) {
        return 2.0 * x;
    }

    private static final double pow2(double x) {
        return x * x;
    }

    public static boolean isFinite(double d) {
        return java.lang.Math.abs(d) <= Double.MAX_VALUE;
    }
}

