/*
 * $Id: XMLEventsTest.java,v 1.1 2004-07-09 02:25:12 cniles Exp $
 * 
 * Copyright (c) 2004, Christian Niles, Unit12
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *		*   Redistributions of source code must retain the above copyright
 *          notice, this list of conditions and the following disclaimer.
 * 
 *	    *	Redistributions in binary form must reproduce the above copyright
 *          notice, this list of conditions and the following disclaimer in the
 *          documentation and/or other materials provided with the distribution.
 * 
 *      *   Neither the name of Christian Niles, Unit12, nor the names of its
 *          contributors may be used to endorse or promote products derived from
 *          this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 */
package javanet.staxutils.events;

import javanet.staxutils.events.EventFactory;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;

import junit.framework.TestCase;

/**
 * 
 * @author Christian Niles
 * @version $Revision: 1.1 $
 */
public class XMLEventsTest extends TestCase {

    private static final String PREFIX = "prefix";

    private static final String URI = "http://w3.org/1999/xhtml";

    private static final String NAME = "name";

    private static final String VALUE = "value";

    private final XMLEventFactory FACTORY = new EventFactory();

    private final ProcessingInstruction PI = FACTORY.createProcessingInstruction(
            NAME, VALUE);

    private final Namespace NAMESPACE = FACTORY.createNamespace("prefix",
            "http://w3.org/1999/xhtml");

    private final EndElement END_ELEMENT = FACTORY.createEndElement(PREFIX,
            URI, NAME);

    private final StartElement START_ELEMENT = FACTORY.createStartElement(
            PREFIX, URI, NAME);

    private final EndDocument END_DOCUMENT = FACTORY.createEndDocument();

    private final StartDocument START_DOCUMENT = FACTORY.createStartDocument();

    private final Characters CHARACTERS = FACTORY.createCharacters(VALUE);

    private final Attribute ATTRIBUTE = FACTORY.createAttribute(NAME, VALUE);

    public void testIsAttribute() {

        assertFalse("Characters.isAttribute() == true",
                CHARACTERS.isAttribute());
        assertFalse("StartDocument.isAttribute() == true",
                START_DOCUMENT.isAttribute());
        assertFalse("EndDocument.isAttribute() == true",
                END_DOCUMENT.isAttribute());
        assertFalse("StartElement.isAttribute() == true",
                START_ELEMENT.isAttribute());
        assertFalse("EndElement.isAttribute() == true",
                END_ELEMENT.isAttribute());
        assertFalse("ProcessingInstruction.isAttribute() == true",
                PI.isAttribute());
        assertFalse("Namespace.isAttribute() == true", NAMESPACE.isAttribute());

        assertTrue("Attribute.isAttribute() == false", ATTRIBUTE.isAttribute());

    }

    public void testIsCharacters() {

        assertFalse("StartDocument.isCharacters() == true",
                START_DOCUMENT.isCharacters());
        assertFalse("EndDocument.isCharacters() == true",
                END_DOCUMENT.isCharacters());
        assertFalse("StartElement.isCharacters() == true",
                START_ELEMENT.isCharacters());
        assertFalse("EndElement.isCharacters() == true",
                END_ELEMENT.isCharacters());
        assertFalse("ProcessingInstruction.isCharacters() == true",
                PI.isCharacters());
        assertFalse("Namespace.isCharacters() == true",
                NAMESPACE.isCharacters());
        assertFalse("Attribute.isCharacters() == true",
                ATTRIBUTE.isCharacters());

        assertTrue("Characters.isCharacters() == false",
                CHARACTERS.isCharacters());

    }

    public void testIsStartDocument() {

        assertFalse("Characters.isStartDocument() == true",
                CHARACTERS.isStartDocument());
        assertFalse("EndDocument.isStartDocument() == true",
                END_DOCUMENT.isStartDocument());
        assertFalse("StartElement.isStartDocument() == true",
                START_ELEMENT.isStartDocument());
        assertFalse("EndElement.isStartDocument() == true",
                END_ELEMENT.isStartDocument());
        assertFalse("ProcessingInstruction.isStartDocument() == true",
                PI.isStartDocument());
        assertFalse("Namespace.isStartDocument() == true",
                NAMESPACE.isStartDocument());
        assertFalse("Attribute.isStartDocument() == true",
                ATTRIBUTE.isStartDocument());

        assertTrue("StartDocument.isStartDocument() == false",
                START_DOCUMENT.isStartDocument());

    }

    public void testIsEndDocument() {

        assertFalse("Characters.isEndDocument() == true",
                CHARACTERS.isEndDocument());
        assertFalse("StartElement.isEndDocument() == true",
                START_ELEMENT.isEndDocument());
        assertFalse("EndElement.isEndDocument() == true",
                END_ELEMENT.isEndDocument());
        assertFalse("StartDocument.isEndDocument() == true",
                START_DOCUMENT.isEndDocument());
        assertFalse("ProcessingInstruction.isEndDocument() == true",
                PI.isEndDocument());
        assertFalse("Namespace.isEndDocument() == true",
                NAMESPACE.isEndDocument());
        assertFalse("Attribute.isEndDocument() == true",
                ATTRIBUTE.isEndDocument());

        assertTrue("EndDocument.isEndDocument() == false",
                END_DOCUMENT.isEndDocument());

    }

    public void testIsStartElement() {

        assertFalse("Characters.isStartElement() == true",
                CHARACTERS.isStartElement());
        assertFalse("EndElement.isStartElement() == true",
                END_ELEMENT.isStartElement());
        assertFalse("ProcessingInstruction.isStartElement() == true",
                PI.isStartElement());
        assertFalse("Namespace.isStartElement() == true",
                NAMESPACE.isStartElement());
        assertFalse("Attribute.isStartElement() == true",
                ATTRIBUTE.isStartElement());
        assertFalse("StartDocument.isStartElement() == true",
                START_DOCUMENT.isStartElement());
        assertFalse("EndDocument.isStartElement() == true",
                END_DOCUMENT.isStartElement());

        assertTrue("StartElement.isStartElement() == false",
                START_ELEMENT.isStartElement());

    }

    public void testIsEndElement() {

        assertFalse("Characters.isEndElement() == true",
                CHARACTERS.isEndElement());
        assertFalse("StartElement.isEndElement() == true",
                START_ELEMENT.isEndElement());
        assertFalse("ProcessingInstruction.isEndElement() == true",
                PI.isEndElement());
        assertFalse("Namespace.isEndElement() == true",
                NAMESPACE.isEndElement());
        assertFalse("Attribute.isEndElement() == true",
                ATTRIBUTE.isEndElement());
        assertFalse("StartDocument.isStartElement() == true",
                START_DOCUMENT.isStartElement());
        assertFalse("EndDocument.isEndElement() == true",
                END_DOCUMENT.isEndElement());

        assertTrue("EndElement.isEndElement() == false",
                END_ELEMENT.isEndElement());

    }

    public void testIsNamespace() {

        assertFalse("Characters.isNamespace() == true",
                CHARACTERS.isNamespace());
        assertFalse("StartElement.isNamespace() == true",
                START_ELEMENT.isNamespace());
        assertFalse("ProcessingInstruction.isNamespace() == true",
                PI.isNamespace());
        assertFalse("Attribute.isNamespace() == true", ATTRIBUTE.isNamespace());
        assertFalse("StartDocument.isNamespace() == true",
                START_DOCUMENT.isNamespace());
        assertFalse("EndDocument.isNamespace() == true",
                END_DOCUMENT.isNamespace());
        assertFalse("EndElement.isNamespace() == true",
                END_ELEMENT.isNamespace());

        assertTrue("Namespace.isNamespace() == false", NAMESPACE.isNamespace());

    }

    public void testIsProcessingInstruction() {

        assertFalse("Characters.isProcessingInstruction() == true",
                CHARACTERS.isProcessingInstruction());
        assertFalse("StartElement.isProcessingInstruction() == true",
                START_ELEMENT.isProcessingInstruction());
        assertFalse("Namespace.isProcessingInstruction() == true",
                NAMESPACE.isProcessingInstruction());
        assertFalse("Attribute.isProcessingInstruction() == true",
                ATTRIBUTE.isProcessingInstruction());
        assertFalse("StartDocument.isProcessingInstruction() == true",
                START_DOCUMENT.isProcessingInstruction());
        assertFalse("EndDocument.isProcessingInstruction() == true",
                END_DOCUMENT.isProcessingInstruction());
        assertFalse("EndElement.isProcessingInstruction() == true",
                END_ELEMENT.isProcessingInstruction());

        assertTrue("ProcessingInstruction.isProcessingInstruction() == false",
                PI.isProcessingInstruction());

    }

}