/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WORKINGCOPYLVI_H
#define _SC_WORKINGCOPYLVI_H

// sc
#include "ScLvi.h"
#include "Project.h"
#include "commands/ScCmdData.h"
//#include "svn/WcStatusTypes.h"
class ProjectFoldersWidget;
class WcModel;

namespace svn
{
  class Error;
}

// qt
class QPopupMenu;

/**
 * QListViewItem representing working copy folders.
 */
class WorkingCopyLvi : public ScLvi
{
  typedef ScLvi super;

public:
  /**
   * root constructor
   */
  WorkingCopyLvi( QListViewItem* parent, WcModel* model, Project* prj, const Project::Item& wcItem );

  /**
   * child constructor
   */
  ~WorkingCopyLvi();

  static void setupActions( ProjectFoldersWidget* parent );
  static QPopupMenu* getMenu();

  // qlistviewitem
  QString text( int column ) const;
  int compare( QListViewItem* i, int col, bool ascending ) const;
  void paintFocus( QPainter* p, const QColorGroup& cg, const QRect& r );
  void paintBranches( QPainter* p, const QColorGroup& cg, int w, int y, int h );
  void paintCell( QPainter* p, const QColorGroup& cg, int column, int width, int alignment );
  bool acceptDrop( const QMimeSource* mime ) const;
  void dropped( QDropEvent* e );

  // ScLvi
  void onItem();
  void pressed( bool refresh );
  void renamed( const QString& text );
  void contextMenuRequest( const QPoint& pos, int col );
  long getSortPos() const;
  QDragObject* dragObject();

  Project* getProject() const;
  QString getWorkingCopyPath() const;
  void setSvnversion( const QString& version );
  const Project::Item& getProjectItem() const;
  void setProjectItem( const Project::Item& );

  void update();
  void commit();
  void log();
  void updateRev();

  void enableActions();
  void disableActions();

  ScLviAccept(WorkingCopyLvi);

private:
  void checkout();
  bool isCurrentRoot();
  QString makePathRelative( QListViewItem* parent, QString path );

private:
  WcModel*             _wcModel;

  Project*             _prj;         ///< my Project
  Project::Item        _wcItem;      ///< wc info

  QString              _svnversion;  ///< svnversion string
};

typedef SimpleCmdData<WorkingCopyLvi*> WorkingCopyLviCmdData;

template<typename T> inline WorkingCopyLvi* WcLvi_cast(T *p)
{
  return dynamic_cast<WorkingCopyLvi*>(p);
}

#endif // _SC_WORKINGCOPYLVI_H
