/* ====================================================================
 * Copyright (c) 2006-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_PATH_H
#define _SVN_PATH_H

// sc
#include "ClientTypes.h"

namespace svn
{

class Path
{
public:
  static sc::String findPrefix( const Paths& paths );

  /** svn_path_basename */
  static sc::String getBaseName( const sc::String& path );
  /** svn_path_dirname */
  static sc::String getDirName( const sc::String& path );

  /** svn_path_is_url */
  static bool isUrl( const sc::String& path );

  /** svn_path_uri_decode */
  static sc::String getUriDecode( const sc::String& path );
};

} // namespace

#endif // _SVN_PATH_H
