/*
 *   Copyright (C) 2008, 2009 Nicolas Vion <nico@yojik.eu>
 *
 *   This file is part of Swac-explore.
 * 
 *   Swac-explore is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   Swac-explore is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Swac-explore.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/main.h>
#include <gconfmm.h>
#include <giomm.h>

#include "sqlite3++.hh"
#include "explorer.hh"
#include "messages.hh"
#include "gstreamer.hh"


bool db_check_version(SqlDatabase* db) {
	SqlQuery query(db);
	query.prepare("PRAGMA user_version;");
	return (query.step() == SQLITE_ROW and query.columnInt(0) >= 1);
}

SqlDatabase* db_open() {
	Glib::ustring path(Glib::get_home_dir() + G_DIR_SEPARATOR_S ".swac" G_DIR_SEPARATOR_S "swac.db");
	
	if (Glib::file_test(path, Glib::FILE_TEST_EXISTS)) {
		SqlDatabase *db;  
	   	db = new class SqlDatabase;  
		db->open(path);

		if (db_check_version(db))
			return db;

		db->close();
		message_error("Please upgrade the database structure version with \"swac-get\".");
		return NULL;
	}
	message_error("Can not open the database. Please run \"swac-get\" to build it.");
	return NULL;
}

int main(int argc, char **argv) {

	Gtk::Main application(&argc, &argv);
	Gio::init();

	Gnome::Conf::init();
	Glib::RefPtr<Gnome::Conf::Client> gconf;

	gconf = Gnome::Conf::Client::get_default_client();
	gconf->add_dir(GCONF_DIR);

	Gst gst;
	gst.init(argc, argv);

	SqlDatabase *db;  
	if ((db = db_open()) != NULL) {
		Explorer explorer(db, &gst, gconf);
		application.run(explorer);
		db->close();
		delete db;
	}
	gst.close();
	return 0;
}
