#!/usr/bin/env python

import unittest
import os, sys, glob, shutil, commands

import SyFi
import sfc

_test_temp_dir = "temp_dir"
class SFCCommandlineTest(unittest.TestCase):
    def setUp(self):
        print "Running templatetest in testdir"
        print "Imported SyFi from location", SyFi.__file__
        print "Imported sfc  from location", sfc.__file__
        shutil.rmtree(_test_temp_dir, ignore_errors=True)
        os.mkdir(_test_temp_dir)
        os.chdir(_test_temp_dir)
    
    def tearDown(self):
        os.chdir("..")
        #shutil.rmtree(_test_temp_dir, ignore_errors=True)
    
    def testForms(self):
        forms = glob.glob("../forms/*.form")
        for f in forms:
            #cmd = "sfc -o %s %s" % (_test_temp_dir, f)
            cmd = "sfc %s" % f
            status, output = commands.getstatusoutput(cmd)
            self.assertTrue(status == 0)
    
    #def testFailureExample(self):
    #    assert 1
    #    #assert 0 # uncomment to see how a failure looks like


tests = [SFCCommandlineTest]

if __name__ == "__main__":
    unittest.main()
