#!/usr/bin/env python
#from sfc.CodeFormatter import CodeFormatter
from newsfc.codegeneration import CodeFormatter

facet_dofs = [(2, 0, 1), (5, 3, 4), (6, 7, 8)]

code = CodeFormatter()
code.begin_switch("facet")
for i, dofs in enumerate(facet_dofs):
    code.begin_case(i)
    for j, d in enumerate(dofs):
        code += "dofs[%d] = %d;" % (j, d)
    code.end_case()
code += "default:"
code.indent()
code += 'throw std::runtime_error("Invalid facet number.");'
code.outdent()
code.end_switch()

code = str(code)
assert code == """switch(facet)
{
case 0:
    dofs[0] = 2;
    dofs[1] = 0;
    dofs[2] = 1;
    break;
case 1:
    dofs[0] = 5;
    dofs[1] = 3;
    dofs[2] = 4;
    break;
case 2:
    dofs[0] = 6;
    dofs[1] = 7;
    dofs[2] = 8;
    break;
default:
    throw std::runtime_error("Invalid facet number.");
}"""

