/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>
# include "f2c_syrthes.h"
# include "abs.h"

/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | termic                                                               |
  |         Programme principal de SYRTHES                               |
  |======================================================================| */

proc(void termic,void TERMIC)()
{                                                                     
  int ndim,nelesf,nbcouf,nbraf,nelraf,ndmasf;
  int npoins,nelems,neless,neleus,nelepr,nelerc,nelera;
  int nbcous,nbflus,nbdirs,nbechs,nbflvs,nbress;
  int nbrays,nbrais,nbprio,nbmobs,nbfflu,nbfech,nbfrai;
  int ndiele,ndmats,ndmass,ncoema,nbphys,nbface;
  int nbcopr,nbicor,nppel,npoue,npfel;
  int npoinr,nelray,nnsray,nnfray,nneray;
  int nfcfra,nfcsra,nftira,nffira,nfpera,nfmst,nfmste;
  int idtrav,mtotia,mtotra,nbpaso,memuti,memutr,nbpara;
  int nfbida;
  double tcpu,tcpu1,tcpui;
  double totrai=0,totsoi=0,totso=0,totray=0;
  int nb,un=1,zero=0,deux=2,moinsun=-1,nnn,i,prem=1;
  
  int taill_i,taill_r,taill_it,taill_rt,taill_rr;

  /* variables a recuperer des communs */
  int lcface,lray,ntsyr,ncthfs,ldern,lstops,lhisor,ltmax;
  int nchror,lsdepl,ntsmax,ntsyrd,lhisol,nhrmax,nbande,ndprop,nfreqs;
  double rdtts,dtimpo,tempss;
  int lsyrth=1;

  /* tableaux */
  int *ncoups,*nfluss,*ndirs,*nechs,*nfluvs,*nrescs,*nrayts;
  int *nrayis,*nprios,*nmobil;
  double *vfluss,*vdirs,*vechs,*vfluvs,*vrescs,*vrayts,*vrayis;
  int *nrefac,*nrefal,*nfcous,*nfflus,*nfechs,*nfresc,*nfrays,*nfrais;
  double *vfflus,*vfechs,*vfresc,*vfrays,*vfrais,*coords;
  int *nrefs,*nrefe,*nodes,*nodess,*nodeus,*noderc,*nodepr,*nodera,*angles;
  double *physol,*tmpsa,*tmps,*tmpsc1,*tmpsc2,*tmpsc3,*volume,*surfus;
  double *tmpmax,*tmpmin;
  int *ngffir,*ngftir,*ngfper,*ngfpef;
  int *ngfmst,*ngfmse;
  double *vfmste,*phmstp,*phmsto;
  double *emissi,*phfraf,*phfrae,*temray,*firay,*vfiray;
  double *erayeq,*trayeq,*erayen,*trayen,*epropr;
  int *nodray,*nrfray,*ityfar,*ncsray,*ncfray,*nesray;
  double *cooray,*fdfray,*sufray;
  int *ncfin,*ncgros,*itrav,*itravmed;
  double *tabray,*radios,*flumst,*barygr,*baryfs;
  double *b,*dmat,*xmat,*diag,*wct;
  int *itrav1,*itrav2;
  double *trav1,*trav2,*trav3,*trav4,*travf;

  /* inutile : ne sert que pour le fluide */
  int *ncfinf,*ncgrof,*ncbors,*ncborf,*nodesf,*ncoupf,*nrapf;
  double *baryfr,*baryff,*barys,*baryf,*vcoups,*vcoupf,*vfcous,*coordf,*vrapf;
  int *bidon,nbidon=0;
  /* inutile : ne sert que pour le fluide */


  proc(cpusyr,CPUSYR)(&tcpu);
  tcpui=tcpu; totso=totray=0.;  
  nbpaso=nbpara=taill_i=taill_r=taill_it=taill_rt=taill_rr=0;

  proc(syrban,SYRBAN)(&un);
  proc(cpusyr,CPUSYR)(&tcpu);
  printf("\n **TEMPS D'ENTREE ETAPE D'INITIALISATION : %f\n",tcpu);

  proc(recusy,RECUSY)(&lsyrth,&lcface,&lray,&ntsyr,&ncthfs,&ldern,&lstops,&lhisor,
		      &nchror,&lsdepl,&ntsmax,&ntsyrd,&lhisol,&nhrmax,&nbande,&ndprop,
		      &rdtts,&tempss,&nfreqs,&ltmax);

  proc(iniso1,INISO1)
         (&ndim,&npoins,&nelems,&nfbida,
	  &neless,&neleus,&nelepr,&nelerc,&nelera,
          &nbcous,&nbflus,&nbdirs,&nbechs,&nbflvs,&npfel,&nbress,
          &nbrays,&nbrais,&nbprio,&nbmobs,&nbcopr,
          &ndiele,&ndmats,&ndmass,&nbface,&ncoema,&nbphys,&nppel,&npoue,
          &nbicor,&nbfflu,&nbfech,&nbfrai,
          &npoinr,&nelray,&nnsray,&nnfray,&nneray,
          &nfcfra,&nfcsra,&nftira,&nffira,&nfpera,&nfmst,&nfmste);
  
  proc(recusy,RECUSY)(&lsyrth,&lcface,&lray,&ntsyr,&ncthfs,&ldern,&lstops,&lhisor,
		      &nchror,&lsdepl,&ntsmax,&ntsyrd,&lhisol,&nhrmax,&nbande,&ndprop,
		      &rdtts,&tempss,&nfreqs,&ltmax);


  nelesf=nbcouf=nbraf=nelraf=ndmasf=0;
  idtrav=max(nbcouf,npoins); idtrav=max(idtrav,npoinr);idtrav=max(idtrav,nelray);

  fflush(stdout);

  ncoups=(int*)malloc(max(nbcous,1)*sizeof(int));                     taill_i+=max(nbcous,1);
  nfluss=(int*)malloc(max(nbflus,1)*sizeof(int));                     taill_i+=max(nbflus,1);
  ndirs=(int*)malloc(max(nbdirs,1)*sizeof(int));                      taill_i+=max(nbdirs,1);
  nechs=(int*)malloc(max(nbechs*2,1)*sizeof(int));                    taill_i+=max(nbechs*2,1);
  nfluvs=(int*)malloc(max(nbflvs,1)*sizeof(int));                     taill_i+=max(nbflvs,1);
  nrescs=(int*)malloc(max(nbress*2,1)*sizeof(int));                   taill_i+=max(nbress*2,1);
  nrayts=(int*)malloc(max(nbrays,1)*sizeof(int));                     taill_i+=max(nbrays,1);
  nrayis=(int*)malloc(max(nbrais,1)*sizeof(int));                     taill_i+=max(nbrais,1);
  nprios=(int*)malloc(max(nbprio*(nbcopr+1),1)*sizeof(int));          taill_i+=max(nbprio*(nbcopr+1),1);
  nmobil=(int*)malloc(max(nbmobs*2,1)*sizeof(int));                   taill_i+=max(nbmobs*2,1);
  vfluss=(double*)malloc(max(nbflus,1)*sizeof(double));               taill_r+=max(nbflus,1);
  vdirs=(double*)malloc(max(nbdirs,1)*sizeof(double));                taill_r+=max(nbdirs,1);
  vechs=(double*)malloc(max(nbechs*2,1)*sizeof(double));              taill_r+=max(nbechs*2,1);
  vfluvs=(double*)malloc(max(nbflvs*npfel,1)*sizeof(double));         taill_r+=max(nbflvs*npfel,1);
  vrescs=(double*)malloc(max(nbress*2,1)*sizeof(double));             taill_r+=max(nbress*2,1);
  vrayts=(double*)malloc(max(nbrays*2,1)*sizeof(double));             taill_r+=max(nbrays*2,1);
  vrayis=(double*)malloc(max(nbrais*2,1)*sizeof(double));             taill_r+=max(nbrais*2,1);
  nrefe=(int*)malloc(nelems*sizeof(int));                             taill_i+=nelems;
  if (!ncoups|| !ndirs|| !nechs|| !nfluvs|| !nrescs|| !nrayts|| !nrayis|| !nprios|| !nmobil
   || !vfluss|| !vdirs|| !vechs|| !vfluvs|| !vrescs|| !vrayts|| !vrayis|| !nrefe)
    { printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}

  if (lcface)
    {
      nrefac=(int*)malloc(nelems*nbface*sizeof(int));                       taill_i+=nelems*nbface;
      nrefal=(int*)malloc(max(neleus,1)*sizeof(int));                       taill_i+=max(neleus,1);
      if (ncthfs==2)       {nfcous=(int*)malloc(max(nelems,1)*sizeof(int)); taill_i+=max(nelems,1);}
      else if  (ncthfs==3) {nfcous=(int*)malloc(max(neless,1)*sizeof(int)); taill_i+=max(neless,1);}
      nfflus=(int*)malloc(max(nbfflu,1)*sizeof(int));                       taill_i+=max(nbfflu,1);
      nfechs=(int*)malloc(max(nbfech,1)*sizeof(int));                       taill_i+=max(nbfech,1);
      nfresc=(int*)malloc(max(nelerc,1)*sizeof(int));                       taill_i+=max(nelerc,1);
      nfrays=(int*)malloc(max(nelera,1)*sizeof(int));                       taill_i+=max(nelera,1);
      nfrais=(int*)malloc(max(nbfrai,1)*sizeof(int));                       taill_i+=max(nbfrai,1);
      vfflus=(double*)malloc(max(nbfflu*ndmass,1)*sizeof(double));          taill_r+=max(nbfflu*ndmass,1);
      vfechs=(double*)malloc(max(nbfech*ndmass*2,1)*sizeof(double));        taill_r+=max(nbfech*ndmass*2,1);
      vfresc=(double*)malloc(max(nelerc*ndmass*2,1)*sizeof(double));        taill_r+=max(nelerc*ndmass*2,1);
      vfrays=(double*)malloc(max(nelera*ndmass*2,1)*sizeof(double));        taill_r+=max(nelera*ndmass*2,1);
      vfrais=(double*)malloc(max(nbfrai*ndmass*2,1)*sizeof(double));        taill_r+=max(nbfrai*ndmass*2,1);
      if ( !nrefal || !nfcous || !nfflus || !nfechs || !nfresc || !nfrays || !nfrais 
        || !vfflus || !vfechs || !vfresc || !vfrays || !vfrais || !nrefac)
	{printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
    }
  
  nrefs=(int*)malloc(npoins*sizeof(int));                                   taill_i+=npoins;
  coords=(double*)malloc(npoins*ndim*sizeof(double));                       taill_r+=npoins*ndim;
  nodes=(int*)malloc(nelems*ndmats*sizeof(int));                            taill_i+=nelems*ndmats;
  angles=(int*)malloc(nelems*sizeof(int));                                  taill_i+=nelems;
  nodess=(int*)malloc(max(neless*ndmass,1)*sizeof(int));                    taill_i+=max(neless*ndmass,1);
  nodeus=(int*)malloc(max(neleus*ndmass,1)*sizeof(int));                    taill_i+=max(neleus*ndmass,1);
  noderc=(int*)malloc(max(nelerc*ndmass,1)*sizeof(int));                    taill_i+=max(nelerc*ndmass,1);
  nodepr=(int*)malloc(max(nelepr*(ndmats+1),1)*sizeof(int));                taill_i+=max(nelepr*(ndmats+1),1);
  nodera=(int*)malloc(max(nelera*ndmass,1)*sizeof(int));                    taill_i+=max(nelera*ndmass,1);
  physol=(double*)malloc(max(npoue*nppel*nbphys,1)*sizeof(double));         taill_r+=max(npoue*nppel*nbphys,1);
  tmpsa=(double*)malloc(npoins*sizeof(double));                             taill_r+=npoins;
  tmps=(double*)malloc(npoins*sizeof(double));                              taill_r+=npoins;
  if ( !coords|| !nodes|| !angles || !nodess|| !nodeus|| !noderc|| !nodepr|| !nodera|| !physol
    || !tmpsa || !tmps || !nrefs)
    { printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
  if (ncthfs==2)
    {
      tmpsc1=(double*)malloc(npoins*sizeof(double));                 taill_r+=npoins;
      tmpsc2=(double*)malloc(npoins*sizeof(double));                 taill_r+=npoins;
      tmpsc3=(double*)malloc(npoins*sizeof(double));                 taill_r+=npoins;
      if ( !tmpsc1|| !tmpsc2|| !tmpsc3) { printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
    }
  if (ncthfs!=2)
    {
      volume=(double*)malloc(nelems*sizeof(double));                        taill_r+=nelems;
      surfus=(double*)malloc(max(neleus,1)*sizeof(double));                 taill_r+=max(neleus,1);
      if ( !volume|| !surfus) { printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
    }
  if (ltmax)
    {
      tmpmax=(double*)malloc(npoins*sizeof(double));     
      tmpmin=(double*)malloc(npoins*sizeof(double));     
      if (!tmpmax || !tmpmin) { printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
    }

  if (lray)
    {
      ngffir=(int*)malloc(max(nffira,1)*sizeof(int));                      taill_i+=max(nffira,1);
      ngftir=(int*)malloc(max(nftira,1)*sizeof(int));                      taill_i+=max(nftira,1);
      ngfper=(int*)malloc(max(nfpera,1)*sizeof(int));                      taill_i+=max(nfpera,1);
      ngfpef=(int*)malloc(max(nfcfra,1)*sizeof(int));                      taill_i+=max(nfcfra,1);
      ngfmst=(int*)malloc(max(nfmst*2,1)*sizeof(int));                     taill_i+=max(nfmst*2,1);
      ngfmse=(int*)malloc(max(nfmste,1)*sizeof(int));                      taill_i+=max(nfmste,1);
      vfmste=(double*)malloc(max(nfmste*2,1)*sizeof(double));              taill_r+=max(nfmste*2,1);
      phmstp=(double*)malloc(max(nfmst*4,1)*sizeof(double));               taill_r+=max(nfmst*4,1)  ;  
      phmsto=(double*)malloc(max(nfmst*5*nbande,1)*sizeof(double));        taill_r+=max(nfmst*5*nbande,1);
      flumst=(double*)malloc(max(nfmst*nbande,1)*sizeof(double));          taill_r+=max(nfmst*nbande,1);
      emissi=(double*)malloc(max(nelray*2*nbande,1)*sizeof(double));       taill_r+=max(nelray*2*nbande,1);
      epropr=(double*)malloc(max(nelray*nbande,1)*sizeof(double));         taill_r+=max(nelray*nbande,1);
      phfraf=(double*)malloc(max(nfcfra*4,1)*sizeof(double));              taill_r+=max(nfcfra*4,1);
      phfrae=(double*)malloc(max(nfpera*4,1)*sizeof(double));              taill_r+=max(nfpera*4,1);
      temray=(double*)malloc(max(nelray,1)*sizeof(double));                taill_r+=max(nelray,1);
      firay=(double*)malloc(max(nelray*nbande,1)*sizeof(double));          taill_r+=max(nelray*nbande,1);
      vfiray=(double*)malloc(max(nffira*nbande*2,1)*sizeof(double));       taill_r+=max(nffira*nbande*2,1);
      erayeq=(double*)malloc(max(nelray,1)*sizeof(double));                taill_r+=max(nelray,1);
      trayeq=(double*)malloc(max(nelray,1)*sizeof(double));                taill_r+=max(nelray,1);
      erayen=(double*)malloc(max(npoinr,1)*sizeof(double));                taill_r+=max(npoinr,1);
      trayen=(double*)malloc(max(npoinr,1)*sizeof(double));                taill_r+=max(npoinr,1);
      nodray=(int*)malloc(max(nelray*ndim,1)*sizeof(int));                 taill_i+=max(nelray*ndim,1);
      nrfray=(int*)malloc(max(nelray,1)*sizeof(int));                      taill_i+=max(nelray,1);
      ityfar=(int*)malloc(max(nelray,1)*sizeof(int));                      taill_i+=max(nelray,1);
      cooray=(double*)malloc(max(npoinr*ndim,1)*sizeof(double));           taill_r+=max(npoinr*ndim,1);
      fdfray=(double*)malloc(max(nelray*(nelray+1)/2,1)*sizeof(double));   taill_r+=max(nelray*(nelray+1)/2,1);
      sufray=(double*)malloc(max(nelray,1)*sizeof(double));                taill_r+=max(nelray,1);
      ncsray=(int*)malloc(max(nnsray,1)*sizeof(int));                      taill_i+=max(nnsray,1);
      ncfray=(int*)malloc(max(nnfray,1)*sizeof(int));                      taill_i+=max(nnfray,1);
      nesray=(int*)malloc(max(nneray,1)*sizeof(int));                      taill_i+=max(nneray,1);
      ncfin=(int*)malloc(max(nbrays,1)*sizeof(int));                       taill_i+=max(nbrays,1);
      ncgros=(int*)malloc(max(nnsray*2,1)*sizeof(int));                    taill_i+=max(nnsray*2,1);
      barygr=(double*)malloc(max(nnsray*ndim,1)*sizeof(double));           taill_r+=max(nnsray*ndim,1);
      baryfs=(double*)malloc(max(nbrays*ndim,1)*sizeof(double));           taill_r+=max(nbrays*ndim,1);
      tabray=(double*)malloc(max(nelray*9,1)*sizeof(double));          taill_r+=max((nelray+1)*8,1);
      radios=(double*)malloc(max(nelray*nbande,1)*sizeof(double));        taill_r+=max(nfmst*5*nbande,1);
							       
      if (!ngffir || !ngftir || !ngfper || !ngfpef || !ngfmst  || !ngfmse || !vfmste || 
	  !phmstp || !phmsto || !flumst || !emissi || !epropr  || !phfraf || !phfrae || 
	  !temray || !firay  || !vfiray || !erayeq || !trayen  || !erayen || !trayen || 
	  !nodray || !nrfray || !ityfar || !cooray || !fdfray  || !sufray || !ncsray || 
	  !ncfray || !nesray || !ncfin  || !ncgros || !barygr  || !baryfs ||  
	  !tabray || !radios)
	{printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
    }
      
  itrav=(int*)malloc(max(idtrav,1)*sizeof(int));                           taill_it+=max(idtrav,1);
  itrav1=(int*)malloc(max(idtrav,1)*sizeof(int));                          taill_it+=max(idtrav,1);
  if (!itrav||!itrav1){printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
  trav1=(double*)malloc(max(npoins,1)*sizeof(double));                 taill_rt+=npoins;
  trav2=(double*)malloc(max(npoins,1)*sizeof(double));                 taill_rt+=npoins;
  if (!trav1||!trav2)
    {printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
  if (nbprio)
    {
      itrav2=(int*)malloc(max(npoins,1)*sizeof(int));                      taill_it+=npoins;
      trav3=(double*)malloc(max(npoins,1)*sizeof(double));                 taill_rt+=npoins;
      if (!itrav2||!trav3)
	{printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
    }

#ifdef MED
      itravmed=(int*)malloc(max(nelems*ndmats,1)*sizeof(int));             taill_rt+=nelems*ndmats;
      if (!itravmed)
	{printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
#endif

  printf("\n\n ============================================================\n");
  printf("        Memoire totale pour la phase initiale :\n\n");
  printf("            Nombre d'entiers reserves : %9d\n",taill_i+taill_it);
  printf("                       soit par noeud : %9d\n\n",(taill_i+taill_it)/npoins);
  printf("            Nombre de reels  reserves : %9d\n",taill_r+taill_rt);
  printf("                       soit par noeud : %9d\n",(taill_r+taill_rt)/npoins); 
  printf("============================================================\n\n");

  proc(inisol,INISOL)
        (&ndim,&ndiele,&nbface,&nfbida,
         &nbcous,&nbflus,&nbdirs,&nbechs,&nbflvs,&npfel,&npoins,&nelems,
         &ndmats,&neless,&ndmass,&neleus,&nelerc,&nelepr,&nelera,&nbress,
         &nbrays,&nbrais,&nbprio,&nbmobs,&nbcopr,
         &nbphys,&nppel,&npoue,&nbicor,&nbfflu,&nbfech,&nbfrai,
	 ncoups,nfluss,ndirs,nechs,nfluvs,nrescs,nrayts,
	 nrayis,nprios,nmobil,
	 vfluss,vdirs,vechs,vfluvs,vrescs,vrayts,vrayis,
	 nrefac,nrefal,nfcous,nfflus,nfechs,nfresc,nfrays,nfrais,
	 vfflus,vfechs,vfresc,vfrays,vfrais,
	 nrefs,nrefe,coords,nodes,nodess,nodeus,noderc,nodepr,nodera,angles,
	 physol,tmpsa,tmps,tmpsc1,tmpsc2,tmpsc3,volume,surfus,
	 &nelray,&npoinr,&nnsray,&nnfray,&nneray,&nfcfra,&nfcsra,&nftira,
	 &nffira,&nfpera,&nfmst,&nfmste,
	 ngffir,ngftir,ngfper,ngfpef,
	 ngfmst,ngfmse,vfmste,phmstp,phmsto,
	 emissi,phfraf,phfrae,temray,firay,vfiray,erayeq,trayeq,
	 nodray,nrfray,ityfar,cooray,fdfray,sufray,ncsray,ncfray,nesray,
	 ncfin,ncgros,barygr,baryfs,itrav,&idtrav,tabray,radios,
	 itrav1,itrav2,trav1,trav2,trav3,&totrai,tmpmax,tmpmin,itravmed);

  proc(recusy,RECUSY)(&lsyrth,&lcface,&lray,&ntsyr,&ncthfs,&ldern,&lstops,&lhisor,
		      &nchror,&lsdepl,&ntsmax,&ntsyrd,&lhisol,&nhrmax,&nbande,&ndprop,
		      &rdtts,&tempss,&nfreqs,&ltmax);

  free(itrav); free(itrav1); free(trav1); free(trav2);
  if (nbprio) {free(itrav2); free(trav3);}
  idtrav=max(npoins,npoinr);idtrav=max(idtrav,nelray);

  
  b=(double*)malloc(max(npoins,1)*sizeof(double));           taill_rr+=npoins;
  trav1=(double*)malloc(max(idtrav,1)*sizeof(double));       taill_rr+=idtrav;
  trav2=(double*)malloc(max(idtrav,1)*sizeof(double));       taill_rr+=idtrav;
  trav3=(double*)malloc(max(idtrav,1)*sizeof(double));       taill_rr+=idtrav;
  trav4=(double*)malloc(max(idtrav,1)*sizeof(double));       taill_rr+=idtrav;
  dmat=(double*)malloc(max(idtrav,1)*sizeof(double));        taill_rr+=idtrav;
  xmat=(double*)malloc(max(nelems*ncoema,1)*sizeof(double)); taill_rr+=nelems*ncoema;
  diag=(double*)malloc(max(npoins,1)*sizeof(double));        taill_rr+=npoins;
  wct=(double*)malloc(max(nelems*ndmats,1)*sizeof(double));  taill_rr+=nelems*ndmats;
  if (!b||!trav1||!trav2||!trav3||!trav4||!dmat||!xmat||!diag||!wct)
    {printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
  if (lcface) 
    {
      travf=(double*)malloc(max(neleus*ndmass,1)*sizeof(double));
      if (!travf) {printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
    }

  if (ltmax) for (i=0;i<npoins;i++) { *(tmpmax+i)=*(tmps+i); *(tmpmin+i)=*(tmps+i);}


  printf("\n\n ============================================================\n");
  printf("        Memoire totale pour la phase de resolution :\n\n");
  printf("            Nombre d'entiers reserves : %9d\n",taill_i);
  printf("                       soit par noeud : %9d\n\n",(taill_i)/npoins);
  printf("            Nombre de reels  reserves : %9d\n",taill_r+taill_rr);
  printf("                       soit par noeud : %9d\n",(taill_r+taill_rr)/npoins); 
  printf("============================================================\n\n");

  proc(cpusyr,CPUSYR)(&tcpu);
  totsoi = tcpu-tcpui;
  fflush(stdout);

                                                                       
/* =======================================================================
         D E B U T   I T E R A T I O N S   E N   T E M P S             
   ======================================================================= */

  do
    {
                                            
      /* 0- MISE A JOUR DU TEMPS REEL 
	 ============================*/
      /* pour recuperer lstops */
      proc(recusy,RECUSY)(&lsyrth,&lcface,&lray,&ntsyr,&ncthfs,&ldern,&lstops,&lhisor,
			  &nchror,&lsdepl,&ntsmax,&ntsyrd,&lhisol,&nhrmax,&nbande,&ndprop,
			  &rdtts,&tempss,&nfreqs,&ltmax);
      ntsyr++;
      dtimpo=-1;
      proc(cadtmy,CADTMY)(&ntsyr,&rdtts,&dtimpo,&prem,&npoins,tmpsa,tmps);prem=0;
      tempss+=rdtts;
      proc(envosy,ENVOSY)(&lsyrth,&ntsyr,&ldern,&lstops,&tempss,&ntsmax);
      
      /* 1- BANNIERE
	 ===========*/
      printf("\n ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
      printf(" ITERATION SOLIDE  NTSYR=%7d   TEMPSS=%14.8e  dt=%12.5e\n",ntsyr,tempss,rdtts);
      printf(" ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");
      
      
      /* 2- RESOLUTION RAYONNEMENT
	 ========================= */
      
      if (lray) 
	{
	  nbpara++;
	  proc(cpusyr,CPUSYR)(&tcpu1);
	  printf("\n **TEMPS D'ENTREE RAYONNEMENT : %f\n",tcpu1);
	  
	  proc(solray,SOLRAY)(&ndim,&npoins,tmps,&nbrays,nrayts,vrayts);
	  
	  proc(limray,LIMRAY) (&ndim,&nelray,&npoinr,
			       &nfcfra,&nfcsra,&nftira,&nffira,&nfpera,
			       nodray,nrfray,ngffir,ngftir,ngfper,ngfpef,
			       cooray,emissi,temray,firay,phfraf,phfrae,vfiray);
	  
	  if (nfpera) proc(resrer,RESRER) (&un,&nfpera,&nelray,
					   ngfper,temray,trayeq,erayeq,phfrae,trav3,trav4);
	  
	  
	  if (nbrays)  /* (ITRAV de dimension NELRAY) */
	    proc(pasray,PASRAY)(&un,&ndim,&npoinr,&nbrays,
				nrayts,vrayts,&nbraf,nrapf,vrapf,nrfray,
				ityfar,&nelray,nodray,&nelraf,&ndmasf,
				&nelera,&ndmass,nodera,bidon,
				&nnsray,&nnfray,&nfcfra,ngfpef,ncsray,ncfray,
				ncfin,ncgros,barygr,ncfinf,ncgrof,baryfr,baryff,baryfs,
				temray,firay,erayeq,trayeq,phfraf,trayen,erayen,sufray,
				trav1,trav2,trav3,trav4);
	  	   
	  proc(resray,RESRAY) (&ndim,&nelray,&npoinr,
			       cooray,nodray,nrfray,
			       fdfray,sufray,temray,radios,firay,trayeq,erayeq,
			       emissi,epropr,&nffira,ngffir,vfiray,tabray,
			       &nfmst,ngfmst,flumst,phmsto);
	  
	  if (nbrays)
	    proc(pasray,PASRAY) (&deux,&ndim,&npoinr,&nbrays,
				 nrayts,vrayts,&nbraf,nrapf,vrapf,nrfray,
				 ityfar,&nelray,nodray,&nelraf,&ndmasf,
				 &nelera,&ndmass,nodera,bidon,
				 &nnsray,&nnfray,&nfcfra,ngfpef,ncsray,ncfray,
				 ncfin,ncgros,barygr,ncfinf,ncgrof,baryfr,baryff,baryfs,
				 temray,firay,erayeq,trayeq,phfraf,trayen,erayen,sufray,
				 trav1,trav2,trav3,trav4);
	  
	  
	  /* 7- COND LIM PAR FACES : REMPLISSAGE DE VFRAYS
	     --------------------------------------------- */ 
	  if (lcface) 
	    proc(pssclf,PSSCLF)(&nbrays,vrayts,&nelera,&ndmass,vfrays,nodera);
	  
	  /* temps CPU rayonnement */
	  proc(cpusyr,CPUSYR)(&tcpu); totray+=(tcpu-tcpu1); fflush(stdout);
	}
      
      
      
      /* CONDUCTION
	 ----------
	 Traitement de la conduction  (avant juste apres l'etiquette 1)  */
      proc(cpusyr,CPUSYR)(&tcpu1);
      printf("\n **TEMPS D'ENTREE ETAPE DE RESOLUTION DE LA CONDUCTION : %f\n",tcpu1);
      
      nbpaso++;
      
      proc(ressol, RESSOL) 
        (&ndim,&ndiele,&nbcouf,&nelesf,&nbidon,&nbface,
         &nbcous,&nbflus,&nbdirs,&nbechs,&nbflvs,&npfel,&npoins,&nelems,&ndmats,
         &neless,&ndmass,&neleus,&nelerc,&nelepr,&nbress,&nbrays,&nbrais,
         &nbprio,&nbmobs,&nbcopr,&nbphys,&nppel,&npoue,&ncoema,&nbicor,
	 nodesf,ncoupf,vcoupf,ncoups,nfluss,ndirs,nechs,nfluvs,
	 nrescs,nrayts,nrayis,nprios,nmobil,
	 vcoups,vfluss,vdirs,vechs,vfluvs,vrescs,vrayts,vrayis,nrefac,nrefal,
	 nrefs,nrefe,coords,nodes,nodess,nodeus,noderc,nodepr,angles,
	 nfflus,vfflus,&nbfflu,nfechs,vfechs,&nbfech, nfresc,vfresc, nfrays,vfrays,&nelera,
	 nfrais,vfrais,&nbfrai, nfcous,vfcous, ncbors,ncborf,barys,baryf,coordf,
	 physol,tmpsa,tmps,tmpsc1,tmpsc2,tmpsc3, volume,surfus,
	 b,dmat,xmat,diag, travf,trav1,trav2,trav3,trav4,wct,tmpmax,tmpmin);
	  
      proc(cpusyr,CPUSYR)(&tcpu);totso += tcpu-tcpu1;
      /* printf("\n **TEMPS DE SORTIE ETAPE DE RESOLUTION DE LA CONDUCTION : %f\n",tcpu); */
      fflush(stdout);
      
/*      OPEN(99,file='syrthes.stop',status='old',ERR=2)
	IF (LDERN) THEN
	  GOTO 3
	    ELSE
	      LDERN = .TRUE.
		ENDIF
		  2 CONTINUE
		    C
*/
      if (ntsyr==ntsmax-1) ldern=1;
    }
  while (!lstops && ntsyr<ntsmax);

/* =======================================================================
          F I N       I T E R A T I O N S   E N   T E M P S             
   ======================================================================= */

  /* Fermeture des fichiers
     ~~~~~~~~~~~~~~~~~~~~~~ */
  proc(closct,CLOSCT)();

  printf("\n\n ============================================================================\n");
  proc(cpusyr,CPUSYR)(&tcpu);
  printf("\n **TEMPS FINAL : %f\n",tcpu);

  printf("\n\n          ================================================\n");
  printf("                       SYRTHES : BILAN DU CALCUL\n\n");
  printf("                  CONDUCTION :  %9d PAS DE TEMPS\n",nbpaso);
  printf("                                %9d       NOEUDS\n",npoins);
  printf("                                %9d     ELEMENTS\n",nelems);
  if (lray)
    {
  printf("                 RAYONNEMENT :  %9d PAS DE TEMPS\n",nbpara);
  printf("                                %9d     FACETTES\n",nelray);
    }
  printf("          ================================================\n\n\n\n");
  printf("     TEMPS CPU (secondes)\n");
  printf("     =========\n\n");
  printf("     PHASE INITIALE POUR LA CONDUCTION . . . . . . . . %12.4f\n",abs(totsoi-totrai));
  printf("     RESOLUTION DE LA CONDUCTION . . . . . . . . . . . %12.4f\n",abs(totso));
  if (lray)
    {
  printf("     PHASE INITIALE POUR LE RAYONNEMENT. . . . . . . . %12.4f\n",abs(totrai));
  printf("     RESOLUTION DU RAYONNEMENT . . . . . . . . . . . . %12.4f\n",abs(totray));
    }
  printf("     T E M P S   T O T A L   . . . . . . . . . . . . . %12.4f\n",abs(totsoi+totso+totray));
  printf("     D U R E E S M O Y E N N E S\n");                       
  printf("        - RESOLUTION DE LA CONDUCTION\n");                  
  printf("                             par pas de temps  . .%12.4f\n",abs(totso)/nbpaso);
  printf("            par pas de temps pour 1000 noeuds  . .%12.4f\n",abs(totso)*1000./(nbpaso*npoins));
  if (lray)
    {
  printf("        - RESOLUTION DU RAYONNEMENT\n");              
  printf("                             par pas de temps  . .%12.4f\n",abs(totray)/max(nbpara,1)); 
    }


  /* Banniere
     ~~~~~~~~ */
  proc(syrban,SYRBAN)(&moinsun);

}  

