from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


CONF = _Mock()

exclude_trees = _Mock()

extensions = _Mock()

html_context = _Mock()

html_short_title = _Mock()

html_static_path = _Mock()

html_title = _Mock()

templates_path = _Mock()

u = _Mock()

add_function_parentheses = _Mock()

copyright = u'2009--2013, The Spyder Development Team'

default_role = 'None'

html_copy_source = _Mock()

html_split_index = _Mock()

html_style = 'default.css'

html_use_index = _Mock()

html_use_modindex = _Mock()

jsmath_path = 'easy/load.js'

master_doc = 'docstring'

math = _Mock()

mathjax_path = 'MathJax/MathJax.js'

project = u'Object Inspector'

pygments_style = 'sphinx'

source_suffix = '.rst'

sphinx_version = '1.2.3'



