-- vim: nowrap fo-=a
return
  { { code = 0x00021,  char = '!',  class = 'punct',     cs = 'exclam'                            } -- exclamation mark
  , { code = 0x00023,  char = '#',  class = 'ord',       cs = 'octothorpe'                        } -- number sign
  , { code = 0x00024,  char = '$',  class = 'ord',       cs = 'mathdollar'                        } -- dollar sign
  , { code = 0x00025,  char = '%',  class = 'ord',       cs = 'percent'                           } -- percent sign
  , { code = 0x00026,  char = '&',  class = 'ord',       cs = 'ampersand'                         } -- ampersand
  , { code = 0x00028,  char = '(',  class = 'open',      cs = 'lparen'                            } -- left parenthesis
  , { code = 0x00029,  char = ')',  class = 'close',     cs = 'rparen'                            } -- right parenthesis
  , { code = 0x0002B,  char = '+',  class = 'bin',       cs = 'plus'                              } -- plus sign
  , { code = 0x0002C,  char = ',',  class = 'punct',     cs = 'comma'                             } -- comma
  , { code = 0x0002E,  char = '.',  class = 'ord',       cs = 'ldot'                              } -- full stop
  , { code = 0x0002F,  char = '/',  class = 'ord',       cs = 'mathslash'                         } -- solidus
  , { code = 0x00030,  char = '0',  class = 'var',       alphabet = 'digits'                      } -- digit zero
  , { code = 0x00031,  char = '1',  class = 'var',       alphabet = 'digits'                      } -- digit one
  , { code = 0x00032,  char = '2',  class = 'var',       alphabet = 'digits'                      } -- digit two
  , { code = 0x00033,  char = '3',  class = 'var',       alphabet = 'digits'                      } -- digit three
  , { code = 0x00034,  char = '4',  class = 'var',       alphabet = 'digits'                      } -- digit four
  , { code = 0x00035,  char = '5',  class = 'var',       alphabet = 'digits'                      } -- digit five
  , { code = 0x00036,  char = '6',  class = 'var',       alphabet = 'digits'                      } -- digit six
  , { code = 0x00037,  char = '7',  class = 'var',       alphabet = 'digits'                      } -- digit seven
  , { code = 0x00038,  char = '8',  class = 'var',       alphabet = 'digits'                      } -- digit eight
  , { code = 0x00039,  char = '9',  class = 'var',       alphabet = 'digits'                      } -- digit nine
  , { code = 0x0003A,  char = ':',  class = 'punct',     cs = 'colon'                             } -- colon
  , { code = 0x0003B,  char = ';',  class = 'punct',     cs = 'semicolon'                         } -- semicolon
  , { code = 0x0003C,  char = '<',  class = 'rel',       cs = 'less'                              } -- less-than sign
  , { code = 0x0003D,  char = '=',  class = 'rel',       cs = 'equal'                             } -- equals sign
  , { code = 0x0003E,  char = '>',  class = 'rel',       cs = 'greater'                           } -- greater-than sign
  , { code = 0x0003F,  char = '?',  class = 'ord',       cs = 'question'                          } -- question mark
  , { code = 0x00040,  char = '@',  class = 'ord',       cs = 'atsign'                            } -- commercial at
  , { code = 0x00041,  char = 'A',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter a
  , { code = 0x00042,  char = 'B',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter b
  , { code = 0x00043,  char = 'C',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter c
  , { code = 0x00044,  char = 'D',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter d
  , { code = 0x00045,  char = 'E',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter e
  , { code = 0x00046,  char = 'F',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter f
  , { code = 0x00047,  char = 'G',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter g
  , { code = 0x00048,  char = 'H',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter h
  , { code = 0x00049,  char = 'I',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter i
  , { code = 0x0004A,  char = 'J',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter j
  , { code = 0x0004B,  char = 'K',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter k
  , { code = 0x0004C,  char = 'L',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter l
  , { code = 0x0004D,  char = 'M',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter m
  , { code = 0x0004E,  char = 'N',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter n
  , { code = 0x0004F,  char = 'O',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter o
  , { code = 0x00050,  char = 'P',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter p
  , { code = 0x00051,  char = 'Q',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter q
  , { code = 0x00052,  char = 'R',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter r
  , { code = 0x00053,  char = 'S',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter s
  , { code = 0x00054,  char = 'T',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter t
  , { code = 0x00055,  char = 'U',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter u
  , { code = 0x00056,  char = 'V',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter v
  , { code = 0x00057,  char = 'W',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter w
  , { code = 0x00058,  char = 'X',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter x
  , { code = 0x00059,  char = 'Y',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter y
  , { code = 0x0005A,  char = 'Z',  class = 'var',       alphabet = 'Latin'                       } -- latin capital letter z
  , { code = 0x00061,  char = 'a',  class = 'var',       alphabet = 'latin'                       } -- latin small letter a
  , { code = 0x00062,  char = 'b',  class = 'var',       alphabet = 'latin'                       } -- latin small letter b
  , { code = 0x00063,  char = 'c',  class = 'var',       alphabet = 'latin'                       } -- latin small letter c
  , { code = 0x00064,  char = 'd',  class = 'var',       alphabet = 'latin'                       } -- latin small letter d
  , { code = 0x00065,  char = 'e',  class = 'var',       alphabet = 'latin'                       } -- latin small letter e
  , { code = 0x00066,  char = 'f',  class = 'var',       alphabet = 'latin'                       } -- latin small letter f
  , { code = 0x00067,  char = 'g',  class = 'var',       alphabet = 'latin'                       } -- latin small letter g
  , { code = 0x00068,  char = 'h',  class = 'var',       alphabet = 'latin'                       } -- latin small letter h
  , { code = 0x00069,  char = 'i',  class = 'var',       alphabet = 'latin'                       } -- latin small letter i
  , { code = 0x0006A,  char = 'j',  class = 'var',       alphabet = 'latin'                       } -- latin small letter j
  , { code = 0x0006B,  char = 'k',  class = 'var',       alphabet = 'latin'                       } -- latin small letter k
  , { code = 0x0006C,  char = 'l',  class = 'var',       alphabet = 'latin'                       } -- latin small letter l
  , { code = 0x0006D,  char = 'm',  class = 'var',       alphabet = 'latin'                       } -- latin small letter m
  , { code = 0x0006E,  char = 'n',  class = 'var',       alphabet = 'latin'                       } -- latin small letter n
  , { code = 0x0006F,  char = 'o',  class = 'var',       alphabet = 'latin'                       } -- latin small letter o
  , { code = 0x00070,  char = 'p',  class = 'var',       alphabet = 'latin'                       } -- latin small letter p
  , { code = 0x00071,  char = 'q',  class = 'var',       alphabet = 'latin'                       } -- latin small letter q
  , { code = 0x00072,  char = 'r',  class = 'var',       alphabet = 'latin'                       } -- latin small letter r
  , { code = 0x00073,  char = 's',  class = 'var',       alphabet = 'latin'                       } -- latin small letter s
  , { code = 0x00074,  char = 't',  class = 'var',       alphabet = 'latin'                       } -- latin small letter t
  , { code = 0x00075,  char = 'u',  class = 'var',       alphabet = 'latin'                       } -- latin small letter u
  , { code = 0x00076,  char = 'v',  class = 'var',       alphabet = 'latin'                       } -- latin small letter v
  , { code = 0x00077,  char = 'w',  class = 'var',       alphabet = 'latin'                       } -- latin small letter w
  , { code = 0x00078,  char = 'x',  class = 'var',       alphabet = 'latin'                       } -- latin small letter x
  , { code = 0x00079,  char = 'y',  class = 'var',       alphabet = 'latin'                       } -- latin small letter y
  , { code = 0x0007A,  char = 'z',  class = 'var',       alphabet = 'latin'                       } -- latin small letter z
  , { code = 0x0005B,  char = '[',  class = 'open',      cs = 'lbrack'                            } -- left square bracket
  , { code = 0x0005C,  char = '\\', class = 'ord',       cs = 'mathbackslash'                     } -- reverse solidus
  , { code = 0x0005D,  char = ']',  class = 'close',     cs = 'rbrack'                            } -- right square bracket
  , { code = 0x0007B,  char = '{',  class = 'open',      cs = 'lbrace'                            } -- left curly bracket
  , { code = 0x0007C,  char = '|',  class = 'fence',     cs = 'vert'                              } -- vertical line
  , { code = 0x0007D,  char = '}',  class = 'close',     cs = 'rbrace'                            } -- right curly bracket
  , { code = 0x000A3,  char = '£',  class = 'ord',       cs = 'sterling'                          } -- pound sign
  , { code = 0x000A5,  char = '¥',  class = 'ord',       cs = 'yen'                               } -- yen sign
  , { code = 0x000AC,  char = '¬',  class = 'ord',       cs = 'neg'                               } -- not sign
  , { code = 0x000B1,  char = '±',  class = 'bin',       cs = 'pm'                                } -- plus-minus sign
  , { code = 0x000B7,  char = '·',  class = 'punct',     cs = 'cdotp'                             } -- middle dot
  , { code = 0x000D7,  char = '×',  class = 'bin',       cs = 'times'                             } -- multiplication sign
  , { code = 0x000F0,  char = 'ð',  class = 'ord',       cs = 'matheth'                           } -- latin small letter eth
  , { code = 0x000F7,  char = '÷',  class = 'bin',       cs = 'div'                               } -- division sign
  , { code = 0x001B5,  char = 'Ƶ',  class = 'ord',       cs = 'Zbar'                              } -- latin capital letter z with stroke
  , { code = 0x00300,  char = ' ̀',  class = 'accent',    cs = 'grave'                             } -- combining grave accent
  , { code = 0x00301,  char = ' ́',  class = 'accent',    cs = 'acute'                             } -- combining acute accent
  , { code = 0x00302,  char = ' ̂',  class = 'accent',    cs = 'hat'                               } -- combining circumflex accent
  , { code = 0x00303,  char = ' ̃',  class = 'accent',    cs = 'tilde'                             } -- combining tilde
  , { code = 0x00304,  char = ' ̄',  class = 'accent',    cs = 'bar'                               } -- combining macron
  , { code = 0x00305,  char = ' ̅',  class = 'accent',    cs = 'overbar'                           } -- combining overline
  , { code = 0x00306,  char = ' ̆',  class = 'accent',    cs = 'breve'                             } -- combining breve
  , { code = 0x00307,  char = ' ̇',  class = 'accent',    cs = 'dot'                               } -- combining dot above
  , { code = 0x00308,  char = ' ̈',  class = 'accent',    cs = 'ddot'                              } -- combining diaeresis
  , { code = 0x00309,  char = ' ̉',  class = 'accent',    cs = 'ovhook'                            } -- combining hook above
  , { code = 0x0030A,  char = ' ̊',  class = 'accent',    cs = 'ocirc'                             } -- combining ring above
  , { code = 0x0030C,  char = ' ̌',  class = 'accent',    cs = 'check'                             } -- combining caron
  , { code = 0x00310,  char = ' ̐',  class = 'accent',    cs = 'candra'                            } -- combining candrabindu
  , { code = 0x00312,  char = ' ̒',  class = 'accent',    cs = 'oturnedcomma'                      } -- combining turned comma above
  , { code = 0x00315,  char = ' ̕',  class = 'accent',    cs = 'ocommatopright'                    } -- combining comma above right
  , { code = 0x0031A,  char = ' ̚',  class = 'accent',    cs = 'droang'                            } -- combining left angle above
  , { code = 0x00330,  char = ' ̰',  class = 'botaccent', cs = 'wideutilde'                        } -- combining tilde below
  , { code = 0x00331,  char = ' ̱',  class = 'botaccent', cs = 'underbar'                          } -- combining macron below
  , { code = 0x00338,  char = ' ̸',  class = 'overlay',   cs = 'not'                               } -- combining long solidus overlay
  , { code = 0x00391,  char = 'Α',  class = 'var',       cs = 'Alpha', alphabet = 'Greek'         } -- greek capital letter alpha
  , { code = 0x00392,  char = 'Β',  class = 'var',       cs = 'Beta', alphabet = 'Greek'          } -- greek capital letter beta
  , { code = 0x00393,  char = 'Γ',  class = 'var',       cs = 'Gamma', alphabet = 'Greek'         } -- greek capital letter gamma
  , { code = 0x00394,  char = 'Δ',  class = 'var',       cs = 'Delta', alphabet = 'Greek'         } -- greek capital letter delta
  , { code = 0x00395,  char = 'Ε',  class = 'var',       cs = 'Epsilon', alphabet = 'Greek'       } -- greek capital letter epsilon
  , { code = 0x00396,  char = 'Ζ',  class = 'var',       cs = 'Zeta', alphabet = 'Greek'          } -- greek capital letter zeta
  , { code = 0x00397,  char = 'Η',  class = 'var',       cs = 'Eta', alphabet = 'Greek'           } -- greek capital letter eta
  , { code = 0x00398,  char = 'Θ',  class = 'var',       cs = 'Theta', alphabet = 'Greek'         } -- greek capital letter theta
  , { code = 0x00399,  char = 'Ι',  class = 'var',       cs = 'Iota', alphabet = 'Greek'          } -- greek capital letter iota
  , { code = 0x0039A,  char = 'Κ',  class = 'var',       cs = 'Kappa', alphabet = 'Greek'         } -- greek capital letter kappa
  , { code = 0x0039B,  char = 'Λ',  class = 'var',       cs = 'Lambda', alphabet = 'Greek'        } -- greek capital letter lamda
  , { code = 0x0039C,  char = 'Μ',  class = 'var',       cs = 'Mu', alphabet = 'Greek'            } -- greek capital letter mu
  , { code = 0x0039D,  char = 'Ν',  class = 'var',       cs = 'Nu', alphabet = 'Greek'            } -- greek capital letter nu
  , { code = 0x0039E,  char = 'Ξ',  class = 'var',       cs = 'Xi', alphabet = 'Greek'            } -- greek capital letter xi
  , { code = 0x0039F,  char = 'Ο',  class = 'var',       cs = 'Omicron', alphabet = 'Greek'       } -- greek capital letter omicron
  , { code = 0x003A0,  char = 'Π',  class = 'var',       cs = 'Pi', alphabet = 'Greek'            } -- greek capital letter pi
  , { code = 0x003A1,  char = 'Ρ',  class = 'var',       cs = 'Rho', alphabet = 'Greek'           } -- greek capital letter rho
  , { code = 0x003A3,  char = 'Σ',  class = 'var',       cs = 'Sigma', alphabet = 'Greek'         } -- greek capital letter sigma
  , { code = 0x003A4,  char = 'Τ',  class = 'var',       cs = 'Tau', alphabet = 'Greek'           } -- greek capital letter tau
  , { code = 0x003A5,  char = 'Υ',  class = 'var',       cs = 'Upsilon', alphabet = 'Greek'       } -- greek capital letter upsilon
  , { code = 0x003A6,  char = 'Φ',  class = 'var',       cs = 'Phi', alphabet = 'Greek'           } -- greek capital letter phi
  , { code = 0x003A7,  char = 'Χ',  class = 'var',       cs = 'Chi', alphabet = 'Greek'           } -- greek capital letter chi
  , { code = 0x003A8,  char = 'Ψ',  class = 'var',       cs = 'Psi', alphabet = 'Greek'           } -- greek capital letter psi
  , { code = 0x003A9,  char = 'Ω',  class = 'var',       cs = 'Omega', alphabet = 'Greek'         } -- greek capital letter omega
  , { code = 0x003B1,  char = 'α',  class = 'var',       cs = 'alpha', alphabet = 'greek'         } -- greek small letter alpha
  , { code = 0x003B2,  char = 'β',  class = 'var',       cs = 'beta', alphabet = 'greek'          } -- greek small letter beta
  , { code = 0x003B3,  char = 'γ',  class = 'var',       cs = 'gamma', alphabet = 'greek'         } -- greek small letter gamma
  , { code = 0x003B4,  char = 'δ',  class = 'var',       cs = 'delta', alphabet = 'greek'         } -- greek small letter delta
  , { code = 0x003B5,  char = 'ε',  class = 'var',       cs = 'epsilon', alphabet = 'greek'       } -- greek small letter epsilon
  , { code = 0x003B6,  char = 'ζ',  class = 'var',       cs = 'zeta', alphabet = 'greek'          } -- greek small letter zeta
  , { code = 0x003B7,  char = 'η',  class = 'var',       cs = 'eta', alphabet = 'greek'           } -- greek small letter eta
  , { code = 0x003B8,  char = 'θ',  class = 'var',       cs = 'theta', alphabet = 'greek'         } -- greek small letter theta
  , { code = 0x003B9,  char = 'ι',  class = 'var',       cs = 'iota', alphabet = 'greek'          } -- greek small letter iota
  , { code = 0x003BA,  char = 'κ',  class = 'var',       cs = 'kappa', alphabet = 'greek'         } -- greek small letter kappa
  , { code = 0x003BB,  char = 'λ',  class = 'var',       cs = 'lambda', alphabet = 'greek'        } -- greek small letter lamda
  , { code = 0x003BC,  char = 'μ',  class = 'var',       cs = 'mu', alphabet = 'greek'            } -- greek small letter mu
  , { code = 0x003BD,  char = 'ν',  class = 'var',       cs = 'nu', alphabet = 'greek'            } -- greek small letter nu
  , { code = 0x003BE,  char = 'ξ',  class = 'var',       cs = 'xi', alphabet = 'greek'            } -- greek small letter xi
  , { code = 0x003BF,  char = 'ο',  class = 'var',       cs = 'omicron', alphabet = 'greek'       } -- greek small letter omicron
  , { code = 0x003C0,  char = 'π',  class = 'var',       cs = 'pi', alphabet = 'greek'            } -- greek small letter pi
  , { code = 0x003C1,  char = 'ρ',  class = 'var',       cs = 'rho', alphabet = 'greek'           } -- greek small letter rho
  , { code = 0x003C2,  char = 'ς',  class = 'var',       cs = 'varsigma', alphabet = 'greek'      } -- greek small letter final sigma
  , { code = 0x003C3,  char = 'σ',  class = 'var',       cs = 'sigma', alphabet = 'greek'         } -- greek small letter sigma
  , { code = 0x003C4,  char = 'τ',  class = 'var',       cs = 'tau', alphabet = 'greek'           } -- greek small letter tau
  , { code = 0x003C5,  char = 'υ',  class = 'var',       cs = 'upsilon', alphabet = 'greek'       } -- greek small letter upsilon
  , { code = 0x003C6,  char = 'φ',  class = 'var',       cs = 'phi', alphabet = 'greek'           } -- greek small letter phi
  , { code = 0x003C7,  char = 'χ',  class = 'var',       cs = 'chi', alphabet = 'greek'           } -- greek small letter chi
  , { code = 0x003C8,  char = 'ψ',  class = 'var',       cs = 'psi', alphabet = 'greek'           } -- greek small letter psi
  , { code = 0x003C9,  char = 'ω',  class = 'var',       cs = 'omega', alphabet = 'greek'         } -- greek small letter omega
  , { code = 0x003D0,  char = 'ϐ',  class = 'ord',       cs = 'varbeta'                           } -- greek beta symbol
  , { code = 0x003D1,  char = 'ϑ',  class = 'var',       cs = 'vartheta', alphabet = 'greek'      } -- greek theta symbol
  , { code = 0x003D5,  char = 'ϕ',  class = 'var',       cs = 'varphi', alphabet = 'greek'        } -- greek phi symbol
  , { code = 0x003D6,  char = 'ϖ',  class = 'var',       cs = 'varpi', alphabet = 'greek'         } -- greek pi symbol
  , { code = 0x003D8,  char = 'Ϙ',  class = 'ord',       cs = 'oldKoppa'                          } -- greek letter archaic koppa
  , { code = 0x003D9,  char = 'ϙ',  class = 'ord',       cs = 'oldkoppa'                          } -- greek small letter archaic koppa
  , { code = 0x003DA,  char = 'Ϛ',  class = 'ord',       cs = 'Stigma'                            } -- greek letter stigma
  , { code = 0x003DB,  char = 'ϛ',  class = 'ord',       cs = 'stigma'                            } -- greek small letter stigma
  , { code = 0x003DC,  char = 'Ϝ',  class = 'ord',       cs = 'Digamma'                           } -- greek letter digamma
  , { code = 0x003DD,  char = 'ϝ',  class = 'ord',       cs = 'digamma'                           } -- greek small letter digamma
  , { code = 0x003DE,  char = 'Ϟ',  class = 'ord',       cs = 'Koppa'                             } -- greek letter koppa
  , { code = 0x003DF,  char = 'ϟ',  class = 'ord',       cs = 'koppa'                             } -- greek small letter koppa
  , { code = 0x003E0,  char = 'Ϡ',  class = 'ord',       cs = 'Sampi'                             } -- greek letter sampi
  , { code = 0x003E1,  char = 'ϡ',  class = 'ord',       cs = 'sampi'                             } -- greek small letter sampi
  , { code = 0x003F0,  char = 'ϰ',  class = 'var',       cs = 'varkappa', alphabet = 'greek'      } -- greek kappa symbol
  , { code = 0x003F1,  char = 'ϱ',  class = 'var',       cs = 'varrho', alphabet = 'greek'        } -- greek rho symbol
  , { code = 0x003F4,  char = 'ϴ',  class = 'var',       cs = 'varTheta', alphabet = 'Greek'      } -- greek capital theta symbol
  , { code = 0x003F5,  char = 'ϵ',  class = 'var',       cs = 'varepsilon', alphabet = 'greek'    } -- greek lunate epsilon symbol
  , { code = 0x003F6,  char = '϶',  class = 'ord',       cs = 'backepsilon'                       } -- greek reversed lunate epsilon symbol
  , { code = 0x02015,  char = '―',  class = 'ord',       cs = 'horizbar'                          } -- horizontal bar
  , { code = 0x02016,  char = '‖',  class = 'fence',     cs = 'Vert'                              } -- double vertical line
  , { code = 0x02017,  char = '‗',  class = 'ord',       cs = 'twolowline'                        } -- double low line
  , { code = 0x02020,  char = '†',  class = 'bin',       cs = 'dagger'                            } -- dagger
  , { code = 0x02021,  char = '‡',  class = 'bin',       cs = 'ddagger'                           } -- double dagger
  , { code = 0x02022,  char = '•',  class = 'bin',       cs = 'smblkcircle'                       } -- bullet
  , { code = 0x02025,  char = '‥',  class = 'ord',       cs = 'enleadertwodots'                   } -- two dot leader
  , { code = 0x02026,  char = '…',  class = 'ord',       cs = 'unicodeellipsis'                   } -- horizontal ellipsis
  , { code = 0x02032,  char = '′',  class = 'ord',       cs = 'prime'                             } -- prime
  , { code = 0x02033,  char = '″',  class = 'ord',       cs = 'dprime'                            } -- double prime
  , { code = 0x02034,  char = '‴',  class = 'ord',       cs = 'trprime'                           } -- triple prime
  , { code = 0x02035,  char = '‵',  class = 'ord',       cs = 'backprime'                         } -- reversed prime
  , { code = 0x02036,  char = '‶',  class = 'ord',       cs = 'backdprime'                        } -- reversed double prime
  , { code = 0x02037,  char = '‷',  class = 'ord',       cs = 'backtrprime'                       } -- reversed triple prime
  , { code = 0x02038,  char = '‸',  class = 'ord',       cs = 'caretinsert'                       } -- caret
  , { code = 0x0203C,  char = '‼',  class = 'ord',       cs = 'Exclam'                            } -- double exclamation mark
  , { code = 0x02040,  char = '⁀',  class = 'bin',       cs = 'tieconcat'                         } -- char acter tie
  , { code = 0x02043,  char = '⁃',  class = 'ord',       cs = 'hyphenbullet'                      } -- hyphen bullet
  , { code = 0x02044,  char = '⁄',  class = 'bin',       cs = 'fracslash'                         } -- fraction slash
  , { code = 0x02047,  char = '⁇',  class = 'ord',       cs = 'Question'                          } -- double question mark
  , { code = 0x02050,  char = '⁐',  class = 'rel',       cs = 'closure'                           } -- close up
  , { code = 0x02057,  char = '⁗',  class = 'ord',       cs = 'qprime'                            } -- quadruple prime
  , { code = 0x020AC,  char = '€',  class = 'ord',       cs = 'euro'                              } -- euro sign
  , { code = 0x020D0,  char = ' ⃐',  class = 'accent',    cs = 'leftharpoonaccent'                 } -- combining left harpoon above
  , { code = 0x020D1,  char = ' ⃑',  class = 'accent',    cs = 'rightharpoonaccent'                } -- combining right harpoon above
  , { code = 0x020D2,  char = ' ⃒',  class = 'overlay',   cs = 'vertoverlay'                       } -- combining long vertical line overlay
  , { code = 0x020D6,  char = ' ⃖',  class = 'accent',    cs = 'overleftarrow'                     } -- combining left arrow above
  , { code = 0x020D7,  char = ' ⃗',  class = 'accent',    cs = 'vec'                               } -- combining right arrow above
  , { code = 0x020DB,  char = ' ⃛',  class = 'accent',    cs = 'dddot'                             } -- combining three dots above
  , { code = 0x020DC,  char = ' ⃜',  class = 'accent',    cs = 'ddddot'                            } -- combining four dots above
  , { code = 0x020DD,  char = '⃝',   class = 'ord',       cs = 'enclosecircle'                     } -- combining enclosing circle
  , { code = 0x020DE,  char = '⃞',   class = 'ord',       cs = 'enclosesquare'                     } -- combining enclosing square
  , { code = 0x020DF,  char = '⃟',   class = 'ord',       cs = 'enclosediamond'                    } -- combining enclosing iamond
  , { code = 0x020E1,  char = ' ⃡',  class = 'accent',    cs = 'overleftrightarrow'                } -- combining left right arrow above
  , { code = 0x020E4,  char = '⃤',   class = 'ord',       cs = 'enclosetriangle'                   } -- combining enclosing upward pointing triangle
  , { code = 0x020E7,  char = ' ⃧',  class = 'accent',    cs = 'annuity'                           } -- combining annuity symbol
  , { code = 0x020E8,  char = ' ⃨',  class = 'botaccent', cs = 'threeunderdot'                     } -- combining triple underdot
  , { code = 0x020E9,  char = ' ⃩',  class = 'accent',    cs = 'widebridgeabove'                   } -- combining wide bridge above
  , { code = 0x020EC,  char = ' ⃬',  class = 'botaccent', cs = 'underrightharpoondown'             } -- combining rightwards harpoon with barb downwards
  , { code = 0x020ED,  char = ' ⃭',  class = 'botaccent', cs = 'underleftharpoondown'              } -- combining leftwards harpoon with barb downwards
  , { code = 0x020EE,  char = ' ⃮',  class = 'botaccent', cs = 'underleftarrow'                    } -- combining left arrow below
  , { code = 0x020EF,  char = ' ⃯',  class = 'botaccent', cs = 'underrightarrow'                   } -- combining right arrow below
  , { code = 0x020F0,  char = ' ⃰',  class = 'accent',    cs = 'asteraccent'                       } -- combining asterisk above
  , { code = 0x02102,  char = 'ℂ',  class = 'ord',       cs = 'BbbC', alphabet = 'blackboard'     } -- double-struck capital c
  , { code = 0x02107,  char = 'ℇ',  class = 'ord',       cs = 'Eulerconst'                        } -- euler constant
  , { code = 0x0210A,  char = 'ℊ',  class = 'ord',       cs = 'mscrg', alphabet = 'script'        } -- script small g
  , { code = 0x0210B,  char = 'ℋ',  class = 'ord',       cs = 'mscrH', alphabet = 'script'        } -- script capital h
  , { code = 0x0210C,  char = 'ℌ',  class = 'ord',       cs = 'mfrakH'                            } -- black-letter capital h
  , { code = 0x0210D,  char = 'ℍ',  class = 'ord',       cs = 'BbbH', alphabet = 'blackboard'     } -- double-struck capital h
  , { code = 0x0210E,  char = 'ℎ',  class = 'ord',       cs = 'mith'                              } -- planck constant
  , { code = 0x0210F,  char = 'ℏ',  class = 'ord',       cs = 'hbar'                              } -- planck constant over two pi
  , { code = 0x02110,  char = 'ℐ',  class = 'ord',       cs = 'mscrI', alphabet = 'script'        } -- script capital i
  , { code = 0x02111,  char = 'ℑ',  class = 'ord',       cs = 'Im'                                } -- black-letter capital i
  , { code = 0x02112,  char = 'ℒ',  class = 'ord',       cs = 'mscrL', alphabet = 'script'        } -- script capital l
  , { code = 0x02113,  char = 'ℓ',  class = 'ord',       cs = 'ell', alphabet = 'script'          } -- script small l
  , { code = 0x02115,  char = 'ℕ',  class = 'ord',       cs = 'BbbN', alphabet = 'blackboard'     } -- double-struck capital n
  , { code = 0x02118,  char = '℘',  class = 'ord',       cs = 'wp',                               } -- weierstrass elliptic function
  , { code = 0x02119,  char = 'ℙ',  class = 'ord',       cs = 'BbbP', alphabet = 'blackboard'     } -- double-struck capital p
  , { code = 0x0211A,  char = 'ℚ',  class = 'ord',       cs = 'BbbQ', alphabet = 'blackboard'     } -- double-struck capital q
  , { code = 0x0211B,  char = 'ℛ',  class = 'ord',       cs = 'mscrR', alphabet = 'script'        } -- script capital r
  , { code = 0x0211C,  char = 'ℜ',  class = 'ord',       cs = 'Re'                                } -- black-letter capital r
  , { code = 0x0211D,  char = 'ℝ',  class = 'ord',       cs = 'BbbR', alphabet = 'blackboard'     } -- double-struck capital r
  , { code = 0x02124,  char = 'ℤ',  class = 'ord',       cs = 'BbbZ', alphabet = 'blackboard'     } -- double-struck capital z
  , { code = 0x02127,  char = '℧',  class = 'ord',       cs = 'mho'                               } -- inverted ohm sign
  , { code = 0x02128,  char = 'ℨ',  class = 'ord',       cs = 'mfrakZ'                            } -- black-letter capital z
  , { code = 0x02129,  char = '℩',  class = 'ord',       cs = 'turnediota'                        } -- turned greek small letter iota
  , { code = 0x0212B,  char = 'Å',  class = 'ord',       cs = 'Angstrom'                          } -- angstrom sign
  , { code = 0x0212C,  char = 'ℬ',  class = 'ord',       cs = 'mscrB', alphabet = 'script'        } -- script capital b
  , { code = 0x0212D,  char = 'ℭ',  class = 'ord',       cs = 'mfrakC'                            } -- black-letter capital c
  , { code = 0x0212F,  char = 'ℯ',  class = 'ord',       cs = 'mscre', alphabet = 'script'        } -- script small e
  , { code = 0x02130,  char = 'ℰ',  class = 'ord',       cs = 'mscrE', alphabet = 'script'        } -- script capital e
  , { code = 0x02131,  char = 'ℱ',  class = 'ord',       cs = 'mscrF', alphabet = 'script'        } -- script capital f
  , { code = 0x02132,  char = 'Ⅎ',  class = 'ord',       cs = 'Finv'                              } -- turned capital f
  , { code = 0x02133,  char = 'ℳ',  class = 'ord',       cs = 'mscrM', alphabet = 'script'        } -- script capital m
  , { code = 0x02134,  char = 'ℴ',  class = 'ord',       cs = 'mscro', alphabet = 'script'        } -- script small o
  , { code = 0x02135,  char = 'ℵ',  class = 'ord',       cs = 'aleph'                             } -- alef symbol
  , { code = 0x02136,  char = 'ℶ',  class = 'ord',       cs = 'beth'                              } -- bet symbol
  , { code = 0x02137,  char = 'ℷ',  class = 'ord',       cs = 'gimel'                             } -- gimel symbol
  , { code = 0x02138,  char = 'ℸ',  class = 'ord',       cs = 'daleth'                            } -- dalet symbol
  , { code = 0x0213C,  char = 'ℼ',  class = 'ord',       cs = 'Bbbpi', alphabet = 'blackboard'    } -- double-struck small pi
  , { code = 0x0213D,  char = 'ℽ',  class = 'ord',       cs = 'Bbbgamma', alphabet = 'blackboard' } -- double-struck small gamma
  , { code = 0x0213E,  char = 'ℾ',  class = 'ord',       cs = 'BbbGamma', alphabet = 'blackboard' } -- double-struck capital gamma
  , { code = 0x0213F,  char = 'ℿ',  class = 'ord',       cs = 'BbbPi', alphabet = 'blackboard'    } -- double-struck capital pi
  , { code = 0x02140,  char = '⅀',  class = 'op',        cs = 'Bbbsum', alphabet = 'blackboard'   } -- double-struck n-ary summation
  , { code = 0x02141,  char = '⅁',  class = 'ord',       cs = 'Game'                              } -- turned sans-serif capital g
  , { code = 0x02142,  char = '⅂',  class = 'ord',       cs = 'sansLturned'                       } -- turned sans-serif capital l
  , { code = 0x02143,  char = '⅃',  class = 'ord',       cs = 'sansLmirrored'                     } -- reversed sans-serif capital l
  , { code = 0x02144,  char = '⅄',  class = 'ord',       cs = 'Yup'                               } -- turned sans-serif capital y
  , { code = 0x02145,  char = 'ⅅ',  class = 'ord',       cs = 'mitBbbD', alphabet = 'blackboard'  } -- double-struck italic capital d
  , { code = 0x02146,  char = 'ⅆ',  class = 'ord',       cs = 'mitBbbd', alphabet = 'blackboard'  } -- double-struck italic small d
  , { code = 0x02147,  char = 'ⅇ',  class = 'ord',       cs = 'mitBbbe', alphabet = 'blackboard'  } -- double-struck italic small e
  , { code = 0x02148,  char = 'ⅈ',  class = 'ord',       cs = 'mitBbbi', alphabet = 'blackboard'  } -- double-struck italic small i
  , { code = 0x02149,  char = 'ⅉ',  class = 'ord',       cs = 'mitBbbj', alphabet = 'blackboard'  } -- double-struck italic small j
  , { code = 0x0214A,  char = '⅊',  class = 'ord',       cs = 'PropertyLine'                      } -- property line
  , { code = 0x0214B,  char = '⅋',  class = 'bin',       cs = 'upand'                             } -- turned ampersand
  , { code = 0x02190,  char = '←',  class = 'rel',       cs = 'leftarrow'                         } -- leftwards arrow
  , { code = 0x02191,  char = '↑',  class = 'rel',       cs = 'uparrow'                           } -- upwards arrow
  , { code = 0x02192,  char = '→',  class = 'rel',       cs = 'rightarrow'                        } -- rightwards arrow
  , { code = 0x02193,  char = '↓',  class = 'rel',       cs = 'downarrow'                         } -- downwards arrow
  , { code = 0x02194,  char = '↔',  class = 'rel',       cs = 'leftrightarrow'                    } -- left right arrow
  , { code = 0x02195,  char = '↕',  class = 'rel',       cs = 'updownarrow'                       } -- up down arrow
  , { code = 0x02196,  char = '↖',  class = 'rel',       cs = 'nwarrow'                           } -- north west arrow
  , { code = 0x02197,  char = '↗',  class = 'rel',       cs = 'nearrow'                           } -- north east arrow
  , { code = 0x02198,  char = '↘',  class = 'rel',       cs = 'searrow'                           } -- south east arrow
  , { code = 0x02199,  char = '↙',  class = 'rel',       cs = 'swarrow'                           } -- south west arrow
  , { code = 0x0219A,  char = '↚',  class = 'rel',       cs = 'nleftarrow'                        } -- leftwards arrow with stroke
  , { code = 0x0219B,  char = '↛',  class = 'rel',       cs = 'nrightarrow'                       } -- rightwards arrow with stroke
  , { code = 0x0219C,  char = '↜',  class = 'rel',       cs = 'leftwavearrow'                     } -- leftwards wave arrow
  , { code = 0x0219D,  char = '↝',  class = 'rel',       cs = 'rightwavearrow'                    } -- rightwards wave arrow
  , { code = 0x0219E,  char = '↞',  class = 'rel',       cs = 'twoheadleftarrow'                  } -- leftwards two headed arrow
  , { code = 0x0219F,  char = '↟',  class = 'rel',       cs = 'twoheaduparrow'                    } -- upwards two headed arrow
  , { code = 0x021A0,  char = '↠',  class = 'rel',       cs = 'twoheadrightarrow'                 } -- rightwards two headed arrow
  , { code = 0x021A1,  char = '↡',  class = 'rel',       cs = 'twoheaddownarrow'                  } -- downwards two headed arrow
  , { code = 0x021A2,  char = '↢',  class = 'rel',       cs = 'leftarrowtail'                     } -- leftwards arrow with tail
  , { code = 0x021A3,  char = '↣',  class = 'rel',       cs = 'rightarrowtail'                    } -- rightwards arrow with tail
  , { code = 0x021A4,  char = '↤',  class = 'rel',       cs = 'mapsfrom'                          } -- leftwards arrow from bar
  , { code = 0x021A5,  char = '↥',  class = 'rel',       cs = 'mapsup'                            } -- upwards arrow from bar
  , { code = 0x021A6,  char = '↦',  class = 'rel',       cs = 'mapsto'                            } -- rightwards arrow from bar
  , { code = 0x021A7,  char = '↧',  class = 'rel',       cs = 'mapsdown'                          } -- downwards arrow from bar
  , { code = 0x021A8,  char = '↨',  class = 'ord',       cs = 'updownarrowbar'                    } -- up down arrow with base
  , { code = 0x021A9,  char = '↩',  class = 'rel',       cs = 'hookleftarrow'                     } -- leftwards arrow with hook
  , { code = 0x021AA,  char = '↪',  class = 'rel',       cs = 'hookrightarrow'                    } -- rightwards arrow with hook
  , { code = 0x021AB,  char = '↫',  class = 'rel',       cs = 'looparrowleft'                     } -- leftwards arrow with loop
  , { code = 0x021AC,  char = '↬',  class = 'rel',       cs = 'looparrowright'                    } -- rightwards arrow with loop
  , { code = 0x021AD,  char = '↭',  class = 'rel',       cs = 'leftrightsquigarrow'               } -- left right wave arrow
  , { code = 0x021AE,  char = '↮',  class = 'rel',       cs = 'nleftrightarrow'                   } -- left right arrow with stroke
  , { code = 0x021AF,  char = '↯',  class = 'rel',       cs = 'downzigzagarrow'                   } -- downwards zigzag arrow
  , { code = 0x021B0,  char = '↰',  class = 'rel',       cs = 'Lsh'                               } -- upwards arrow with tip leftwards
  , { code = 0x021B1,  char = '↱',  class = 'rel',       cs = 'Rsh'                               } -- upwards arrow with tip rightwards
  , { code = 0x021B2,  char = '↲',  class = 'rel',       cs = 'Ldsh'                              } -- downwards arrow with tip leftwards
  , { code = 0x021B3,  char = '↳',  class = 'rel',       cs = 'Rdsh'                              } -- downwards arrow with tip rightwards
  , { code = 0x021B4,  char = '↴',  class = 'ord',       cs = 'linefeed'                          } -- rightwards arrow with corner downwards
  , { code = 0x021B5,  char = '↵',  class = 'ord',       cs = 'carriagereturn'                    } -- downwards arrow with corner leftwards
  , { code = 0x021B6,  char = '↶',  class = 'rel',       cs = 'curvearrowleft'                    } -- anticlockwise top semicircle arrow
  , { code = 0x021B7,  char = '↷',  class = 'rel',       cs = 'curvearrowright'                   } -- clockwise top semicircle arrow
  , { code = 0x021B8,  char = '↸',  class = 'ord',       cs = 'barovernorthwestarrow'             } -- north west arrow to long bar
  , { code = 0x021B9,  char = '↹',  class = 'ord',       cs = 'barleftarrowrightarrowbar'         } -- leftwards arrow to bar over rightwards arrow to bar
  , { code = 0x021BA,  char = '↺',  class = 'ord',       cs = 'acwopencirclearrow'                } -- anticlockwise open circle arrow
  , { code = 0x021BB,  char = '↻',  class = 'ord',       cs = 'cwopencirclearrow'                 } -- clockwise open circle arrow
  , { code = 0x021BC,  char = '↼',  class = 'rel',       cs = 'leftharpoonup'                     } -- leftwards harpoon with barb upwards
  , { code = 0x021BD,  char = '↽',  class = 'rel',       cs = 'leftharpoondown'                   } -- leftwards harpoon with barb downwards
  , { code = 0x021BE,  char = '↾',  class = 'rel',       cs = 'upharpoonright'                    } -- upwards harpoon with barb rightwards
  , { code = 0x021BF,  char = '↿',  class = 'rel',       cs = 'upharpoonleft'                     } -- upwards harpoon with barb leftwards
  , { code = 0x021C0,  char = '⇀',  class = 'rel',       cs = 'rightharpoonup'                    } -- rightwards harpoon with barb upwards
  , { code = 0x021C1,  char = '⇁',  class = 'rel',       cs = 'rightharpoondown'                  } -- rightwards harpoon with barb downwards
  , { code = 0x021C2,  char = '⇂',  class = 'rel',       cs = 'downharpoonright'                  } -- downwards harpoon with barb rightwards
  , { code = 0x021C3,  char = '⇃',  class = 'rel',       cs = 'downharpoonleft'                   } -- downwards harpoon with barb leftwards
  , { code = 0x021C4,  char = '⇄',  class = 'rel',       cs = 'rightleftarrows'                   } -- rightwards arrow over leftwards arrow
  , { code = 0x021C5,  char = '⇅',  class = 'rel',       cs = 'updownarrows'                      } -- upwards arrow leftwards of downwards arrow
  , { code = 0x021C6,  char = '⇆',  class = 'rel',       cs = 'leftrightarrows'                   } -- leftwards arrow over rightwards arrow
  , { code = 0x021C7,  char = '⇇',  class = 'rel',       cs = 'leftleftarrows'                    } -- leftwards paired arrows
  , { code = 0x021C8,  char = '⇈',  class = 'rel',       cs = 'upuparrows'                        } -- upwards paired arrows
  , { code = 0x021C9,  char = '⇉',  class = 'rel',       cs = 'rightrightarrows'                  } -- rightwards paired arrows
  , { code = 0x021CA,  char = '⇊',  class = 'rel',       cs = 'downdownarrows'                    } -- downwards paired arrows
  , { code = 0x021CB,  char = '⇋',  class = 'rel',       cs = 'leftrightharpoons'                 } -- leftwards harpoon over rightwards harpoon
  , { code = 0x021CC,  char = '⇌',  class = 'rel',       cs = 'rightleftharpoons'                 } -- rightwards harpoon over leftwards harpoon
  , { code = 0x021CD,  char = '⇍',  class = 'rel',       cs = 'nLeftarrow'                        } -- leftwards double arrow with stroke
  , { code = 0x021CE,  char = '⇎',  class = 'rel',       cs = 'nLeftrightarrow'                   } -- left right double arrow with stroke
  , { code = 0x021CF,  char = '⇏',  class = 'rel',       cs = 'nRightarrow'                       } -- rightwards double arrow with stroke
  , { code = 0x021D0,  char = '⇐',  class = 'rel',       cs = 'Leftarrow'                         } -- leftwards double arrow
  , { code = 0x021D1,  char = '⇑',  class = 'rel',       cs = 'Uparrow'                           } -- upwards double arrow
  , { code = 0x021D2,  char = '⇒',  class = 'rel',       cs = 'Rightarrow'                        } -- rightwards double arrow
  , { code = 0x021D3,  char = '⇓',  class = 'rel',       cs = 'Downarrow'                         } -- downwards double arrow
  , { code = 0x021D4,  char = '⇔',  class = 'rel',       cs = 'Leftrightarrow'                    } -- left right double arrow
  , { code = 0x021D5,  char = '⇕',  class = 'rel',       cs = 'Updownarrow'                       } -- up down double arrow
  , { code = 0x021D6,  char = '⇖',  class = 'rel',       cs = 'Nwarrow'                           } -- north west double arrow
  , { code = 0x021D7,  char = '⇗',  class = 'rel',       cs = 'Nearrow'                           } -- north east double arrow
  , { code = 0x021D8,  char = '⇘',  class = 'rel',       cs = 'Searrow'                           } -- south east double arrow
  , { code = 0x021D9,  char = '⇙',  class = 'rel',       cs = 'Swarrow'                           } -- south west double arrow
  , { code = 0x021DA,  char = '⇚',  class = 'rel',       cs = 'Lleftarrow'                        } -- leftwards triple arrow
  , { code = 0x021DB,  char = '⇛',  class = 'rel',       cs = 'Rrightarrow'                       } -- rightwards triple arrow
  , { code = 0x021DC,  char = '⇜',  class = 'rel',       cs = 'leftsquigarrow'                    } -- leftwards squiggle arrow
  , { code = 0x021DD,  char = '⇝',  class = 'rel',       cs = 'rightsquigarrow'                   } -- rightwards squiggle arrow
  , { code = 0x021DE,  char = '⇞',  class = 'ord',       cs = 'nHuparrow'                         } -- upwards arrow with double stroke
  , { code = 0x021DF,  char = '⇟',  class = 'ord',       cs = 'nHdownarrow'                       } -- downwards arrow with double stroke
  , { code = 0x021E0,  char = '⇠',  class = 'ord',       cs = 'leftdasharrow'                     } -- leftwards dashed arrow
  , { code = 0x021E1,  char = '⇡',  class = 'ord',       cs = 'updasharrow'                       } -- upwards dashed arrow
  , { code = 0x021E2,  char = '⇢',  class = 'ord',       cs = 'rightdasharrow'                    } -- rightwards dashed arrow
  , { code = 0x021E3,  char = '⇣',  class = 'ord',       cs = 'downdasharrow'                     } -- downwards dashed arrow
  , { code = 0x021E4,  char = '⇤',  class = 'rel',       cs = 'barleftarrow'                      } -- leftwards arrow to bar
  , { code = 0x021E5,  char = '⇥',  class = 'rel',       cs = 'rightarrowbar'                     } -- rightwards arrow to bar
  , { code = 0x021E6,  char = '⇦',  class = 'ord',       cs = 'leftwhitearrow'                    } -- leftwards white arrow
  , { code = 0x021E7,  char = '⇧',  class = 'ord',       cs = 'upwhitearrow'                      } -- upwards white arrow
  , { code = 0x021E8,  char = '⇨',  class = 'ord',       cs = 'rightwhitearrow'                   } -- rightwards white arrow
  , { code = 0x021E9,  char = '⇩',  class = 'ord',       cs = 'downwhitearrow'                    } -- downwards white arrow
  , { code = 0x021EA,  char = '⇪',  class = 'ord',       cs = 'whitearrowupfrombar'               } -- upwards white arrow from bar
  , { code = 0x021F4,  char = '⇴',  class = 'rel',       cs = 'circleonrightarrow'                } -- right arrow with small circle
  , { code = 0x021F5,  char = '⇵',  class = 'rel',       cs = 'downuparrows'                      } -- downwards arrow leftwards of upwards arrow
  , { code = 0x021F6,  char = '⇶',  class = 'rel',       cs = 'rightthreearrows'                  } -- three rightwards arrows
  , { code = 0x021F7,  char = '⇷',  class = 'rel',       cs = 'nvleftarrow'                       } -- leftwards arrow with vertical stroke
  , { code = 0x021F8,  char = '⇸',  class = 'rel',       cs = 'nvrightarrow'                      } -- rightwards arrow with vertical stroke
  , { code = 0x021F9,  char = '⇹',  class = 'rel',       cs = 'nvleftrightarrow'                  } -- left right arrow with vertical stroke
  , { code = 0x021FA,  char = '⇺',  class = 'rel',       cs = 'nVleftarrow'                       } -- leftwards arrow with double vertical stroke
  , { code = 0x021FB,  char = '⇻',  class = 'rel',       cs = 'nVrightarrow'                      } -- rightwards arrow with double vertical stroke
  , { code = 0x021FC,  char = '⇼',  class = 'rel',       cs = 'nVleftrightarrow'                  } -- left right arrow with double vertical stroke
  , { code = 0x021FD,  char = '⇽',  class = 'rel',       cs = 'leftarrowtriangle'                 } -- leftwards open-headed arrow
  , { code = 0x021FE,  char = '⇾',  class = 'rel',       cs = 'rightarrowtriangle'                } -- rightwards open-headed arrow
  , { code = 0x021FF,  char = '⇿',  class = 'rel',       cs = 'leftrightarrowtriangle'            } -- left right open-headed arrow
  , { code = 0x02200,  char = '∀',  class = 'ord',       cs = 'forall'                            } -- for all
  , { code = 0x02201,  char = '∁',  class = 'ord',       cs = 'complement'                        } -- complement
  , { code = 0x02202,  char = '∂',  class = 'var',       cs = 'partial'                           } -- partial differential
  , { code = 0x02203,  char = '∃',  class = 'ord',       cs = 'exists'                            } -- there exists
  , { code = 0x02204,  char = '∄',  class = 'ord',       cs = 'nexists'                           } -- there does not exist
  , { code = 0x02205,  char = '∅',  class = 'ord',       cs = 'varnothing'                        } -- empty set
  , { code = 0x02206,  char = '∆',  class = 'ord',       cs = 'increment'                         } -- increment
  , { code = 0x02207,  char = '∇',  class = 'var',       cs = 'nabla'                             } -- nabla
  , { code = 0x02208,  char = '∈',  class = 'rel',       cs = 'in'                                } -- element of
  , { code = 0x02209,  char = '∉',  class = 'rel',       cs = 'notin'                             } -- not an element of
  , { code = 0x0220A,  char = '∊',  class = 'rel',       cs = 'smallin'                           } -- small element of
  , { code = 0x0220B,  char = '∋',  class = 'rel',       cs = 'ni'                                } -- contains as member
  , { code = 0x0220C,  char = '∌',  class = 'rel',       cs = 'nni'                               } -- does not contain as member
  , { code = 0x0220D,  char = '∍',  class = 'rel',       cs = 'smallni'                           } -- small contains as member
  , { code = 0x0220E,  char = '∎',  class = 'ord',       cs = 'QED'                               } -- end of proof
  , { code = 0x0220F,  char = '∏',  class = 'op',        cs = 'prod'                              } -- n-ary product
  , { code = 0x02210,  char = '∐',  class = 'op',        cs = 'coprod'                            } -- n-ary coproduct
  , { code = 0x02211,  char = '∑',  class = 'op',        cs = 'sum'                               } -- n-ary summation
  , { code = 0x02212,  char = '−',  class = 'bin',       cs = 'minus'                             } -- minus sign
  , { code = 0x02213,  char = '∓',  class = 'bin',       cs = 'mp'                                } -- minus-or-plus sign
  , { code = 0x02214,  char = '∔',  class = 'bin',       cs = 'dotplus'                           } -- dot plus
  , { code = 0x02215,  char = '∕',  class = 'bin',       cs = 'divslash'                          } -- division slash
  , { code = 0x02216,  char = '∖',  class = 'bin',       cs = 'smallsetminus'                     } -- set minus
  , { code = 0x02217,  char = '∗',  class = 'bin',       cs = 'ast'                               } -- asterisk operator
  , { code = 0x02218,  char = '∘',  class = 'bin',       cs = 'vysmwhtcircle'                     } -- ring operator
  , { code = 0x02219,  char = '∙',  class = 'bin',       cs = 'vysmblkcircle'                     } -- bullet operator
  , { code = 0x0221A,  char = '√',  class = 'radical',   cs = 'sqrt'                              } -- square root
  , { code = 0x0221B,  char = '∛',  class = 'radical',   cs = 'cuberoot'                          } -- cube root
  , { code = 0x0221C,  char = '∜',  class = 'radical',   cs = 'fourthroot'                        } -- fourth root
  , { code = 0x0221D,  char = '∝',  class = 'rel',       cs = 'propto'                            } -- proportional to
  , { code = 0x0221E,  char = '∞',  class = 'ord',       cs = 'infty'                             } -- infinity
  , { code = 0x0221F,  char = '∟',  class = 'ord',       cs = 'rightangle'                        } -- right angle
  , { code = 0x02220,  char = '∠',  class = 'ord',       cs = 'angle'                             } -- angle
  , { code = 0x02221,  char = '∡',  class = 'ord',       cs = 'measuredangle'                     } -- measured angle
  , { code = 0x02222,  char = '∢',  class = 'ord',       cs = 'sphericalangle'                    } -- spherical angle
  , { code = 0x02223,  char = '∣',  class = 'rel',       cs = 'mid'                               } -- divides
  , { code = 0x02224,  char = '∤',  class = 'rel',       cs = 'nmid'                              } -- does not divide
  , { code = 0x02225,  char = '∥',  class = 'rel',       cs = 'parallel'                          } -- parallel to
  , { code = 0x02226,  char = '∦',  class = 'rel',       cs = 'nparallel'                         } -- not parallel to
  , { code = 0x02227,  char = '∧',  class = 'bin',       cs = 'wedge'                             } -- logical and
  , { code = 0x02228,  char = '∨',  class = 'bin',       cs = 'vee'                               } -- logical or
  , { code = 0x02229,  char = '∩',  class = 'bin',       cs = 'cap'                               } -- intersection
  , { code = 0x0222A,  char = '∪',  class = 'bin',       cs = 'cup'                               } -- union
  , { code = 0x0222B,  char = '∫',  class = 'op',        cs = 'intop'                             } -- integral
  , { code = 0x0222C,  char = '∬',  class = 'op',        cs = 'iintop'                            } -- double integral
  , { code = 0x0222D,  char = '∭',  class = 'op',        cs = 'iiintop'                           } -- triple integral
  , { code = 0x0222E,  char = '∮',  class = 'op',        cs = 'ointop'                            } -- contour integral
  , { code = 0x0222F,  char = '∯',  class = 'op',        cs = 'oiintop'                           } -- surface integral
  , { code = 0x02230,  char = '∰',  class = 'op',        cs = 'oiiintop'                          } -- volume integral
  , { code = 0x02231,  char = '∱',  class = 'op',        cs = 'intclockwiseop'                    } -- clockwise integral
  , { code = 0x02232,  char = '∲',  class = 'op',        cs = 'varointclockwiseop'                } -- clockwise contour integral
  , { code = 0x02233,  char = '∳',  class = 'op',        cs = 'ointctrclockwiseop'                } -- anticlockwise contour integral
  , { code = 0x02234,  char = '∴',  class = 'ord',       cs = 'therefore'                         } -- therefore
  , { code = 0x02235,  char = '∵',  class = 'ord',       cs = 'because'                           } -- because
  , { code = 0x02236,  char = '∶',  class = 'rel',       cs = 'ratio'                             } -- ratio
  , { code = 0x02237,  char = '∷',  class = 'rel',       cs = 'Colon'                             } -- proportion
  , { code = 0x02238,  char = '∸',  class = 'bin',       cs = 'dotminus'                          } -- dot minus
  , { code = 0x02239,  char = '∹',  class = 'rel',       cs = 'dashcolon'                         } -- excess
  , { code = 0x0223A,  char = '∺',  class = 'rel',       cs = 'dotsminusdots'                     } -- geometric proportion
  , { code = 0x0223B,  char = '∻',  class = 'rel',       cs = 'kernelcontraction'                 } -- homothetic
  , { code = 0x0223C,  char = '∼',  class = 'rel',       cs = 'sim'                               } -- tilde operator
  , { code = 0x0223D,  char = '∽',  class = 'rel',       cs = 'backsim'                           } -- reversed tilde
  , { code = 0x0223E,  char = '∾',  class = 'bin',       cs = 'invlazys'                          } -- inverted lazy s
  , { code = 0x0223F,  char = '∿',  class = 'ord',       cs = 'sinewave'                          } -- sine wave
  , { code = 0x02240,  char = '≀',  class = 'bin',       cs = 'wr'                                } -- wreath product
  , { code = 0x02241,  char = '≁',  class = 'rel',       cs = 'nsim'                              } -- not tilde
  , { code = 0x02242,  char = '≂',  class = 'rel',       cs = 'eqsim'                             } -- minus tilde
  , { code = 0x02243,  char = '≃',  class = 'rel',       cs = 'simeq'                             } -- asymptotically equal to
  , { code = 0x02244,  char = '≄',  class = 'rel',       cs = 'nsimeq'                            } -- not asymptotically equal to
  , { code = 0x02245,  char = '≅',  class = 'rel',       cs = 'cong'                              } -- approximately equal to
  , { code = 0x02246,  char = '≆',  class = 'rel',       cs = 'simneqq'                           } -- approximately but not actually equal to
  , { code = 0x02247,  char = '≇',  class = 'rel',       cs = 'ncong'                             } -- neither approximately nor actually equal to
  , { code = 0x02248,  char = '≈',  class = 'rel',       cs = 'approx'                            } -- almost equal to
  , { code = 0x02249,  char = '≉',  class = 'rel',       cs = 'napprox'                           } -- not almost equal to
  , { code = 0x0224A,  char = '≊',  class = 'rel',       cs = 'approxeq'                          } -- almost equal or equal to
  , { code = 0x0224B,  char = '≋',  class = 'rel',       cs = 'approxident'                       } -- triple tilde
  , { code = 0x0224C,  char = '≌',  class = 'rel',       cs = 'backcong'                          } -- all equal to
  , { code = 0x0224D,  char = '≍',  class = 'rel',       cs = 'asymp'                             } -- equivalent to
  , { code = 0x0224E,  char = '≎',  class = 'rel',       cs = 'Bumpeq'                            } -- geometrically equivalent to
  , { code = 0x0224F,  char = '≏',  class = 'rel',       cs = 'bumpeq'                            } -- difference between
  , { code = 0x02250,  char = '≐',  class = 'rel',       cs = 'doteq'                             } -- approaches the limit
  , { code = 0x02251,  char = '≑',  class = 'rel',       cs = 'Doteq'                             } -- geometrically equal to
  , { code = 0x02252,  char = '≒',  class = 'rel',       cs = 'fallingdotseq'                     } -- approximately equal to or the image of
  , { code = 0x02253,  char = '≓',  class = 'rel',       cs = 'risingdotseq'                      } -- image of or approximately equal to
  , { code = 0x02254,  char = '≔',  class = 'rel',       cs = 'coloneq'                           } -- colon equals
  , { code = 0x02255,  char = '≕',  class = 'rel',       cs = 'eqcolon'                           } -- equals colon
  , { code = 0x02256,  char = '≖',  class = 'rel',       cs = 'eqcirc'                            } -- ring in equal to
  , { code = 0x02257,  char = '≗',  class = 'rel',       cs = 'circeq'                            } -- ring equal to
  , { code = 0x02258,  char = '≘',  class = 'rel',       cs = 'arceq'                             } -- corresponds to
  , { code = 0x02259,  char = '≙',  class = 'rel',       cs = 'wedgeq'                            } -- estimates
  , { code = 0x0225A,  char = '≚',  class = 'rel',       cs = 'veeeq'                             } -- equiangular to
  , { code = 0x0225B,  char = '≛',  class = 'rel',       cs = 'stareq'                            } -- star equals
  , { code = 0x0225C,  char = '≜',  class = 'rel',       cs = 'triangleq'                         } -- delta equal to
  , { code = 0x0225D,  char = '≝',  class = 'rel',       cs = 'eqdef'                             } -- equal to by definition
  , { code = 0x0225E,  char = '≞',  class = 'rel',       cs = 'measeq'                            } -- measured by
  , { code = 0x0225F,  char = '≟',  class = 'rel',       cs = 'questeq'                           } -- questioned equal to
  , { code = 0x02260,  char = '≠',  class = 'rel',       cs = 'ne'                                } -- not equal to
  , { code = 0x02261,  char = '≡',  class = 'rel',       cs = 'equiv'                             } -- identical to
  , { code = 0x02262,  char = '≢',  class = 'rel',       cs = 'nequiv'                            } -- not identical to
  , { code = 0x02263,  char = '≣',  class = 'rel',       cs = 'Equiv'                             } -- strictly equivalent to
  , { code = 0x02264,  char = '≤',  class = 'rel',       cs = 'leq'                               } -- less-than or equal to
  , { code = 0x02265,  char = '≥',  class = 'rel',       cs = 'geq'                               } -- greater-than or equal to
  , { code = 0x02266,  char = '≦',  class = 'rel',       cs = 'leqq'                              } -- less-than over equal to
  , { code = 0x02267,  char = '≧',  class = 'rel',       cs = 'geqq'                              } -- greater-than over equal to
  , { code = 0x02268,  char = '≨',  class = 'rel',       cs = 'lneqq'                             } -- less-than but not equal to
  , { code = 0x02269,  char = '≩',  class = 'rel',       cs = 'gneqq'                             } -- greater-than but not equal to
  , { code = 0x0226A,  char = '≪',  class = 'rel',       cs = 'll'                                } -- much less-than
  , { code = 0x0226B,  char = '≫',  class = 'rel',       cs = 'gg'                                } -- much greater-than
  , { code = 0x0226C,  char = '≬',  class = 'rel',       cs = 'between'                           } -- between
  , { code = 0x0226D,  char = '≭',  class = 'rel',       cs = 'nasymp'                            } -- not equivalent to
  , { code = 0x0226E,  char = '≮',  class = 'rel',       cs = 'nless'                             } -- not less-than
  , { code = 0x0226F,  char = '≯',  class = 'rel',       cs = 'ngtr'                              } -- not greater-than
  , { code = 0x02270,  char = '≰',  class = 'rel',       cs = 'nleq'                              } -- neither less-than nor equal to
  , { code = 0x02271,  char = '≱',  class = 'rel',       cs = 'ngeq'                              } -- neither greater-than nor equal to
  , { code = 0x02272,  char = '≲',  class = 'rel',       cs = 'lesssim'                           } -- less-than or equivalent to
  , { code = 0x02273,  char = '≳',  class = 'rel',       cs = 'gtrsim'                            } -- greater-than or equivalent to
  , { code = 0x02274,  char = '≴',  class = 'rel',       cs = 'nlesssim'                          } -- neither less-than nor equivalent to
  , { code = 0x02275,  char = '≵',  class = 'rel',       cs = 'ngtrsim'                           } -- neither greater-than nor equivalent to
  , { code = 0x02276,  char = '≶',  class = 'rel',       cs = 'lessgtr'                           } -- less-than or greater-than
  , { code = 0x02277,  char = '≷',  class = 'rel',       cs = 'gtrless'                           } -- greater-than or less-than
  , { code = 0x02278,  char = '≸',  class = 'rel',       cs = 'nlessgtr'                          } -- neither less-than nor greater-than
  , { code = 0x02279,  char = '≹',  class = 'rel',       cs = 'ngtrless'                          } -- neither greater-than nor less-than
  , { code = 0x0227A,  char = '≺',  class = 'rel',       cs = 'prec'                              } -- precedes
  , { code = 0x0227B,  char = '≻',  class = 'rel',       cs = 'succ'                              } -- succeeds
  , { code = 0x0227C,  char = '≼',  class = 'rel',       cs = 'preccurlyeq'                       } -- precedes or equal to
  , { code = 0x0227D,  char = '≽',  class = 'rel',       cs = 'succcurlyeq'                       } -- succeeds or equal to
  , { code = 0x0227E,  char = '≾',  class = 'rel',       cs = 'precsim'                           } -- precedes or equivalent to
  , { code = 0x0227F,  char = '≿',  class = 'rel',       cs = 'succsim'                           } -- succeeds or equivalent to
  , { code = 0x02280,  char = '⊀',  class = 'rel',       cs = 'nprec'                             } -- does not precede
  , { code = 0x02281,  char = '⊁',  class = 'rel',       cs = 'nsucc'                             } -- does not succeed
  , { code = 0x02282,  char = '⊂',  class = 'rel',       cs = 'subset'                            } -- subset of
  , { code = 0x02283,  char = '⊃',  class = 'rel',       cs = 'supset'                            } -- superset of
  , { code = 0x02284,  char = '⊄',  class = 'rel',       cs = 'nsubset'                           } -- not a subset of
  , { code = 0x02285,  char = '⊅',  class = 'rel',       cs = 'nsupset'                           } -- not a superset of
  , { code = 0x02286,  char = '⊆',  class = 'rel',       cs = 'subseteq'                          } -- subset of or equal to
  , { code = 0x02287,  char = '⊇',  class = 'rel',       cs = 'supseteq'                          } -- superset of or equal to
  , { code = 0x02288,  char = '⊈',  class = 'rel',       cs = 'nsubseteq'                         } -- neither a subset of nor equal to
  , { code = 0x02289,  char = '⊉',  class = 'rel',       cs = 'nsupseteq'                         } -- neither a superset of nor equal to
  , { code = 0x0228A,  char = '⊊',  class = 'rel',       cs = 'subsetneq'                         } -- subset of with not equal to
  , { code = 0x0228B,  char = '⊋',  class = 'rel',       cs = 'supsetneq'                         } -- superset of with not equal to
  , { code = 0x0228C,  char = '⊌',  class = 'bin',       cs = 'cupleftarrow'                      } -- multiset
  , { code = 0x0228D,  char = '⊍',  class = 'bin',       cs = 'cupdot'                            } -- multiset multiplication
  , { code = 0x0228E,  char = '⊎',  class = 'bin',       cs = 'uplus'                             } -- multiset union
  , { code = 0x0228F,  char = '⊏',  class = 'rel',       cs = 'sqsubset'                          } -- square image of
  , { code = 0x02290,  char = '⊐',  class = 'rel',       cs = 'sqsupset'                          } -- square original of
  , { code = 0x02291,  char = '⊑',  class = 'rel',       cs = 'sqsubseteq'                        } -- square image of or equal to
  , { code = 0x02292,  char = '⊒',  class = 'rel',       cs = 'sqsupseteq'                        } -- square original of or equal to
  , { code = 0x02293,  char = '⊓',  class = 'bin',       cs = 'sqcap'                             } -- square cap
  , { code = 0x02294,  char = '⊔',  class = 'bin',       cs = 'sqcup'                             } -- square cup
  , { code = 0x02295,  char = '⊕',  class = 'bin',       cs = 'oplus'                             } -- circled plus
  , { code = 0x02296,  char = '⊖',  class = 'bin',       cs = 'ominus'                            } -- circled minus
  , { code = 0x02297,  char = '⊗',  class = 'bin',       cs = 'otimes'                            } -- circled times
  , { code = 0x02298,  char = '⊘',  class = 'bin',       cs = 'oslash'                            } -- circled division slash
  , { code = 0x02299,  char = '⊙',  class = 'bin',       cs = 'odot'                              } -- circled dot operator
  , { code = 0x0229A,  char = '⊚',  class = 'bin',       cs = 'circledcirc'                       } -- circled ring operator
  , { code = 0x0229B,  char = '⊛',  class = 'bin',       cs = 'circledast'                        } -- circled asterisk operator
  , { code = 0x0229C,  char = '⊜',  class = 'bin',       cs = 'circledequal'                      } -- circled equals
  , { code = 0x0229D,  char = '⊝',  class = 'bin',       cs = 'circleddash'                       } -- circled dash
  , { code = 0x0229E,  char = '⊞',  class = 'bin',       cs = 'boxplus'                           } -- squared plus
  , { code = 0x0229F,  char = '⊟',  class = 'bin',       cs = 'boxminus'                          } -- squared minus
  , { code = 0x022A0,  char = '⊠',  class = 'bin',       cs = 'boxtimes'                          } -- squared times
  , { code = 0x022A1,  char = '⊡',  class = 'bin',       cs = 'boxdot'                            } -- squared dot operator
  , { code = 0x022A2,  char = '⊢',  class = 'rel',       cs = 'vdash'                             } -- right tack
  , { code = 0x022A3,  char = '⊣',  class = 'rel',       cs = 'dashv'                             } -- left tack
  , { code = 0x022A4,  char = '⊤',  class = 'ord',       cs = 'top'                               } -- down tack
  , { code = 0x022A5,  char = '⊥',  class = 'ord',       cs = 'bot'                               } -- up tack
  , { code = 0x022A6,  char = '⊦',  class = 'rel',       cs = 'assert'                            } -- assertion
  , { code = 0x022A7,  char = '⊧',  class = 'rel',       cs = 'models'                            } -- models
  , { code = 0x022A8,  char = '⊨',  class = 'rel',       cs = 'vDash'                             } -- true
  , { code = 0x022A9,  char = '⊩',  class = 'rel',       cs = 'Vdash'                             } -- forces
  , { code = 0x022AA,  char = '⊪',  class = 'rel',       cs = 'Vvdash'                            } -- triple vertical bar right turnstile
  , { code = 0x022AB,  char = '⊫',  class = 'rel',       cs = 'VDash'                             } -- double vertical bar double right turnstile
  , { code = 0x022AC,  char = '⊬',  class = 'rel',       cs = 'nvdash'                            } -- does not prove
  , { code = 0x022AD,  char = '⊭',  class = 'rel',       cs = 'nvDash'                            } -- not true
  , { code = 0x022AE,  char = '⊮',  class = 'rel',       cs = 'nVdash'                            } -- does not force
  , { code = 0x022AF,  char = '⊯',  class = 'rel',       cs = 'nVDash'                            } -- negated double vertical bar double right turnstile
  , { code = 0x022B0,  char = '⊰',  class = 'rel',       cs = 'prurel'                            } -- precedes under relation
  , { code = 0x022B1,  char = '⊱',  class = 'rel',       cs = 'scurel'                            } -- succeeds under relation
  , { code = 0x022B2,  char = '⊲',  class = 'rel',       cs = 'vartriangleleft'                   } -- normal subgroup of
  , { code = 0x022B3,  char = '⊳',  class = 'rel',       cs = 'vartriangleright'                  } -- contains as normal subgroup
  , { code = 0x022B4,  char = '⊴',  class = 'rel',       cs = 'trianglelefteq'                    } -- normal subgroup of or equal to
  , { code = 0x022B5,  char = '⊵',  class = 'rel',       cs = 'trianglerighteq'                   } -- contains as normal subgroup or equal to
  , { code = 0x022B6,  char = '⊶',  class = 'rel',       cs = 'origof'                            } -- original of
  , { code = 0x022B7,  char = '⊷',  class = 'rel',       cs = 'imageof'                           } -- image of
  , { code = 0x022B8,  char = '⊸',  class = 'rel',       cs = 'multimap'                          } -- multimap
  , { code = 0x022B9,  char = '⊹',  class = 'ord',       cs = 'hermitmatrix'                      } -- hermitian conjugate matrix
  , { code = 0x022BA,  char = '⊺',  class = 'bin',       cs = 'intercal'                          } -- intercalate
  , { code = 0x022BB,  char = '⊻',  class = 'bin',       cs = 'veebar'                            } -- xor
  , { code = 0x022BC,  char = '⊼',  class = 'bin',       cs = 'barwedge'                          } -- nand
  , { code = 0x022BD,  char = '⊽',  class = 'bin',       cs = 'barvee'                            } -- nor
  , { code = 0x022BE,  char = '⊾',  class = 'ord',       cs = 'measuredrightangle'                } -- right angle with arc
  , { code = 0x022BF,  char = '⊿',  class = 'ord',       cs = 'varlrtriangle'                     } -- right triangle
  , { code = 0x022C0,  char = '⋀',  class = 'op',        cs = 'bigwedge'                          } -- n-ary logical and
  , { code = 0x022C1,  char = '⋁',  class = 'op',        cs = 'bigvee'                            } -- n-ary logical or
  , { code = 0x022C2,  char = '⋂',  class = 'op',        cs = 'bigcap'                            } -- n-ary intersection
  , { code = 0x022C3,  char = '⋃',  class = 'op',        cs = 'bigcup'                            } -- n-ary union
  , { code = 0x022C4,  char = '⋄',  class = 'bin',       cs = 'smwhtdiamond'                      } -- diamond operator
  , { code = 0x022C5,  char = '⋅',  class = 'bin',       cs = 'cdot'                              } -- dot operator
  , { code = 0x022C6,  char = '⋆',  class = 'bin',       cs = 'star'                              } -- star operator
  , { code = 0x022C7,  char = '⋇',  class = 'bin',       cs = 'divideontimes'                     } -- division times
  , { code = 0x022C8,  char = '⋈',  class = 'rel',       cs = 'bowtie'                            } -- bowtie
  , { code = 0x022C9,  char = '⋉',  class = 'bin',       cs = 'ltimes'                            } -- left normal factor semidirect product
  , { code = 0x022CA,  char = '⋊',  class = 'bin',       cs = 'rtimes'                            } -- right normal factor semidirect product
  , { code = 0x022CB,  char = '⋋',  class = 'bin',       cs = 'leftthreetimes'                    } -- left semidirect product
  , { code = 0x022CC,  char = '⋌',  class = 'bin',       cs = 'rightthreetimes'                   } -- right semidirect product
  , { code = 0x022CD,  char = '⋍',  class = 'rel',       cs = 'backsimeq'                         } -- reversed tilde equals
  , { code = 0x022CE,  char = '⋎',  class = 'bin',       cs = 'curlyvee'                          } -- curly logical or
  , { code = 0x022CF,  char = '⋏',  class = 'bin',       cs = 'curlywedge'                        } -- curly logical and
  , { code = 0x022D0,  char = '⋐',  class = 'rel',       cs = 'Subset'                            } -- double subset
  , { code = 0x022D1,  char = '⋑',  class = 'rel',       cs = 'Supset'                            } -- double superset
  , { code = 0x022D2,  char = '⋒',  class = 'bin',       cs = 'Cap'                               } -- double intersection
  , { code = 0x022D3,  char = '⋓',  class = 'bin',       cs = 'Cup'                               } -- double union
  , { code = 0x022D4,  char = '⋔',  class = 'rel',       cs = 'pitchfork'                         } -- pitchfork
  , { code = 0x022D5,  char = '⋕',  class = 'rel',       cs = 'equalparallel'                     } -- equal and parallel to
  , { code = 0x022D6,  char = '⋖',  class = 'rel',       cs = 'lessdot'                           } -- less-than with dot
  , { code = 0x022D7,  char = '⋗',  class = 'rel',       cs = 'gtrdot'                            } -- greater-than with dot
  , { code = 0x022D8,  char = '⋘',  class = 'rel',       cs = 'lll'                               } -- very much less-than
  , { code = 0x022D9,  char = '⋙',  class = 'rel',       cs = 'ggg'                               } -- very much greater-than
  , { code = 0x022DA,  char = '⋚',  class = 'rel',       cs = 'lesseqgtr'                         } -- less-than equal to or greater-than
  , { code = 0x022DB,  char = '⋛',  class = 'rel',       cs = 'gtreqless'                         } -- greater-than equal to or less-than
  , { code = 0x022DC,  char = '⋜',  class = 'rel',       cs = 'eqless'                            } -- equal to or less-than
  , { code = 0x022DD,  char = '⋝',  class = 'rel',       cs = 'eqgtr'                             } -- equal to or greater-than
  , { code = 0x022DE,  char = '⋞',  class = 'rel',       cs = 'curlyeqprec'                       } -- equal to or precedes
  , { code = 0x022DF,  char = '⋟',  class = 'rel',       cs = 'curlyeqsucc'                       } -- equal to or succeeds
  , { code = 0x022E0,  char = '⋠',  class = 'rel',       cs = 'npreccurlyeq'                      } -- does not precede or equal
  , { code = 0x022E1,  char = '⋡',  class = 'rel',       cs = 'nsucccurlyeq'                      } -- does not succeed or equal
  , { code = 0x022E2,  char = '⋢',  class = 'rel',       cs = 'nsqsubseteq'                       } -- not square image of or equal to
  , { code = 0x022E3,  char = '⋣',  class = 'rel',       cs = 'nsqsupseteq'                       } -- not square original of or equal to
  , { code = 0x022E4,  char = '⋤',  class = 'rel',       cs = 'sqsubsetneq'                       } -- square image of or not equal to
  , { code = 0x022E5,  char = '⋥',  class = 'rel',       cs = 'sqsupsetneq'                       } -- square original of or not equal to
  , { code = 0x022E6,  char = '⋦',  class = 'rel',       cs = 'lnsim'                             } -- less-than but not equivalent to
  , { code = 0x022E7,  char = '⋧',  class = 'rel',       cs = 'gnsim'                             } -- greater-than but not equivalent to
  , { code = 0x022E8,  char = '⋨',  class = 'rel',       cs = 'precnsim'                          } -- precedes but not equivalent to
  , { code = 0x022E9,  char = '⋩',  class = 'rel',       cs = 'succnsim'                          } -- succeeds but not equivalent to
  , { code = 0x022EA,  char = '⋪',  class = 'rel',       cs = 'nvartriangleleft'                  } -- not normal subgroup of
  , { code = 0x022EB,  char = '⋫',  class = 'rel',       cs = 'nvartriangleright'                 } -- does not contain as normal subgroup
  , { code = 0x022EC,  char = '⋬',  class = 'rel',       cs = 'ntrianglelefteq'                   } -- not normal subgroup of or equal to
  , { code = 0x022ED,  char = '⋭',  class = 'rel',       cs = 'ntrianglerighteq'                  } -- does not contain as normal subgroup or equal
  , { code = 0x022EE,  char = '⋮',  class = 'rel',       cs = 'unicodevdots'                      } -- vertical ellipsis
  , { code = 0x022EF,  char = '⋯',  class = 'ord',       cs = 'unicodecdots'                      } -- midline horizontal ellipsis
  , { code = 0x022F0,  char = '⋰',  class = 'rel',       cs = 'unicodeadots'                      } -- up right diagonal ellipsis
  , { code = 0x022F1,  char = '⋱',  class = 'rel',       cs = 'unicodeddots'                      } -- down right diagonal ellipsis
  , { code = 0x022F2,  char = '⋲',  class = 'rel',       cs = 'disin'                             } -- element of with long horizontal stroke
  , { code = 0x022F3,  char = '⋳',  class = 'rel',       cs = 'varisins'                          } -- element of with vertical bar at end of horizontal stroke
  , { code = 0x022F4,  char = '⋴',  class = 'rel',       cs = 'isins'                             } -- small element of with vertical bar at end of horizontal stroke
  , { code = 0x022F5,  char = '⋵',  class = 'rel',       cs = 'isindot'                           } -- element of with dot above
  , { code = 0x022F6,  char = '⋶',  class = 'rel',       cs = 'varisinobar'                       } -- element of with overbar
  , { code = 0x022F7,  char = '⋷',  class = 'rel',       cs = 'isinobar'                          } -- small element of with overbar
  , { code = 0x022F8,  char = '⋸',  class = 'rel',       cs = 'isinvb'                            } -- element of with underbar
  , { code = 0x022F9,  char = '⋹',  class = 'rel',       cs = 'isinE'                             } -- element of with two horizontal strokes
  , { code = 0x022FA,  char = '⋺',  class = 'rel',       cs = 'nisd'                              } -- contains with long horizontal stroke
  , { code = 0x022FB,  char = '⋻',  class = 'rel',       cs = 'varnis'                            } -- contains with vertical bar at end of horizontal stroke
  , { code = 0x022FC,  char = '⋼',  class = 'rel',       cs = 'nis'                               } -- small contains with vertical bar at end of horizontal stroke
  , { code = 0x022FD,  char = '⋽',  class = 'rel',       cs = 'varniobar'                         } -- contains with overbar
  , { code = 0x022FE,  char = '⋾',  class = 'rel',       cs = 'niobar'                            } -- small contains with overbar
  , { code = 0x022FF,  char = '⋿',  class = 'rel',       cs = 'bagmember'                         } -- z notation bag membership
  , { code = 0x02300,  char = '⌀',  class = 'ord',       cs = 'diameter'                          } -- diameter sign
  , { code = 0x02302,  char = '⌂',  class = 'ord',       cs = 'house'                             } -- house
  , { code = 0x02305,  char = '⌅',  class = 'bin',       cs = 'varbarwedge'                       } -- projective
  , { code = 0x02306,  char = '⌆',  class = 'bin',       cs = 'vardoublebarwedge'                 } -- perspective
  , { code = 0x02308,  char = '⌈',  class = 'open',      cs = 'lceil'                             } -- left ceiling
  , { code = 0x02309,  char = '⌉',  class = 'close',     cs = 'rceil'                             } -- right ceiling
  , { code = 0x0230A,  char = '⌊',  class = 'open',      cs = 'lfloor'                            } -- left floor
  , { code = 0x0230B,  char = '⌋',  class = 'close',     cs = 'rfloor'                            } -- right floor
  , { code = 0x02310,  char = '⌐',  class = 'ord',       cs = 'invnot'                            } -- reversed not sign
  , { code = 0x02311,  char = '⌑',  class = 'ord',       cs = 'sqlozenge'                         } -- square lozenge
  , { code = 0x02312,  char = '⌒',  class = 'ord',       cs = 'profline'                          } -- arc
  , { code = 0x02313,  char = '⌓',  class = 'ord',       cs = 'profsurf'                          } -- segment
  , { code = 0x02317,  char = '⌗',  class = 'ord',       cs = 'viewdata'                          } -- viewdata square
  , { code = 0x02319,  char = '⌙',  class = 'ord',       cs = 'turnednot'                         } -- turned not sign
  , { code = 0x0231C,  char = '⌜',  class = 'open',      cs = 'ulcorner'                          } -- top left corner
  , { code = 0x0231D,  char = '⌝',  class = 'close',     cs = 'urcorner'                          } -- top right corner
  , { code = 0x0231E,  char = '⌞',  class = 'open',      cs = 'llcorner'                          } -- bottom left corner
  , { code = 0x0231F,  char = '⌟',  class = 'close',     cs = 'lrcorner'                          } -- bottom right corner
  , { code = 0x02320,  char = '⌠',  class = 'ord',       cs = 'inttop'                            } -- top half integral
  , { code = 0x02321,  char = '⌡',  class = 'ord',       cs = 'intbottom'                         } -- bottom half integral
  , { code = 0x02322,  char = '⌢',  class = 'rel',       cs = 'frown'                             } -- frown
  , { code = 0x02323,  char = '⌣',  class = 'rel',       cs = 'smile'                             } -- smile
  , { code = 0x0232C,  char = '⌬',  class = 'ord',       cs = 'varhexagonlrbonds'                 } -- benzene ring
  , { code = 0x02332,  char = '⌲',  class = 'ord',       cs = 'conictaper'                        } -- conical taper
  , { code = 0x02336,  char = '⌶',  class = 'ord',       cs = 'topbot'                            } -- apl functional symbol i-beam
  , { code = 0x0233D,  char = '⌽',  class = 'bin',       cs = 'obar'                              } -- apl functional symbol circle stile
  , { code = 0x0233F,  char = '⌿',  class = 'rel',       cs = 'APLnotslash'                       } -- apl functional symbol slash bar
  , { code = 0x02340,  char = '⍀',  class = 'ord',       cs = 'APLnotbackslash'                   } -- apl functional symbol backslash bar
  , { code = 0x02353,  char = '⍓',  class = 'ord',       cs = 'APLboxupcaret'                     } -- apl functional symbol quad up caret
  , { code = 0x02370,  char = '⍰',  class = 'ord',       cs = 'APLboxquestion'                    } -- apl functional symbol quad question
  , { code = 0x0237C,  char = '⍼',  class = 'ord',       cs = 'rangledownzigzagarrow'             } -- right angle with downwards zigzag arrow
  , { code = 0x02394,  char = '⎔',  class = 'ord',       cs = 'hexagon'                           } -- software-function symbol
  , { code = 0x0239B,  char = '⎛',  class = 'ord',       cs = 'lparenuend'                        } -- left parenthesis upper hook
  , { code = 0x0239C,  char = '⎜',  class = 'ord',       cs = 'lparenextender'                    } -- left parenthesis extension
  , { code = 0x0239D,  char = '⎝',  class = 'ord',       cs = 'lparenlend'                        } -- left parenthesis lower hook
  , { code = 0x0239E,  char = '⎞',  class = 'ord',       cs = 'rparenuend'                        } -- right parenthesis upper hook
  , { code = 0x0239F,  char = '⎟',  class = 'ord',       cs = 'rparenextender'                    } -- right parenthesis extension
  , { code = 0x023A0,  char = '⎠',  class = 'ord',       cs = 'rparenlend'                        } -- right parenthesis lower hook
  , { code = 0x023A1,  char = '⎡',  class = 'ord',       cs = 'lbrackuend'                        } -- left square bracket upper corner
  , { code = 0x023A2,  char = '⎢',  class = 'ord',       cs = 'lbrackextender'                    } -- left square bracket extension
  , { code = 0x023A3,  char = '⎣',  class = 'ord',       cs = 'lbracklend'                        } -- left square bracket lower corner
  , { code = 0x023A4,  char = '⎤',  class = 'ord',       cs = 'rbrackuend'                        } -- right square bracket upper corner
  , { code = 0x023A5,  char = '⎥',  class = 'ord',       cs = 'rbrackextender'                    } -- right square bracket extension
  , { code = 0x023A6,  char = '⎦',  class = 'ord',       cs = 'rbracklend'                        } -- right square bracket lower corner
  , { code = 0x023A7,  char = '⎧',  class = 'ord',       cs = 'lbraceuend'                        } -- left curly bracket upper hook
  , { code = 0x023A8,  char = '⎨',  class = 'ord',       cs = 'lbracemid'                         } -- left curly bracket middle piece
  , { code = 0x023A9,  char = '⎩',  class = 'ord',       cs = 'lbracelend'                        } -- left curly bracket lower hook
  , { code = 0x023AA,  char = '⎪',  class = 'ord',       cs = 'vbraceextender'                    } -- curly bracket extension
  , { code = 0x023AB,  char = '⎫',  class = 'ord',       cs = 'rbraceuend'                        } -- right curly bracket upper hook
  , { code = 0x023AC,  char = '⎬',  class = 'ord',       cs = 'rbracemid'                         } -- right curly bracket middle piece
  , { code = 0x023AD,  char = '⎭',  class = 'ord',       cs = 'rbracelend'                        } -- right curly bracket lower hook
  , { code = 0x023AE,  char = '⎮',  class = 'ord',       cs = 'intextender'                       } -- integral extension
  , { code = 0x023AF,  char = '⎯',  class = 'ord',       cs = 'harrowextender'                    } -- horizontal line extension
  , { code = 0x023B0,  char = '⎰',  class = 'open',      cs = 'lmoustache'                        } -- upper left or lower right curly bracket section
  , { code = 0x023B1,  char = '⎱',  class = 'close',     cs = 'rmoustache'                        } -- upper right or lower left curly bracket section
  , { code = 0x023B2,  char = '⎲',  class = 'ord',       cs = 'sumtop'                            } -- summation top
  , { code = 0x023B3,  char = '⎳',  class = 'ord',       cs = 'sumbottom'                         } -- summation bottom
  , { code = 0x023B4,  char = '⎴',  class = 'over',      cs = 'overbracket'                       } -- top square bracket
  , { code = 0x023B5,  char = '⎵',  class = 'under',     cs = 'underbracket'                      } -- bottom square bracket
  , { code = 0x023B6,  char = '⎶',  class = 'ord',       cs = 'bbrktbrk'                          } -- bottom square bracket over top square bracket
  , { code = 0x023B7,  char = '⎷',  class = 'ord',       cs = 'sqrtbottom'                        } -- radical symbol bottom
  , { code = 0x023B8,  char = '⎸',  class = 'ord',       cs = 'lvboxline'                         } -- left vertical box line
  , { code = 0x023B9,  char = '⎹',  class = 'ord',       cs = 'rvboxline'                         } -- right vertical box line
  , { code = 0x023CE,  char = '⏎',  class = 'ord',       cs = 'varcarriagereturn'                 } -- return symbol
  , { code = 0x023DC,  char = '⏜',  class = 'over',      cs = 'overparen'                         } -- top parenthesis
  , { code = 0x023DD,  char = '⏝',  class = 'under',     cs = 'underparen'                        } -- bottom parenthesis
  , { code = 0x023DE,  char = '⏞',  class = 'over',      cs = 'overbrace'                         } -- top curly bracket
  , { code = 0x023DF,  char = '⏟',  class = 'under',     cs = 'underbrace'                        } -- bottom curly bracket
  , { code = 0x023E0,  char = '⏠',  class = 'ord',       cs = 'obrbrak'                           } -- top tortoise shell bracket
  , { code = 0x023E1,  char = '⏡',  class = 'ord',       cs = 'ubrbrak'                           } -- bottom tortoise shell bracket
  , { code = 0x023E2,  char = '⏢',  class = 'ord',       cs = 'trapezium'                         } -- white trapezium
  , { code = 0x023E3,  char = '⏣',  class = 'ord',       cs = 'benzenr'                           } -- benzene ring with circle
  , { code = 0x023E4,  char = '⏤',  class = 'ord',       cs = 'strns'                             } -- straightness
  , { code = 0x023E5,  char = '⏥',  class = 'ord',       cs = 'fltns'                             } -- flatness
  , { code = 0x023E6,  char = '⏦',  class = 'ord',       cs = 'accurrent'                         } -- ac current
  , { code = 0x023E7,  char = '⏧',  class = 'ord',       cs = 'elinters'                          } -- electrical intersection
  , { code = 0x02422,  char = '␢',  class = 'ord',       cs = 'blanksymbol'                       } -- blank symbol
  , { code = 0x02423,  char = '␣',  class = 'ord',       cs = 'mathvisiblespace'                  } -- open box
  , { code = 0x02506,  char = '┆',  class = 'ord',       cs = 'bdtriplevdash'                     } -- box drawings light triple dash vertical
  , { code = 0x02580,  char = '▀',  class = 'ord',       cs = 'blockuphalf'                       } -- upper half block
  , { code = 0x02584,  char = '▄',  class = 'ord',       cs = 'blocklowhalf'                      } -- lower half block
  , { code = 0x02588,  char = '█',  class = 'ord',       cs = 'blockfull'                         } -- full block
  , { code = 0x0258C,  char = '▌',  class = 'ord',       cs = 'blocklefthalf'                     } -- left half block
  , { code = 0x02590,  char = '▐',  class = 'ord',       cs = 'blockrighthalf'                    } -- right half block
  , { code = 0x02591,  char = '░',  class = 'ord',       cs = 'blockqtrshaded'                    } -- light shade
  , { code = 0x02592,  char = '▒',  class = 'ord',       cs = 'blockhalfshaded'                   } -- medium shade
  , { code = 0x02593,  char = '▓',  class = 'ord',       cs = 'blockthreeqtrshaded'               } -- dark shade
  , { code = 0x025A0,  char = '■',  class = 'ord',       cs = 'mdlgblksquare'                     } -- black square
  , { code = 0x025A1,  char = '□',  class = 'ord',       cs = 'mdlgwhtsquare'                     } -- white square
  , { code = 0x025A2,  char = '▢',  class = 'ord',       cs = 'squoval'                           } -- white square with rounded corners
  , { code = 0x025A3,  char = '▣',  class = 'ord',       cs = 'blackinwhitesquare'                } -- white square containing black small square
  , { code = 0x025A4,  char = '▤',  class = 'ord',       cs = 'squarehfill'                       } -- square with horizontal fill
  , { code = 0x025A5,  char = '▥',  class = 'ord',       cs = 'squarevfill'                       } -- square with vertical fill
  , { code = 0x025A6,  char = '▦',  class = 'ord',       cs = 'squarehvfill'                      } -- square with orthogonal crosshatch fill
  , { code = 0x025A7,  char = '▧',  class = 'ord',       cs = 'squarenwsefill'                    } -- square with upper left to lower right fill
  , { code = 0x025A8,  char = '▨',  class = 'ord',       cs = 'squareneswfill'                    } -- square with upper right to lower left fill
  , { code = 0x025A9,  char = '▩',  class = 'ord',       cs = 'squarecrossfill'                   } -- square with diagonal crosshatch fill
  , { code = 0x025AA,  char = '▪',  class = 'ord',       cs = 'smblksquare'                       } -- black small square
  , { code = 0x025AB,  char = '▫',  class = 'ord',       cs = 'smwhtsquare'                       } -- white small square
  , { code = 0x025AC,  char = '▬',  class = 'ord',       cs = 'hrectangleblack'                   } -- black rectangle
  , { code = 0x025AD,  char = '▭',  class = 'ord',       cs = 'hrectangle'                        } -- white rectangle
  , { code = 0x025AE,  char = '▮',  class = 'ord',       cs = 'vrectangleblack'                   } -- black vertical rectangle
  , { code = 0x025AF,  char = '▯',  class = 'ord',       cs = 'vrectangle'                        } -- white vertical rectangle
  , { code = 0x025B0,  char = '▰',  class = 'ord',       cs = 'parallelogramblack'                } -- black parallelogram
  , { code = 0x025B1,  char = '▱',  class = 'ord',       cs = 'parallelogram'                     } -- white parallelogram
  , { code = 0x025B2,  char = '▲',  class = 'ord',       cs = 'bigblacktriangleup'                } -- black up-pointing triangle
  , { code = 0x025B3,  char = '△',  class = 'bin',       cs = 'bigtriangleup'                     } -- white up-pointing triangle
  , { code = 0x025B4,  char = '▴',  class = 'ord',       cs = 'blacktriangle'                     } -- black up-pointing small triangle
  , { code = 0x025B5,  char = '▵',  class = 'rel',       cs = 'vartriangle'                       } -- white up-pointing small triangle
  , { code = 0x025B6,  char = '▶',  class = 'ord',       cs = 'blacktriangleright'                } -- black right-pointing triangle
  , { code = 0x025B7,  char = '▷',  class = 'bin',       cs = 'triangleright'                     } -- white right-pointing triangle
  , { code = 0x025B8,  char = '▸',  class = 'ord',       cs = 'smallblacktriangleright'           } -- black right-pointing small triangle
  , { code = 0x025B9,  char = '▹',  class = 'ord',       cs = 'smalltriangleright'                } -- white right-pointing small triangle
  , { code = 0x025BA,  char = '►',  class = 'ord',       cs = 'blackpointerright'                 } -- black right-pointing pointer
  , { code = 0x025BB,  char = '▻',  class = 'ord',       cs = 'whitepointerright'                 } -- white right-pointing pointer
  , { code = 0x025BC,  char = '▼',  class = 'ord',       cs = 'bigblacktriangledown'              } -- black down-pointing triangle
  , { code = 0x025BD,  char = '▽',  class = 'ord',       cs = 'bigtriangledown'                   } -- white down-pointing triangle
  , { code = 0x025BE,  char = '▾',  class = 'ord',       cs = 'blacktriangledown'                 } -- black down-pointing small triangle
  , { code = 0x025BF,  char = '▿',  class = 'ord',       cs = 'triangledown'                      } -- white down-pointing small triangle
  , { code = 0x025C0,  char = '◀',  class = 'ord',       cs = 'blacktriangleleft'                 } -- black left-pointing triangle
  , { code = 0x025C1,  char = '◁',  class = 'bin',       cs = 'triangleleft'                      } -- white left-pointing triangle
  , { code = 0x025C2,  char = '◂',  class = 'ord',       cs = 'smallblacktriangleleft'            } -- black left-pointing small triangle
  , { code = 0x025C3,  char = '◃',  class = 'ord',       cs = 'smalltriangleleft'                 } -- white left-pointing small triangle
  , { code = 0x025C4,  char = '◄',  class = 'ord',       cs = 'blackpointerleft'                  } -- black left-pointing pointer
  , { code = 0x025C5,  char = '◅',  class = 'ord',       cs = 'whitepointerleft'                  } -- white left-pointing pointer
  , { code = 0x025C6,  char = '◆',  class = 'ord',       cs = 'mdlgblkdiamond'                    } -- black diamond
  , { code = 0x025C7,  char = '◇',  class = 'ord',       cs = 'mdlgwhtdiamond'                    } -- white diamond
  , { code = 0x025C8,  char = '◈',  class = 'ord',       cs = 'blackinwhitediamond'               } -- white diamond containing black small diamond
  , { code = 0x025C9,  char = '◉',  class = 'ord',       cs = 'fisheye'                           } -- fisheye
  , { code = 0x025CA,  char = '◊',  class = 'ord',       cs = 'mdlgwhtlozenge'                    } -- lozenge
  , { code = 0x025CB,  char = '○',  class = 'bin',       cs = 'mdlgwhtcircle'                     } -- white circle
  , { code = 0x025CC,  char = '◌',  class = 'ord',       cs = 'dottedcircle'                      } -- dotted circle
  , { code = 0x025CD,  char = '◍',  class = 'ord',       cs = 'circlevertfill'                    } -- circle with vertical fill
  , { code = 0x025CE,  char = '◎',  class = 'ord',       cs = 'bullseye'                          } -- bullseye
  , { code = 0x025CF,  char = '●',  class = 'ord',       cs = 'mdlgblkcircle'                     } -- black circle
  , { code = 0x025D0,  char = '◐',  class = 'ord',       cs = 'circlelefthalfblack'               } -- circle with left half black
  , { code = 0x025D1,  char = '◑',  class = 'ord',       cs = 'circlerighthalfblack'              } -- circle with right half black
  , { code = 0x025D2,  char = '◒',  class = 'ord',       cs = 'circlebottomhalfblack'             } -- circle with lower half black
  , { code = 0x025D3,  char = '◓',  class = 'ord',       cs = 'circletophalfblack'                } -- circle with upper half black
  , { code = 0x025D4,  char = '◔',  class = 'ord',       cs = 'circleurquadblack'                 } -- circle with upper right quadrant black
  , { code = 0x025D5,  char = '◕',  class = 'ord',       cs = 'blackcircleulquadwhite'            } -- circle with all but upper left quadrant black
  , { code = 0x025D6,  char = '◖',  class = 'ord',       cs = 'blacklefthalfcircle'               } -- left half black circle
  , { code = 0x025D7,  char = '◗',  class = 'ord',       cs = 'blackrighthalfcircle'              } -- right half black circle
  , { code = 0x025D8,  char = '◘',  class = 'ord',       cs = 'inversebullet'                     } -- inverse bullet
  , { code = 0x025D9,  char = '◙',  class = 'ord',       cs = 'inversewhitecircle'                } -- inverse white circle
  , { code = 0x025DA,  char = '◚',  class = 'ord',       cs = 'invwhiteupperhalfcircle'           } -- upper half inverse white circle
  , { code = 0x025DB,  char = '◛',  class = 'ord',       cs = 'invwhitelowerhalfcircle'           } -- lower half inverse white circle
  , { code = 0x025DC,  char = '◜',  class = 'ord',       cs = 'ularc'                             } -- upper left quadrant circular arc
  , { code = 0x025DD,  char = '◝',  class = 'ord',       cs = 'urarc'                             } -- upper right quadrant circular arc
  , { code = 0x025DE,  char = '◞',  class = 'ord',       cs = 'lrarc'                             } -- lower right quadrant circular arc
  , { code = 0x025DF,  char = '◟',  class = 'ord',       cs = 'llarc'                             } -- lower left quadrant circular arc
  , { code = 0x025E0,  char = '◠',  class = 'ord',       cs = 'topsemicircle'                     } -- upper half circle
  , { code = 0x025E1,  char = '◡',  class = 'ord',       cs = 'botsemicircle'                     } -- lower half circle
  , { code = 0x025E2,  char = '◢',  class = 'ord',       cs = 'lrblacktriangle'                   } -- black lower right triangle
  , { code = 0x025E3,  char = '◣',  class = 'ord',       cs = 'llblacktriangle'                   } -- black lower left triangle
  , { code = 0x025E4,  char = '◤',  class = 'ord',       cs = 'ulblacktriangle'                   } -- black upper left triangle
  , { code = 0x025E5,  char = '◥',  class = 'ord',       cs = 'urblacktriangle'                   } -- black upper right triangle
  , { code = 0x025E6,  char = '◦',  class = 'ord',       cs = 'smwhtcircle'                       } -- white bullet
  , { code = 0x025E7,  char = '◧',  class = 'ord',       cs = 'squareleftblack'                   } -- square with left half black
  , { code = 0x025E8,  char = '◨',  class = 'ord',       cs = 'squarerightblack'                  } -- square with right half black
  , { code = 0x025E9,  char = '◩',  class = 'ord',       cs = 'squareulblack'                     } -- square with upper left diagonal half black
  , { code = 0x025EA,  char = '◪',  class = 'ord',       cs = 'squarelrblack'                     } -- square with lower right diagonal half black
  , { code = 0x025EB,  char = '◫',  class = 'bin',       cs = 'boxbar'                            } -- white square with vertical bisecting line
  , { code = 0x025EC,  char = '◬',  class = 'ord',       cs = 'trianglecdot'                      } -- white up-pointing triangle with dot
  , { code = 0x025ED,  char = '◭',  class = 'ord',       cs = 'triangleleftblack'                 } -- up-pointing triangle with left half black
  , { code = 0x025EE,  char = '◮',  class = 'ord',       cs = 'trianglerightblack'                } -- up-pointing triangle with right half black
  , { code = 0x025EF,  char = '◯',  class = 'ord',       cs = 'lgwhtcircle'                       } -- large circle
  , { code = 0x025F0,  char = '◰',  class = 'ord',       cs = 'squareulquad'                      } -- white square with upper left quadrant
  , { code = 0x025F1,  char = '◱',  class = 'ord',       cs = 'squarellquad'                      } -- white square with lower left quadrant
  , { code = 0x025F2,  char = '◲',  class = 'ord',       cs = 'squarelrquad'                      } -- white square with lower right quadrant
  , { code = 0x025F3,  char = '◳',  class = 'ord',       cs = 'squareurquad'                      } -- white square with upper right quadrant
  , { code = 0x025F4,  char = '◴',  class = 'ord',       cs = 'circleulquad'                      } -- white circle with upper left quadrant
  , { code = 0x025F5,  char = '◵',  class = 'ord',       cs = 'circlellquad'                      } -- white circle with lower left quadrant
  , { code = 0x025F6,  char = '◶',  class = 'ord',       cs = 'circlelrquad'                      } -- white circle with lower right quadrant
  , { code = 0x025F7,  char = '◷',  class = 'ord',       cs = 'circleurquad'                      } -- white circle with upper right quadrant
  , { code = 0x025F8,  char = '◸',  class = 'ord',       cs = 'ultriangle'                        } -- upper left triangle
  , { code = 0x025F9,  char = '◹',  class = 'ord',       cs = 'urtriangle'                        } -- upper right triangle
  , { code = 0x025FA,  char = '◺',  class = 'ord',       cs = 'lltriangle'                        } -- lower left triangle
  , { code = 0x025FB,  char = '◻',  class = 'ord',       cs = 'mdwhtsquare'                       } -- white medium square
  , { code = 0x025FC,  char = '◼',  class = 'ord',       cs = 'mdblksquare'                       } -- black medium square
  , { code = 0x025FD,  char = '◽',  class = 'ord',       cs = 'mdsmwhtsquare'                     } -- white medium small square
  , { code = 0x025FE,  char = '◾',  class = 'ord',       cs = 'mdsmblksquare'                     } -- black medium small square
  , { code = 0x025FF,  char = '◿',  class = 'ord',       cs = 'lrtriangle'                        } -- lower right triangle
  , { code = 0x02605,  char = '★',  class = 'ord',       cs = 'bigstar'                           } -- black star
  , { code = 0x02606,  char = '☆',  class = 'ord',       cs = 'bigwhitestar'                      } -- white star
  , { code = 0x02609,  char = '☉',  class = 'ord',       cs = 'astrosun'                          } -- sun
  , { code = 0x02621,  char = '☡',  class = 'ord',       cs = 'danger'                            } -- caution sign
  , { code = 0x0263B,  char = '☻',  class = 'ord',       cs = 'blacksmiley'                       } -- black smiling face
  , { code = 0x0263C,  char = '☼',  class = 'ord',       cs = 'sun'                               } -- white sun with rays
  , { code = 0x0263D,  char = '☽',  class = 'ord',       cs = 'rightmoon'                         } -- first quarter moon
  , { code = 0x0263E,  char = '☾',  class = 'ord',       cs = 'leftmoon'                          } -- last quarter moon
  , { code = 0x02640,  char = '♀',  class = 'ord',       cs = 'female'                            } -- female sign
  , { code = 0x02642,  char = '♂',  class = 'ord',       cs = 'male'                              } -- male sign
  , { code = 0x02660,  char = '♠',  class = 'ord',       cs = 'spadesuit'                         } -- black spade suit
  , { code = 0x02661,  char = '♡',  class = 'ord',       cs = 'heartsuit'                         } -- white heart suit
  , { code = 0x02662,  char = '♢',  class = 'ord',       cs = 'diamondsuit'                       } -- white diamond suit
  , { code = 0x02663,  char = '♣',  class = 'ord',       cs = 'clubsuit'                          } -- black club suit
  , { code = 0x02664,  char = '♤',  class = 'ord',       cs = 'varspadesuit'                      } -- white spade suit
  , { code = 0x02665,  char = '♥',  class = 'ord',       cs = 'varheartsuit'                      } -- black heart suit
  , { code = 0x02666,  char = '♦',  class = 'ord',       cs = 'vardiamondsuit'                    } -- black diamond suit
  , { code = 0x02667,  char = '♧',  class = 'ord',       cs = 'varclubsuit'                       } -- white club suit
  , { code = 0x02669,  char = '♩',  class = 'ord',       cs = 'quarternote'                       } -- quarter note
  , { code = 0x0266A,  char = '♪',  class = 'ord',       cs = 'eighthnote'                        } -- eighth note
  , { code = 0x0266B,  char = '♫',  class = 'ord',       cs = 'twonotes'                          } -- beamed eighth notes
  , { code = 0x0266D,  char = '♭',  class = 'ord',       cs = 'flat'                              } -- music flat sign
  , { code = 0x0266E,  char = '♮',  class = 'ord',       cs = 'natural'                           } -- music natural sign
  , { code = 0x0266F,  char = '♯',  class = 'ord',       cs = 'sharp'                             } -- music sharp sign
  , { code = 0x0267E,  char = '♾',  class = 'ord',       cs = 'acidfree'                          } -- permanent paper sign
  , { code = 0x02680,  char = '⚀',  class = 'ord',       cs = 'dicei'                             } -- die face-1
  , { code = 0x02681,  char = '⚁',  class = 'ord',       cs = 'diceii'                            } -- die face-2
  , { code = 0x02682,  char = '⚂',  class = 'ord',       cs = 'diceiii'                           } -- die face-3
  , { code = 0x02683,  char = '⚃',  class = 'ord',       cs = 'diceiv'                            } -- die face-4
  , { code = 0x02684,  char = '⚄',  class = 'ord',       cs = 'dicev'                             } -- die face-5
  , { code = 0x02685,  char = '⚅',  class = 'ord',       cs = 'dicevi'                            } -- die face-6
  , { code = 0x02686,  char = '⚆',  class = 'ord',       cs = 'circledrightdot'                   } -- white circle with dot right
  , { code = 0x02687,  char = '⚇',  class = 'ord',       cs = 'circledtwodots'                    } -- white circle with two dots
  , { code = 0x02688,  char = '⚈',  class = 'ord',       cs = 'blackcircledrightdot'              } -- black circle with white dot right
  , { code = 0x02689,  char = '⚉',  class = 'ord',       cs = 'blackcircledtwodots'               } -- black circle with two white dots
  , { code = 0x026A5,  char = '⚥',  class = 'ord',       cs = 'Hermaphrodite'                     } -- male and female sign
  , { code = 0x026AA,  char = '⚪',  class = 'ord',       cs = 'mdwhtcircle'                       } -- medium white circle
  , { code = 0x026AB,  char = '⚫',  class = 'ord',       cs = 'mdblkcircle'                       } -- medium black circle
  , { code = 0x026AC,  char = '⚬',  class = 'ord',       cs = 'mdsmwhtcircle'                     } -- medium small white circle
  , { code = 0x026B2,  char = '⚲',  class = 'ord',       cs = 'neuter'                            } -- neuter
  , { code = 0x02713,  char = '✓',  class = 'ord',       cs = 'checkmark'                         } -- check mark
  , { code = 0x02720,  char = '✠',  class = 'ord',       cs = 'maltese'                           } -- maltese cross
  , { code = 0x0272A,  char = '✪',  class = 'ord',       cs = 'circledstar'                       } -- circled white star
  , { code = 0x02736,  char = '✶',  class = 'ord',       cs = 'varstar'                           } -- six pointed black star
  , { code = 0x0273D,  char = '✽',  class = 'ord',       cs = 'dingasterisk'                      } -- heavy teardrop-spoked asterisk
  , { code = 0x02772,  char = '❲',  class = 'open',      cs = 'lbrbrak'                           } -- light left tortoise shell bracket ornament
  , { code = 0x02773,  char = '❳',  class = 'close',     cs = 'rbrbrak'                           } -- light right tortoise shell bracket ornament
  , { code = 0x0279B,  char = '➛',  class = 'ord',       cs = 'draftingarrow'                     } -- drafting point rightwards arrow
  , { code = 0x027C0,  char = '⟀',  class = 'ord',       cs = 'threedangle'                       } -- three dimensional angle
  , { code = 0x027C1,  char = '⟁',  class = 'ord',       cs = 'whiteinwhitetriangle'              } -- white triangle containing small white triangle
  , { code = 0x027C2,  char = '⟂',  class = 'rel',       cs = 'perp'                              } -- perpendicular
  , { code = 0x027C3,  char = '⟃',  class = 'ord',       cs = 'subsetcirc'                        } -- open subset
  , { code = 0x027C4,  char = '⟄',  class = 'ord',       cs = 'supsetcirc'                        } -- open superset
  , { code = 0x027C5,  char = '⟅',  class = 'open',      cs = 'lbag'                              } -- left s-shaped bag delimiter
  , { code = 0x027C6,  char = '⟆',  class = 'close',     cs = 'rbag'                              } -- right s-shaped bag delimiter
  , { code = 0x027C7,  char = '⟇',  class = 'bin',       cs = 'veedot'                            } -- or with dot inside
  , { code = 0x027C8,  char = '⟈',  class = 'rel',       cs = 'bsolhsub'                          } -- reverse solidus preceding subset
  , { code = 0x027C9,  char = '⟉',  class = 'rel',       cs = 'suphsol'                           } -- superset preceding solidus
  , { code = 0x027CC,  char = '⟌',  class = 'radical',   cs = 'longdivision'                      } -- long division
  , { code = 0x027D0,  char = '⟐',  class = 'ord',       cs = 'diamondcdot'                       } -- white diamond with centred dot
  , { code = 0x027D1,  char = '⟑',  class = 'bin',       cs = 'wedgedot'                          } -- and with dot
  , { code = 0x027D2,  char = '⟒',  class = 'rel',       cs = 'upin'                              } -- element of opening upwards
  , { code = 0x027D3,  char = '⟓',  class = 'rel',       cs = 'pullback'                          } -- lower right corner with dot
  , { code = 0x027D4,  char = '⟔',  class = 'rel',       cs = 'pushout'                           } -- upper left corner with dot
  , { code = 0x027D5,  char = '⟕',  class = 'op',        cs = 'leftouterjoin'                     } -- left outer join
  , { code = 0x027D6,  char = '⟖',  class = 'op',        cs = 'rightouterjoin'                    } -- right outer join
  , { code = 0x027D7,  char = '⟗',  class = 'op',        cs = 'fullouterjoin'                     } -- full outer join
  , { code = 0x027D8,  char = '⟘',  class = 'op',        cs = 'bigbot'                            } -- large up tack
  , { code = 0x027D9,  char = '⟙',  class = 'op',        cs = 'bigtop'                            } -- large down tack
  , { code = 0x027DA,  char = '⟚',  class = 'rel',       cs = 'DashVDash'                         } -- left and right double turnstile
  , { code = 0x027DB,  char = '⟛',  class = 'rel',       cs = 'dashVdash'                         } -- left and right tack
  , { code = 0x027DC,  char = '⟜',  class = 'rel',       cs = 'multimapinv'                       } -- left multimap
  , { code = 0x027DD,  char = '⟝',  class = 'rel',       cs = 'vlongdash'                         } -- long right tack
  , { code = 0x027DE,  char = '⟞',  class = 'rel',       cs = 'longdashv'                         } -- long left tack
  , { code = 0x027DF,  char = '⟟',  class = 'rel',       cs = 'cirbot'                            } -- up tack with circle above
  , { code = 0x027E0,  char = '⟠',  class = 'bin',       cs = 'lozengeminus'                      } -- lozenge divided by horizontal rule
  , { code = 0x027E1,  char = '⟡',  class = 'bin',       cs = 'concavediamond'                    } -- white concave-sided diamond
  , { code = 0x027E2,  char = '⟢',  class = 'bin',       cs = 'concavediamondtickleft'            } -- white concave-sided diamond with leftwards tick
  , { code = 0x027E3,  char = '⟣',  class = 'bin',       cs = 'concavediamondtickright'           } -- white concave-sided diamond with rightwards tick
  , { code = 0x027E4,  char = '⟤',  class = 'bin',       cs = 'whitesquaretickleft'               } -- white square with leftwards tick
  , { code = 0x027E5,  char = '⟥',  class = 'bin',       cs = 'whitesquaretickright'              } -- white square with rightwards tick
  , { code = 0x027E6,  char = '⟦',  class = 'open',      cs = 'lBrack'                            } -- mathematical left white square bracket
  , { code = 0x027E7,  char = '⟧',  class = 'close',     cs = 'rBrack'                            } -- mathematical right white square bracket
  , { code = 0x027E8,  char = '⟨',  class = 'open',      cs = 'langle'                            } -- mathematical left angle bracket
  , { code = 0x027E9,  char = '⟩',  class = 'close',     cs = 'rangle'                            } -- mathematical right angle bracket
  , { code = 0x027EA,  char = '⟪',  class = 'open',      cs = 'lAngle'                            } -- mathematical left double angle bracket
  , { code = 0x027EB,  char = '⟫',  class = 'close',     cs = 'rAngle'                            } -- mathematical right double angle bracket
  , { code = 0x027EC,  char = '⟬',  class = 'open',      cs = 'Lbrbrak'                           } -- mathematical left white tortoise shell bracket
  , { code = 0x027ED,  char = '⟭',  class = 'close',     cs = 'Rbrbrak'                           } -- mathematical right white tortoise shell bracket
  , { code = 0x027EE,  char = '⟮',  class = 'open',      cs = 'lgroup'                            } -- mathematical left flattened parenthesis
  , { code = 0x027EF,  char = '⟯',  class = 'close',     cs = 'rgroup'                            } -- mathematical right flattened parenthesis
  , { code = 0x027F0,  char = '⟰',  class = 'rel',       cs = 'UUparrow'                          } -- upwards quadruple arrow
  , { code = 0x027F1,  char = '⟱',  class = 'rel',       cs = 'DDownarrow'                        } -- downwards quadruple arrow
  , { code = 0x027F2,  char = '⟲',  class = 'rel',       cs = 'acwgapcirclearrow'                 } -- anticlockwise gapped circle arrow
  , { code = 0x027F3,  char = '⟳',  class = 'rel',       cs = 'cwgapcirclearrow'                  } -- clockwise gapped circle arrow
  , { code = 0x027F4,  char = '⟴',  class = 'rel',       cs = 'rightarrowonoplus'                 } -- right arrow with circled plus
  , { code = 0x027F5,  char = '⟵',  class = 'rel',       cs = 'longleftarrow'                     } -- long leftwards arrow
  , { code = 0x027F6,  char = '⟶',  class = 'rel',       cs = 'longrightarrow'                    } -- long rightwards arrow
  , { code = 0x027F7,  char = '⟷',  class = 'rel',       cs = 'longleftrightarrow'                } -- long left right arrow
  , { code = 0x027F8,  char = '⟸',  class = 'rel',       cs = 'Longleftarrow'                     } -- long leftwards double arrow
  , { code = 0x027F9,  char = '⟹',  class = 'rel',       cs = 'Longrightarrow'                    } -- long rightwards double arrow
  , { code = 0x027FA,  char = '⟺',  class = 'rel',       cs = 'Longleftrightarrow'                } -- long left right double arrow
  , { code = 0x027FB,  char = '⟻',  class = 'rel',       cs = 'longmapsfrom'                      } -- long leftwards arrow from bar
  , { code = 0x027FC,  char = '⟼',  class = 'rel',       cs = 'longmapsto'                        } -- long rightwards arrow from bar
  , { code = 0x027FD,  char = '⟽',  class = 'rel',       cs = 'Longmapsfrom'                      } -- long leftwards double arrow from bar
  , { code = 0x027FE,  char = '⟾',  class = 'rel',       cs = 'Longmapsto'                        } -- long rightwards double arrow from bar
  , { code = 0x027FF,  char = '⟿',  class = 'rel',       cs = 'longrightsquigarrow'               } -- long rightwards squiggle arrow
  , { code = 0x02900,  char = '⤀',  class = 'rel',       cs = 'nvtwoheadrightarrow'               } -- rightwards two-headed arrow with vertical stroke
  , { code = 0x02901,  char = '⤁',  class = 'rel',       cs = 'nVtwoheadrightarrow'               } -- rightwards two-headed arrow with double vertical stroke
  , { code = 0x02902,  char = '⤂',  class = 'rel',       cs = 'nvLeftarrow'                       } -- leftwards double arrow with vertical stroke
  , { code = 0x02903,  char = '⤃',  class = 'rel',       cs = 'nvRightarrow'                      } -- rightwards double arrow with vertical stroke
  , { code = 0x02904,  char = '⤄',  class = 'rel',       cs = 'nvLeftrightarrow'                  } -- left right double arrow with vertical stroke
  , { code = 0x02905,  char = '⤅',  class = 'rel',       cs = 'twoheadmapsto'                     } -- rightwards two-headed arrow from bar
  , { code = 0x02906,  char = '⤆',  class = 'rel',       cs = 'Mapsfrom'                          } -- leftwards double arrow from bar
  , { code = 0x02907,  char = '⤇',  class = 'rel',       cs = 'Mapsto'                            } -- rightwards double arrow from bar
  , { code = 0x02908,  char = '⤈',  class = 'rel',       cs = 'downarrowbarred'                   } -- downwards arrow with horizontal stroke
  , { code = 0x02909,  char = '⤉',  class = 'rel',       cs = 'uparrowbarred'                     } -- upwards arrow with horizontal stroke
  , { code = 0x0290A,  char = '⤊',  class = 'rel',       cs = 'Uuparrow'                          } -- upwards triple arrow
  , { code = 0x0290B,  char = '⤋',  class = 'rel',       cs = 'Ddownarrow'                        } -- downwards triple arrow
  , { code = 0x0290C,  char = '⤌',  class = 'rel',       cs = 'leftbkarrow'                       } -- leftwards double dash arrow
  , { code = 0x0290D,  char = '⤍',  class = 'rel',       cs = 'rightbkarrow'                      } -- rightwards double dash arrow
  , { code = 0x0290E,  char = '⤎',  class = 'rel',       cs = 'leftdbkarrow'                      } -- leftwards triple dash arrow
  , { code = 0x0290F,  char = '⤏',  class = 'rel',       cs = 'dbkarow'                           } -- rightwards triple dash arrow
  , { code = 0x02910,  char = '⤐',  class = 'rel',       cs = 'drbkarow'                          } -- rightwards two-headed triple dash arrow
  , { code = 0x02911,  char = '⤑',  class = 'rel',       cs = 'rightdotarrow'                     } -- rightwards arrow with dotted stem
  , { code = 0x02912,  char = '⤒',  class = 'rel',       cs = 'baruparrow'                        } -- upwards arrow to bar
  , { code = 0x02913,  char = '⤓',  class = 'rel',       cs = 'downarrowbar'                      } -- downwards arrow to bar
  , { code = 0x02914,  char = '⤔',  class = 'rel',       cs = 'nvrightarrowtail'                  } -- rightwards arrow with tail with vertical stroke
  , { code = 0x02915,  char = '⤕',  class = 'rel',       cs = 'nVrightarrowtail'                  } -- rightwards arrow with tail with double vertical stroke
  , { code = 0x02916,  char = '⤖',  class = 'rel',       cs = 'twoheadrightarrowtail'             } -- rightwards two-headed arrow with tail
  , { code = 0x02917,  char = '⤗',  class = 'rel',       cs = 'nvtwoheadrightarrowtail'           } -- rightwards two-headed arrow with tail with vertical stroke
  , { code = 0x02918,  char = '⤘',  class = 'rel',       cs = 'nVtwoheadrightarrowtail'           } -- rightwards two-headed arrow with tail with double vertical stroke
  , { code = 0x02919,  char = '⤙',  class = 'rel',       cs = 'lefttail'                          } -- leftwards arrow-tail
  , { code = 0x0291A,  char = '⤚',  class = 'rel',       cs = 'righttail'                         } -- rightwards arrow-tail
  , { code = 0x0291B,  char = '⤛',  class = 'rel',       cs = 'leftdbltail'                       } -- leftwards double arrow-tail
  , { code = 0x0291C,  char = '⤜',  class = 'rel',       cs = 'rightdbltail'                      } -- rightwards double arrow-tail
  , { code = 0x0291D,  char = '⤝',  class = 'rel',       cs = 'diamondleftarrow'                  } -- leftwards arrow to black diamond
  , { code = 0x0291E,  char = '⤞',  class = 'rel',       cs = 'rightarrowdiamond'                 } -- rightwards arrow to black diamond
  , { code = 0x0291F,  char = '⤟',  class = 'rel',       cs = 'diamondleftarrowbar'               } -- leftwards arrow from bar to black diamond
  , { code = 0x02920,  char = '⤠',  class = 'rel',       cs = 'barrightarrowdiamond'              } -- rightwards arrow from bar to black diamond
  , { code = 0x02921,  char = '⤡',  class = 'rel',       cs = 'nwsearrow'                         } -- north west and south east arrow
  , { code = 0x02922,  char = '⤢',  class = 'rel',       cs = 'neswarrow'                         } -- north east and south west arrow
  , { code = 0x02923,  char = '⤣',  class = 'rel',       cs = 'hknwarrow'                         } -- north west arrow with hook
  , { code = 0x02924,  char = '⤤',  class = 'rel',       cs = 'hknearrow'                         } -- north east arrow with hook
  , { code = 0x02925,  char = '⤥',  class = 'rel',       cs = 'hksearrow'                         } -- south east arrow with hook
  , { code = 0x02926,  char = '⤦',  class = 'rel',       cs = 'hkswarrow'                         } -- south west arrow with hook
  , { code = 0x02927,  char = '⤧',  class = 'rel',       cs = 'tona'                              } -- north west arrow and north east arrow
  , { code = 0x02928,  char = '⤨',  class = 'rel',       cs = 'toea'                              } -- north east arrow and south east arrow
  , { code = 0x02929,  char = '⤩',  class = 'rel',       cs = 'tosa'                              } -- south east arrow and south west arrow
  , { code = 0x0292A,  char = '⤪',  class = 'rel',       cs = 'towa'                              } -- south west arrow and north west arrow
  , { code = 0x0292B,  char = '⤫',  class = 'ord',       cs = 'rdiagovfdiag'                      } -- rising diagonal crossing falling diagonal
  , { code = 0x0292C,  char = '⤬',  class = 'ord',       cs = 'fdiagovrdiag'                      } -- falling diagonal crossing rising diagonal
  , { code = 0x0292D,  char = '⤭',  class = 'ord',       cs = 'seovnearrow'                       } -- south east arrow crossing north east arrow
  , { code = 0x0292E,  char = '⤮',  class = 'ord',       cs = 'neovsearrow'                       } -- north east arrow crossing south east arrow
  , { code = 0x0292F,  char = '⤯',  class = 'ord',       cs = 'fdiagovnearrow'                    } -- falling diagonal crossing north east arrow
  , { code = 0x02930,  char = '⤰',  class = 'ord',       cs = 'rdiagovsearrow'                    } -- rising diagonal crossing south east arrow
  , { code = 0x02931,  char = '⤱',  class = 'ord',       cs = 'neovnwarrow'                       } -- north east arrow crossing north west arrow
  , { code = 0x02932,  char = '⤲',  class = 'ord',       cs = 'nwovnearrow'                       } -- north west arrow crossing north east arrow
  , { code = 0x02933,  char = '⤳',  class = 'rel',       cs = 'rightcurvedarrow'                  } -- wave arrow pointing directly right
  , { code = 0x02934,  char = '⤴',  class = 'ord',       cs = 'uprightcurvearrow'                 } -- arrow pointing rightwards then curving upwards
  , { code = 0x02935,  char = '⤵',  class = 'ord',       cs = 'downrightcurvedarrow'              } -- arrow pointing rightwards then curving downwards
  , { code = 0x02936,  char = '⤶',  class = 'rel',       cs = 'leftdowncurvedarrow'               } -- arrow pointing downwards then curving leftwards
  , { code = 0x02937,  char = '⤷',  class = 'rel',       cs = 'rightdowncurvedarrow'              } -- arrow pointing downwards then curving rightwards
  , { code = 0x02938,  char = '⤸',  class = 'rel',       cs = 'cwrightarcarrow'                   } -- right-side arc clockwise arrow
  , { code = 0x02939,  char = '⤹',  class = 'rel',       cs = 'acwleftarcarrow'                   } -- left-side arc anticlockwise arrow
  , { code = 0x0293A,  char = '⤺',  class = 'rel',       cs = 'acwoverarcarrow'                   } -- top arc anticlockwise arrow
  , { code = 0x0293B,  char = '⤻',  class = 'rel',       cs = 'acwunderarcarrow'                  } -- bottom arc anticlockwise arrow
  , { code = 0x0293C,  char = '⤼',  class = 'rel',       cs = 'curvearrowrightminus'              } -- top arc clockwise arrow with minus
  , { code = 0x0293D,  char = '⤽',  class = 'rel',       cs = 'curvearrowleftplus'                } -- top arc anticlockwise arrow with plus
  , { code = 0x0293E,  char = '⤾',  class = 'rel',       cs = 'cwundercurvearrow'                 } -- lower right semicircular clockwise arrow
  , { code = 0x0293F,  char = '⤿',  class = 'rel',       cs = 'ccwundercurvearrow'                } -- lower left semicircular anticlockwise arrow
  , { code = 0x02940,  char = '⥀',  class = 'rel',       cs = 'acwcirclearrow'                    } -- anticlockwise closed circle arrow
  , { code = 0x02941,  char = '⥁',  class = 'rel',       cs = 'cwcirclearrow'                     } -- clockwise closed circle arrow
  , { code = 0x02942,  char = '⥂',  class = 'rel',       cs = 'rightarrowshortleftarrow'          } -- rightwards arrow above short leftwards arrow
  , { code = 0x02943,  char = '⥃',  class = 'rel',       cs = 'leftarrowshortrightarrow'          } -- leftwards arrow above short rightwards arrow
  , { code = 0x02944,  char = '⥄',  class = 'rel',       cs = 'shortrightarrowleftarrow'          } -- short rightwards arrow above leftwards arrow
  , { code = 0x02945,  char = '⥅',  class = 'rel',       cs = 'rightarrowplus'                    } -- rightwards arrow with plus below
  , { code = 0x02946,  char = '⥆',  class = 'rel',       cs = 'leftarrowplus'                     } -- leftwards arrow with plus below
  , { code = 0x02947,  char = '⥇',  class = 'rel',       cs = 'rightarrowx'                       } -- rightwards arrow through x
  , { code = 0x02948,  char = '⥈',  class = 'rel',       cs = 'leftrightarrowcircle'              } -- left right arrow through small circle
  , { code = 0x02949,  char = '⥉',  class = 'rel',       cs = 'twoheaduparrowcircle'              } -- upwards two-headed arrow from small circle
  , { code = 0x0294A,  char = '⥊',  class = 'rel',       cs = 'leftrightharpoonupdown'            } -- left barb up right barb down harpoon
  , { code = 0x0294B,  char = '⥋',  class = 'rel',       cs = 'leftrightharpoondownup'            } -- left barb down right barb up harpoon
  , { code = 0x0294C,  char = '⥌',  class = 'rel',       cs = 'updownharpoonrightleft'            } -- up barb right down barb left harpoon
  , { code = 0x0294D,  char = '⥍',  class = 'rel',       cs = 'updownharpoonleftright'            } -- up barb left down barb right harpoon
  , { code = 0x0294E,  char = '⥎',  class = 'rel',       cs = 'leftrightharpoonupup'              } -- left barb up right barb up harpoon
  , { code = 0x0294F,  char = '⥏',  class = 'rel',       cs = 'updownharpoonrightright'           } -- up barb right down barb right harpoon
  , { code = 0x02950,  char = '⥐',  class = 'rel',       cs = 'leftrightharpoondowndown'          } -- left barb down right barb down harpoon
  , { code = 0x02951,  char = '⥑',  class = 'rel',       cs = 'updownharpoonleftleft'             } -- up barb left down barb left harpoon
  , { code = 0x02952,  char = '⥒',  class = 'rel',       cs = 'barleftharpoonup'                  } -- leftwards harpoon with barb up to bar
  , { code = 0x02953,  char = '⥓',  class = 'rel',       cs = 'rightharpoonupbar'                 } -- rightwards harpoon with barb up to bar
  , { code = 0x02954,  char = '⥔',  class = 'rel',       cs = 'barupharpoonright'                 } -- upwards harpoon with barb right to bar
  , { code = 0x02955,  char = '⥕',  class = 'rel',       cs = 'downharpoonrightbar'               } -- downwards harpoon with barb right to bar
  , { code = 0x02956,  char = '⥖',  class = 'rel',       cs = 'barleftharpoondown'                } -- leftwards harpoon with barb down to bar
  , { code = 0x02957,  char = '⥗',  class = 'rel',       cs = 'rightharpoondownbar'               } -- rightwards harpoon with barb down to bar
  , { code = 0x02958,  char = '⥘',  class = 'rel',       cs = 'barupharpoonleft'                  } -- upwards harpoon with barb left to bar
  , { code = 0x02959,  char = '⥙',  class = 'rel',       cs = 'downharpoonleftbar'                } -- downwards harpoon with barb left to bar
  , { code = 0x0295A,  char = '⥚',  class = 'rel',       cs = 'leftharpoonupbar'                  } -- leftwards harpoon with barb up from bar
  , { code = 0x0295B,  char = '⥛',  class = 'rel',       cs = 'barrightharpoonup'                 } -- rightwards harpoon with barb up from bar
  , { code = 0x0295C,  char = '⥜',  class = 'rel',       cs = 'upharpoonrightbar'                 } -- upwards harpoon with barb right from bar
  , { code = 0x0295D,  char = '⥝',  class = 'rel',       cs = 'bardownharpoonright'               } -- downwards harpoon with barb right from bar
  , { code = 0x0295E,  char = '⥞',  class = 'rel',       cs = 'leftharpoondownbar'                } -- leftwards harpoon with barb down from bar
  , { code = 0x0295F,  char = '⥟',  class = 'rel',       cs = 'barrightharpoondown'               } -- rightwards harpoon with barb down from bar
  , { code = 0x02960,  char = '⥠',  class = 'rel',       cs = 'upharpoonleftbar'                  } -- upwards harpoon with barb left from bar
  , { code = 0x02961,  char = '⥡',  class = 'rel',       cs = 'bardownharpoonleft'                } -- downwards harpoon with barb left from bar
  , { code = 0x02962,  char = '⥢',  class = 'rel',       cs = 'leftharpoonsupdown'                } -- leftwards harpoon with barb up above leftwards harpoon with barb down
  , { code = 0x02963,  char = '⥣',  class = 'rel',       cs = 'upharpoonsleftright'               } -- upwards harpoon with barb left beside upwards harpoon with barb right
  , { code = 0x02964,  char = '⥤',  class = 'rel',       cs = 'rightharpoonsupdown'               } -- rightwards harpoon with barb up above rightwards harpoon with barb down
  , { code = 0x02965,  char = '⥥',  class = 'rel',       cs = 'downharpoonsleftright'             } -- downwards harpoon with barb left beside downwards harpoon with barb right
  , { code = 0x02966,  char = '⥦',  class = 'rel',       cs = 'leftrightharpoonsup'               } -- leftwards harpoon with barb up above rightwards harpoon with barb up
  , { code = 0x02967,  char = '⥧',  class = 'rel',       cs = 'leftrightharpoonsdown'             } -- leftwards harpoon with barb down above rightwards harpoon with barb down
  , { code = 0x02968,  char = '⥨',  class = 'rel',       cs = 'rightleftharpoonsup'               } -- rightwards harpoon with barb up above leftwards harpoon with barb up
  , { code = 0x02969,  char = '⥩',  class = 'rel',       cs = 'rightleftharpoonsdown'             } -- rightwards harpoon with barb down above leftwards harpoon with barb down
  , { code = 0x0296A,  char = '⥪',  class = 'rel',       cs = 'leftharpoonupdash'                 } -- leftwards harpoon with barb up above long dash
  , { code = 0x0296B,  char = '⥫',  class = 'rel',       cs = 'dashleftharpoondown'               } -- leftwards harpoon with barb down below long dash
  , { code = 0x0296C,  char = '⥬',  class = 'rel',       cs = 'rightharpoonupdash'                } -- rightwards harpoon with barb up above long dash
  , { code = 0x0296D,  char = '⥭',  class = 'rel',       cs = 'dashrightharpoondown'              } -- rightwards harpoon with barb down below long dash
  , { code = 0x0296E,  char = '⥮',  class = 'rel',       cs = 'updownharpoonsleftright'           } -- upwards harpoon with barb left beside downwards harpoon with barb right
  , { code = 0x0296F,  char = '⥯',  class = 'rel',       cs = 'downupharpoonsleftright'           } -- downwards harpoon with barb left beside upwards harpoon with barb right
  , { code = 0x02970,  char = '⥰',  class = 'rel',       cs = 'rightimply'                        } -- right double arrow with rounded head
  , { code = 0x02971,  char = '⥱',  class = 'rel',       cs = 'equalrightarrow'                   } -- equals sign above rightwards arrow
  , { code = 0x02972,  char = '⥲',  class = 'rel',       cs = 'similarrightarrow'                 } -- tilde operator above rightwards arrow
  , { code = 0x02973,  char = '⥳',  class = 'rel',       cs = 'leftarrowsimilar'                  } -- leftwards arrow above tilde operator
  , { code = 0x02974,  char = '⥴',  class = 'rel',       cs = 'rightarrowsimilar'                 } -- rightwards arrow above tilde operator
  , { code = 0x02975,  char = '⥵',  class = 'rel',       cs = 'rightarrowapprox'                  } -- rightwards arrow above almost equal to
  , { code = 0x02976,  char = '⥶',  class = 'rel',       cs = 'ltlarr'                            } -- less-than above leftwards arrow
  , { code = 0x02977,  char = '⥷',  class = 'rel',       cs = 'leftarrowless'                     } -- leftwards arrow through less-than
  , { code = 0x02978,  char = '⥸',  class = 'rel',       cs = 'gtrarr'                            } -- greater-than above rightwards arrow
  , { code = 0x02979,  char = '⥹',  class = 'rel',       cs = 'subrarr'                           } -- subset above rightwards arrow
  , { code = 0x0297A,  char = '⥺',  class = 'rel',       cs = 'leftarrowsubset'                   } -- leftwards arrow through subset
  , { code = 0x0297B,  char = '⥻',  class = 'rel',       cs = 'suplarr'                           } -- superset above leftwards arrow
  , { code = 0x0297C,  char = '⥼',  class = 'rel',       cs = 'leftfishtail'                      } -- left fish tail
  , { code = 0x0297D,  char = '⥽',  class = 'rel',       cs = 'rightfishtail'                     } -- right fish tail
  , { code = 0x0297E,  char = '⥾',  class = 'rel',       cs = 'upfishtail'                        } -- up fish tail
  , { code = 0x0297F,  char = '⥿',  class = 'rel',       cs = 'downfishtail'                      } -- down fish tail
  , { code = 0x02980,  char = '⦀',  class = 'fence',     cs = 'Vvert'                             } -- triple vertical bar delimiter
  , { code = 0x02981,  char = '⦁',  class = 'ord',       cs = 'mdsmblkcircle'                     } -- z notation spot
  , { code = 0x02982,  char = '⦂',  class = 'bin',       cs = 'typecolon'                         } -- z notation type colon
  , { code = 0x02983,  char = '⦃',  class = 'open',      cs = 'lBrace'                            } -- left white curly bracket
  , { code = 0x02984,  char = '⦄',  class = 'close',     cs = 'rBrace'                            } -- right white curly bracket
  , { code = 0x02985,  char = '⦅',  class = 'open',      cs = 'lParen'                            } -- left white parenthesis
  , { code = 0x02986,  char = '⦆',  class = 'close',     cs = 'rParen'                            } -- right white parenthesis
  , { code = 0x02987,  char = '⦇',  class = 'open',      cs = 'llparenthesis'                     } -- z notation left image bracket
  , { code = 0x02988,  char = '⦈',  class = 'close',     cs = 'rrparenthesis'                     } -- z notation right image bracket
  , { code = 0x02989,  char = '⦉',  class = 'open',      cs = 'llangle'                           } -- z notation left binding bracket
  , { code = 0x0298A,  char = '⦊',  class = 'close',     cs = 'rrangle'                           } -- z notation right binding bracket
  , { code = 0x0298B,  char = '⦋',  class = 'open',      cs = 'lbrackubar'                        } -- left square bracket with underbar
  , { code = 0x0298C,  char = '⦌',  class = 'close',     cs = 'rbrackubar'                        } -- right square bracket with underbar
  , { code = 0x0298D,  char = '⦍',  class = 'open',      cs = 'lbrackultick'                      } -- left square bracket with tick in top corner
  , { code = 0x0298E,  char = '⦎',  class = 'close',     cs = 'rbracklrtick'                      } -- right square bracket with tick in bottom corner
  , { code = 0x0298F,  char = '⦏',  class = 'open',      cs = 'lbracklltick'                      } -- left square bracket with tick in bottom corner
  , { code = 0x02990,  char = '⦐',  class = 'close',     cs = 'rbrackurtick'                      } -- right square bracket with tick in top corner
  , { code = 0x02991,  char = '⦑',  class = 'open',      cs = 'langledot'                         } -- left angle bracket with dot
  , { code = 0x02992,  char = '⦒',  class = 'close',     cs = 'rangledot'                         } -- right angle bracket with dot
  , { code = 0x02993,  char = '⦓',  class = 'open',      cs = 'lparenless'                        } -- left arc less-than bracket
  , { code = 0x02994,  char = '⦔',  class = 'close',     cs = 'rparengtr'                         } -- right arc greater-than bracket
  , { code = 0x02995,  char = '⦕',  class = 'open',      cs = 'Lparengtr'                         } -- double left arc greater-than bracket
  , { code = 0x02996,  char = '⦖',  class = 'close',     cs = 'Rparenless'                        } -- double right arc less-than bracket
  , { code = 0x02997,  char = '⦗',  class = 'open',      cs = 'lblkbrbrak'                        } -- left black tortoise shell bracket
  , { code = 0x02998,  char = '⦘',  class = 'close',     cs = 'rblkbrbrak'                        } -- right black tortoise shell bracket
  , { code = 0x02999,  char = '⦙',  class = 'ord',       cs = 'fourvdots'                         } -- dotted fence
  , { code = 0x0299A,  char = '⦚',  class = 'ord',       cs = 'vzigzag'                           } -- vertical zigzag line
  , { code = 0x0299B,  char = '⦛',  class = 'ord',       cs = 'measuredangleleft'                 } -- measured angle opening left
  , { code = 0x0299C,  char = '⦜',  class = 'ord',       cs = 'rightanglesqr'                     } -- right angle variant with square
  , { code = 0x0299D,  char = '⦝',  class = 'ord',       cs = 'rightanglemdot'                    } -- measured right angle with dot
  , { code = 0x0299E,  char = '⦞',  class = 'ord',       cs = 'angles'                            } -- angle with s inside
  , { code = 0x0299F,  char = '⦟',  class = 'ord',       cs = 'angdnr'                            } -- acute angle
  , { code = 0x029A0,  char = '⦠',  class = 'ord',       cs = 'gtlpar'                            } -- spherical angle opening left
  , { code = 0x029A1,  char = '⦡',  class = 'ord',       cs = 'sphericalangleup'                  } -- spherical angle opening up
  , { code = 0x029A2,  char = '⦢',  class = 'ord',       cs = 'turnangle'                         } -- turned angle
  , { code = 0x029A3,  char = '⦣',  class = 'ord',       cs = 'revangle'                          } -- reversed angle
  , { code = 0x029A4,  char = '⦤',  class = 'ord',       cs = 'angleubar'                         } -- angle with underbar
  , { code = 0x029A5,  char = '⦥',  class = 'ord',       cs = 'revangleubar'                      } -- reversed angle with underbar
  , { code = 0x029A6,  char = '⦦',  class = 'ord',       cs = 'wideangledown'                     } -- oblique angle opening up
  , { code = 0x029A7,  char = '⦧',  class = 'ord',       cs = 'wideangleup'                       } -- oblique angle opening down
  , { code = 0x029A8,  char = '⦨',  class = 'ord',       cs = 'measanglerutone'                   } -- measured angle with open arm ending in arrow pointing up and right
  , { code = 0x029A9,  char = '⦩',  class = 'ord',       cs = 'measanglelutonw'                   } -- measured angle with open arm ending in arrow pointing up and left
  , { code = 0x029AA,  char = '⦪',  class = 'ord',       cs = 'measanglerdtose'                   } -- measured angle with open arm ending in arrow pointing down and right
  , { code = 0x029AB,  char = '⦫',  class = 'ord',       cs = 'measangleldtosw'                   } -- measured angle with open arm ending in arrow pointing down and left
  , { code = 0x029AC,  char = '⦬',  class = 'ord',       cs = 'measangleurtone'                   } -- measured angle with open arm ending in arrow pointing right and up
  , { code = 0x029AD,  char = '⦭',  class = 'ord',       cs = 'measangleultonw'                   } -- measured angle with open arm ending in arrow pointing left and up
  , { code = 0x029AE,  char = '⦮',  class = 'ord',       cs = 'measangledrtose'                   } -- measured angle with open arm ending in arrow pointing right and down
  , { code = 0x029AF,  char = '⦯',  class = 'ord',       cs = 'measangledltosw'                   } -- measured angle with open arm ending in arrow pointing left and down
  , { code = 0x029B0,  char = '⦰',  class = 'ord',       cs = 'revemptyset'                       } -- reversed empty set
  , { code = 0x029B1,  char = '⦱',  class = 'ord',       cs = 'emptysetobar'                      } -- empty set with overbar
  , { code = 0x029B2,  char = '⦲',  class = 'ord',       cs = 'emptysetocirc'                     } -- empty set with small circle above
  , { code = 0x029B3,  char = '⦳',  class = 'ord',       cs = 'emptysetoarr'                      } -- empty set with right arrow above
  , { code = 0x029B4,  char = '⦴',  class = 'ord',       cs = 'emptysetoarrl'                     } -- empty set with left arrow above
  , { code = 0x029B5,  char = '⦵',  class = 'bin',       cs = 'circlehbar'                        } -- circle with horizontal bar
  , { code = 0x029B6,  char = '⦶',  class = 'bin',       cs = 'circledvert'                       } -- circled vertical bar
  , { code = 0x029B7,  char = '⦷',  class = 'bin',       cs = 'circledparallel'                   } -- circled parallel
  , { code = 0x029B8,  char = '⦸',  class = 'bin',       cs = 'obslash'                           } -- circled reverse solidus
  , { code = 0x029B9,  char = '⦹',  class = 'bin',       cs = 'operp'                             } -- circled perpendicular
  , { code = 0x029BA,  char = '⦺',  class = 'ord',       cs = 'obot'                              } -- circle divided by horizontal bar and top half divided by vertical bar
  , { code = 0x029BB,  char = '⦻',  class = 'ord',       cs = 'olcross'                           } -- circle with superimposed x
  , { code = 0x029BC,  char = '⦼',  class = 'ord',       cs = 'odotslashdot'                      } -- circled anticlockwise-rotated division sign
  , { code = 0x029BD,  char = '⦽',  class = 'ord',       cs = 'uparrowoncircle'                   } -- up arrow through circle
  , { code = 0x029BE,  char = '⦾',  class = 'ord',       cs = 'circledwhitebullet'                } -- circled white bullet
  , { code = 0x029BF,  char = '⦿',  class = 'ord',       cs = 'circledbullet'                     } -- circled bullet
  , { code = 0x029C0,  char = '⧀',  class = 'bin',       cs = 'olessthan'                         } -- circled less-than
  , { code = 0x029C1,  char = '⧁',  class = 'bin',       cs = 'ogreaterthan'                      } -- circled greater-than
  , { code = 0x029C2,  char = '⧂',  class = 'ord',       cs = 'cirscir'                           } -- circle with small circle to the right
  , { code = 0x029C3,  char = '⧃',  class = 'ord',       cs = 'cirE'                              } -- circle with two horizontal strokes to the right
  , { code = 0x029C4,  char = '⧄',  class = 'bin',       cs = 'boxdiag'                           } -- squared rising diagonal slash
  , { code = 0x029C5,  char = '⧅',  class = 'bin',       cs = 'boxbslash'                         } -- squared falling diagonal slash
  , { code = 0x029C6,  char = '⧆',  class = 'bin',       cs = 'boxast'                            } -- squared asterisk
  , { code = 0x029C7,  char = '⧇',  class = 'bin',       cs = 'boxcircle'                         } -- squared small circle
  , { code = 0x029C8,  char = '⧈',  class = 'bin',       cs = 'boxbox'                            } -- squared square
  , { code = 0x029C9,  char = '⧉',  class = 'ord',       cs = 'boxonbox'                          } -- two joined squares
  , { code = 0x029CA,  char = '⧊',  class = 'ord',       cs = 'triangleodot'                      } -- triangle with dot above
  , { code = 0x029CB,  char = '⧋',  class = 'ord',       cs = 'triangleubar'                      } -- triangle with underbar
  , { code = 0x029CC,  char = '⧌',  class = 'ord',       cs = 'triangles'                         } -- s in triangle
  , { code = 0x029CD,  char = '⧍',  class = 'bin',       cs = 'triangleserifs'                    } -- triangle with serifs at bottom
  , { code = 0x029CE,  char = '⧎',  class = 'rel',       cs = 'rtriltri'                          } -- right triangle above left triangle
  , { code = 0x029CF,  char = '⧏',  class = 'rel',       cs = 'ltrivb'                            } -- left triangle beside vertical bar
  , { code = 0x029D0,  char = '⧐',  class = 'rel',       cs = 'vbrtri'                            } -- vertical bar beside right triangle
  , { code = 0x029D1,  char = '⧑',  class = 'rel',       cs = 'lfbowtie'                          } -- bowtie with left half black
  , { code = 0x029D2,  char = '⧒',  class = 'rel',       cs = 'rfbowtie'                          } -- bowtie with right half black
  , { code = 0x029D3,  char = '⧓',  class = 'rel',       cs = 'fbowtie'                           } -- black bowtie
  , { code = 0x029D4,  char = '⧔',  class = 'rel',       cs = 'lftimes'                           } -- times with left half black
  , { code = 0x029D5,  char = '⧕',  class = 'rel',       cs = 'rftimes'                           } -- times with right half black
  , { code = 0x029D6,  char = '⧖',  class = 'bin',       cs = 'hourglass'                         } -- white hourglass
  , { code = 0x029D7,  char = '⧗',  class = 'bin',       cs = 'blackhourglass'                    } -- black hourglass
  , { code = 0x029D8,  char = '⧘',  class = 'open',      cs = 'lvzigzag'                          } -- left wiggly fence
  , { code = 0x029D9,  char = '⧙',  class = 'close',     cs = 'rvzigzag'                          } -- right wiggly fence
  , { code = 0x029DA,  char = '⧚',  class = 'open',      cs = 'Lvzigzag'                          } -- left double wiggly fence
  , { code = 0x029DB,  char = '⧛',  class = 'close',     cs = 'Rvzigzag'                          } -- right double wiggly fence
  , { code = 0x029DC,  char = '⧜',  class = 'ord',       cs = 'iinfin'                            } -- incomplete infinity
  , { code = 0x029DD,  char = '⧝',  class = 'ord',       cs = 'tieinfty'                          } -- tie over infinity
  , { code = 0x029DE,  char = '⧞',  class = 'ord',       cs = 'nvinfty'                           } -- infinity negated with vertical bar
  , { code = 0x029DF,  char = '⧟',  class = 'rel',       cs = 'dualmap'                           } -- double-ended multimap
  , { code = 0x029E0,  char = '⧠',  class = 'ord',       cs = 'laplac'                            } -- square with contoured outline
  , { code = 0x029E1,  char = '⧡',  class = 'rel',       cs = 'lrtriangleeq'                      } -- increases as
  , { code = 0x029E2,  char = '⧢',  class = 'bin',       cs = 'shuffle'                           } -- shuffle product
  , { code = 0x029E3,  char = '⧣',  class = 'rel',       cs = 'eparsl'                            } -- equals sign and slanted parallel
  , { code = 0x029E4,  char = '⧤',  class = 'rel',       cs = 'smeparsl'                          } -- equals sign and slanted parallel with tilde above
  , { code = 0x029E5,  char = '⧥',  class = 'rel',       cs = 'eqvparsl'                          } -- identical to and slanted parallel
  , { code = 0x029E6,  char = '⧦',  class = 'rel',       cs = 'gleichstark'                       } -- gleich stark
  , { code = 0x029E7,  char = '⧧',  class = 'ord',       cs = 'thermod'                           } -- thermodynamic
  , { code = 0x029E8,  char = '⧨',  class = 'ord',       cs = 'downtriangleleftblack'             } -- down-pointing triangle with left half black
  , { code = 0x029E9,  char = '⧩',  class = 'ord',       cs = 'downtrianglerightblack'            } -- down-pointing triangle with right half black
  , { code = 0x029EA,  char = '⧪',  class = 'ord',       cs = 'blackdiamonddownarrow'             } -- black diamond with down arrow
  , { code = 0x029EB,  char = '⧫',  class = 'bin',       cs = 'mdlgblklozenge'                    } -- black lozenge
  , { code = 0x029EC,  char = '⧬',  class = 'ord',       cs = 'circledownarrow'                   } -- white circle with down arrow
  , { code = 0x029ED,  char = '⧭',  class = 'ord',       cs = 'blackcircledownarrow'              } -- black circle with down arrow
  , { code = 0x029EE,  char = '⧮',  class = 'ord',       cs = 'errbarsquare'                      } -- error-barred white square
  , { code = 0x029EF,  char = '⧯',  class = 'ord',       cs = 'errbarblacksquare'                 } -- error-barred black square
  , { code = 0x029F0,  char = '⧰',  class = 'ord',       cs = 'errbardiamond'                     } -- error-barred white diamond
  , { code = 0x029F1,  char = '⧱',  class = 'ord',       cs = 'errbarblackdiamond'                } -- error-barred black diamond
  , { code = 0x029F2,  char = '⧲',  class = 'ord',       cs = 'errbarcircle'                      } -- error-barred white circle
  , { code = 0x029F3,  char = '⧳',  class = 'ord',       cs = 'errbarblackcircle'                 } -- error-barred black circle
  , { code = 0x029F4,  char = '⧴',  class = 'rel',       cs = 'ruledelayed'                       } -- rule-delayed
  , { code = 0x029F5,  char = '⧵',  class = 'bin',       cs = 'setminus'                          } -- reverse solidus operator
  , { code = 0x029F6,  char = '⧶',  class = 'bin',       cs = 'dsol'                              } -- solidus with overbar
  , { code = 0x029F7,  char = '⧷',  class = 'bin',       cs = 'rsolbar'                           } -- reverse solidus with horizontal stroke
  , { code = 0x029F8,  char = '⧸',  class = 'op',        cs = 'xsol'                              } -- big solidus
  , { code = 0x029F9,  char = '⧹',  class = 'op',        cs = 'xbsol'                             } -- big reverse solidus
  , { code = 0x029FA,  char = '⧺',  class = 'bin',       cs = 'doubleplus'                        } -- double plus
  , { code = 0x029FB,  char = '⧻',  class = 'bin',       cs = 'tripleplus'                        } -- triple plus
  , { code = 0x029FC,  char = '⧼',  class = 'open',      cs = 'lcurvyangle'                       } -- left-pointing curved angle bracket
  , { code = 0x029FD,  char = '⧽',  class = 'close',     cs = 'rcurvyangle'                       } -- right-pointing curved angle bracket
  , { code = 0x029FE,  char = '⧾',  class = 'bin',       cs = 'tplus'                             } -- tiny
  , { code = 0x029FF,  char = '⧿',  class = 'bin',       cs = 'tminus'                            } -- miny
  , { code = 0x02A00,  char = '⨀',  class = 'op',        cs = 'bigodot'                           } -- n-ary circled dot operator
  , { code = 0x02A01,  char = '⨁',  class = 'op',        cs = 'bigoplus'                          } -- n-ary circled plus operator
  , { code = 0x02A02,  char = '⨂',  class = 'op',        cs = 'bigotimes'                         } -- n-ary circled times operator
  , { code = 0x02A03,  char = '⨃',  class = 'op',        cs = 'bigcupdot'                         } -- n-ary union operator with dot
  , { code = 0x02A04,  char = '⨄',  class = 'op',        cs = 'biguplus'                          } -- n-ary union operator with plus
  , { code = 0x02A05,  char = '⨅',  class = 'op',        cs = 'bigsqcap'                          } -- n-ary square intersection operator
  , { code = 0x02A06,  char = '⨆',  class = 'op',        cs = 'bigsqcup'                          } -- n-ary square union operator
  , { code = 0x02A07,  char = '⨇',  class = 'op',        cs = 'conjquant'                         } -- two logical and operator
  , { code = 0x02A08,  char = '⨈',  class = 'op',        cs = 'disjquant'                         } -- two logical or operator
  , { code = 0x02A09,  char = '⨉',  class = 'op',        cs = 'bigtimes'                          } -- n-ary times operator
  , { code = 0x02A0A,  char = '⨊',  class = 'op',        cs = 'modtwosum'                         } -- modulo two sum
  , { code = 0x02A0B,  char = '⨋',  class = 'op',        cs = 'sumint'                            } -- summation with integral
  , { code = 0x02A0C,  char = '⨌',  class = 'op',        cs = 'iiiint'                            } -- quadruple integral operator
  , { code = 0x02A0D,  char = '⨍',  class = 'op',        cs = 'intbar'                            } -- finite part integral
  , { code = 0x02A0E,  char = '⨎',  class = 'op',        cs = 'intBar'                            } -- integral with double stroke
  , { code = 0x02A0F,  char = '⨏',  class = 'op',        cs = 'fint'                              } -- integral average with slash
  , { code = 0x02A10,  char = '⨐',  class = 'op',        cs = 'cirfnint'                          } -- circulation function
  , { code = 0x02A11,  char = '⨑',  class = 'op',        cs = 'awint'                             } -- anticlockwise integration
  , { code = 0x02A12,  char = '⨒',  class = 'op',        cs = 'rppolint'                          } -- line integration with rectangular path around pole
  , { code = 0x02A13,  char = '⨓',  class = 'op',        cs = 'scpolint'                          } -- line integration with semicircular path around pole
  , { code = 0x02A14,  char = '⨔',  class = 'op',        cs = 'npolint'                           } -- line integration not including the pole
  , { code = 0x02A15,  char = '⨕',  class = 'op',        cs = 'pointint'                          } -- integral around a point operator
  , { code = 0x02A16,  char = '⨖',  class = 'op',        cs = 'sqint'                             } -- quaternion integral operator
  , { code = 0x02A17,  char = '⨗',  class = 'op',        cs = 'intlarhk'                          } -- integral with leftwards arrow with hook
  , { code = 0x02A18,  char = '⨘',  class = 'op',        cs = 'intx'                              } -- integral with times sign
  , { code = 0x02A19,  char = '⨙',  class = 'op',        cs = 'intcap'                            } -- integral with intersection
  , { code = 0x02A1A,  char = '⨚',  class = 'op',        cs = 'intcup'                            } -- integral with union
  , { code = 0x02A1B,  char = '⨛',  class = 'op',        cs = 'upint'                             } -- integral with overbar
  , { code = 0x02A1C,  char = '⨜',  class = 'op',        cs = 'lowint'                            } -- integral with underbar
  , { code = 0x02A1D,  char = '⨝',  class = 'op',        cs = 'Join'                              } -- join
  , { code = 0x02A1E,  char = '⨞',  class = 'op',        cs = 'bigtriangleleft'                   } -- large left triangle operator
  , { code = 0x02A1F,  char = '⨟',  class = 'op',        cs = 'zcmp'                              } -- z notation schema composition
  , { code = 0x02A20,  char = '⨠',  class = 'op',        cs = 'zpipe'                             } -- z notation schema piping
  , { code = 0x02A21,  char = '⨡',  class = 'op',        cs = 'zproject'                          } -- z notation schema projection
  , { code = 0x02A22,  char = '⨢',  class = 'bin',       cs = 'ringplus'                          } -- plus sign with small circle above
  , { code = 0x02A23,  char = '⨣',  class = 'bin',       cs = 'plushat'                           } -- plus sign with circumflex accent above
  , { code = 0x02A24,  char = '⨤',  class = 'bin',       cs = 'simplus'                           } -- plus sign with tilde above
  , { code = 0x02A25,  char = '⨥',  class = 'bin',       cs = 'plusdot'                           } -- plus sign with dot below
  , { code = 0x02A26,  char = '⨦',  class = 'bin',       cs = 'plussim'                           } -- plus sign with tilde below
  , { code = 0x02A27,  char = '⨧',  class = 'bin',       cs = 'plussubtwo'                        } -- plus sign with subscript two
  , { code = 0x02A28,  char = '⨨',  class = 'bin',       cs = 'plustrif'                          } -- plus sign with black triangle
  , { code = 0x02A29,  char = '⨩',  class = 'bin',       cs = 'commaminus'                        } -- minus sign with comma above
  , { code = 0x02A2A,  char = '⨪',  class = 'bin',       cs = 'minusdot'                          } -- minus sign with dot below
  , { code = 0x02A2B,  char = '⨫',  class = 'bin',       cs = 'minusfdots'                        } -- minus sign with falling dots
  , { code = 0x02A2C,  char = '⨬',  class = 'bin',       cs = 'minusrdots'                        } -- minus sign with rising dots
  , { code = 0x02A2D,  char = '⨭',  class = 'bin',       cs = 'opluslhrim'                        } -- plus sign in left half circle
  , { code = 0x02A2E,  char = '⨮',  class = 'bin',       cs = 'oplusrhrim'                        } -- plus sign in right half circle
  , { code = 0x02A2F,  char = '⨯',  class = 'bin',       cs = 'vectimes'                          } -- vector or cross product
  , { code = 0x02A30,  char = '⨰',  class = 'bin',       cs = 'dottimes'                          } -- multiplication sign with dot above
  , { code = 0x02A31,  char = '⨱',  class = 'bin',       cs = 'timesbar'                          } -- multiplication sign with underbar
  , { code = 0x02A32,  char = '⨲',  class = 'bin',       cs = 'btimes'                            } -- semidirect product with bottom closed
  , { code = 0x02A33,  char = '⨳',  class = 'bin',       cs = 'smashtimes'                        } -- smash product
  , { code = 0x02A34,  char = '⨴',  class = 'bin',       cs = 'otimeslhrim'                       } -- multiplication sign in left half circle
  , { code = 0x02A35,  char = '⨵',  class = 'bin',       cs = 'otimesrhrim'                       } -- multiplication sign in right half circle
  , { code = 0x02A36,  char = '⨶',  class = 'bin',       cs = 'otimeshat'                         } -- circled multiplication sign with circumflex accent
  , { code = 0x02A37,  char = '⨷',  class = 'bin',       cs = 'Otimes'                            } -- multiplication sign in double circle
  , { code = 0x02A38,  char = '⨸',  class = 'bin',       cs = 'odiv'                              } -- circled division sign
  , { code = 0x02A39,  char = '⨹',  class = 'bin',       cs = 'triangleplus'                      } -- plus sign in triangle
  , { code = 0x02A3A,  char = '⨺',  class = 'bin',       cs = 'triangleminus'                     } -- minus sign in triangle
  , { code = 0x02A3B,  char = '⨻',  class = 'bin',       cs = 'triangletimes'                     } -- multiplication sign in triangle
  , { code = 0x02A3C,  char = '⨼',  class = 'bin',       cs = 'intprod'                           } -- interior product
  , { code = 0x02A3D,  char = '⨽',  class = 'bin',       cs = 'intprodr'                          } -- righthand interior product
  , { code = 0x02A3E,  char = '⨾',  class = 'bin',       cs = 'fcmp'                              } -- z notation relational composition
  , { code = 0x02A3F,  char = '⨿',  class = 'bin',       cs = 'amalg'                             } -- amalgamation or coproduct
  , { code = 0x02A40,  char = '⩀',  class = 'bin',       cs = 'capdot'                            } -- intersection with dot
  , { code = 0x02A41,  char = '⩁',  class = 'bin',       cs = 'uminus'                            } -- union with minus sign
  , { code = 0x02A42,  char = '⩂',  class = 'bin',       cs = 'barcup'                            } -- union with overbar
  , { code = 0x02A43,  char = '⩃',  class = 'bin',       cs = 'barcap'                            } -- intersection with overbar
  , { code = 0x02A44,  char = '⩄',  class = 'bin',       cs = 'capwedge'                          } -- intersection with logical and
  , { code = 0x02A45,  char = '⩅',  class = 'bin',       cs = 'cupvee'                            } -- union with logical or
  , { code = 0x02A46,  char = '⩆',  class = 'bin',       cs = 'cupovercap'                        } -- union above intersection
  , { code = 0x02A47,  char = '⩇',  class = 'bin',       cs = 'capovercup'                        } -- intersection above union
  , { code = 0x02A48,  char = '⩈',  class = 'bin',       cs = 'cupbarcap'                         } -- union above bar above intersection
  , { code = 0x02A49,  char = '⩉',  class = 'bin',       cs = 'capbarcup'                         } -- intersection above bar above union
  , { code = 0x02A4A,  char = '⩊',  class = 'bin',       cs = 'twocups'                           } -- union beside and joined with union
  , { code = 0x02A4B,  char = '⩋',  class = 'bin',       cs = 'twocaps'                           } -- intersection beside and joined with intersection
  , { code = 0x02A4C,  char = '⩌',  class = 'bin',       cs = 'closedvarcup'                      } -- closed union with serifs
  , { code = 0x02A4D,  char = '⩍',  class = 'bin',       cs = 'closedvarcap'                      } -- closed intersection with serifs
  , { code = 0x02A4E,  char = '⩎',  class = 'bin',       cs = 'Sqcap'                             } -- double square intersection
  , { code = 0x02A4F,  char = '⩏',  class = 'bin',       cs = 'Sqcup'                             } -- double square union
  , { code = 0x02A50,  char = '⩐',  class = 'bin',       cs = 'closedvarcupsmashprod'             } -- closed union with serifs and smash product
  , { code = 0x02A51,  char = '⩑',  class = 'bin',       cs = 'wedgeodot'                         } -- logical and with dot above
  , { code = 0x02A52,  char = '⩒',  class = 'bin',       cs = 'veeodot'                           } -- logical or with dot above
  , { code = 0x02A53,  char = '⩓',  class = 'bin',       cs = 'Wedge'                             } -- double logical and
  , { code = 0x02A54,  char = '⩔',  class = 'bin',       cs = 'Vee'                               } -- double logical or
  , { code = 0x02A55,  char = '⩕',  class = 'bin',       cs = 'wedgeonwedge'                      } -- two intersecting logical and
  , { code = 0x02A56,  char = '⩖',  class = 'bin',       cs = 'veeonvee'                          } -- two intersecting logical or
  , { code = 0x02A57,  char = '⩗',  class = 'bin',       cs = 'bigslopedvee'                      } -- sloping large or
  , { code = 0x02A58,  char = '⩘',  class = 'bin',       cs = 'bigslopedwedge'                    } -- sloping large and
  , { code = 0x02A59,  char = '⩙',  class = 'rel',       cs = 'veeonwedge'                        } -- logical or overlapping logical and
  , { code = 0x02A5A,  char = '⩚',  class = 'bin',       cs = 'wedgemidvert'                      } -- logical and with middle stem
  , { code = 0x02A5B,  char = '⩛',  class = 'bin',       cs = 'veemidvert'                        } -- logical or with middle stem
  , { code = 0x02A5C,  char = '⩜',  class = 'bin',       cs = 'midbarwedge'                       } -- logical and with horizontal dash
  , { code = 0x02A5D,  char = '⩝',  class = 'bin',       cs = 'midbarvee'                         } -- logical or with horizontal dash
  , { code = 0x02A5E,  char = '⩞',  class = 'bin',       cs = 'doublebarwedge'                    } -- logical and with double overbar
  , { code = 0x02A5F,  char = '⩟',  class = 'bin',       cs = 'wedgebar'                          } -- logical and with underbar
  , { code = 0x02A60,  char = '⩠',  class = 'bin',       cs = 'wedgedoublebar'                    } -- logical and with double underbar
  , { code = 0x02A61,  char = '⩡',  class = 'bin',       cs = 'varveebar'                         } -- small vee with underbar
  , { code = 0x02A62,  char = '⩢',  class = 'bin',       cs = 'doublebarvee'                      } -- logical or with double overbar
  , { code = 0x02A63,  char = '⩣',  class = 'bin',       cs = 'veedoublebar'                      } -- logical or with double underbar
  , { code = 0x02A64,  char = '⩤',  class = 'bin',       cs = 'dsub'                              } -- z notation domain antirestriction
  , { code = 0x02A65,  char = '⩥',  class = 'bin',       cs = 'rsub'                              } -- z notation range antirestriction
  , { code = 0x02A66,  char = '⩦',  class = 'rel',       cs = 'eqdot'                             } -- equals sign with dot below
  , { code = 0x02A67,  char = '⩧',  class = 'rel',       cs = 'dotequiv'                          } -- identical with dot above
  , { code = 0x02A68,  char = '⩨',  class = 'rel',       cs = 'equivVert'                         } -- triple horizontal bar with double vertical stroke
  , { code = 0x02A69,  char = '⩩',  class = 'rel',       cs = 'equivVvert'                        } -- triple horizontal bar with triple vertical stroke
  , { code = 0x02A6A,  char = '⩪',  class = 'rel',       cs = 'dotsim'                            } -- tilde operator with dot above
  , { code = 0x02A6B,  char = '⩫',  class = 'rel',       cs = 'simrdots'                          } -- tilde operator with rising dots
  , { code = 0x02A6C,  char = '⩬',  class = 'rel',       cs = 'simminussim'                       } -- similar minus similar
  , { code = 0x02A6D,  char = '⩭',  class = 'rel',       cs = 'congdot'                           } -- congruent with dot above
  , { code = 0x02A6E,  char = '⩮',  class = 'rel',       cs = 'asteq'                             } -- equals with asterisk
  , { code = 0x02A6F,  char = '⩯',  class = 'rel',       cs = 'hatapprox'                         } -- almost equal to with circumflex accent
  , { code = 0x02A70,  char = '⩰',  class = 'rel',       cs = 'approxeqq'                         } -- approximately equal or equal to
  , { code = 0x02A71,  char = '⩱',  class = 'bin',       cs = 'eqqplus'                           } -- equals sign above plus sign
  , { code = 0x02A72,  char = '⩲',  class = 'bin',       cs = 'pluseqq'                           } -- plus sign above equals sign
  , { code = 0x02A73,  char = '⩳',  class = 'rel',       cs = 'eqqsim'                            } -- equals sign above tilde operator
  , { code = 0x02A74,  char = '⩴',  class = 'rel',       cs = 'Coloneq'                           } -- double colon equal
  , { code = 0x02A75,  char = '⩵',  class = 'rel',       cs = 'eqeq'                              } -- two consecutive equals signs
  , { code = 0x02A76,  char = '⩶',  class = 'rel',       cs = 'eqeqeq'                            } -- three consecutive equals signs
  , { code = 0x02A77,  char = '⩷',  class = 'rel',       cs = 'ddotseq'                           } -- equals sign with two dots above and two dots below
  , { code = 0x02A78,  char = '⩸',  class = 'rel',       cs = 'equivDD'                           } -- equivalent with four dots above
  , { code = 0x02A79,  char = '⩹',  class = 'rel',       cs = 'ltcir'                             } -- less-than with circle inside
  , { code = 0x02A7A,  char = '⩺',  class = 'rel',       cs = 'gtcir'                             } -- greater-than with circle inside
  , { code = 0x02A7B,  char = '⩻',  class = 'rel',       cs = 'ltquest'                           } -- less-than with question mark above
  , { code = 0x02A7C,  char = '⩼',  class = 'rel',       cs = 'gtquest'                           } -- greater-than with question mark above
  , { code = 0x02A7D,  char = '⩽',  class = 'rel',       cs = 'leqslant'                          } -- less-than or slanted equal to
  , { code = 0x02A7E,  char = '⩾',  class = 'rel',       cs = 'geqslant'                          } -- greater-than or slanted equal to
  , { code = 0x02A7F,  char = '⩿',  class = 'rel',       cs = 'lesdot'                            } -- less-than or slanted equal to with dot inside
  , { code = 0x02A80,  char = '⪀',  class = 'rel',       cs = 'gesdot'                            } -- greater-than or slanted equal to with dot inside
  , { code = 0x02A81,  char = '⪁',  class = 'rel',       cs = 'lesdoto'                           } -- less-than or slanted equal to with dot above
  , { code = 0x02A82,  char = '⪂',  class = 'rel',       cs = 'gesdoto'                           } -- greater-than or slanted equal to with dot above
  , { code = 0x02A83,  char = '⪃',  class = 'rel',       cs = 'lesdotor'                          } -- less-than or slanted equal to with dot above right
  , { code = 0x02A84,  char = '⪄',  class = 'rel',       cs = 'gesdotol'                          } -- greater-than or slanted equal to with dot above left
  , { code = 0x02A85,  char = '⪅',  class = 'rel',       cs = 'lessapprox'                        } -- less-than or approximate
  , { code = 0x02A86,  char = '⪆',  class = 'rel',       cs = 'gtrapprox'                         } -- greater-than or approximate
  , { code = 0x02A87,  char = '⪇',  class = 'rel',       cs = 'lneq'                              } -- less-than and single-line not equal to
  , { code = 0x02A88,  char = '⪈',  class = 'rel',       cs = 'gneq'                              } -- greater-than and single-line not equal to
  , { code = 0x02A89,  char = '⪉',  class = 'rel',       cs = 'lnapprox'                          } -- less-than and not approximate
  , { code = 0x02A8A,  char = '⪊',  class = 'rel',       cs = 'gnapprox'                          } -- greater-than and not approximate
  , { code = 0x02A8B,  char = '⪋',  class = 'rel',       cs = 'lesseqqgtr'                        } -- less-than above double-line equal above greater-than
  , { code = 0x02A8C,  char = '⪌',  class = 'rel',       cs = 'gtreqqless'                        } -- greater-than above double-line equal above less-than
  , { code = 0x02A8D,  char = '⪍',  class = 'rel',       cs = 'lsime'                             } -- less-than above similar or equal
  , { code = 0x02A8E,  char = '⪎',  class = 'rel',       cs = 'gsime'                             } -- greater-than above similar or equal
  , { code = 0x02A8F,  char = '⪏',  class = 'rel',       cs = 'lsimg'                             } -- less-than above similar above greater-than
  , { code = 0x02A90,  char = '⪐',  class = 'rel',       cs = 'gsiml'                             } -- greater-than above similar above less-than
  , { code = 0x02A91,  char = '⪑',  class = 'rel',       cs = 'lgE'                               } -- less-than above greater-than above double-line equal
  , { code = 0x02A92,  char = '⪒',  class = 'rel',       cs = 'glE'                               } -- greater-than above less-than above double-line equal
  , { code = 0x02A93,  char = '⪓',  class = 'rel',       cs = 'lesges'                            } -- less-than above slanted equal above greater-than above slanted equal
  , { code = 0x02A94,  char = '⪔',  class = 'rel',       cs = 'gesles'                            } -- greater-than above slanted equal above less-than above slanted equal
  , { code = 0x02A95,  char = '⪕',  class = 'rel',       cs = 'eqslantless'                       } -- slanted equal to or less-than
  , { code = 0x02A96,  char = '⪖',  class = 'rel',       cs = 'eqslantgtr'                        } -- slanted equal to or greater-than
  , { code = 0x02A97,  char = '⪗',  class = 'rel',       cs = 'elsdot'                            } -- slanted equal to or less-than with dot inside
  , { code = 0x02A98,  char = '⪘',  class = 'rel',       cs = 'egsdot'                            } -- slanted equal to or greater-than with dot inside
  , { code = 0x02A99,  char = '⪙',  class = 'rel',       cs = 'eqqless'                           } -- double-line equal to or less-than
  , { code = 0x02A9A,  char = '⪚',  class = 'rel',       cs = 'eqqgtr'                            } -- double-line equal to or greater-than
  , { code = 0x02A9B,  char = '⪛',  class = 'rel',       cs = 'eqqslantless'                      } -- double-line slanted equal to or less-than
  , { code = 0x02A9C,  char = '⪜',  class = 'rel',       cs = 'eqqslantgtr'                       } -- double-line slanted equal to or greater-than
  , { code = 0x02A9D,  char = '⪝',  class = 'rel',       cs = 'simless'                           } -- similar or less-than
  , { code = 0x02A9E,  char = '⪞',  class = 'rel',       cs = 'simgtr'                            } -- similar or greater-than
  , { code = 0x02A9F,  char = '⪟',  class = 'rel',       cs = 'simlE'                             } -- similar above less-than above equals sign
  , { code = 0x02AA0,  char = '⪠',  class = 'rel',       cs = 'simgE'                             } -- similar above greater-than above equals sign
  , { code = 0x02AA1,  char = '⪡',  class = 'rel',       cs = 'Lt'                                } -- double nested less-than
  , { code = 0x02AA2,  char = '⪢',  class = 'rel',       cs = 'Gt'                                } -- double nested greater-than
  , { code = 0x02AA3,  char = '⪣',  class = 'rel',       cs = 'partialmeetcontraction'            } -- double nested less-than with underbar
  , { code = 0x02AA4,  char = '⪤',  class = 'rel',       cs = 'glj'                               } -- greater-than overlapping less-than
  , { code = 0x02AA5,  char = '⪥',  class = 'rel',       cs = 'gla'                               } -- greater-than beside less-than
  , { code = 0x02AA6,  char = '⪦',  class = 'rel',       cs = 'ltcc'                              } -- less-than closed by curve
  , { code = 0x02AA7,  char = '⪧',  class = 'rel',       cs = 'gtcc'                              } -- greater-than closed by curve
  , { code = 0x02AA8,  char = '⪨',  class = 'rel',       cs = 'lescc'                             } -- less-than closed by curve above slanted equal
  , { code = 0x02AA9,  char = '⪩',  class = 'rel',       cs = 'gescc'                             } -- greater-than closed by curve above slanted equal
  , { code = 0x02AAA,  char = '⪪',  class = 'rel',       cs = 'smt'                               } -- smaller than
  , { code = 0x02AAB,  char = '⪫',  class = 'rel',       cs = 'lat'                               } -- larger than
  , { code = 0x02AAC,  char = '⪬',  class = 'rel',       cs = 'smte'                              } -- smaller than or equal to
  , { code = 0x02AAD,  char = '⪭',  class = 'rel',       cs = 'late'                              } -- larger than or equal to
  , { code = 0x02AAE,  char = '⪮',  class = 'rel',       cs = 'bumpeqq'                           } -- equals sign with bumpy above
  , { code = 0x02AAF,  char = '⪯',  class = 'rel',       cs = 'preceq'                            } -- precedes above single-line equals sign
  , { code = 0x02AB0,  char = '⪰',  class = 'rel',       cs = 'succeq'                            } -- succeeds above single-line equals sign
  , { code = 0x02AB1,  char = '⪱',  class = 'rel',       cs = 'precneq'                           } -- precedes above single-line not equal to
  , { code = 0x02AB2,  char = '⪲',  class = 'rel',       cs = 'succneq'                           } -- succeeds above single-line not equal to
  , { code = 0x02AB3,  char = '⪳',  class = 'rel',       cs = 'preceqq'                           } -- precedes above equals sign
  , { code = 0x02AB4,  char = '⪴',  class = 'rel',       cs = 'succeqq'                           } -- succeeds above equals sign
  , { code = 0x02AB5,  char = '⪵',  class = 'rel',       cs = 'precneqq'                          } -- precedes above not equal to
  , { code = 0x02AB6,  char = '⪶',  class = 'rel',       cs = 'succneqq'                          } -- succeeds above not equal to
  , { code = 0x02AB7,  char = '⪷',  class = 'rel',       cs = 'precapprox'                        } -- precedes above almost equal to
  , { code = 0x02AB8,  char = '⪸',  class = 'rel',       cs = 'succapprox'                        } -- succeeds above almost equal to
  , { code = 0x02AB9,  char = '⪹',  class = 'rel',       cs = 'precnapprox'                       } -- precedes above not almost equal to
  , { code = 0x02ABA,  char = '⪺',  class = 'rel',       cs = 'succnapprox'                       } -- succeeds above not almost equal to
  , { code = 0x02ABB,  char = '⪻',  class = 'rel',       cs = 'Prec'                              } -- double precedes
  , { code = 0x02ABC,  char = '⪼',  class = 'rel',       cs = 'Succ'                              } -- double succeeds
  , { code = 0x02ABD,  char = '⪽',  class = 'rel',       cs = 'subsetdot'                         } -- subset with dot
  , { code = 0x02ABE,  char = '⪾',  class = 'rel',       cs = 'supsetdot'                         } -- superset with dot
  , { code = 0x02ABF,  char = '⪿',  class = 'rel',       cs = 'subsetplus'                        } -- subset with plus sign below
  , { code = 0x02AC0,  char = '⫀',  class = 'rel',       cs = 'supsetplus'                        } -- superset with plus sign below
  , { code = 0x02AC1,  char = '⫁',  class = 'rel',       cs = 'submult'                           } -- subset with multiplication sign below
  , { code = 0x02AC2,  char = '⫂',  class = 'rel',       cs = 'supmult'                           } -- superset with multiplication sign below
  , { code = 0x02AC3,  char = '⫃',  class = 'rel',       cs = 'subedot'                           } -- subset of or equal to with dot above
  , { code = 0x02AC4,  char = '⫄',  class = 'rel',       cs = 'supedot'                           } -- superset of or equal to with dot above
  , { code = 0x02AC5,  char = '⫅',  class = 'rel',       cs = 'subseteqq'                         } -- subset of above equals sign
  , { code = 0x02AC6,  char = '⫆',  class = 'rel',       cs = 'supseteqq'                         } -- superset of above equals sign
  , { code = 0x02AC7,  char = '⫇',  class = 'rel',       cs = 'subsim'                            } -- subset of above tilde operator
  , { code = 0x02AC8,  char = '⫈',  class = 'rel',       cs = 'supsim'                            } -- superset of above tilde operator
  , { code = 0x02AC9,  char = '⫉',  class = 'rel',       cs = 'subsetapprox'                      } -- subset of above almost equal to
  , { code = 0x02ACA,  char = '⫊',  class = 'rel',       cs = 'supsetapprox'                      } -- superset of above almost equal to
  , { code = 0x02ACB,  char = '⫋',  class = 'rel',       cs = 'subsetneqq'                        } -- subset of above not equal to
  , { code = 0x02ACC,  char = '⫌',  class = 'rel',       cs = 'supsetneqq'                        } -- superset of above not equal to
  , { code = 0x02ACD,  char = '⫍',  class = 'rel',       cs = 'lsqhook'                           } -- square left open box operator
  , { code = 0x02ACE,  char = '⫎',  class = 'rel',       cs = 'rsqhook'                           } -- square right open box operator
  , { code = 0x02ACF,  char = '⫏',  class = 'rel',       cs = 'csub'                              } -- closed subset
  , { code = 0x02AD0,  char = '⫐',  class = 'rel',       cs = 'csup'                              } -- closed superset
  , { code = 0x02AD1,  char = '⫑',  class = 'rel',       cs = 'csube'                             } -- closed subset or equal to
  , { code = 0x02AD2,  char = '⫒',  class = 'rel',       cs = 'csupe'                             } -- closed superset or equal to
  , { code = 0x02AD3,  char = '⫓',  class = 'rel',       cs = 'subsup'                            } -- subset above superset
  , { code = 0x02AD4,  char = '⫔',  class = 'rel',       cs = 'supsub'                            } -- superset above subset
  , { code = 0x02AD5,  char = '⫕',  class = 'rel',       cs = 'subsub'                            } -- subset above subset
  , { code = 0x02AD6,  char = '⫖',  class = 'rel',       cs = 'supsup'                            } -- superset above superset
  , { code = 0x02AD7,  char = '⫗',  class = 'rel',       cs = 'suphsub'                           } -- superset beside subset
  , { code = 0x02AD8,  char = '⫘',  class = 'rel',       cs = 'supdsub'                           } -- superset beside and joined by dash with subset
  , { code = 0x02AD9,  char = '⫙',  class = 'rel',       cs = 'forkv'                             } -- element of opening downwards
  , { code = 0x02ADA,  char = '⫚',  class = 'rel',       cs = 'topfork'                           } -- pitchfork with tee top
  , { code = 0x02ADB,  char = '⫛',  class = 'rel',       cs = 'mlcp'                              } -- transversal intersection
  , { code = 0x02ADC,  char = '⫝̸',  class = 'rel',       cs = 'forks'                             } -- forking
  , { code = 0x02ADD,  char = '⫝',  class = 'rel',       cs = 'forksnot'                          } -- nonforking
  , { code = 0x02ADE,  char = '⫞',  class = 'rel',       cs = 'shortlefttack'                     } -- short left tack
  , { code = 0x02ADF,  char = '⫟',  class = 'rel',       cs = 'shortdowntack'                     } -- short down tack
  , { code = 0x02AE0,  char = '⫠',  class = 'rel',       cs = 'shortuptack'                       } -- short up tack
  , { code = 0x02AE1,  char = '⫡',  class = 'ord',       cs = 'perps'                             } -- perpendicular with s
  , { code = 0x02AE2,  char = '⫢',  class = 'rel',       cs = 'vDdash'                            } -- vertical bar triple right turnstile
  , { code = 0x02AE3,  char = '⫣',  class = 'rel',       cs = 'dashV'                             } -- double vertical bar left turnstile
  , { code = 0x02AE4,  char = '⫤',  class = 'rel',       cs = 'Dashv'                             } -- vertical bar double left turnstile
  , { code = 0x02AE5,  char = '⫥',  class = 'rel',       cs = 'DashV'                             } -- double vertical bar double left turnstile
  , { code = 0x02AE6,  char = '⫦',  class = 'rel',       cs = 'varVdash'                          } -- long dash from left member of double vertical
  , { code = 0x02AE7,  char = '⫧',  class = 'rel',       cs = 'Barv'                              } -- short down tack with overbar
  , { code = 0x02AE8,  char = '⫨',  class = 'rel',       cs = 'vBar'                              } -- short up tack with underbar
  , { code = 0x02AE9,  char = '⫩',  class = 'rel',       cs = 'vBarv'                             } -- short up tack above short down tack
  , { code = 0x02AEA,  char = '⫪',  class = 'rel',       cs = 'barV'                              } -- double down tack
  , { code = 0x02AEB,  char = '⫫',  class = 'rel',       cs = 'Vbar'                              } -- double up tack
  , { code = 0x02AEC,  char = '⫬',  class = 'rel',       cs = 'Not'                               } -- double stroke not sign
  , { code = 0x02AED,  char = '⫭',  class = 'rel',       cs = 'bNot'                              } -- reversed double stroke not sign
  , { code = 0x02AEE,  char = '⫮',  class = 'rel',       cs = 'revnmid'                           } -- does not divide with reversed negation slash
  , { code = 0x02AEF,  char = '⫯',  class = 'rel',       cs = 'cirmid'                            } -- vertical line with circle above
  , { code = 0x02AF0,  char = '⫰',  class = 'rel',       cs = 'midcir'                            } -- vertical line with circle below
  , { code = 0x02AF1,  char = '⫱',  class = 'ord',       cs = 'topcir'                            } -- down tack with circle below
  , { code = 0x02AF2,  char = '⫲',  class = 'rel',       cs = 'nhpar'                             } -- parallel with horizontal stroke
  , { code = 0x02AF3,  char = '⫳',  class = 'rel',       cs = 'parsim'                            } -- parallel with tilde operator
  , { code = 0x02AF4,  char = '⫴',  class = 'bin',       cs = 'interleave'                        } -- triple vertical bar binary relation
  , { code = 0x02AF5,  char = '⫵',  class = 'bin',       cs = 'nhVvert'                           } -- triple vertical bar with horizontal stroke
  , { code = 0x02AF6,  char = '⫶',  class = 'bin',       cs = 'threedotcolon'                     } -- triple colon operator
  , { code = 0x02AF7,  char = '⫷',  class = 'rel',       cs = 'lllnest'                           } -- triple nested less-than
  , { code = 0x02AF8,  char = '⫸',  class = 'rel',       cs = 'gggnest'                           } -- triple nested greater-than
  , { code = 0x02AF9,  char = '⫹',  class = 'rel',       cs = 'leqqslant'                         } -- double-line slanted less-than or equal to
  , { code = 0x02AFA,  char = '⫺',  class = 'rel',       cs = 'geqqslant'                         } -- double-line slanted greater-than or equal to
  , { code = 0x02AFB,  char = '⫻',  class = 'bin',       cs = 'trslash'                           } -- triple solidus binary relation
  , { code = 0x02AFC,  char = '⫼',  class = 'op',        cs = 'biginterleave'                     } -- large triple vertical bar operator
  , { code = 0x02AFD,  char = '⫽',  class = 'bin',       cs = 'sslash'                            } -- double solidus operator
  , { code = 0x02AFE,  char = '⫾',  class = 'bin',       cs = 'talloblong'                        } -- white vertical bar
  , { code = 0x02AFF,  char = '⫿',  class = 'op',        cs = 'bigtalloblong'                     } -- n-ary white vertical bar
  , { code = 0x02B12,  char = '⬒',  class = 'ord',       cs = 'squaretopblack'                    } -- square with top half black
  , { code = 0x02B13,  char = '⬓',  class = 'ord',       cs = 'squarebotblack'                    } -- square with bottom half black
  , { code = 0x02B14,  char = '⬔',  class = 'ord',       cs = 'squareurblack'                     } -- square with upper right diagonal half black
  , { code = 0x02B15,  char = '⬕',  class = 'ord',       cs = 'squarellblack'                     } -- square with lower left diagonal half black
  , { code = 0x02B16,  char = '⬖',  class = 'ord',       cs = 'diamondleftblack'                  } -- diamond with left half black
  , { code = 0x02B17,  char = '⬗',  class = 'ord',       cs = 'diamondrightblack'                 } -- diamond with right half black
  , { code = 0x02B18,  char = '⬘',  class = 'ord',       cs = 'diamondtopblack'                   } -- diamond with top half black
  , { code = 0x02B19,  char = '⬙',  class = 'ord',       cs = 'diamondbotblack'                   } -- diamond with bottom half black
  , { code = 0x02B1A,  char = '⬚',  class = 'ord',       cs = 'dottedsquare'                      } -- dotted square
  , { code = 0x02B1B,  char = '⬛',  class = 'ord',       cs = 'lgblksquare'                       } -- black large square
  , { code = 0x02B1C,  char = '⬜',  class = 'ord',       cs = 'lgwhtsquare'                       } -- white large square
  , { code = 0x02B1D,  char = '⬝',  class = 'ord',       cs = 'vysmblksquare'                     } -- black very small square
  , { code = 0x02B1E,  char = '⬞',  class = 'ord',       cs = 'vysmwhtsquare'                     } -- white very small square
  , { code = 0x02B1F,  char = '⬟',  class = 'ord',       cs = 'pentagonblack'                     } -- black pentagon
  , { code = 0x02B20,  char = '⬠',  class = 'ord',       cs = 'pentagon'                          } -- white pentagon
  , { code = 0x02B21,  char = '⬡',  class = 'ord',       cs = 'varhexagon'                        } -- white hexagon
  , { code = 0x02B22,  char = '⬢',  class = 'ord',       cs = 'varhexagonblack'                   } -- black hexagon
  , { code = 0x02B23,  char = '⬣',  class = 'ord',       cs = 'hexagonblack'                      } -- horizontal black hexagon
  , { code = 0x02B24,  char = '⬤',  class = 'ord',       cs = 'lgblkcircle'                       } -- black large circle
  , { code = 0x02B25,  char = '⬥',  class = 'ord',       cs = 'mdblkdiamond'                      } -- black medium diamond
  , { code = 0x02B26,  char = '⬦',  class = 'ord',       cs = 'mdwhtdiamond'                      } -- white medium diamond
  , { code = 0x02B27,  char = '⬧',  class = 'ord',       cs = 'mdblklozenge'                      } -- black medium lozenge
  , { code = 0x02B28,  char = '⬨',  class = 'ord',       cs = 'mdwhtlozenge'                      } -- white medium lozenge
  , { code = 0x02B29,  char = '⬩',  class = 'ord',       cs = 'smblkdiamond'                      } -- black small diamond
  , { code = 0x02B2A,  char = '⬪',  class = 'ord',       cs = 'smblklozenge'                      } -- black small lozenge
  , { code = 0x02B2B,  char = '⬫',  class = 'ord',       cs = 'smwhtlozenge'                      } -- white small lozenge
  , { code = 0x02B2C,  char = '⬬',  class = 'ord',       cs = 'blkhorzoval'                       } -- black horizontal ellipse
  , { code = 0x02B2D,  char = '⬭',  class = 'ord',       cs = 'whthorzoval'                       } -- white horizontal ellipse
  , { code = 0x02B2E,  char = '⬮',  class = 'ord',       cs = 'blkvertoval'                       } -- black vertical ellipse
  , { code = 0x02B2F,  char = '⬯',  class = 'ord',       cs = 'whtvertoval'                       } -- white vertical ellipse
  , { code = 0x02B30,  char = '⬰',  class = 'rel',       cs = 'circleonleftarrow'                 } -- left arrow with small circle
  , { code = 0x02B31,  char = '⬱',  class = 'rel',       cs = 'leftthreearrows'                   } -- three leftwards arrows
  , { code = 0x02B32,  char = '⬲',  class = 'rel',       cs = 'leftarrowonoplus'                  } -- left arrow with circled plus
  , { code = 0x02B33,  char = '⬳',  class = 'rel',       cs = 'longleftsquigarrow'                } -- long leftwards squiggle arrow
  , { code = 0x02B34,  char = '⬴',  class = 'rel',       cs = 'nvtwoheadleftarrow'                } -- leftwards two-headed arrow with vertical stroke
  , { code = 0x02B35,  char = '⬵',  class = 'rel',       cs = 'nVtwoheadleftarrow'                } -- leftwards two-headed arrow with double vertical stroke
  , { code = 0x02B36,  char = '⬶',  class = 'rel',       cs = 'twoheadmapsfrom'                   } -- leftwards two-headed arrow from bar
  , { code = 0x02B37,  char = '⬷',  class = 'rel',       cs = 'twoheadleftdbkarrow'               } -- leftwards two-headed triple dash arrow
  , { code = 0x02B38,  char = '⬸',  class = 'rel',       cs = 'leftdotarrow'                      } -- leftwards arrow with dotted stem
  , { code = 0x02B39,  char = '⬹',  class = 'rel',       cs = 'nvleftarrowtail'                   } -- leftwards arrow with tail with vertical stroke
  , { code = 0x02B3A,  char = '⬺',  class = 'rel',       cs = 'nVleftarrowtail'                   } -- leftwards arrow with tail with double vertical stroke
  , { code = 0x02B3B,  char = '⬻',  class = 'rel',       cs = 'twoheadleftarrowtail'              } -- leftwards two-headed arrow with tail
  , { code = 0x02B3C,  char = '⬼',  class = 'rel',       cs = 'nvtwoheadleftarrowtail'            } -- leftwards two-headed arrow with tail with vertical stroke
  , { code = 0x02B3D,  char = '⬽',  class = 'rel',       cs = 'nVtwoheadleftarrowtail'            } -- leftwards two-headed arrow with tail with double vertical stroke
  , { code = 0x02B3E,  char = '⬾',  class = 'rel',       cs = 'leftarrowx'                        } -- leftwards arrow through x
  , { code = 0x02B3F,  char = '⬿',  class = 'rel',       cs = 'leftcurvedarrow'                   } -- wave arrow pointing directly left
  , { code = 0x02B40,  char = '⭀',  class = 'rel',       cs = 'equalleftarrow'                    } -- equals sign above leftwards arrow
  , { code = 0x02B41,  char = '⭁',  class = 'rel',       cs = 'bsimilarleftarrow'                 } -- reverse tilde operator above leftwards arrow
  , { code = 0x02B42,  char = '⭂',  class = 'rel',       cs = 'leftarrowbackapprox'               } -- leftwards arrow above reverse almost equal to
  , { code = 0x02B43,  char = '⭃',  class = 'rel',       cs = 'rightarrowgtr'                     } -- rightwards arrow through greater-than
  , { code = 0x02B44,  char = '⭄',  class = 'rel',       cs = 'rightarrowsupset'                  } -- rightwards arrow through superset
  , { code = 0x02B45,  char = '⭅',  class = 'rel',       cs = 'LLeftarrow'                        } -- leftwards quadruple arrow
  , { code = 0x02B46,  char = '⭆',  class = 'rel',       cs = 'RRightarrow'                       } -- rightwards quadruple arrow
  , { code = 0x02B47,  char = '⭇',  class = 'rel',       cs = 'bsimilarrightarrow'                } -- reverse tilde operator above rightwards arrow
  , { code = 0x02B48,  char = '⭈',  class = 'rel',       cs = 'rightarrowbackapprox'              } -- rightwards arrow above reverse almost equal to
  , { code = 0x02B49,  char = '⭉',  class = 'rel',       cs = 'similarleftarrow'                  } -- tilde operator above leftwards arrow
  , { code = 0x02B4A,  char = '⭊',  class = 'rel',       cs = 'leftarrowapprox'                   } -- leftwards arrow above almost equal to
  , { code = 0x02B4B,  char = '⭋',  class = 'rel',       cs = 'leftarrowbsimilar'                 } -- leftwards arrow above reverse tilde operator
  , { code = 0x02B4C,  char = '⭌',  class = 'rel',       cs = 'rightarrowbsimilar'                } -- rightwards arrow above reverse tilde operator
  , { code = 0x02B50,  char = '⭐',  class = 'ord',       cs = 'medwhitestar'                      } -- white medium star
  , { code = 0x02B51,  char = '⭑',  class = 'ord',       cs = 'medblackstar'                      } -- black small star
  , { code = 0x02B52,  char = '⭒',  class = 'ord',       cs = 'smwhitestar'                       } -- white small star
  , { code = 0x02B53,  char = '⭓',  class = 'ord',       cs = 'rightpentagonblack'                } -- black right-pointing pentagon
  , { code = 0x02B54,  char = '⭔',  class = 'ord',       cs = 'rightpentagon'                     } -- white right-pointing pentagon
  , { code = 0x03012,  char = '〒',  class = 'ord',       cs = 'postalmark'                        } -- postal mark
  , { code = 0x03014,  char = '〔',  class = 'open',      cs = 'lbrbrak'                           } -- left tortoise shell bracket
  , { code = 0x03015,  char = '〕',  class = 'close',     cs = 'rbrbrak'                           } -- right tortoise shell bracket
  , { code = 0x03018,  char = '〘',  class = 'open',      cs = 'Lbrbrak'                           } -- left white tortoise shell bracket
  , { code = 0x03019,  char = '〙',  class = 'close',     cs = 'Rbrbrak'                           } -- right white tortoise shell bracket
  , { code = 0x03030,  char = '〰',  class = 'ord',       cs = 'hzigzag'                           } -- wavy dash
  , { code = 0x1D400,  char = '𝐀',  class = 'ord',       cs = 'mbfA', alphabet = 'bold'           } -- mathematical bold capital a
  , { code = 0x1D401,  char = '𝐁',  class = 'ord',       cs = 'mbfB', alphabet = 'bold'           } -- mathematical bold capital b
  , { code = 0x1D402,  char = '𝐂',  class = 'ord',       cs = 'mbfC', alphabet = 'bold'           } -- mathematical bold capital c
  , { code = 0x1D403,  char = '𝐃',  class = 'ord',       cs = 'mbfD', alphabet = 'bold'           } -- mathematical bold capital d
  , { code = 0x1D404,  char = '𝐄',  class = 'ord',       cs = 'mbfE', alphabet = 'bold'           } -- mathematical bold capital e
  , { code = 0x1D405,  char = '𝐅',  class = 'ord',       cs = 'mbfF', alphabet = 'bold'           } -- mathematical bold capital f
  , { code = 0x1D406,  char = '𝐆',  class = 'ord',       cs = 'mbfG', alphabet = 'bold'           } -- mathematical bold capital g
  , { code = 0x1D407,  char = '𝐇',  class = 'ord',       cs = 'mbfH', alphabet = 'bold'           } -- mathematical bold capital h
  , { code = 0x1D408,  char = '𝐈',  class = 'ord',       cs = 'mbfI', alphabet = 'bold'           } -- mathematical bold capital i
  , { code = 0x1D409,  char = '𝐉',  class = 'ord',       cs = 'mbfJ', alphabet = 'bold'           } -- mathematical bold capital j
  , { code = 0x1D40A,  char = '𝐊',  class = 'ord',       cs = 'mbfK', alphabet = 'bold'           } -- mathematical bold capital k
  , { code = 0x1D40B,  char = '𝐋',  class = 'ord',       cs = 'mbfL', alphabet = 'bold'           } -- mathematical bold capital l
  , { code = 0x1D40C,  char = '𝐌',  class = 'ord',       cs = 'mbfM', alphabet = 'bold'           } -- mathematical bold capital m
  , { code = 0x1D40D,  char = '𝐍',  class = 'ord',       cs = 'mbfN', alphabet = 'bold'           } -- mathematical bold capital n
  , { code = 0x1D40E,  char = '𝐎',  class = 'ord',       cs = 'mbfO', alphabet = 'bold'           } -- mathematical bold capital o
  , { code = 0x1D40F,  char = '𝐏',  class = 'ord',       cs = 'mbfP', alphabet = 'bold'           } -- mathematical bold capital p
  , { code = 0x1D410,  char = '𝐐',  class = 'ord',       cs = 'mbfQ', alphabet = 'bold'           } -- mathematical bold capital q
  , { code = 0x1D411,  char = '𝐑',  class = 'ord',       cs = 'mbfR', alphabet = 'bold'           } -- mathematical bold capital r
  , { code = 0x1D412,  char = '𝐒',  class = 'ord',       cs = 'mbfS', alphabet = 'bold'           } -- mathematical bold capital s
  , { code = 0x1D413,  char = '𝐓',  class = 'ord',       cs = 'mbfT', alphabet = 'bold'           } -- mathematical bold capital t
  , { code = 0x1D414,  char = '𝐔',  class = 'ord',       cs = 'mbfU', alphabet = 'bold'           } -- mathematical bold capital u
  , { code = 0x1D415,  char = '𝐕',  class = 'ord',       cs = 'mbfV', alphabet = 'bold'           } -- mathematical bold capital v
  , { code = 0x1D416,  char = '𝐖',  class = 'ord',       cs = 'mbfW', alphabet = 'bold'           } -- mathematical bold capital w
  , { code = 0x1D417,  char = '𝐗',  class = 'ord',       cs = 'mbfX', alphabet = 'bold'           } -- mathematical bold capital x
  , { code = 0x1D418,  char = '𝐘',  class = 'ord',       cs = 'mbfY', alphabet = 'bold'           } -- mathematical bold capital y
  , { code = 0x1D419,  char = '𝐙',  class = 'ord',       cs = 'mbfZ', alphabet = 'bold'           } -- mathematical bold capital z
  , { code = 0x1D41A,  char = '𝐚',  class = 'ord',       cs = 'mbfa', alphabet = 'bold'           } -- mathematical bold small a
  , { code = 0x1D41B,  char = '𝐛',  class = 'ord',       cs = 'mbfb', alphabet = 'bold'           } -- mathematical bold small b
  , { code = 0x1D41C,  char = '𝐜',  class = 'ord',       cs = 'mbfc', alphabet = 'bold'           } -- mathematical bold small c
  , { code = 0x1D41D,  char = '𝐝',  class = 'ord',       cs = 'mbfd', alphabet = 'bold'           } -- mathematical bold small d
  , { code = 0x1D41E,  char = '𝐞',  class = 'ord',       cs = 'mbfe', alphabet = 'bold'           } -- mathematical bold small e
  , { code = 0x1D41F,  char = '𝐟',  class = 'ord',       cs = 'mbff', alphabet = 'bold'           } -- mathematical bold small f
  , { code = 0x1D420,  char = '𝐠',  class = 'ord',       cs = 'mbfg', alphabet = 'bold'           } -- mathematical bold small g
  , { code = 0x1D421,  char = '𝐡',  class = 'ord',       cs = 'mbfh', alphabet = 'bold'           } -- mathematical bold small h
  , { code = 0x1D422,  char = '𝐢',  class = 'ord',       cs = 'mbfi', alphabet = 'bold'           } -- mathematical bold small i
  , { code = 0x1D423,  char = '𝐣',  class = 'ord',       cs = 'mbfj', alphabet = 'bold'           } -- mathematical bold small j
  , { code = 0x1D424,  char = '𝐤',  class = 'ord',       cs = 'mbfk', alphabet = 'bold'           } -- mathematical bold small k
  , { code = 0x1D425,  char = '𝐥',  class = 'ord',       cs = 'mbfl', alphabet = 'bold'           } -- mathematical bold small l
  , { code = 0x1D426,  char = '𝐦',  class = 'ord',       cs = 'mbfm', alphabet = 'bold'           } -- mathematical bold small m
  , { code = 0x1D427,  char = '𝐧',  class = 'ord',       cs = 'mbfn', alphabet = 'bold'           } -- mathematical bold small n
  , { code = 0x1D428,  char = '𝐨',  class = 'ord',       cs = 'mbfo', alphabet = 'bold'           } -- mathematical bold small o
  , { code = 0x1D429,  char = '𝐩',  class = 'ord',       cs = 'mbfp', alphabet = 'bold'           } -- mathematical bold small p
  , { code = 0x1D42A,  char = '𝐪',  class = 'ord',       cs = 'mbfq', alphabet = 'bold'           } -- mathematical bold small q
  , { code = 0x1D42B,  char = '𝐫',  class = 'ord',       cs = 'mbfr', alphabet = 'bold'           } -- mathematical bold small r
  , { code = 0x1D42C,  char = '𝐬',  class = 'ord',       cs = 'mbfs', alphabet = 'bold'           } -- mathematical bold small s
  , { code = 0x1D42D,  char = '𝐭',  class = 'ord',       cs = 'mbft', alphabet = 'bold'           } -- mathematical bold small t
  , { code = 0x1D42E,  char = '𝐮',  class = 'ord',       cs = 'mbfu', alphabet = 'bold'           } -- mathematical bold small u
  , { code = 0x1D42F,  char = '𝐯',  class = 'ord',       cs = 'mbfv', alphabet = 'bold'           } -- mathematical bold small v
  , { code = 0x1D430,  char = '𝐰',  class = 'ord',       cs = 'mbfw', alphabet = 'bold'           } -- mathematical bold small w
  , { code = 0x1D431,  char = '𝐱',  class = 'ord',       cs = 'mbfx', alphabet = 'bold'           } -- mathematical bold small x
  , { code = 0x1D432,  char = '𝐲',  class = 'ord',       cs = 'mbfy', alphabet = 'bold'           } -- mathematical bold small y
  , { code = 0x1D433,  char = '𝐳',  class = 'ord',       cs = 'mbfz', alphabet = 'bold'           } -- mathematical bold small z
  , { code = 0x1D434,  char = '𝐴',  class = 'ord',       cs = 'mitA'                              } -- mathematical italic capital a
  , { code = 0x1D435,  char = '𝐵',  class = 'ord',       cs = 'mitB'                              } -- mathematical italic capital b
  , { code = 0x1D436,  char = '𝐶',  class = 'ord',       cs = 'mitC'                              } -- mathematical italic capital c
  , { code = 0x1D437,  char = '𝐷',  class = 'ord',       cs = 'mitD'                              } -- mathematical italic capital d
  , { code = 0x1D438,  char = '𝐸',  class = 'ord',       cs = 'mitE'                              } -- mathematical italic capital e
  , { code = 0x1D439,  char = '𝐹',  class = 'ord',       cs = 'mitF'                              } -- mathematical italic capital f
  , { code = 0x1D43A,  char = '𝐺',  class = 'ord',       cs = 'mitG'                              } -- mathematical italic capital g
  , { code = 0x1D43B,  char = '𝐻',  class = 'ord',       cs = 'mitH'                              } -- mathematical italic capital h
  , { code = 0x1D43C,  char = '𝐼',  class = 'ord',       cs = 'mitI'                              } -- mathematical italic capital i
  , { code = 0x1D43D,  char = '𝐽',  class = 'ord',       cs = 'mitJ'                              } -- mathematical italic capital j
  , { code = 0x1D43E,  char = '𝐾',  class = 'ord',       cs = 'mitK'                              } -- mathematical italic capital k
  , { code = 0x1D43F,  char = '𝐿',  class = 'ord',       cs = 'mitL'                              } -- mathematical italic capital l
  , { code = 0x1D440,  char = '𝑀',  class = 'ord',       cs = 'mitM'                              } -- mathematical italic capital m
  , { code = 0x1D441,  char = '𝑁',  class = 'ord',       cs = 'mitN'                              } -- mathematical italic capital n
  , { code = 0x1D442,  char = '𝑂',  class = 'ord',       cs = 'mitO'                              } -- mathematical italic capital o
  , { code = 0x1D443,  char = '𝑃',  class = 'ord',       cs = 'mitP'                              } -- mathematical italic capital p
  , { code = 0x1D444,  char = '𝑄',  class = 'ord',       cs = 'mitQ'                              } -- mathematical italic capital q
  , { code = 0x1D445,  char = '𝑅',  class = 'ord',       cs = 'mitR'                              } -- mathematical italic capital r
  , { code = 0x1D446,  char = '𝑆',  class = 'ord',       cs = 'mitS'                              } -- mathematical italic capital s
  , { code = 0x1D447,  char = '𝑇',  class = 'ord',       cs = 'mitT'                              } -- mathematical italic capital t
  , { code = 0x1D448,  char = '𝑈',  class = 'ord',       cs = 'mitU'                              } -- mathematical italic capital u
  , { code = 0x1D449,  char = '𝑉',  class = 'ord',       cs = 'mitV'                              } -- mathematical italic capital v
  , { code = 0x1D44A,  char = '𝑊',  class = 'ord',       cs = 'mitW'                              } -- mathematical italic capital w
  , { code = 0x1D44B,  char = '𝑋',  class = 'ord',       cs = 'mitX'                              } -- mathematical italic capital x
  , { code = 0x1D44C,  char = '𝑌',  class = 'ord',       cs = 'mitY'                              } -- mathematical italic capital y
  , { code = 0x1D44D,  char = '𝑍',  class = 'ord',       cs = 'mitZ'                              } -- mathematical italic capital z
  , { code = 0x1D44E,  char = '𝑎',  class = 'ord',       cs = 'mita'                              } -- mathematical italic small a
  , { code = 0x1D44F,  char = '𝑏',  class = 'ord',       cs = 'mitb'                              } -- mathematical italic small b
  , { code = 0x1D450,  char = '𝑐',  class = 'ord',       cs = 'mitc'                              } -- mathematical italic small c
  , { code = 0x1D451,  char = '𝑑',  class = 'ord',       cs = 'mitd'                              } -- mathematical italic small d
  , { code = 0x1D452,  char = '𝑒',  class = 'ord',       cs = 'mite'                              } -- mathematical italic small e
  , { code = 0x1D453,  char = '𝑓',  class = 'ord',       cs = 'mitf'                              } -- mathematical italic small f
  , { code = 0x1D454,  char = '𝑔',  class = 'ord',       cs = 'mitg'                              } -- mathematical italic small g
  , { code = 0x1D456,  char = '𝑖',  class = 'ord',       cs = 'miti'                              } -- mathematical italic small i
  , { code = 0x1D457,  char = '𝑗',  class = 'ord',       cs = 'mitj'                              } -- mathematical italic small j
  , { code = 0x1D458,  char = '𝑘',  class = 'ord',       cs = 'mitk'                              } -- mathematical italic small k
  , { code = 0x1D459,  char = '𝑙',  class = 'ord',       cs = 'mitl'                              } -- mathematical italic small l
  , { code = 0x1D45A,  char = '𝑚',  class = 'ord',       cs = 'mitm'                              } -- mathematical italic small m
  , { code = 0x1D45B,  char = '𝑛',  class = 'ord',       cs = 'mitn'                              } -- mathematical italic small n
  , { code = 0x1D45C,  char = '𝑜',  class = 'ord',       cs = 'mito'                              } -- mathematical italic small o
  , { code = 0x1D45D,  char = '𝑝',  class = 'ord',       cs = 'mitp'                              } -- mathematical italic small p
  , { code = 0x1D45E,  char = '𝑞',  class = 'ord',       cs = 'mitq'                              } -- mathematical italic small q
  , { code = 0x1D45F,  char = '𝑟',  class = 'ord',       cs = 'mitr'                              } -- mathematical italic small r
  , { code = 0x1D460,  char = '𝑠',  class = 'ord',       cs = 'mits'                              } -- mathematical italic small s
  , { code = 0x1D461,  char = '𝑡',  class = 'ord',       cs = 'mitt'                              } -- mathematical italic small t
  , { code = 0x1D462,  char = '𝑢',  class = 'ord',       cs = 'mitu'                              } -- mathematical italic small u
  , { code = 0x1D463,  char = '𝑣',  class = 'ord',       cs = 'mitv'                              } -- mathematical italic small v
  , { code = 0x1D464,  char = '𝑤',  class = 'ord',       cs = 'mitw'                              } -- mathematical italic small w
  , { code = 0x1D465,  char = '𝑥',  class = 'ord',       cs = 'mitx'                              } -- mathematical italic small x
  , { code = 0x1D466,  char = '𝑦',  class = 'ord',       cs = 'mity'                              } -- mathematical italic small y
  , { code = 0x1D467,  char = '𝑧',  class = 'ord',       cs = 'mitz'                              } -- mathematical italic small z
  , { code = 0x1D468,  char = '𝑨',  class = 'ord',       cs = 'mbfitA', alphabet = 'bold'         } -- mathematical bold italic capital a
  , { code = 0x1D469,  char = '𝑩',  class = 'ord',       cs = 'mbfitB', alphabet = 'bold'         } -- mathematical bold italic capital b
  , { code = 0x1D46A,  char = '𝑪',  class = 'ord',       cs = 'mbfitC', alphabet = 'bold'         } -- mathematical bold italic capital c
  , { code = 0x1D46B,  char = '𝑫',  class = 'ord',       cs = 'mbfitD', alphabet = 'bold'         } -- mathematical bold italic capital d
  , { code = 0x1D46C,  char = '𝑬',  class = 'ord',       cs = 'mbfitE', alphabet = 'bold'         } -- mathematical bold italic capital e
  , { code = 0x1D46D,  char = '𝑭',  class = 'ord',       cs = 'mbfitF', alphabet = 'bold'         } -- mathematical bold italic capital f
  , { code = 0x1D46E,  char = '𝑮',  class = 'ord',       cs = 'mbfitG', alphabet = 'bold'         } -- mathematical bold italic capital g
  , { code = 0x1D46F,  char = '𝑯',  class = 'ord',       cs = 'mbfitH', alphabet = 'bold'         } -- mathematical bold italic capital h
  , { code = 0x1D470,  char = '𝑰',  class = 'ord',       cs = 'mbfitI', alphabet = 'bold'         } -- mathematical bold italic capital i
  , { code = 0x1D471,  char = '𝑱',  class = 'ord',       cs = 'mbfitJ', alphabet = 'bold'         } -- mathematical bold italic capital j
  , { code = 0x1D472,  char = '𝑲',  class = 'ord',       cs = 'mbfitK', alphabet = 'bold'         } -- mathematical bold italic capital k
  , { code = 0x1D473,  char = '𝑳',  class = 'ord',       cs = 'mbfitL', alphabet = 'bold'         } -- mathematical bold italic capital l
  , { code = 0x1D474,  char = '𝑴',  class = 'ord',       cs = 'mbfitM', alphabet = 'bold'         } -- mathematical bold italic capital m
  , { code = 0x1D475,  char = '𝑵',  class = 'ord',       cs = 'mbfitN', alphabet = 'bold'         } -- mathematical bold italic capital n
  , { code = 0x1D476,  char = '𝑶',  class = 'ord',       cs = 'mbfitO', alphabet = 'bold'         } -- mathematical bold italic capital o
  , { code = 0x1D477,  char = '𝑷',  class = 'ord',       cs = 'mbfitP', alphabet = 'bold'         } -- mathematical bold italic capital p
  , { code = 0x1D478,  char = '𝑸',  class = 'ord',       cs = 'mbfitQ', alphabet = 'bold'         } -- mathematical bold italic capital q
  , { code = 0x1D479,  char = '𝑹',  class = 'ord',       cs = 'mbfitR', alphabet = 'bold'         } -- mathematical bold italic capital r
  , { code = 0x1D47A,  char = '𝑺',  class = 'ord',       cs = 'mbfitS', alphabet = 'bold'         } -- mathematical bold italic capital s
  , { code = 0x1D47B,  char = '𝑻',  class = 'ord',       cs = 'mbfitT', alphabet = 'bold'         } -- mathematical bold italic capital t
  , { code = 0x1D47C,  char = '𝑼',  class = 'ord',       cs = 'mbfitU', alphabet = 'bold'         } -- mathematical bold italic capital u
  , { code = 0x1D47D,  char = '𝑽',  class = 'ord',       cs = 'mbfitV', alphabet = 'bold'         } -- mathematical bold italic capital v
  , { code = 0x1D47E,  char = '𝑾',  class = 'ord',       cs = 'mbfitW', alphabet = 'bold'         } -- mathematical bold italic capital w
  , { code = 0x1D47F,  char = '𝑿',  class = 'ord',       cs = 'mbfitX', alphabet = 'bold'         } -- mathematical bold italic capital x
  , { code = 0x1D480,  char = '𝒀',  class = 'ord',       cs = 'mbfitY', alphabet = 'bold'         } -- mathematical bold italic capital y
  , { code = 0x1D481,  char = '𝒁',  class = 'ord',       cs = 'mbfitZ', alphabet = 'bold'         } -- mathematical bold italic capital z
  , { code = 0x1D482,  char = '𝒂',  class = 'ord',       cs = 'mbfita', alphabet = 'bold'         } -- mathematical bold italic small a
  , { code = 0x1D483,  char = '𝒃',  class = 'ord',       cs = 'mbfitb', alphabet = 'bold'         } -- mathematical bold italic small b
  , { code = 0x1D484,  char = '𝒄',  class = 'ord',       cs = 'mbfitc', alphabet = 'bold'         } -- mathematical bold italic small c
  , { code = 0x1D485,  char = '𝒅',  class = 'ord',       cs = 'mbfitd', alphabet = 'bold'         } -- mathematical bold italic small d
  , { code = 0x1D486,  char = '𝒆',  class = 'ord',       cs = 'mbfite', alphabet = 'bold'         } -- mathematical bold italic small e
  , { code = 0x1D487,  char = '𝒇',  class = 'ord',       cs = 'mbfitf', alphabet = 'bold'         } -- mathematical bold italic small f
  , { code = 0x1D488,  char = '𝒈',  class = 'ord',       cs = 'mbfitg', alphabet = 'bold'         } -- mathematical bold italic small g
  , { code = 0x1D489,  char = '𝒉',  class = 'ord',       cs = 'mbfith', alphabet = 'bold'         } -- mathematical bold italic small h
  , { code = 0x1D48A,  char = '𝒊',  class = 'ord',       cs = 'mbfiti', alphabet = 'bold'         } -- mathematical bold italic small i
  , { code = 0x1D48B,  char = '𝒋',  class = 'ord',       cs = 'mbfitj', alphabet = 'bold'         } -- mathematical bold italic small j
  , { code = 0x1D48C,  char = '𝒌',  class = 'ord',       cs = 'mbfitk', alphabet = 'bold'         } -- mathematical bold italic small k
  , { code = 0x1D48D,  char = '𝒍',  class = 'ord',       cs = 'mbfitl', alphabet = 'bold'         } -- mathematical bold italic small l
  , { code = 0x1D48E,  char = '𝒎',  class = 'ord',       cs = 'mbfitm', alphabet = 'bold'         } -- mathematical bold italic small m
  , { code = 0x1D48F,  char = '𝒏',  class = 'ord',       cs = 'mbfitn', alphabet = 'bold'         } -- mathematical bold italic small n
  , { code = 0x1D490,  char = '𝒐',  class = 'ord',       cs = 'mbfito', alphabet = 'bold'         } -- mathematical bold italic small o
  , { code = 0x1D491,  char = '𝒑',  class = 'ord',       cs = 'mbfitp', alphabet = 'bold'         } -- mathematical bold italic small p
  , { code = 0x1D492,  char = '𝒒',  class = 'ord',       cs = 'mbfitq', alphabet = 'bold'         } -- mathematical bold italic small q
  , { code = 0x1D493,  char = '𝒓',  class = 'ord',       cs = 'mbfitr', alphabet = 'bold'         } -- mathematical bold italic small r
  , { code = 0x1D494,  char = '𝒔',  class = 'ord',       cs = 'mbfits', alphabet = 'bold'         } -- mathematical bold italic small s
  , { code = 0x1D495,  char = '𝒕',  class = 'ord',       cs = 'mbfitt', alphabet = 'bold'         } -- mathematical bold italic small t
  , { code = 0x1D496,  char = '𝒖',  class = 'ord',       cs = 'mbfitu', alphabet = 'bold'         } -- mathematical bold italic small u
  , { code = 0x1D497,  char = '𝒗',  class = 'ord',       cs = 'mbfitv', alphabet = 'bold'         } -- mathematical bold italic small v
  , { code = 0x1D498,  char = '𝒘',  class = 'ord',       cs = 'mbfitw', alphabet = 'bold'         } -- mathematical bold italic small w
  , { code = 0x1D499,  char = '𝒙',  class = 'ord',       cs = 'mbfitx', alphabet = 'bold'         } -- mathematical bold italic small x
  , { code = 0x1D49A,  char = '𝒚',  class = 'ord',       cs = 'mbfity', alphabet = 'bold'         } -- mathematical bold italic small y
  , { code = 0x1D49B,  char = '𝒛',  class = 'ord',       cs = 'mbfitz', alphabet = 'bold'         } -- mathematical bold italic small z
  , { code = 0x1D49C,  char = '𝒜',  class = 'ord',       cs = 'mscrA', alphabet = 'script'        } -- mathematical script capital a
  , { code = 0x1D49E,  char = '𝒞',  class = 'ord',       cs = 'mscrC', alphabet = 'script'        } -- mathematical script capital c
  , { code = 0x1D49F,  char = '𝒟',  class = 'ord',       cs = 'mscrD', alphabet = 'script'        } -- mathematical script capital d
  , { code = 0x1D4A2,  char = '𝒢',  class = 'ord',       cs = 'mscrG', alphabet = 'script'        } -- mathematical script capital g
  , { code = 0x1D4A5,  char = '𝒥',  class = 'ord',       cs = 'mscrJ', alphabet = 'script'        } -- mathematical script capital j
  , { code = 0x1D4A6,  char = '𝒦',  class = 'ord',       cs = 'mscrK', alphabet = 'script'        } -- mathematical script capital k
  , { code = 0x1D4A9,  char = '𝒩',  class = 'ord',       cs = 'mscrN', alphabet = 'script'        } -- mathematical script capital n
  , { code = 0x1D4AA,  char = '𝒪',  class = 'ord',       cs = 'mscrO', alphabet = 'script'        } -- mathematical script capital o
  , { code = 0x1D4AB,  char = '𝒫',  class = 'ord',       cs = 'mscrP', alphabet = 'script'        } -- mathematical script capital p
  , { code = 0x1D4AC,  char = '𝒬',  class = 'ord',       cs = 'mscrQ', alphabet = 'script'        } -- mathematical script capital q
  , { code = 0x1D4AE,  char = '𝒮',  class = 'ord',       cs = 'mscrS', alphabet = 'script'        } -- mathematical script capital s
  , { code = 0x1D4AF,  char = '𝒯',  class = 'ord',       cs = 'mscrT', alphabet = 'script'        } -- mathematical script capital t
  , { code = 0x1D4B0,  char = '𝒰',  class = 'ord',       cs = 'mscrU', alphabet = 'script'        } -- mathematical script capital u
  , { code = 0x1D4B1,  char = '𝒱',  class = 'ord',       cs = 'mscrV', alphabet = 'script'        } -- mathematical script capital v
  , { code = 0x1D4B2,  char = '𝒲',  class = 'ord',       cs = 'mscrW', alphabet = 'script'        } -- mathematical script capital w
  , { code = 0x1D4B3,  char = '𝒳',  class = 'ord',       cs = 'mscrX', alphabet = 'script'        } -- mathematical script capital x
  , { code = 0x1D4B4,  char = '𝒴',  class = 'ord',       cs = 'mscrY', alphabet = 'script'        } -- mathematical script capital y
  , { code = 0x1D4B5,  char = '𝒵',  class = 'ord',       cs = 'mscrZ', alphabet = 'script'        } -- mathematical script capital z
  , { code = 0x1D4B6,  char = '𝒶',  class = 'ord',       cs = 'mscra', alphabet = 'script'        } -- mathematical script small a
  , { code = 0x1D4B7,  char = '𝒷',  class = 'ord',       cs = 'mscrb', alphabet = 'script'        } -- mathematical script small b
  , { code = 0x1D4B8,  char = '𝒸',  class = 'ord',       cs = 'mscrc', alphabet = 'script'        } -- mathematical script small c
  , { code = 0x1D4B9,  char = '𝒹',  class = 'ord',       cs = 'mscrd', alphabet = 'script'        } -- mathematical script small d
  , { code = 0x1D4BB,  char = '𝒻',  class = 'ord',       cs = 'mscrf', alphabet = 'script'        } -- mathematical script small f
  , { code = 0x1D4BD,  char = '𝒽',  class = 'ord',       cs = 'mscrh', alphabet = 'script'        } -- mathematical script small h
  , { code = 0x1D4BE,  char = '𝒾',  class = 'ord',       cs = 'mscri', alphabet = 'script'        } -- mathematical script small i
  , { code = 0x1D4BF,  char = '𝒿',  class = 'ord',       cs = 'mscrj', alphabet = 'script'        } -- mathematical script small j
  , { code = 0x1D4C0,  char = '𝓀',  class = 'ord',       cs = 'mscrk', alphabet = 'script'        } -- mathematical script small k
  , { code = 0x1D4C1,  char = '𝓁',  class = 'ord',       cs = 'mscrl', alphabet = 'script'        } -- mathematical script small l
  , { code = 0x1D4C2,  char = '𝓂',  class = 'ord',       cs = 'mscrm', alphabet = 'script'        } -- mathematical script small m
  , { code = 0x1D4C3,  char = '𝓃',  class = 'ord',       cs = 'mscrn', alphabet = 'script'        } -- mathematical script small n
  , { code = 0x1D4C5,  char = '𝓅',  class = 'ord',       cs = 'mscrp', alphabet = 'script'        } -- mathematical script small p
  , { code = 0x1D4C6,  char = '𝓆',  class = 'ord',       cs = 'mscrq', alphabet = 'script'        } -- mathematical script small q
  , { code = 0x1D4C7,  char = '𝓇',  class = 'ord',       cs = 'mscrr', alphabet = 'script'        } -- mathematical script small r
  , { code = 0x1D4C8,  char = '𝓈',  class = 'ord',       cs = 'mscrs', alphabet = 'script'        } -- mathematical script small s
  , { code = 0x1D4C9,  char = '𝓉',  class = 'ord',       cs = 'mscrt', alphabet = 'script'        } -- mathematical script small t
  , { code = 0x1D4CA,  char = '𝓊',  class = 'ord',       cs = 'mscru', alphabet = 'script'        } -- mathematical script small u
  , { code = 0x1D4CB,  char = '𝓋',  class = 'ord',       cs = 'mscrv', alphabet = 'script'        } -- mathematical script small v
  , { code = 0x1D4CC,  char = '𝓌',  class = 'ord',       cs = 'mscrw', alphabet = 'script'        } -- mathematical script small w
  , { code = 0x1D4CD,  char = '𝓍',  class = 'ord',       cs = 'mscrx', alphabet = 'script'        } -- mathematical script small x
  , { code = 0x1D4CE,  char = '𝓎',  class = 'ord',       cs = 'mscry', alphabet = 'script'        } -- mathematical script small y
  , { code = 0x1D4CF,  char = '𝓏',  class = 'ord',       cs = 'mscrz', alphabet = 'script'        } -- mathematical script small z
  , { code = 0x1D4D0,  char = '𝓐',  class = 'ord',       cs = 'mbfscrA', alphabet = 'script'      } -- mathematical bold script capital a
  , { code = 0x1D4D1,  char = '𝓑',  class = 'ord',       cs = 'mbfscrB', alphabet = 'script'      } -- mathematical bold script capital b
  , { code = 0x1D4D2,  char = '𝓒',  class = 'ord',       cs = 'mbfscrC', alphabet = 'script'      } -- mathematical bold script capital c
  , { code = 0x1D4D3,  char = '𝓓',  class = 'ord',       cs = 'mbfscrD', alphabet = 'script'      } -- mathematical bold script capital d
  , { code = 0x1D4D4,  char = '𝓔',  class = 'ord',       cs = 'mbfscrE', alphabet = 'script'      } -- mathematical bold script capital e
  , { code = 0x1D4D5,  char = '𝓕',  class = 'ord',       cs = 'mbfscrF', alphabet = 'script'      } -- mathematical bold script capital f
  , { code = 0x1D4D6,  char = '𝓖',  class = 'ord',       cs = 'mbfscrG', alphabet = 'script'      } -- mathematical bold script capital g
  , { code = 0x1D4D7,  char = '𝓗',  class = 'ord',       cs = 'mbfscrH', alphabet = 'script'      } -- mathematical bold script capital h
  , { code = 0x1D4D8,  char = '𝓘',  class = 'ord',       cs = 'mbfscrI', alphabet = 'script'      } -- mathematical bold script capital i
  , { code = 0x1D4D9,  char = '𝓙',  class = 'ord',       cs = 'mbfscrJ', alphabet = 'script'      } -- mathematical bold script capital j
  , { code = 0x1D4DA,  char = '𝓚',  class = 'ord',       cs = 'mbfscrK', alphabet = 'script'      } -- mathematical bold script capital k
  , { code = 0x1D4DB,  char = '𝓛',  class = 'ord',       cs = 'mbfscrL', alphabet = 'script'      } -- mathematical bold script capital l
  , { code = 0x1D4DC,  char = '𝓜',  class = 'ord',       cs = 'mbfscrM', alphabet = 'script'      } -- mathematical bold script capital m
  , { code = 0x1D4DD,  char = '𝓝',  class = 'ord',       cs = 'mbfscrN', alphabet = 'script'      } -- mathematical bold script capital n
  , { code = 0x1D4DE,  char = '𝓞',  class = 'ord',       cs = 'mbfscrO', alphabet = 'script'      } -- mathematical bold script capital o
  , { code = 0x1D4DF,  char = '𝓟',  class = 'ord',       cs = 'mbfscrP', alphabet = 'script'      } -- mathematical bold script capital p
  , { code = 0x1D4E0,  char = '𝓠',  class = 'ord',       cs = 'mbfscrQ', alphabet = 'script'      } -- mathematical bold script capital q
  , { code = 0x1D4E1,  char = '𝓡',  class = 'ord',       cs = 'mbfscrR', alphabet = 'script'      } -- mathematical bold script capital r
  , { code = 0x1D4E2,  char = '𝓢',  class = 'ord',       cs = 'mbfscrS', alphabet = 'script'      } -- mathematical bold script capital s
  , { code = 0x1D4E3,  char = '𝓣',  class = 'ord',       cs = 'mbfscrT', alphabet = 'script'      } -- mathematical bold script capital t
  , { code = 0x1D4E4,  char = '𝓤',  class = 'ord',       cs = 'mbfscrU', alphabet = 'script'      } -- mathematical bold script capital u
  , { code = 0x1D4E5,  char = '𝓥',  class = 'ord',       cs = 'mbfscrV', alphabet = 'script'      } -- mathematical bold script capital v
  , { code = 0x1D4E6,  char = '𝓦',  class = 'ord',       cs = 'mbfscrW', alphabet = 'script'      } -- mathematical bold script capital w
  , { code = 0x1D4E7,  char = '𝓧',  class = 'ord',       cs = 'mbfscrX', alphabet = 'script'      } -- mathematical bold script capital x
  , { code = 0x1D4E8,  char = '𝓨',  class = 'ord',       cs = 'mbfscrY', alphabet = 'script'      } -- mathematical bold script capital y
  , { code = 0x1D4E9,  char = '𝓩',  class = 'ord',       cs = 'mbfscrZ', alphabet = 'script'      } -- mathematical bold script capital z
  , { code = 0x1D4EA,  char = '𝓪',  class = 'ord',       cs = 'mbfscra', alphabet = 'script'      } -- mathematical bold script small a
  , { code = 0x1D4EB,  char = '𝓫',  class = 'ord',       cs = 'mbfscrb', alphabet = 'script'      } -- mathematical bold script small b
  , { code = 0x1D4EC,  char = '𝓬',  class = 'ord',       cs = 'mbfscrc', alphabet = 'script'      } -- mathematical bold script small c
  , { code = 0x1D4ED,  char = '𝓭',  class = 'ord',       cs = 'mbfscrd', alphabet = 'script'      } -- mathematical bold script small d
  , { code = 0x1D4EE,  char = '𝓮',  class = 'ord',       cs = 'mbfscre', alphabet = 'script'      } -- mathematical bold script small e
  , { code = 0x1D4EF,  char = '𝓯',  class = 'ord',       cs = 'mbfscrf', alphabet = 'script'      } -- mathematical bold script small f
  , { code = 0x1D4F0,  char = '𝓰',  class = 'ord',       cs = 'mbfscrg', alphabet = 'script'      } -- mathematical bold script small g
  , { code = 0x1D4F1,  char = '𝓱',  class = 'ord',       cs = 'mbfscrh', alphabet = 'script'      } -- mathematical bold script small h
  , { code = 0x1D4F2,  char = '𝓲',  class = 'ord',       cs = 'mbfscri', alphabet = 'script'      } -- mathematical bold script small i
  , { code = 0x1D4F3,  char = '𝓳',  class = 'ord',       cs = 'mbfscrj', alphabet = 'script'      } -- mathematical bold script small j
  , { code = 0x1D4F4,  char = '𝓴',  class = 'ord',       cs = 'mbfscrk', alphabet = 'script'      } -- mathematical bold script small k
  , { code = 0x1D4F5,  char = '𝓵',  class = 'ord',       cs = 'mbfscrl', alphabet = 'script'      } -- mathematical bold script small l
  , { code = 0x1D4F6,  char = '𝓶',  class = 'ord',       cs = 'mbfscrm', alphabet = 'script'      } -- mathematical bold script small m
  , { code = 0x1D4F7,  char = '𝓷',  class = 'ord',       cs = 'mbfscrn', alphabet = 'script'      } -- mathematical bold script small n
  , { code = 0x1D4F8,  char = '𝓸',  class = 'ord',       cs = 'mbfscro', alphabet = 'script'      } -- mathematical bold script small o
  , { code = 0x1D4F9,  char = '𝓹',  class = 'ord',       cs = 'mbfscrp', alphabet = 'script'      } -- mathematical bold script small p
  , { code = 0x1D4FA,  char = '𝓺',  class = 'ord',       cs = 'mbfscrq', alphabet = 'script'      } -- mathematical bold script small q
  , { code = 0x1D4FB,  char = '𝓻',  class = 'ord',       cs = 'mbfscrr', alphabet = 'script'      } -- mathematical bold script small r
  , { code = 0x1D4FC,  char = '𝓼',  class = 'ord',       cs = 'mbfscrs', alphabet = 'script'      } -- mathematical bold script small s
  , { code = 0x1D4FD,  char = '𝓽',  class = 'ord',       cs = 'mbfscrt', alphabet = 'script'      } -- mathematical bold script small t
  , { code = 0x1D4FE,  char = '𝓾',  class = 'ord',       cs = 'mbfscru', alphabet = 'script'      } -- mathematical bold script small u
  , { code = 0x1D4FF,  char = '𝓿',  class = 'ord',       cs = 'mbfscrv', alphabet = 'script'      } -- mathematical bold script small v
  , { code = 0x1D500,  char = '𝔀',  class = 'ord',       cs = 'mbfscrw', alphabet = 'script'      } -- mathematical bold script small w
  , { code = 0x1D501,  char = '𝔁',  class = 'ord',       cs = 'mbfscrx', alphabet = 'script'      } -- mathematical bold script small x
  , { code = 0x1D502,  char = '𝔂',  class = 'ord',       cs = 'mbfscry', alphabet = 'script'      } -- mathematical bold script small y
  , { code = 0x1D503,  char = '𝔃',  class = 'ord',       cs = 'mbfscrz', alphabet = 'script'      } -- mathematical bold script small z
  , { code = 0x1D504,  char = '𝔄',  class = 'ord',       cs = 'mfrakA', alphabet = 'fraktur'      } -- mathematical fraktur capital a
  , { code = 0x1D505,  char = '𝔅',  class = 'ord',       cs = 'mfrakB', alphabet = 'fraktur'      } -- mathematical fraktur capital b
  , { code = 0x1D507,  char = '𝔇',  class = 'ord',       cs = 'mfrakD', alphabet = 'fraktur'      } -- mathematical fraktur capital d
  , { code = 0x1D508,  char = '𝔈',  class = 'ord',       cs = 'mfrakE', alphabet = 'fraktur'      } -- mathematical fraktur capital e
  , { code = 0x1D509,  char = '𝔉',  class = 'ord',       cs = 'mfrakF', alphabet = 'fraktur'      } -- mathematical fraktur capital f
  , { code = 0x1D50A,  char = '𝔊',  class = 'ord',       cs = 'mfrakG', alphabet = 'fraktur'      } -- mathematical fraktur capital g
  , { code = 0x1D50D,  char = '𝔍',  class = 'ord',       cs = 'mfrakJ', alphabet = 'fraktur'      } -- mathematical fraktur capital j
  , { code = 0x1D50E,  char = '𝔎',  class = 'ord',       cs = 'mfrakK', alphabet = 'fraktur'      } -- mathematical fraktur capital k
  , { code = 0x1D50F,  char = '𝔏',  class = 'ord',       cs = 'mfrakL', alphabet = 'fraktur'      } -- mathematical fraktur capital l
  , { code = 0x1D510,  char = '𝔐',  class = 'ord',       cs = 'mfrakM', alphabet = 'fraktur'      } -- mathematical fraktur capital m
  , { code = 0x1D511,  char = '𝔑',  class = 'ord',       cs = 'mfrakN', alphabet = 'fraktur'      } -- mathematical fraktur capital n
  , { code = 0x1D512,  char = '𝔒',  class = 'ord',       cs = 'mfrakO', alphabet = 'fraktur'      } -- mathematical fraktur capital o
  , { code = 0x1D513,  char = '𝔓',  class = 'ord',       cs = 'mfrakP', alphabet = 'fraktur'      } -- mathematical fraktur capital p
  , { code = 0x1D514,  char = '𝔔',  class = 'ord',       cs = 'mfrakQ', alphabet = 'fraktur'      } -- mathematical fraktur capital q
  , { code = 0x1D516,  char = '𝔖',  class = 'ord',       cs = 'mfrakS', alphabet = 'fraktur'      } -- mathematical fraktur capital s
  , { code = 0x1D517,  char = '𝔗',  class = 'ord',       cs = 'mfrakT', alphabet = 'fraktur'      } -- mathematical fraktur capital t
  , { code = 0x1D518,  char = '𝔘',  class = 'ord',       cs = 'mfrakU', alphabet = 'fraktur'      } -- mathematical fraktur capital u
  , { code = 0x1D519,  char = '𝔙',  class = 'ord',       cs = 'mfrakV', alphabet = 'fraktur'      } -- mathematical fraktur capital v
  , { code = 0x1D51A,  char = '𝔚',  class = 'ord',       cs = 'mfrakW', alphabet = 'fraktur'      } -- mathematical fraktur capital w
  , { code = 0x1D51B,  char = '𝔛',  class = 'ord',       cs = 'mfrakX', alphabet = 'fraktur'      } -- mathematical fraktur capital x
  , { code = 0x1D51C,  char = '𝔜',  class = 'ord',       cs = 'mfrakY', alphabet = 'fraktur'      } -- mathematical fraktur capital y
  , { code = 0x1D51E,  char = '𝔞',  class = 'ord',       cs = 'mfraka', alphabet = 'fraktur'      } -- mathematical fraktur small a
  , { code = 0x1D51F,  char = '𝔟',  class = 'ord',       cs = 'mfrakb', alphabet = 'fraktur'      } -- mathematical fraktur small b
  , { code = 0x1D520,  char = '𝔠',  class = 'ord',       cs = 'mfrakc', alphabet = 'fraktur'      } -- mathematical fraktur small c
  , { code = 0x1D521,  char = '𝔡',  class = 'ord',       cs = 'mfrakd', alphabet = 'fraktur'      } -- mathematical fraktur small d
  , { code = 0x1D522,  char = '𝔢',  class = 'ord',       cs = 'mfrake', alphabet = 'fraktur'      } -- mathematical fraktur small e
  , { code = 0x1D523,  char = '𝔣',  class = 'ord',       cs = 'mfrakf', alphabet = 'fraktur'      } -- mathematical fraktur small f
  , { code = 0x1D524,  char = '𝔤',  class = 'ord',       cs = 'mfrakg', alphabet = 'fraktur'      } -- mathematical fraktur small g
  , { code = 0x1D525,  char = '𝔥',  class = 'ord',       cs = 'mfrakh', alphabet = 'fraktur'      } -- mathematical fraktur small h
  , { code = 0x1D526,  char = '𝔦',  class = 'ord',       cs = 'mfraki', alphabet = 'fraktur'      } -- mathematical fraktur small i
  , { code = 0x1D527,  char = '𝔧',  class = 'ord',       cs = 'mfrakj', alphabet = 'fraktur'      } -- mathematical fraktur small j
  , { code = 0x1D528,  char = '𝔨',  class = 'ord',       cs = 'mfrakk', alphabet = 'fraktur'      } -- mathematical fraktur small k
  , { code = 0x1D529,  char = '𝔩',  class = 'ord',       cs = 'mfrakl', alphabet = 'fraktur'      } -- mathematical fraktur small l
  , { code = 0x1D52A,  char = '𝔪',  class = 'ord',       cs = 'mfrakm', alphabet = 'fraktur'      } -- mathematical fraktur small m
  , { code = 0x1D52B,  char = '𝔫',  class = 'ord',       cs = 'mfrakn', alphabet = 'fraktur'      } -- mathematical fraktur small n
  , { code = 0x1D52C,  char = '𝔬',  class = 'ord',       cs = 'mfrako', alphabet = 'fraktur'      } -- mathematical fraktur small o
  , { code = 0x1D52D,  char = '𝔭',  class = 'ord',       cs = 'mfrakp', alphabet = 'fraktur'      } -- mathematical fraktur small p
  , { code = 0x1D52E,  char = '𝔮',  class = 'ord',       cs = 'mfrakq', alphabet = 'fraktur'      } -- mathematical fraktur small q
  , { code = 0x1D52F,  char = '𝔯',  class = 'ord',       cs = 'mfrakr', alphabet = 'fraktur'      } -- mathematical fraktur small r
  , { code = 0x1D530,  char = '𝔰',  class = 'ord',       cs = 'mfraks', alphabet = 'fraktur'      } -- mathematical fraktur small s
  , { code = 0x1D531,  char = '𝔱',  class = 'ord',       cs = 'mfrakt', alphabet = 'fraktur'      } -- mathematical fraktur small t
  , { code = 0x1D532,  char = '𝔲',  class = 'ord',       cs = 'mfraku', alphabet = 'fraktur'      } -- mathematical fraktur small u
  , { code = 0x1D533,  char = '𝔳',  class = 'ord',       cs = 'mfrakv', alphabet = 'fraktur'      } -- mathematical fraktur small v
  , { code = 0x1D534,  char = '𝔴',  class = 'ord',       cs = 'mfrakw', alphabet = 'fraktur'      } -- mathematical fraktur small w
  , { code = 0x1D535,  char = '𝔵',  class = 'ord',       cs = 'mfrakx', alphabet = 'fraktur'      } -- mathematical fraktur small x
  , { code = 0x1D536,  char = '𝔶',  class = 'ord',       cs = 'mfraky', alphabet = 'fraktur'      } -- mathematical fraktur small y
  , { code = 0x1D537,  char = '𝔷',  class = 'ord',       cs = 'mfrakz', alphabet = 'fraktur'      } -- mathematical fraktur small z
  , { code = 0x1D538,  char = '𝔸',  class = 'ord',       cs = 'BbbA', alphabet = 'blackboard'     } -- mathematical double-struck capital a
  , { code = 0x1D539,  char = '𝔹',  class = 'ord',       cs = 'BbbB', alphabet = 'blackboard'     } -- mathematical double-struck capital b
  , { code = 0x1D53B,  char = '𝔻',  class = 'ord',       cs = 'BbbD', alphabet = 'blackboard'     } -- mathematical double-struck capital d
  , { code = 0x1D53C,  char = '𝔼',  class = 'ord',       cs = 'BbbE', alphabet = 'blackboard'     } -- mathematical double-struck capital e
  , { code = 0x1D53D,  char = '𝔽',  class = 'ord',       cs = 'BbbF', alphabet = 'blackboard'     } -- mathematical double-struck capital f
  , { code = 0x1D53E,  char = '𝔾',  class = 'ord',       cs = 'BbbG', alphabet = 'blackboard'     } -- mathematical double-struck capital g
  , { code = 0x1D540,  char = '𝕀',  class = 'ord',       cs = 'BbbI', alphabet = 'blackboard'     } -- mathematical double-struck capital i
  , { code = 0x1D541,  char = '𝕁',  class = 'ord',       cs = 'BbbJ', alphabet = 'blackboard'     } -- mathematical double-struck capital j
  , { code = 0x1D542,  char = '𝕂',  class = 'ord',       cs = 'BbbK', alphabet = 'blackboard'     } -- mathematical double-struck capital k
  , { code = 0x1D543,  char = '𝕃',  class = 'ord',       cs = 'BbbL', alphabet = 'blackboard'     } -- mathematical double-struck capital l
  , { code = 0x1D544,  char = '𝕄',  class = 'ord',       cs = 'BbbM', alphabet = 'blackboard'     } -- mathematical double-struck capital m
  , { code = 0x1D546,  char = '𝕆',  class = 'ord',       cs = 'BbbO', alphabet = 'blackboard'     } -- mathematical double-struck capital o
  , { code = 0x1D54A,  char = '𝕊',  class = 'ord',       cs = 'BbbS', alphabet = 'blackboard'     } -- mathematical double-struck capital s
  , { code = 0x1D54B,  char = '𝕋',  class = 'ord',       cs = 'BbbT', alphabet = 'blackboard'     } -- mathematical double-struck capital t
  , { code = 0x1D54C,  char = '𝕌',  class = 'ord',       cs = 'BbbU', alphabet = 'blackboard'     } -- mathematical double-struck capital u
  , { code = 0x1D54D,  char = '𝕍',  class = 'ord',       cs = 'BbbV', alphabet = 'blackboard'     } -- mathematical double-struck capital v
  , { code = 0x1D54E,  char = '𝕎',  class = 'ord',       cs = 'BbbW', alphabet = 'blackboard'     } -- mathematical double-struck capital w
  , { code = 0x1D54F,  char = '𝕏',  class = 'ord',       cs = 'BbbX', alphabet = 'blackboard'     } -- mathematical double-struck capital x
  , { code = 0x1D550,  char = '𝕐',  class = 'ord',       cs = 'BbbY', alphabet = 'blackboard'     } -- mathematical double-struck capital y
  , { code = 0x1D552,  char = '𝕒',  class = 'ord',       cs = 'Bbba', alphabet = 'blackboard'     } -- mathematical double-struck small a
  , { code = 0x1D553,  char = '𝕓',  class = 'ord',       cs = 'Bbbb', alphabet = 'blackboard'     } -- mathematical double-struck small b
  , { code = 0x1D554,  char = '𝕔',  class = 'ord',       cs = 'Bbbc', alphabet = 'blackboard'     } -- mathematical double-struck small c
  , { code = 0x1D555,  char = '𝕕',  class = 'ord',       cs = 'Bbbd', alphabet = 'blackboard'     } -- mathematical double-struck small d
  , { code = 0x1D556,  char = '𝕖',  class = 'ord',       cs = 'Bbbe', alphabet = 'blackboard'     } -- mathematical double-struck small e
  , { code = 0x1D557,  char = '𝕗',  class = 'ord',       cs = 'Bbbf', alphabet = 'blackboard'     } -- mathematical double-struck small f
  , { code = 0x1D558,  char = '𝕘',  class = 'ord',       cs = 'Bbbg', alphabet = 'blackboard'     } -- mathematical double-struck small g
  , { code = 0x1D559,  char = '𝕙',  class = 'ord',       cs = 'Bbbh', alphabet = 'blackboard'     } -- mathematical double-struck small h
  , { code = 0x1D55A,  char = '𝕚',  class = 'ord',       cs = 'Bbbi', alphabet = 'blackboard'     } -- mathematical double-struck small i
  , { code = 0x1D55B,  char = '𝕛',  class = 'ord',       cs = 'Bbbj', alphabet = 'blackboard'     } -- mathematical double-struck small j
  , { code = 0x1D55C,  char = '𝕜',  class = 'ord',       cs = 'Bbbk', alphabet = 'blackboard'     } -- mathematical double-struck small k
  , { code = 0x1D55D,  char = '𝕝',  class = 'ord',       cs = 'Bbbl', alphabet = 'blackboard'     } -- mathematical double-struck small l
  , { code = 0x1D55E,  char = '𝕞',  class = 'ord',       cs = 'Bbbm', alphabet = 'blackboard'     } -- mathematical double-struck small m
  , { code = 0x1D55F,  char = '𝕟',  class = 'ord',       cs = 'Bbbn', alphabet = 'blackboard'     } -- mathematical double-struck small n
  , { code = 0x1D560,  char = '𝕠',  class = 'ord',       cs = 'Bbbo', alphabet = 'blackboard'     } -- mathematical double-struck small o
  , { code = 0x1D561,  char = '𝕡',  class = 'ord',       cs = 'Bbbp', alphabet = 'blackboard'     } -- mathematical double-struck small p
  , { code = 0x1D562,  char = '𝕢',  class = 'ord',       cs = 'Bbbq', alphabet = 'blackboard'     } -- mathematical double-struck small q
  , { code = 0x1D563,  char = '𝕣',  class = 'ord',       cs = 'Bbbr', alphabet = 'blackboard'     } -- mathematical double-struck small r
  , { code = 0x1D564,  char = '𝕤',  class = 'ord',       cs = 'Bbbs', alphabet = 'blackboard'     } -- mathematical double-struck small s
  , { code = 0x1D565,  char = '𝕥',  class = 'ord',       cs = 'Bbbt', alphabet = 'blackboard'     } -- mathematical double-struck small t
  , { code = 0x1D566,  char = '𝕦',  class = 'ord',       cs = 'Bbbu', alphabet = 'blackboard'     } -- mathematical double-struck small u
  , { code = 0x1D567,  char = '𝕧',  class = 'ord',       cs = 'Bbbv', alphabet = 'blackboard'     } -- mathematical double-struck small v
  , { code = 0x1D568,  char = '𝕨',  class = 'ord',       cs = 'Bbbw', alphabet = 'blackboard'     } -- mathematical double-struck small w
  , { code = 0x1D569,  char = '𝕩',  class = 'ord',       cs = 'Bbbx', alphabet = 'blackboard'     } -- mathematical double-struck small x
  , { code = 0x1D56A,  char = '𝕪',  class = 'ord',       cs = 'Bbby', alphabet = 'blackboard'     } -- mathematical double-struck small y
  , { code = 0x1D56B,  char = '𝕫',  class = 'ord',       cs = 'Bbbz', alphabet = 'blackboard'     } -- mathematical double-struck small z
  , { code = 0x1D56C,  char = '𝕬',  class = 'ord',       cs = 'mbffrakA', alphabet = 'fraktur'    } -- mathematical bold fraktur capital a
  , { code = 0x1D56D,  char = '𝕭',  class = 'ord',       cs = 'mbffrakB', alphabet = 'fraktur'    } -- mathematical bold fraktur capital b
  , { code = 0x1D56E,  char = '𝕮',  class = 'ord',       cs = 'mbffrakC', alphabet = 'fraktur'    } -- mathematical bold fraktur capital c
  , { code = 0x1D56F,  char = '𝕯',  class = 'ord',       cs = 'mbffrakD', alphabet = 'fraktur'    } -- mathematical bold fraktur capital d
  , { code = 0x1D570,  char = '𝕰',  class = 'ord',       cs = 'mbffrakE', alphabet = 'fraktur'    } -- mathematical bold fraktur capital e
  , { code = 0x1D571,  char = '𝕱',  class = 'ord',       cs = 'mbffrakF', alphabet = 'fraktur'    } -- mathematical bold fraktur capital f
  , { code = 0x1D572,  char = '𝕲',  class = 'ord',       cs = 'mbffrakG', alphabet = 'fraktur'    } -- mathematical bold fraktur capital g
  , { code = 0x1D573,  char = '𝕳',  class = 'ord',       cs = 'mbffrakH', alphabet = 'fraktur'    } -- mathematical bold fraktur capital h
  , { code = 0x1D574,  char = '𝕴',  class = 'ord',       cs = 'mbffrakI', alphabet = 'fraktur'    } -- mathematical bold fraktur capital i
  , { code = 0x1D575,  char = '𝕵',  class = 'ord',       cs = 'mbffrakJ', alphabet = 'fraktur'    } -- mathematical bold fraktur capital j
  , { code = 0x1D576,  char = '𝕶',  class = 'ord',       cs = 'mbffrakK', alphabet = 'fraktur'    } -- mathematical bold fraktur capital k
  , { code = 0x1D577,  char = '𝕷',  class = 'ord',       cs = 'mbffrakL', alphabet = 'fraktur'    } -- mathematical bold fraktur capital l
  , { code = 0x1D578,  char = '𝕸',  class = 'ord',       cs = 'mbffrakM', alphabet = 'fraktur'    } -- mathematical bold fraktur capital m
  , { code = 0x1D579,  char = '𝕹',  class = 'ord',       cs = 'mbffrakN', alphabet = 'fraktur'    } -- mathematical bold fraktur capital n
  , { code = 0x1D57A,  char = '𝕺',  class = 'ord',       cs = 'mbffrakO', alphabet = 'fraktur'    } -- mathematical bold fraktur capital o
  , { code = 0x1D57B,  char = '𝕻',  class = 'ord',       cs = 'mbffrakP', alphabet = 'fraktur'    } -- mathematical bold fraktur capital p
  , { code = 0x1D57C,  char = '𝕼',  class = 'ord',       cs = 'mbffrakQ', alphabet = 'fraktur'    } -- mathematical bold fraktur capital q
  , { code = 0x1D57D,  char = '𝕽',  class = 'ord',       cs = 'mbffrakR', alphabet = 'fraktur'    } -- mathematical bold fraktur capital r
  , { code = 0x1D57E,  char = '𝕾',  class = 'ord',       cs = 'mbffrakS', alphabet = 'fraktur'    } -- mathematical bold fraktur capital s
  , { code = 0x1D57F,  char = '𝕿',  class = 'ord',       cs = 'mbffrakT', alphabet = 'fraktur'    } -- mathematical bold fraktur capital t
  , { code = 0x1D580,  char = '𝖀',  class = 'ord',       cs = 'mbffrakU', alphabet = 'fraktur'    } -- mathematical bold fraktur capital u
  , { code = 0x1D581,  char = '𝖁',  class = 'ord',       cs = 'mbffrakV', alphabet = 'fraktur'    } -- mathematical bold fraktur capital v
  , { code = 0x1D582,  char = '𝖂',  class = 'ord',       cs = 'mbffrakW', alphabet = 'fraktur'    } -- mathematical bold fraktur capital w
  , { code = 0x1D583,  char = '𝖃',  class = 'ord',       cs = 'mbffrakX', alphabet = 'fraktur'    } -- mathematical bold fraktur capital x
  , { code = 0x1D584,  char = '𝖄',  class = 'ord',       cs = 'mbffrakY', alphabet = 'fraktur'    } -- mathematical bold fraktur capital y
  , { code = 0x1D585,  char = '𝖅',  class = 'ord',       cs = 'mbffrakZ', alphabet = 'fraktur'    } -- mathematical bold fraktur capital z
  , { code = 0x1D586,  char = '𝖆',  class = 'ord',       cs = 'mbffraka', alphabet = 'fraktur'    } -- mathematical bold fraktur small a
  , { code = 0x1D587,  char = '𝖇',  class = 'ord',       cs = 'mbffrakb', alphabet = 'fraktur'    } -- mathematical bold fraktur small b
  , { code = 0x1D588,  char = '𝖈',  class = 'ord',       cs = 'mbffrakc', alphabet = 'fraktur'    } -- mathematical bold fraktur small c
  , { code = 0x1D589,  char = '𝖉',  class = 'ord',       cs = 'mbffrakd', alphabet = 'fraktur'    } -- mathematical bold fraktur small d
  , { code = 0x1D58A,  char = '𝖊',  class = 'ord',       cs = 'mbffrake', alphabet = 'fraktur'    } -- mathematical bold fraktur small e
  , { code = 0x1D58B,  char = '𝖋',  class = 'ord',       cs = 'mbffrakf', alphabet = 'fraktur'    } -- mathematical bold fraktur small f
  , { code = 0x1D58C,  char = '𝖌',  class = 'ord',       cs = 'mbffrakg', alphabet = 'fraktur'    } -- mathematical bold fraktur small g
  , { code = 0x1D58D,  char = '𝖍',  class = 'ord',       cs = 'mbffrakh', alphabet = 'fraktur'    } -- mathematical bold fraktur small h
  , { code = 0x1D58E,  char = '𝖎',  class = 'ord',       cs = 'mbffraki', alphabet = 'fraktur'    } -- mathematical bold fraktur small i
  , { code = 0x1D58F,  char = '𝖏',  class = 'ord',       cs = 'mbffrakj', alphabet = 'fraktur'    } -- mathematical bold fraktur small j
  , { code = 0x1D590,  char = '𝖐',  class = 'ord',       cs = 'mbffrakk', alphabet = 'fraktur'    } -- mathematical bold fraktur small k
  , { code = 0x1D591,  char = '𝖑',  class = 'ord',       cs = 'mbffrakl', alphabet = 'fraktur'    } -- mathematical bold fraktur small l
  , { code = 0x1D592,  char = '𝖒',  class = 'ord',       cs = 'mbffrakm', alphabet = 'fraktur'    } -- mathematical bold fraktur small m
  , { code = 0x1D593,  char = '𝖓',  class = 'ord',       cs = 'mbffrakn', alphabet = 'fraktur'    } -- mathematical bold fraktur small n
  , { code = 0x1D594,  char = '𝖔',  class = 'ord',       cs = 'mbffrako', alphabet = 'fraktur'    } -- mathematical bold fraktur small o
  , { code = 0x1D595,  char = '𝖕',  class = 'ord',       cs = 'mbffrakp', alphabet = 'fraktur'    } -- mathematical bold fraktur small p
  , { code = 0x1D596,  char = '𝖖',  class = 'ord',       cs = 'mbffrakq', alphabet = 'fraktur'    } -- mathematical bold fraktur small q
  , { code = 0x1D597,  char = '𝖗',  class = 'ord',       cs = 'mbffrakr', alphabet = 'fraktur'    } -- mathematical bold fraktur small r
  , { code = 0x1D598,  char = '𝖘',  class = 'ord',       cs = 'mbffraks', alphabet = 'fraktur'    } -- mathematical bold fraktur small s
  , { code = 0x1D599,  char = '𝖙',  class = 'ord',       cs = 'mbffrakt', alphabet = 'fraktur'    } -- mathematical bold fraktur small t
  , { code = 0x1D59A,  char = '𝖚',  class = 'ord',       cs = 'mbffraku', alphabet = 'fraktur'    } -- mathematical bold fraktur small u
  , { code = 0x1D59B,  char = '𝖛',  class = 'ord',       cs = 'mbffrakv', alphabet = 'fraktur'    } -- mathematical bold fraktur small v
  , { code = 0x1D59C,  char = '𝖜',  class = 'ord',       cs = 'mbffrakw', alphabet = 'fraktur'    } -- mathematical bold fraktur small w
  , { code = 0x1D59D,  char = '𝖝',  class = 'ord',       cs = 'mbffrakx', alphabet = 'fraktur'    } -- mathematical bold fraktur small x
  , { code = 0x1D59E,  char = '𝖞',  class = 'ord',       cs = 'mbffraky', alphabet = 'fraktur'    } -- mathematical bold fraktur small y
  , { code = 0x1D59F,  char = '𝖟',  class = 'ord',       cs = 'mbffrakz', alphabet = 'fraktur'    } -- mathematical bold fraktur small z
  , { code = 0x1D5A0,  char = '𝖠',  class = 'ord',       cs = 'msansA', alphabet = 'sans'         } -- mathematical sans-serif capital a
  , { code = 0x1D5A1,  char = '𝖡',  class = 'ord',       cs = 'msansB', alphabet = 'sans'         } -- mathematical sans-serif capital b
  , { code = 0x1D5A2,  char = '𝖢',  class = 'ord',       cs = 'msansC', alphabet = 'sans'         } -- mathematical sans-serif capital c
  , { code = 0x1D5A3,  char = '𝖣',  class = 'ord',       cs = 'msansD', alphabet = 'sans'         } -- mathematical sans-serif capital d
  , { code = 0x1D5A4,  char = '𝖤',  class = 'ord',       cs = 'msansE', alphabet = 'sans'         } -- mathematical sans-serif capital e
  , { code = 0x1D5A5,  char = '𝖥',  class = 'ord',       cs = 'msansF', alphabet = 'sans'         } -- mathematical sans-serif capital f
  , { code = 0x1D5A6,  char = '𝖦',  class = 'ord',       cs = 'msansG', alphabet = 'sans'         } -- mathematical sans-serif capital g
  , { code = 0x1D5A7,  char = '𝖧',  class = 'ord',       cs = 'msansH', alphabet = 'sans'         } -- mathematical sans-serif capital h
  , { code = 0x1D5A8,  char = '𝖨',  class = 'ord',       cs = 'msansI', alphabet = 'sans'         } -- mathematical sans-serif capital i
  , { code = 0x1D5A9,  char = '𝖩',  class = 'ord',       cs = 'msansJ', alphabet = 'sans'         } -- mathematical sans-serif capital j
  , { code = 0x1D5AA,  char = '𝖪',  class = 'ord',       cs = 'msansK', alphabet = 'sans'         } -- mathematical sans-serif capital k
  , { code = 0x1D5AB,  char = '𝖫',  class = 'ord',       cs = 'msansL', alphabet = 'sans'         } -- mathematical sans-serif capital l
  , { code = 0x1D5AC,  char = '𝖬',  class = 'ord',       cs = 'msansM', alphabet = 'sans'         } -- mathematical sans-serif capital m
  , { code = 0x1D5AD,  char = '𝖭',  class = 'ord',       cs = 'msansN', alphabet = 'sans'         } -- mathematical sans-serif capital n
  , { code = 0x1D5AE,  char = '𝖮',  class = 'ord',       cs = 'msansO', alphabet = 'sans'         } -- mathematical sans-serif capital o
  , { code = 0x1D5AF,  char = '𝖯',  class = 'ord',       cs = 'msansP', alphabet = 'sans'         } -- mathematical sans-serif capital p
  , { code = 0x1D5B0,  char = '𝖰',  class = 'ord',       cs = 'msansQ', alphabet = 'sans'         } -- mathematical sans-serif capital q
  , { code = 0x1D5B1,  char = '𝖱',  class = 'ord',       cs = 'msansR', alphabet = 'sans'         } -- mathematical sans-serif capital r
  , { code = 0x1D5B2,  char = '𝖲',  class = 'ord',       cs = 'msansS', alphabet = 'sans'         } -- mathematical sans-serif capital s
  , { code = 0x1D5B3,  char = '𝖳',  class = 'ord',       cs = 'msansT', alphabet = 'sans'         } -- mathematical sans-serif capital t
  , { code = 0x1D5B4,  char = '𝖴',  class = 'ord',       cs = 'msansU', alphabet = 'sans'         } -- mathematical sans-serif capital u
  , { code = 0x1D5B5,  char = '𝖵',  class = 'ord',       cs = 'msansV', alphabet = 'sans'         } -- mathematical sans-serif capital v
  , { code = 0x1D5B6,  char = '𝖶',  class = 'ord',       cs = 'msansW', alphabet = 'sans'         } -- mathematical sans-serif capital w
  , { code = 0x1D5B7,  char = '𝖷',  class = 'ord',       cs = 'msansX', alphabet = 'sans'         } -- mathematical sans-serif capital x
  , { code = 0x1D5B8,  char = '𝖸',  class = 'ord',       cs = 'msansY', alphabet = 'sans'         } -- mathematical sans-serif capital y
  , { code = 0x1D5B9,  char = '𝖹',  class = 'ord',       cs = 'msansZ', alphabet = 'sans'         } -- mathematical sans-serif capital z
  , { code = 0x1D5BA,  char = '𝖺',  class = 'ord',       cs = 'msansa', alphabet = 'sans'         } -- mathematical sans-serif small a
  , { code = 0x1D5BB,  char = '𝖻',  class = 'ord',       cs = 'msansb', alphabet = 'sans'         } -- mathematical sans-serif small b
  , { code = 0x1D5BC,  char = '𝖼',  class = 'ord',       cs = 'msansc', alphabet = 'sans'         } -- mathematical sans-serif small c
  , { code = 0x1D5BD,  char = '𝖽',  class = 'ord',       cs = 'msansd', alphabet = 'sans'         } -- mathematical sans-serif small d
  , { code = 0x1D5BE,  char = '𝖾',  class = 'ord',       cs = 'msanse', alphabet = 'sans'         } -- mathematical sans-serif small e
  , { code = 0x1D5BF,  char = '𝖿',  class = 'ord',       cs = 'msansf', alphabet = 'sans'         } -- mathematical sans-serif small f
  , { code = 0x1D5C0,  char = '𝗀',  class = 'ord',       cs = 'msansg', alphabet = 'sans'         } -- mathematical sans-serif small g
  , { code = 0x1D5C1,  char = '𝗁',  class = 'ord',       cs = 'msansh', alphabet = 'sans'         } -- mathematical sans-serif small h
  , { code = 0x1D5C2,  char = '𝗂',  class = 'ord',       cs = 'msansi', alphabet = 'sans'         } -- mathematical sans-serif small i
  , { code = 0x1D5C3,  char = '𝗃',  class = 'ord',       cs = 'msansj', alphabet = 'sans'         } -- mathematical sans-serif small j
  , { code = 0x1D5C4,  char = '𝗄',  class = 'ord',       cs = 'msansk', alphabet = 'sans'         } -- mathematical sans-serif small k
  , { code = 0x1D5C5,  char = '𝗅',  class = 'ord',       cs = 'msansl', alphabet = 'sans'         } -- mathematical sans-serif small l
  , { code = 0x1D5C6,  char = '𝗆',  class = 'ord',       cs = 'msansm', alphabet = 'sans'         } -- mathematical sans-serif small m
  , { code = 0x1D5C7,  char = '𝗇',  class = 'ord',       cs = 'msansn', alphabet = 'sans'         } -- mathematical sans-serif small n
  , { code = 0x1D5C8,  char = '𝗈',  class = 'ord',       cs = 'msanso', alphabet = 'sans'         } -- mathematical sans-serif small o
  , { code = 0x1D5C9,  char = '𝗉',  class = 'ord',       cs = 'msansp', alphabet = 'sans'         } -- mathematical sans-serif small p
  , { code = 0x1D5CA,  char = '𝗊',  class = 'ord',       cs = 'msansq', alphabet = 'sans'         } -- mathematical sans-serif small q
  , { code = 0x1D5CB,  char = '𝗋',  class = 'ord',       cs = 'msansr', alphabet = 'sans'         } -- mathematical sans-serif small r
  , { code = 0x1D5CC,  char = '𝗌',  class = 'ord',       cs = 'msanss', alphabet = 'sans'         } -- mathematical sans-serif small s
  , { code = 0x1D5CD,  char = '𝗍',  class = 'ord',       cs = 'msanst', alphabet = 'sans'         } -- mathematical sans-serif small t
  , { code = 0x1D5CE,  char = '𝗎',  class = 'ord',       cs = 'msansu', alphabet = 'sans'         } -- mathematical sans-serif small u
  , { code = 0x1D5CF,  char = '𝗏',  class = 'ord',       cs = 'msansv', alphabet = 'sans'         } -- mathematical sans-serif small v
  , { code = 0x1D5D0,  char = '𝗐',  class = 'ord',       cs = 'msansw', alphabet = 'sans'         } -- mathematical sans-serif small w
  , { code = 0x1D5D1,  char = '𝗑',  class = 'ord',       cs = 'msansx', alphabet = 'sans'         } -- mathematical sans-serif small x
  , { code = 0x1D5D2,  char = '𝗒',  class = 'ord',       cs = 'msansy', alphabet = 'sans'         } -- mathematical sans-serif small y
  , { code = 0x1D5D3,  char = '𝗓',  class = 'ord',       cs = 'msansz', alphabet = 'sans'         } -- mathematical sans-serif small z
  , { code = 0x1D5D4,  char = '𝗔',  class = 'ord',       cs = 'mbfsansA', alphabet = 'sans'       } -- mathematical sans-serif bold capital a
  , { code = 0x1D5D5,  char = '𝗕',  class = 'ord',       cs = 'mbfsansB', alphabet = 'sans'       } -- mathematical sans-serif bold capital b
  , { code = 0x1D5D6,  char = '𝗖',  class = 'ord',       cs = 'mbfsansC', alphabet = 'sans'       } -- mathematical sans-serif bold capital c
  , { code = 0x1D5D7,  char = '𝗗',  class = 'ord',       cs = 'mbfsansD', alphabet = 'sans'       } -- mathematical sans-serif bold capital d
  , { code = 0x1D5D8,  char = '𝗘',  class = 'ord',       cs = 'mbfsansE', alphabet = 'sans'       } -- mathematical sans-serif bold capital e
  , { code = 0x1D5D9,  char = '𝗙',  class = 'ord',       cs = 'mbfsansF', alphabet = 'sans'       } -- mathematical sans-serif bold capital f
  , { code = 0x1D5DA,  char = '𝗚',  class = 'ord',       cs = 'mbfsansG', alphabet = 'sans'       } -- mathematical sans-serif bold capital g
  , { code = 0x1D5DB,  char = '𝗛',  class = 'ord',       cs = 'mbfsansH', alphabet = 'sans'       } -- mathematical sans-serif bold capital h
  , { code = 0x1D5DC,  char = '𝗜',  class = 'ord',       cs = 'mbfsansI', alphabet = 'sans'       } -- mathematical sans-serif bold capital i
  , { code = 0x1D5DD,  char = '𝗝',  class = 'ord',       cs = 'mbfsansJ', alphabet = 'sans'       } -- mathematical sans-serif bold capital j
  , { code = 0x1D5DE,  char = '𝗞',  class = 'ord',       cs = 'mbfsansK', alphabet = 'sans'       } -- mathematical sans-serif bold capital k
  , { code = 0x1D5DF,  char = '𝗟',  class = 'ord',       cs = 'mbfsansL', alphabet = 'sans'       } -- mathematical sans-serif bold capital l
  , { code = 0x1D5E0,  char = '𝗠',  class = 'ord',       cs = 'mbfsansM', alphabet = 'sans'       } -- mathematical sans-serif bold capital m
  , { code = 0x1D5E1,  char = '𝗡',  class = 'ord',       cs = 'mbfsansN', alphabet = 'sans'       } -- mathematical sans-serif bold capital n
  , { code = 0x1D5E2,  char = '𝗢',  class = 'ord',       cs = 'mbfsansO', alphabet = 'sans'       } -- mathematical sans-serif bold capital o
  , { code = 0x1D5E3,  char = '𝗣',  class = 'ord',       cs = 'mbfsansP', alphabet = 'sans'       } -- mathematical sans-serif bold capital p
  , { code = 0x1D5E4,  char = '𝗤',  class = 'ord',       cs = 'mbfsansQ', alphabet = 'sans'       } -- mathematical sans-serif bold capital q
  , { code = 0x1D5E5,  char = '𝗥',  class = 'ord',       cs = 'mbfsansR', alphabet = 'sans'       } -- mathematical sans-serif bold capital r
  , { code = 0x1D5E6,  char = '𝗦',  class = 'ord',       cs = 'mbfsansS', alphabet = 'sans'       } -- mathematical sans-serif bold capital s
  , { code = 0x1D5E7,  char = '𝗧',  class = 'ord',       cs = 'mbfsansT', alphabet = 'sans'       } -- mathematical sans-serif bold capital t
  , { code = 0x1D5E8,  char = '𝗨',  class = 'ord',       cs = 'mbfsansU', alphabet = 'sans'       } -- mathematical sans-serif bold capital u
  , { code = 0x1D5E9,  char = '𝗩',  class = 'ord',       cs = 'mbfsansV', alphabet = 'sans'       } -- mathematical sans-serif bold capital v
  , { code = 0x1D5EA,  char = '𝗪',  class = 'ord',       cs = 'mbfsansW', alphabet = 'sans'       } -- mathematical sans-serif bold capital w
  , { code = 0x1D5EB,  char = '𝗫',  class = 'ord',       cs = 'mbfsansX', alphabet = 'sans'       } -- mathematical sans-serif bold capital x
  , { code = 0x1D5EC,  char = '𝗬',  class = 'ord',       cs = 'mbfsansY', alphabet = 'sans'       } -- mathematical sans-serif bold capital y
  , { code = 0x1D5ED,  char = '𝗭',  class = 'ord',       cs = 'mbfsansZ', alphabet = 'sans'       } -- mathematical sans-serif bold capital z
  , { code = 0x1D5EE,  char = '𝗮',  class = 'ord',       cs = 'mbfsansa', alphabet = 'sans'       } -- mathematical sans-serif bold small a
  , { code = 0x1D5EF,  char = '𝗯',  class = 'ord',       cs = 'mbfsansb', alphabet = 'sans'       } -- mathematical sans-serif bold small b
  , { code = 0x1D5F0,  char = '𝗰',  class = 'ord',       cs = 'mbfsansc', alphabet = 'sans'       } -- mathematical sans-serif bold small c
  , { code = 0x1D5F1,  char = '𝗱',  class = 'ord',       cs = 'mbfsansd', alphabet = 'sans'       } -- mathematical sans-serif bold small d
  , { code = 0x1D5F2,  char = '𝗲',  class = 'ord',       cs = 'mbfsanse', alphabet = 'sans'       } -- mathematical sans-serif bold small e
  , { code = 0x1D5F3,  char = '𝗳',  class = 'ord',       cs = 'mbfsansf', alphabet = 'sans'       } -- mathematical sans-serif bold small f
  , { code = 0x1D5F4,  char = '𝗴',  class = 'ord',       cs = 'mbfsansg', alphabet = 'sans'       } -- mathematical sans-serif bold small g
  , { code = 0x1D5F5,  char = '𝗵',  class = 'ord',       cs = 'mbfsansh', alphabet = 'sans'       } -- mathematical sans-serif bold small h
  , { code = 0x1D5F6,  char = '𝗶',  class = 'ord',       cs = 'mbfsansi', alphabet = 'sans'       } -- mathematical sans-serif bold small i
  , { code = 0x1D5F7,  char = '𝗷',  class = 'ord',       cs = 'mbfsansj', alphabet = 'sans'       } -- mathematical sans-serif bold small j
  , { code = 0x1D5F8,  char = '𝗸',  class = 'ord',       cs = 'mbfsansk', alphabet = 'sans'       } -- mathematical sans-serif bold small k
  , { code = 0x1D5F9,  char = '𝗹',  class = 'ord',       cs = 'mbfsansl', alphabet = 'sans'       } -- mathematical sans-serif bold small l
  , { code = 0x1D5FA,  char = '𝗺',  class = 'ord',       cs = 'mbfsansm', alphabet = 'sans'       } -- mathematical sans-serif bold small m
  , { code = 0x1D5FB,  char = '𝗻',  class = 'ord',       cs = 'mbfsansn', alphabet = 'sans'       } -- mathematical sans-serif bold small n
  , { code = 0x1D5FC,  char = '𝗼',  class = 'ord',       cs = 'mbfsanso', alphabet = 'sans'       } -- mathematical sans-serif bold small o
  , { code = 0x1D5FD,  char = '𝗽',  class = 'ord',       cs = 'mbfsansp', alphabet = 'sans'       } -- mathematical sans-serif bold small p
  , { code = 0x1D5FE,  char = '𝗾',  class = 'ord',       cs = 'mbfsansq', alphabet = 'sans'       } -- mathematical sans-serif bold small q
  , { code = 0x1D5FF,  char = '𝗿',  class = 'ord',       cs = 'mbfsansr', alphabet = 'sans'       } -- mathematical sans-serif bold small r
  , { code = 0x1D600,  char = '𝘀',  class = 'ord',       cs = 'mbfsanss', alphabet = 'sans'       } -- mathematical sans-serif bold small s
  , { code = 0x1D601,  char = '𝘁',  class = 'ord',       cs = 'mbfsanst', alphabet = 'sans'       } -- mathematical sans-serif bold small t
  , { code = 0x1D602,  char = '𝘂',  class = 'ord',       cs = 'mbfsansu', alphabet = 'sans'       } -- mathematical sans-serif bold small u
  , { code = 0x1D603,  char = '𝘃',  class = 'ord',       cs = 'mbfsansv', alphabet = 'sans'       } -- mathematical sans-serif bold small v
  , { code = 0x1D604,  char = '𝘄',  class = 'ord',       cs = 'mbfsansw', alphabet = 'sans'       } -- mathematical sans-serif bold small w
  , { code = 0x1D605,  char = '𝘅',  class = 'ord',       cs = 'mbfsansx', alphabet = 'sans'       } -- mathematical sans-serif bold small x
  , { code = 0x1D606,  char = '𝘆',  class = 'ord',       cs = 'mbfsansy', alphabet = 'sans'       } -- mathematical sans-serif bold small y
  , { code = 0x1D607,  char = '𝘇',  class = 'ord',       cs = 'mbfsansz', alphabet = 'sans'       } -- mathematical sans-serif bold small z
  , { code = 0x1D608,  char = '𝘈',  class = 'ord',       cs = 'mitsansA', alphabet = 'sans'       } -- mathematical sans-serif italic capital a
  , { code = 0x1D609,  char = '𝘉',  class = 'ord',       cs = 'mitsansB', alphabet = 'sans'       } -- mathematical sans-serif italic capital b
  , { code = 0x1D60A,  char = '𝘊',  class = 'ord',       cs = 'mitsansC', alphabet = 'sans'       } -- mathematical sans-serif italic capital c
  , { code = 0x1D60B,  char = '𝘋',  class = 'ord',       cs = 'mitsansD', alphabet = 'sans'       } -- mathematical sans-serif italic capital d
  , { code = 0x1D60C,  char = '𝘌',  class = 'ord',       cs = 'mitsansE', alphabet = 'sans'       } -- mathematical sans-serif italic capital e
  , { code = 0x1D60D,  char = '𝘍',  class = 'ord',       cs = 'mitsansF', alphabet = 'sans'       } -- mathematical sans-serif italic capital f
  , { code = 0x1D60E,  char = '𝘎',  class = 'ord',       cs = 'mitsansG', alphabet = 'sans'       } -- mathematical sans-serif italic capital g
  , { code = 0x1D60F,  char = '𝘏',  class = 'ord',       cs = 'mitsansH', alphabet = 'sans'       } -- mathematical sans-serif italic capital h
  , { code = 0x1D610,  char = '𝘐',  class = 'ord',       cs = 'mitsansI', alphabet = 'sans'       } -- mathematical sans-serif italic capital i
  , { code = 0x1D611,  char = '𝘑',  class = 'ord',       cs = 'mitsansJ', alphabet = 'sans'       } -- mathematical sans-serif italic capital j
  , { code = 0x1D612,  char = '𝘒',  class = 'ord',       cs = 'mitsansK', alphabet = 'sans'       } -- mathematical sans-serif italic capital k
  , { code = 0x1D613,  char = '𝘓',  class = 'ord',       cs = 'mitsansL', alphabet = 'sans'       } -- mathematical sans-serif italic capital l
  , { code = 0x1D614,  char = '𝘔',  class = 'ord',       cs = 'mitsansM', alphabet = 'sans'       } -- mathematical sans-serif italic capital m
  , { code = 0x1D615,  char = '𝘕',  class = 'ord',       cs = 'mitsansN', alphabet = 'sans'       } -- mathematical sans-serif italic capital n
  , { code = 0x1D616,  char = '𝘖',  class = 'ord',       cs = 'mitsansO', alphabet = 'sans'       } -- mathematical sans-serif italic capital o
  , { code = 0x1D617,  char = '𝘗',  class = 'ord',       cs = 'mitsansP', alphabet = 'sans'       } -- mathematical sans-serif italic capital p
  , { code = 0x1D618,  char = '𝘘',  class = 'ord',       cs = 'mitsansQ', alphabet = 'sans'       } -- mathematical sans-serif italic capital q
  , { code = 0x1D619,  char = '𝘙',  class = 'ord',       cs = 'mitsansR', alphabet = 'sans'       } -- mathematical sans-serif italic capital r
  , { code = 0x1D61A,  char = '𝘚',  class = 'ord',       cs = 'mitsansS', alphabet = 'sans'       } -- mathematical sans-serif italic capital s
  , { code = 0x1D61B,  char = '𝘛',  class = 'ord',       cs = 'mitsansT', alphabet = 'sans'       } -- mathematical sans-serif italic capital t
  , { code = 0x1D61C,  char = '𝘜',  class = 'ord',       cs = 'mitsansU', alphabet = 'sans'       } -- mathematical sans-serif italic capital u
  , { code = 0x1D61D,  char = '𝘝',  class = 'ord',       cs = 'mitsansV', alphabet = 'sans'       } -- mathematical sans-serif italic capital v
  , { code = 0x1D61E,  char = '𝘞',  class = 'ord',       cs = 'mitsansW', alphabet = 'sans'       } -- mathematical sans-serif italic capital w
  , { code = 0x1D61F,  char = '𝘟',  class = 'ord',       cs = 'mitsansX', alphabet = 'sans'       } -- mathematical sans-serif italic capital x
  , { code = 0x1D620,  char = '𝘠',  class = 'ord',       cs = 'mitsansY', alphabet = 'sans'       } -- mathematical sans-serif italic capital y
  , { code = 0x1D621,  char = '𝘡',  class = 'ord',       cs = 'mitsansZ', alphabet = 'sans'       } -- mathematical sans-serif italic capital z
  , { code = 0x1D622,  char = '𝘢',  class = 'ord',       cs = 'mitsansa', alphabet = 'sans'       } -- mathematical sans-serif italic small a
  , { code = 0x1D623,  char = '𝘣',  class = 'ord',       cs = 'mitsansb', alphabet = 'sans'       } -- mathematical sans-serif italic small b
  , { code = 0x1D624,  char = '𝘤',  class = 'ord',       cs = 'mitsansc', alphabet = 'sans'       } -- mathematical sans-serif italic small c
  , { code = 0x1D625,  char = '𝘥',  class = 'ord',       cs = 'mitsansd', alphabet = 'sans'       } -- mathematical sans-serif italic small d
  , { code = 0x1D626,  char = '𝘦',  class = 'ord',       cs = 'mitsanse', alphabet = 'sans'       } -- mathematical sans-serif italic small e
  , { code = 0x1D627,  char = '𝘧',  class = 'ord',       cs = 'mitsansf', alphabet = 'sans'       } -- mathematical sans-serif italic small f
  , { code = 0x1D628,  char = '𝘨',  class = 'ord',       cs = 'mitsansg', alphabet = 'sans'       } -- mathematical sans-serif italic small g
  , { code = 0x1D629,  char = '𝘩',  class = 'ord',       cs = 'mitsansh', alphabet = 'sans'       } -- mathematical sans-serif italic small h
  , { code = 0x1D62A,  char = '𝘪',  class = 'ord',       cs = 'mitsansi', alphabet = 'sans'       } -- mathematical sans-serif italic small i
  , { code = 0x1D62B,  char = '𝘫',  class = 'ord',       cs = 'mitsansj', alphabet = 'sans'       } -- mathematical sans-serif italic small j
  , { code = 0x1D62C,  char = '𝘬',  class = 'ord',       cs = 'mitsansk', alphabet = 'sans'       } -- mathematical sans-serif italic small k
  , { code = 0x1D62D,  char = '𝘭',  class = 'ord',       cs = 'mitsansl', alphabet = 'sans'       } -- mathematical sans-serif italic small l
  , { code = 0x1D62E,  char = '𝘮',  class = 'ord',       cs = 'mitsansm', alphabet = 'sans'       } -- mathematical sans-serif italic small m
  , { code = 0x1D62F,  char = '𝘯',  class = 'ord',       cs = 'mitsansn', alphabet = 'sans'       } -- mathematical sans-serif italic small n
  , { code = 0x1D630,  char = '𝘰',  class = 'ord',       cs = 'mitsanso', alphabet = 'sans'       } -- mathematical sans-serif italic small o
  , { code = 0x1D631,  char = '𝘱',  class = 'ord',       cs = 'mitsansp', alphabet = 'sans'       } -- mathematical sans-serif italic small p
  , { code = 0x1D632,  char = '𝘲',  class = 'ord',       cs = 'mitsansq', alphabet = 'sans'       } -- mathematical sans-serif italic small q
  , { code = 0x1D633,  char = '𝘳',  class = 'ord',       cs = 'mitsansr', alphabet = 'sans'       } -- mathematical sans-serif italic small r
  , { code = 0x1D634,  char = '𝘴',  class = 'ord',       cs = 'mitsanss', alphabet = 'sans'       } -- mathematical sans-serif italic small s
  , { code = 0x1D635,  char = '𝘵',  class = 'ord',       cs = 'mitsanst', alphabet = 'sans'       } -- mathematical sans-serif italic small t
  , { code = 0x1D636,  char = '𝘶',  class = 'ord',       cs = 'mitsansu', alphabet = 'sans'       } -- mathematical sans-serif italic small u
  , { code = 0x1D637,  char = '𝘷',  class = 'ord',       cs = 'mitsansv', alphabet = 'sans'       } -- mathematical sans-serif italic small v
  , { code = 0x1D638,  char = '𝘸',  class = 'ord',       cs = 'mitsansw', alphabet = 'sans'       } -- mathematical sans-serif italic small w
  , { code = 0x1D639,  char = '𝘹',  class = 'ord',       cs = 'mitsansx', alphabet = 'sans'       } -- mathematical sans-serif italic small x
  , { code = 0x1D63A,  char = '𝘺',  class = 'ord',       cs = 'mitsansy', alphabet = 'sans'       } -- mathematical sans-serif italic small y
  , { code = 0x1D63B,  char = '𝘻',  class = 'ord',       cs = 'mitsansz', alphabet = 'sans'       } -- mathematical sans-serif italic small z
  , { code = 0x1D63C,  char = '𝘼',  class = 'ord',       cs = 'mbfitsansA', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital a
  , { code = 0x1D63D,  char = '𝘽',  class = 'ord',       cs = 'mbfitsansB', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital b
  , { code = 0x1D63E,  char = '𝘾',  class = 'ord',       cs = 'mbfitsansC', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital c
  , { code = 0x1D63F,  char = '𝘿',  class = 'ord',       cs = 'mbfitsansD', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital d
  , { code = 0x1D640,  char = '𝙀',  class = 'ord',       cs = 'mbfitsansE', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital e
  , { code = 0x1D641,  char = '𝙁',  class = 'ord',       cs = 'mbfitsansF', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital f
  , { code = 0x1D642,  char = '𝙂',  class = 'ord',       cs = 'mbfitsansG', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital g
  , { code = 0x1D643,  char = '𝙃',  class = 'ord',       cs = 'mbfitsansH', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital h
  , { code = 0x1D644,  char = '𝙄',  class = 'ord',       cs = 'mbfitsansI', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital i
  , { code = 0x1D645,  char = '𝙅',  class = 'ord',       cs = 'mbfitsansJ', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital j
  , { code = 0x1D646,  char = '𝙆',  class = 'ord',       cs = 'mbfitsansK', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital k
  , { code = 0x1D647,  char = '𝙇',  class = 'ord',       cs = 'mbfitsansL', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital l
  , { code = 0x1D648,  char = '𝙈',  class = 'ord',       cs = 'mbfitsansM', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital m
  , { code = 0x1D649,  char = '𝙉',  class = 'ord',       cs = 'mbfitsansN', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital n
  , { code = 0x1D64A,  char = '𝙊',  class = 'ord',       cs = 'mbfitsansO', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital o
  , { code = 0x1D64B,  char = '𝙋',  class = 'ord',       cs = 'mbfitsansP', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital p
  , { code = 0x1D64C,  char = '𝙌',  class = 'ord',       cs = 'mbfitsansQ', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital q
  , { code = 0x1D64D,  char = '𝙍',  class = 'ord',       cs = 'mbfitsansR', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital r
  , { code = 0x1D64E,  char = '𝙎',  class = 'ord',       cs = 'mbfitsansS', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital s
  , { code = 0x1D64F,  char = '𝙏',  class = 'ord',       cs = 'mbfitsansT', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital t
  , { code = 0x1D650,  char = '𝙐',  class = 'ord',       cs = 'mbfitsansU', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital u
  , { code = 0x1D651,  char = '𝙑',  class = 'ord',       cs = 'mbfitsansV', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital v
  , { code = 0x1D652,  char = '𝙒',  class = 'ord',       cs = 'mbfitsansW', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital w
  , { code = 0x1D653,  char = '𝙓',  class = 'ord',       cs = 'mbfitsansX', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital x
  , { code = 0x1D654,  char = '𝙔',  class = 'ord',       cs = 'mbfitsansY', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital y
  , { code = 0x1D655,  char = '𝙕',  class = 'ord',       cs = 'mbfitsansZ', alphabet = 'sans'     } -- mathematical sans-serif bold italic capital z
  , { code = 0x1D656,  char = '𝙖',  class = 'ord',       cs = 'mbfitsansa', alphabet = 'sans'     } -- mathematical sans-serif bold italic small a
  , { code = 0x1D657,  char = '𝙗',  class = 'ord',       cs = 'mbfitsansb', alphabet = 'sans'     } -- mathematical sans-serif bold italic small b
  , { code = 0x1D658,  char = '𝙘',  class = 'ord',       cs = 'mbfitsansc', alphabet = 'sans'     } -- mathematical sans-serif bold italic small c
  , { code = 0x1D659,  char = '𝙙',  class = 'ord',       cs = 'mbfitsansd', alphabet = 'sans'     } -- mathematical sans-serif bold italic small d
  , { code = 0x1D65A,  char = '𝙚',  class = 'ord',       cs = 'mbfitsanse', alphabet = 'sans'     } -- mathematical sans-serif bold italic small e
  , { code = 0x1D65B,  char = '𝙛',  class = 'ord',       cs = 'mbfitsansf', alphabet = 'sans'     } -- mathematical sans-serif bold italic small f
  , { code = 0x1D65C,  char = '𝙜',  class = 'ord',       cs = 'mbfitsansg', alphabet = 'sans'     } -- mathematical sans-serif bold italic small g
  , { code = 0x1D65D,  char = '𝙝',  class = 'ord',       cs = 'mbfitsansh', alphabet = 'sans'     } -- mathematical sans-serif bold italic small h
  , { code = 0x1D65E,  char = '𝙞',  class = 'ord',       cs = 'mbfitsansi', alphabet = 'sans'     } -- mathematical sans-serif bold italic small i
  , { code = 0x1D65F,  char = '𝙟',  class = 'ord',       cs = 'mbfitsansj', alphabet = 'sans'     } -- mathematical sans-serif bold italic small j
  , { code = 0x1D660,  char = '𝙠',  class = 'ord',       cs = 'mbfitsansk', alphabet = 'sans'     } -- mathematical sans-serif bold italic small k
  , { code = 0x1D661,  char = '𝙡',  class = 'ord',       cs = 'mbfitsansl', alphabet = 'sans'     } -- mathematical sans-serif bold italic small l
  , { code = 0x1D662,  char = '𝙢',  class = 'ord',       cs = 'mbfitsansm', alphabet = 'sans'     } -- mathematical sans-serif bold italic small m
  , { code = 0x1D663,  char = '𝙣',  class = 'ord',       cs = 'mbfitsansn', alphabet = 'sans'     } -- mathematical sans-serif bold italic small n
  , { code = 0x1D664,  char = '𝙤',  class = 'ord',       cs = 'mbfitsanso', alphabet = 'sans'     } -- mathematical sans-serif bold italic small o
  , { code = 0x1D665,  char = '𝙥',  class = 'ord',       cs = 'mbfitsansp', alphabet = 'sans'     } -- mathematical sans-serif bold italic small p
  , { code = 0x1D666,  char = '𝙦',  class = 'ord',       cs = 'mbfitsansq', alphabet = 'sans'     } -- mathematical sans-serif bold italic small q
  , { code = 0x1D667,  char = '𝙧',  class = 'ord',       cs = 'mbfitsansr', alphabet = 'sans'     } -- mathematical sans-serif bold italic small r
  , { code = 0x1D668,  char = '𝙨',  class = 'ord',       cs = 'mbfitsanss', alphabet = 'sans'     } -- mathematical sans-serif bold italic small s
  , { code = 0x1D669,  char = '𝙩',  class = 'ord',       cs = 'mbfitsanst', alphabet = 'sans'     } -- mathematical sans-serif bold italic small t
  , { code = 0x1D66A,  char = '𝙪',  class = 'ord',       cs = 'mbfitsansu', alphabet = 'sans'     } -- mathematical sans-serif bold italic small u
  , { code = 0x1D66B,  char = '𝙫',  class = 'ord',       cs = 'mbfitsansv', alphabet = 'sans'     } -- mathematical sans-serif bold italic small v
  , { code = 0x1D66C,  char = '𝙬',  class = 'ord',       cs = 'mbfitsansw', alphabet = 'sans'     } -- mathematical sans-serif bold italic small w
  , { code = 0x1D66D,  char = '𝙭',  class = 'ord',       cs = 'mbfitsansx', alphabet = 'sans'     } -- mathematical sans-serif bold italic small x
  , { code = 0x1D66E,  char = '𝙮',  class = 'ord',       cs = 'mbfitsansy', alphabet = 'sans'     } -- mathematical sans-serif bold italic small y
  , { code = 0x1D66F,  char = '𝙯',  class = 'ord',       cs = 'mbfitsansz', alphabet = 'sans'     } -- mathematical sans-serif bold italic small z
  , { code = 0x1D670,  char = '𝙰',  class = 'ord',       cs = 'mttA', alphabet = 'mono'           } -- mathematical monospace capital a
  , { code = 0x1D671,  char = '𝙱',  class = 'ord',       cs = 'mttB', alphabet = 'mono'           } -- mathematical monospace capital b
  , { code = 0x1D672,  char = '𝙲',  class = 'ord',       cs = 'mttC', alphabet = 'mono'           } -- mathematical monospace capital c
  , { code = 0x1D673,  char = '𝙳',  class = 'ord',       cs = 'mttD', alphabet = 'mono'           } -- mathematical monospace capital d
  , { code = 0x1D674,  char = '𝙴',  class = 'ord',       cs = 'mttE', alphabet = 'mono'           } -- mathematical monospace capital e
  , { code = 0x1D675,  char = '𝙵',  class = 'ord',       cs = 'mttF', alphabet = 'mono'           } -- mathematical monospace capital f
  , { code = 0x1D676,  char = '𝙶',  class = 'ord',       cs = 'mttG', alphabet = 'mono'           } -- mathematical monospace capital g
  , { code = 0x1D677,  char = '𝙷',  class = 'ord',       cs = 'mttH', alphabet = 'mono'           } -- mathematical monospace capital h
  , { code = 0x1D678,  char = '𝙸',  class = 'ord',       cs = 'mttI', alphabet = 'mono'           } -- mathematical monospace capital i
  , { code = 0x1D679,  char = '𝙹',  class = 'ord',       cs = 'mttJ', alphabet = 'mono'           } -- mathematical monospace capital j
  , { code = 0x1D67A,  char = '𝙺',  class = 'ord',       cs = 'mttK', alphabet = 'mono'           } -- mathematical monospace capital k
  , { code = 0x1D67B,  char = '𝙻',  class = 'ord',       cs = 'mttL', alphabet = 'mono'           } -- mathematical monospace capital l
  , { code = 0x1D67C,  char = '𝙼',  class = 'ord',       cs = 'mttM', alphabet = 'mono'           } -- mathematical monospace capital m
  , { code = 0x1D67D,  char = '𝙽',  class = 'ord',       cs = 'mttN', alphabet = 'mono'           } -- mathematical monospace capital n
  , { code = 0x1D67E,  char = '𝙾',  class = 'ord',       cs = 'mttO', alphabet = 'mono'           } -- mathematical monospace capital o
  , { code = 0x1D67F,  char = '𝙿',  class = 'ord',       cs = 'mttP', alphabet = 'mono'           } -- mathematical monospace capital p
  , { code = 0x1D680,  char = '𝚀',  class = 'ord',       cs = 'mttQ', alphabet = 'mono'           } -- mathematical monospace capital q
  , { code = 0x1D681,  char = '𝚁',  class = 'ord',       cs = 'mttR', alphabet = 'mono'           } -- mathematical monospace capital r
  , { code = 0x1D682,  char = '𝚂',  class = 'ord',       cs = 'mttS', alphabet = 'mono'           } -- mathematical monospace capital s
  , { code = 0x1D683,  char = '𝚃',  class = 'ord',       cs = 'mttT', alphabet = 'mono'           } -- mathematical monospace capital t
  , { code = 0x1D684,  char = '𝚄',  class = 'ord',       cs = 'mttU', alphabet = 'mono'           } -- mathematical monospace capital u
  , { code = 0x1D685,  char = '𝚅',  class = 'ord',       cs = 'mttV', alphabet = 'mono'           } -- mathematical monospace capital v
  , { code = 0x1D686,  char = '𝚆',  class = 'ord',       cs = 'mttW', alphabet = 'mono'           } -- mathematical monospace capital w
  , { code = 0x1D687,  char = '𝚇',  class = 'ord',       cs = 'mttX', alphabet = 'mono'           } -- mathematical monospace capital x
  , { code = 0x1D688,  char = '𝚈',  class = 'ord',       cs = 'mttY', alphabet = 'mono'           } -- mathematical monospace capital y
  , { code = 0x1D689,  char = '𝚉',  class = 'ord',       cs = 'mttZ', alphabet = 'mono'           } -- mathematical monospace capital z
  , { code = 0x1D68A,  char = '𝚊',  class = 'ord',       cs = 'mtta', alphabet = 'mono'           } -- mathematical monospace small a
  , { code = 0x1D68B,  char = '𝚋',  class = 'ord',       cs = 'mttb', alphabet = 'mono'           } -- mathematical monospace small b
  , { code = 0x1D68C,  char = '𝚌',  class = 'ord',       cs = 'mttc', alphabet = 'mono'           } -- mathematical monospace small c
  , { code = 0x1D68D,  char = '𝚍',  class = 'ord',       cs = 'mttd', alphabet = 'mono'           } -- mathematical monospace small d
  , { code = 0x1D68E,  char = '𝚎',  class = 'ord',       cs = 'mtte', alphabet = 'mono'           } -- mathematical monospace small e
  , { code = 0x1D68F,  char = '𝚏',  class = 'ord',       cs = 'mttf', alphabet = 'mono'           } -- mathematical monospace small f
  , { code = 0x1D690,  char = '𝚐',  class = 'ord',       cs = 'mttg', alphabet = 'mono'           } -- mathematical monospace small g
  , { code = 0x1D691,  char = '𝚑',  class = 'ord',       cs = 'mtth', alphabet = 'mono'           } -- mathematical monospace small h
  , { code = 0x1D692,  char = '𝚒',  class = 'ord',       cs = 'mtti', alphabet = 'mono'           } -- mathematical monospace small i
  , { code = 0x1D693,  char = '𝚓',  class = 'ord',       cs = 'mttj', alphabet = 'mono'           } -- mathematical monospace small j
  , { code = 0x1D694,  char = '𝚔',  class = 'ord',       cs = 'mttk', alphabet = 'mono'           } -- mathematical monospace small k
  , { code = 0x1D695,  char = '𝚕',  class = 'ord',       cs = 'mttl', alphabet = 'mono'           } -- mathematical monospace small l
  , { code = 0x1D696,  char = '𝚖',  class = 'ord',       cs = 'mttm', alphabet = 'mono'           } -- mathematical monospace small m
  , { code = 0x1D697,  char = '𝚗',  class = 'ord',       cs = 'mttn', alphabet = 'mono'           } -- mathematical monospace small n
  , { code = 0x1D698,  char = '𝚘',  class = 'ord',       cs = 'mtto', alphabet = 'mono'           } -- mathematical monospace small o
  , { code = 0x1D699,  char = '𝚙',  class = 'ord',       cs = 'mttp', alphabet = 'mono'           } -- mathematical monospace small p
  , { code = 0x1D69A,  char = '𝚚',  class = 'ord',       cs = 'mttq', alphabet = 'mono'           } -- mathematical monospace small q
  , { code = 0x1D69B,  char = '𝚛',  class = 'ord',       cs = 'mttr', alphabet = 'mono'           } -- mathematical monospace small r
  , { code = 0x1D69C,  char = '𝚜',  class = 'ord',       cs = 'mtts', alphabet = 'mono'           } -- mathematical monospace small s
  , { code = 0x1D69D,  char = '𝚝',  class = 'ord',       cs = 'mttt', alphabet = 'mono'           } -- mathematical monospace small t
  , { code = 0x1D69E,  char = '𝚞',  class = 'ord',       cs = 'mttu', alphabet = 'mono'           } -- mathematical monospace small u
  , { code = 0x1D69F,  char = '𝚟',  class = 'ord',       cs = 'mttv', alphabet = 'mono'           } -- mathematical monospace small v
  , { code = 0x1D6A0,  char = '𝚠',  class = 'ord',       cs = 'mttw', alphabet = 'mono'           } -- mathematical monospace small w
  , { code = 0x1D6A1,  char = '𝚡',  class = 'ord',       cs = 'mttx', alphabet = 'mono'           } -- mathematical monospace small x
  , { code = 0x1D6A2,  char = '𝚢',  class = 'ord',       cs = 'mtty', alphabet = 'mono'           } -- mathematical monospace small y
  , { code = 0x1D6A3,  char = '𝚣',  class = 'ord',       cs = 'mttz', alphabet = 'mono'           } -- mathematical monospace small z
  , { code = 0x1D6A4,  char = '𝚤',  class = 'ord',       cs = 'imath'                             } -- mathematical italic small dotless i
  , { code = 0x1D6A5,  char = '𝚥',  class = 'ord',       cs = 'jmath'                             } -- mathematical italic small dotless j
  , { code = 0x1D6A8,  char = '𝚨',  class = 'ord',       cs = 'mbfAlpha', alphabet = 'boldgreek'  } -- mathematical bold capital alpha
  , { code = 0x1D6A9,  char = '𝚩',  class = 'ord',       cs = 'mbfBeta', alphabet = 'boldgreek'   } -- mathematical bold capital beta
  , { code = 0x1D6AA,  char = '𝚪',  class = 'ord',       cs = 'mbfGamma', alphabet = 'boldgreek'  } -- mathematical bold capital gamma
  , { code = 0x1D6AB,  char = '𝚫',  class = 'ord',       cs = 'mbfDelta', alphabet = 'boldgreek'  } -- mathematical bold capital delta
  , { code = 0x1D6AC,  char = '𝚬',  class = 'ord',       cs = 'mbfEpsilon', alphabet = 'boldgreek'} -- mathematical bold capital epsilon
  , { code = 0x1D6AD,  char = '𝚭',  class = 'ord',       cs = 'mbfZeta', alphabet = 'boldgreek'   } -- mathematical bold capital zeta
  , { code = 0x1D6AE,  char = '𝚮',  class = 'ord',       cs = 'mbfEta', alphabet = 'boldgreek'    } -- mathematical bold capital eta
  , { code = 0x1D6AF,  char = '𝚯',  class = 'ord',       cs = 'mbfTheta', alphabet = 'boldgreek'  } -- mathematical bold capital theta
  , { code = 0x1D6B0,  char = '𝚰',  class = 'ord',       cs = 'mbfIota', alphabet = 'boldgreek'   } -- mathematical bold capital iota
  , { code = 0x1D6B1,  char = '𝚱',  class = 'ord',       cs = 'mbfKappa', alphabet = 'boldgreek'  } -- mathematical bold capital kappa
  , { code = 0x1D6B2,  char = '𝚲',  class = 'ord',       cs = 'mbfLambda', alphabet = 'boldgreek' } -- mathematical bold capital lamda
  , { code = 0x1D6B3,  char = '𝚳',  class = 'ord',       cs = 'mbfMu', alphabet = 'boldgreek'     } -- mathematical bold capital mu
  , { code = 0x1D6B4,  char = '𝚴',  class = 'ord',       cs = 'mbfNu', alphabet = 'boldgreek'     } -- mathematical bold capital nu
  , { code = 0x1D6B5,  char = '𝚵',  class = 'ord',       cs = 'mbfXi', alphabet = 'boldgreek'     } -- mathematical bold capital xi
  , { code = 0x1D6B6,  char = '𝚶',  class = 'ord',       cs = 'mbfOmicron', alphabet = 'boldgreek'} -- mathematical bold capital omicron
  , { code = 0x1D6B7,  char = '𝚷',  class = 'ord',       cs = 'mbfPi', alphabet = 'boldgreek'     } -- mathematical bold capital pi
  , { code = 0x1D6B8,  char = '𝚸',  class = 'ord',       cs = 'mbfRho', alphabet = 'boldgreek'    } -- mathematical bold capital rho
  , { code = 0x1D6B9,  char = '𝚹',  class = 'ord',       cs = 'mbfvarTheta', alphabet = 'boldgreek'} -- mathematical bold capital theta symbol
  , { code = 0x1D6BA,  char = '𝚺',  class = 'ord',       cs = 'mbfSigma', alphabet = 'boldgreek'  } -- mathematical bold capital sigma
  , { code = 0x1D6BB,  char = '𝚻',  class = 'ord',       cs = 'mbfTau', alphabet = 'boldgreek'    } -- mathematical bold capital tau
  , { code = 0x1D6BC,  char = '𝚼',  class = 'ord',       cs = 'mbfUpsilon', alphabet = 'boldgreek'} -- mathematical bold capital upsilon
  , { code = 0x1D6BD,  char = '𝚽',  class = 'ord',       cs = 'mbfPhi', alphabet = 'boldgreek'    } -- mathematical bold capital phi
  , { code = 0x1D6BE,  char = '𝚾',  class = 'ord',       cs = 'mbfChi', alphabet = 'boldgreek'    } -- mathematical bold capital chi
  , { code = 0x1D6BF,  char = '𝚿',  class = 'ord',       cs = 'mbfPsi', alphabet = 'boldgreek'    } -- mathematical bold capital psi
  , { code = 0x1D6C0,  char = '𝛀',  class = 'ord',       cs = 'mbfOmega', alphabet = 'boldgreek'  } -- mathematical bold capital omega
  , { code = 0x1D6C1,  char = '𝛁',  class = 'ord',       cs = 'mbfnabla'                          } -- mathematical bold nabla
  , { code = 0x1D6C2,  char = '𝛂',  class = 'ord',       cs = 'mbfalpha', alphabet = 'boldgreek'  } -- mathematical bold small alpha
  , { code = 0x1D6C3,  char = '𝛃',  class = 'ord',       cs = 'mbfbeta', alphabet = 'boldgreek'   } -- mathematical bold small beta
  , { code = 0x1D6C4,  char = '𝛄',  class = 'ord',       cs = 'mbfgamma', alphabet = 'boldgreek'  } -- mathematical bold small gamma
  , { code = 0x1D6C5,  char = '𝛅',  class = 'ord',       cs = 'mbfdelta', alphabet = 'boldgreek'  } -- mathematical bold small delta
  , { code = 0x1D6C6,  char = '𝛆',  class = 'ord',       cs = 'mbfepsilon', alphabet = 'boldgreek'} -- mathematical bold small epsilon
  , { code = 0x1D6C7,  char = '𝛇',  class = 'ord',       cs = 'mbfzeta', alphabet = 'boldgreek'   } -- mathematical bold small zeta
  , { code = 0x1D6C8,  char = '𝛈',  class = 'ord',       cs = 'mbfeta', alphabet = 'boldgreek'    } -- mathematical bold small eta
  , { code = 0x1D6C9,  char = '𝛉',  class = 'ord',       cs = 'mbftheta', alphabet = 'boldgreek'  } -- mathematical bold small theta
  , { code = 0x1D6CA,  char = '𝛊',  class = 'ord',       cs = 'mbfiota', alphabet = 'boldgreek'   } -- mathematical bold small iota
  , { code = 0x1D6CB,  char = '𝛋',  class = 'ord',       cs = 'mbfkappa', alphabet = 'boldgreek'  } -- mathematical bold small kappa
  , { code = 0x1D6CC,  char = '𝛌',  class = 'ord',       cs = 'mbflambda', alphabet = 'boldgreek' } -- mathematical bold small lamda
  , { code = 0x1D6CD,  char = '𝛍',  class = 'ord',       cs = 'mbfmu', alphabet = 'boldgreek'     } -- mathematical bold small mu
  , { code = 0x1D6CE,  char = '𝛎',  class = 'ord',       cs = 'mbfnu', alphabet = 'boldgreek'     } -- mathematical bold small nu
  , { code = 0x1D6CF,  char = '𝛏',  class = 'ord',       cs = 'mbfxi', alphabet = 'boldgreek'     } -- mathematical bold small xi
  , { code = 0x1D6D0,  char = '𝛐',  class = 'ord',       cs = 'mbfomicron', alphabet = 'boldgreek'} -- mathematical bold small omicron
  , { code = 0x1D6D1,  char = '𝛑',  class = 'ord',       cs = 'mbfpi', alphabet = 'boldgreek'     } -- mathematical bold small pi
  , { code = 0x1D6D2,  char = '𝛒',  class = 'ord',       cs = 'mbfrho', alphabet = 'boldgreek'    } -- mathematical bold small rho
  , { code = 0x1D6D3,  char = '𝛓',  class = 'ord',       cs = 'mbfvarsigma', alphabet = 'boldgreek'} -- mathematical bold small final sigma
  , { code = 0x1D6D4,  char = '𝛔',  class = 'ord',       cs = 'mbfsigma', alphabet = 'boldgreek'  } -- mathematical bold small sigma
  , { code = 0x1D6D5,  char = '𝛕',  class = 'ord',       cs = 'mbftau', alphabet = 'boldgreek'    } -- mathematical bold small tau
  , { code = 0x1D6D6,  char = '𝛖',  class = 'ord',       cs = 'mbfupsilon', alphabet = 'boldgreek'} -- mathematical bold small upsilon
  , { code = 0x1D6D7,  char = '𝛗',  class = 'ord',       cs = 'mbfphi', alphabet = 'boldgreek'    } -- mathematical bold small phi
  , { code = 0x1D6D8,  char = '𝛘',  class = 'ord',       cs = 'mbfchi', alphabet = 'boldgreek'    } -- mathematical bold small chi
  , { code = 0x1D6D9,  char = '𝛙',  class = 'ord',       cs = 'mbfpsi', alphabet = 'boldgreek'    } -- mathematical bold small psi
  , { code = 0x1D6DA,  char = '𝛚',  class = 'ord',       cs = 'mbfomega', alphabet = 'boldgreek'  } -- mathematical bold small omega
  , { code = 0x1D6DB,  char = '𝛛',  class = 'ord',       cs = 'mbfpartial'                        } -- mathematical bold partial differential
  , { code = 0x1D6DC,  char = '𝛜',  class = 'ord',       cs = 'mbfvarepsilon', alphabet = 'boldgreek'} -- mathematical bold epsilon symbol
  , { code = 0x1D6DD,  char = '𝛝',  class = 'ord',       cs = 'mbfvartheta', alphabet = 'boldgreek'} -- mathematical bold theta symbol
  , { code = 0x1D6DE,  char = '𝛞',  class = 'ord',       cs = 'mbfvarkappa', alphabet = 'boldgreek'} -- mathematical bold kappa symbol
  , { code = 0x1D6DF,  char = '𝛟',  class = 'ord',       cs = 'mbfvarphi', alphabet = 'boldgreek' } -- mathematical bold phi symbol
  , { code = 0x1D6E0,  char = '𝛠',  class = 'ord',       cs = 'mbfvarrho', alphabet = 'boldgreek' } -- mathematical bold rho symbol
  , { code = 0x1D6E1,  char = '𝛡',  class = 'ord',       cs = 'mbfvarpi', alphabet = 'boldgreek'  } -- mathematical bold pi symbol
  , { code = 0x1D6E2,  char = '𝛢',  class = 'ord',       cs = 'mitAlpha'                          } -- mathematical italic capital alpha
  , { code = 0x1D6E3,  char = '𝛣',  class = 'ord',       cs = 'mitBeta'                           } -- mathematical italic capital beta
  , { code = 0x1D6E4,  char = '𝛤',  class = 'ord',       cs = 'mitGamma'                          } -- mathematical italic capital gamma
  , { code = 0x1D6E5,  char = '𝛥',  class = 'ord',       cs = 'mitDelta'                          } -- mathematical italic capital delta
  , { code = 0x1D6E6,  char = '𝛦',  class = 'ord',       cs = 'mitEpsilon'                        } -- mathematical italic capital epsilon
  , { code = 0x1D6E7,  char = '𝛧',  class = 'ord',       cs = 'mitZeta'                           } -- mathematical italic capital zeta
  , { code = 0x1D6E8,  char = '𝛨',  class = 'ord',       cs = 'mitEta'                            } -- mathematical italic capital eta
  , { code = 0x1D6E9,  char = '𝛩',  class = 'ord',       cs = 'mitTheta'                          } -- mathematical italic capital theta
  , { code = 0x1D6EA,  char = '𝛪',  class = 'ord',       cs = 'mitIota'                           } -- mathematical italic capital iota
  , { code = 0x1D6EB,  char = '𝛫',  class = 'ord',       cs = 'mitKappa'                          } -- mathematical italic capital kappa
  , { code = 0x1D6EC,  char = '𝛬',  class = 'ord',       cs = 'mitLambda'                         } -- mathematical italic capital lamda
  , { code = 0x1D6ED,  char = '𝛭',  class = 'ord',       cs = 'mitMu'                             } -- mathematical italic capital mu
  , { code = 0x1D6EE,  char = '𝛮',  class = 'ord',       cs = 'mitNu'                             } -- mathematical italic capital nu
  , { code = 0x1D6EF,  char = '𝛯',  class = 'ord',       cs = 'mitXi'                             } -- mathematical italic capital xi
  , { code = 0x1D6F0,  char = '𝛰',  class = 'ord',       cs = 'mitOmicron'                        } -- mathematical italic capital omicron
  , { code = 0x1D6F1,  char = '𝛱',  class = 'ord',       cs = 'mitPi'                             } -- mathematical italic capital pi
  , { code = 0x1D6F2,  char = '𝛲',  class = 'ord',       cs = 'mitRho'                            } -- mathematical italic capital rho
  , { code = 0x1D6F3,  char = '𝛳',  class = 'ord',       cs = 'mitvarTheta'                       } -- mathematical italic capital theta symbol
  , { code = 0x1D6F4,  char = '𝛴',  class = 'ord',       cs = 'mitSigma'                          } -- mathematical italic capital sigma
  , { code = 0x1D6F5,  char = '𝛵',  class = 'ord',       cs = 'mitTau'                            } -- mathematical italic capital tau
  , { code = 0x1D6F6,  char = '𝛶',  class = 'ord',       cs = 'mitUpsilon'                        } -- mathematical italic capital upsilon
  , { code = 0x1D6F7,  char = '𝛷',  class = 'ord',       cs = 'mitPhi'                            } -- mathematical italic capital phi
  , { code = 0x1D6F8,  char = '𝛸',  class = 'ord',       cs = 'mitChi'                            } -- mathematical italic capital chi
  , { code = 0x1D6F9,  char = '𝛹',  class = 'ord',       cs = 'mitPsi'                            } -- mathematical italic capital psi
  , { code = 0x1D6FA,  char = '𝛺',  class = 'ord',       cs = 'mitOmega'                          } -- mathematical italic capital omega
  , { code = 0x1D6FB,  char = '𝛻',  class = 'ord',       cs = 'mitnabla'                          } -- mathematical italic nabla
  , { code = 0x1D6FC,  char = '𝛼',  class = 'ord',       cs = 'mitalpha'                          } -- mathematical italic small alpha
  , { code = 0x1D6FD,  char = '𝛽',  class = 'ord',       cs = 'mitbeta'                           } -- mathematical italic small beta
  , { code = 0x1D6FE,  char = '𝛾',  class = 'ord',       cs = 'mitgamma'                          } -- mathematical italic small gamma
  , { code = 0x1D6FF,  char = '𝛿',  class = 'ord',       cs = 'mitdelta'                          } -- mathematical italic small delta
  , { code = 0x1D700,  char = '𝜀',  class = 'ord',       cs = 'mitepsilon'                        } -- mathematical italic small epsilon
  , { code = 0x1D701,  char = '𝜁',  class = 'ord',       cs = 'mitzeta'                           } -- mathematical italic small zeta
  , { code = 0x1D702,  char = '𝜂',  class = 'ord',       cs = 'miteta'                            } -- mathematical italic small eta
  , { code = 0x1D703,  char = '𝜃',  class = 'ord',       cs = 'mittheta'                          } -- mathematical italic small theta
  , { code = 0x1D704,  char = '𝜄',  class = 'ord',       cs = 'mitiota'                           } -- mathematical italic small iota
  , { code = 0x1D705,  char = '𝜅',  class = 'ord',       cs = 'mitkappa'                          } -- mathematical italic small kappa
  , { code = 0x1D706,  char = '𝜆',  class = 'ord',       cs = 'mitlambda'                         } -- mathematical italic small lamda
  , { code = 0x1D707,  char = '𝜇',  class = 'ord',       cs = 'mitmu'                             } -- mathematical italic small mu
  , { code = 0x1D708,  char = '𝜈',  class = 'ord',       cs = 'mitnu'                             } -- mathematical italic small nu
  , { code = 0x1D709,  char = '𝜉',  class = 'ord',       cs = 'mitxi'                             } -- mathematical italic small xi
  , { code = 0x1D70A,  char = '𝜊',  class = 'ord',       cs = 'mitomicron'                        } -- mathematical italic small omicron
  , { code = 0x1D70B,  char = '𝜋',  class = 'ord',       cs = 'mitpi'                             } -- mathematical italic small pi
  , { code = 0x1D70C,  char = '𝜌',  class = 'ord',       cs = 'mitrho'                            } -- mathematical italic small rho
  , { code = 0x1D70D,  char = '𝜍',  class = 'ord',       cs = 'mitvarsigma'                       } -- mathematical italic small final sigma
  , { code = 0x1D70E,  char = '𝜎',  class = 'ord',       cs = 'mitsigma'                          } -- mathematical italic small sigma
  , { code = 0x1D70F,  char = '𝜏',  class = 'ord',       cs = 'mittau'                            } -- mathematical italic small tau
  , { code = 0x1D710,  char = '𝜐',  class = 'ord',       cs = 'mitupsilon'                        } -- mathematical italic small upsilon
  , { code = 0x1D711,  char = '𝜑',  class = 'ord',       cs = 'mitphi'                            } -- mathematical italic small phi
  , { code = 0x1D712,  char = '𝜒',  class = 'ord',       cs = 'mitchi'                            } -- mathematical italic small chi
  , { code = 0x1D713,  char = '𝜓',  class = 'ord',       cs = 'mitpsi'                            } -- mathematical italic small psi
  , { code = 0x1D714,  char = '𝜔',  class = 'ord',       cs = 'mitomega'                          } -- mathematical italic small omega
  , { code = 0x1D715,  char = '𝜕',  class = 'ord',       cs = 'mitpartial'                        } -- mathematical italic partial differential
  , { code = 0x1D716,  char = '𝜖',  class = 'ord',       cs = 'mitvarepsilon'                     } -- mathematical italic epsilon symbol
  , { code = 0x1D717,  char = '𝜗',  class = 'ord',       cs = 'mitvartheta'                       } -- mathematical italic theta symbol
  , { code = 0x1D718,  char = '𝜘',  class = 'ord',       cs = 'mitvarkappa'                       } -- mathematical italic kappa symbol
  , { code = 0x1D719,  char = '𝜙',  class = 'ord',       cs = 'mitvarphi'                         } -- mathematical italic phi symbol
  , { code = 0x1D71A,  char = '𝜚',  class = 'ord',       cs = 'mitvarrho'                         } -- mathematical italic rho symbol
  , { code = 0x1D71B,  char = '𝜛',  class = 'ord',       cs = 'mitvarpi'                          } -- mathematical italic pi symbol
  , { code = 0x1D71C,  char = '𝜜',  class = 'ord',       cs = 'mbfitAlpha', alphabet = 'boldgreek' } -- mathematical bold italic capital alpha
  , { code = 0x1D71D,  char = '𝜝',  class = 'ord',       cs = 'mbfitBeta', alphabet = 'boldgreek'  } -- mathematical bold italic capital beta
  , { code = 0x1D71E,  char = '𝜞',  class = 'ord',       cs = 'mbfitGamma', alphabet = 'boldgreek' } -- mathematical bold italic capital gamma
  , { code = 0x1D71F,  char = '𝜟',  class = 'ord',       cs = 'mbfitDelta', alphabet = 'boldgreek' } -- mathematical bold italic capital delta
  , { code = 0x1D720,  char = '𝜠',  class = 'ord',       cs = 'mbfitEpsilon', alphabet = 'boldgreek'} -- mathematical bold italic capital epsilon
  , { code = 0x1D721,  char = '𝜡',  class = 'ord',       cs = 'mbfitZeta', alphabet = 'boldgreek'  } -- mathematical bold italic capital zeta
  , { code = 0x1D722,  char = '𝜢',  class = 'ord',       cs = 'mbfitEta', alphabet = 'boldgreek'   } -- mathematical bold italic capital eta
  , { code = 0x1D723,  char = '𝜣',  class = 'ord',       cs = 'mbfitTheta', alphabet = 'boldgreek' } -- mathematical bold italic capital theta
  , { code = 0x1D724,  char = '𝜤',  class = 'ord',       cs = 'mbfitIota', alphabet = 'boldgreek'  } -- mathematical bold italic capital iota
  , { code = 0x1D725,  char = '𝜥',  class = 'ord',       cs = 'mbfitKappa', alphabet = 'boldgreek' } -- mathematical bold italic capital kappa
  , { code = 0x1D726,  char = '𝜦',  class = 'ord',       cs = 'mbfitLambda', alphabet = 'boldgreek'} -- mathematical bold italic capital lamda
  , { code = 0x1D727,  char = '𝜧',  class = 'ord',       cs = 'mbfitMu', alphabet = 'boldgreek'    } -- mathematical bold italic capital mu
  , { code = 0x1D728,  char = '𝜨',  class = 'ord',       cs = 'mbfitNu', alphabet = 'boldgreek'    } -- mathematical bold italic capital nu
  , { code = 0x1D729,  char = '𝜩',  class = 'ord',       cs = 'mbfitXi', alphabet = 'boldgreek'    } -- mathematical bold italic capital xi
  , { code = 0x1D72A,  char = '𝜪',  class = 'ord',       cs = 'mbfitOmicron', alphabet = 'boldgreek'} -- mathematical bold italic capital omicron
  , { code = 0x1D72B,  char = '𝜫',  class = 'ord',       cs = 'mbfitPi', alphabet = 'boldgreek'    } -- mathematical bold italic capital pi
  , { code = 0x1D72C,  char = '𝜬',  class = 'ord',       cs = 'mbfitRho', alphabet = 'boldgreek'   } -- mathematical bold italic capital rho
  , { code = 0x1D72D,  char = '𝜭',  class = 'ord',       cs = 'mbfitvarTheta', alphabet = 'boldgreek'} -- mathematical bold italic capital theta symbol
  , { code = 0x1D72E,  char = '𝜮',  class = 'ord',       cs = 'mbfitSigma', alphabet = 'boldgreek' } -- mathematical bold italic capital sigma
  , { code = 0x1D72F,  char = '𝜯',  class = 'ord',       cs = 'mbfitTau', alphabet = 'boldgreek'   } -- mathematical bold italic capital tau
  , { code = 0x1D730,  char = '𝜰',  class = 'ord',       cs = 'mbfitUpsilon', alphabet = 'boldgreek'} -- mathematical bold italic capital upsilon
  , { code = 0x1D731,  char = '𝜱',  class = 'ord',       cs = 'mbfitPhi', alphabet = 'boldgreek'   } -- mathematical bold italic capital phi
  , { code = 0x1D732,  char = '𝜲',  class = 'ord',       cs = 'mbfitChi', alphabet = 'boldgreek'   } -- mathematical bold italic capital chi
  , { code = 0x1D733,  char = '𝜳',  class = 'ord',       cs = 'mbfitPsi', alphabet = 'boldgreek'   } -- mathematical bold italic capital psi
  , { code = 0x1D734,  char = '𝜴',  class = 'ord',       cs = 'mbfitOmega', alphabet = 'boldgreek' } -- mathematical bold italic capital omega
  , { code = 0x1D735,  char = '𝜵',  class = 'ord',       cs = 'mbfitnabla'                         } -- mathematical bold italic nabla
  , { code = 0x1D736,  char = '𝜶',  class = 'ord',       cs = 'mbfitalpha', alphabet = 'boldgreek' } -- mathematical bold italic small alpha
  , { code = 0x1D737,  char = '𝜷',  class = 'ord',       cs = 'mbfitbeta', alphabet = 'boldgreek'  } -- mathematical bold italic small beta
  , { code = 0x1D738,  char = '𝜸',  class = 'ord',       cs = 'mbfitgamma', alphabet = 'boldgreek' } -- mathematical bold italic small gamma
  , { code = 0x1D739,  char = '𝜹',  class = 'ord',       cs = 'mbfitdelta', alphabet = 'boldgreek' } -- mathematical bold italic small delta
  , { code = 0x1D73A,  char = '𝜺',  class = 'ord',       cs = 'mbfitepsilon', alphabet = 'boldgreek'} -- mathematical bold italic small epsilon
  , { code = 0x1D73B,  char = '𝜻',  class = 'ord',       cs = 'mbfitzeta', alphabet = 'boldgreek'  } -- mathematical bold italic small zeta
  , { code = 0x1D73C,  char = '𝜼',  class = 'ord',       cs = 'mbfiteta', alphabet = 'boldgreek'   } -- mathematical bold italic small eta
  , { code = 0x1D73D,  char = '𝜽',  class = 'ord',       cs = 'mbfittheta', alphabet = 'boldgreek' } -- mathematical bold italic small theta
  , { code = 0x1D73E,  char = '𝜾',  class = 'ord',       cs = 'mbfitiota', alphabet = 'boldgreek'  } -- mathematical bold italic small iota
  , { code = 0x1D73F,  char = '𝜿',  class = 'ord',       cs = 'mbfitkappa', alphabet = 'boldgreek' } -- mathematical bold italic small kappa
  , { code = 0x1D740,  char = '𝝀',  class = 'ord',       cs = 'mbfitlambda', alphabet = 'boldgreek'} -- mathematical bold italic small lamda
  , { code = 0x1D741,  char = '𝝁',  class = 'ord',       cs = 'mbfitmu', alphabet = 'boldgreek'    } -- mathematical bold italic small mu
  , { code = 0x1D742,  char = '𝝂',  class = 'ord',       cs = 'mbfitnu', alphabet = 'boldgreek'    } -- mathematical bold italic small nu
  , { code = 0x1D743,  char = '𝝃',  class = 'ord',       cs = 'mbfitxi', alphabet = 'boldgreek'    } -- mathematical bold italic small xi
  , { code = 0x1D744,  char = '𝝄',  class = 'ord',       cs = 'mbfitomicron', alphabet = 'boldgreek'} -- mathematical bold italic small omicron
  , { code = 0x1D745,  char = '𝝅',  class = 'ord',       cs = 'mbfitpi', alphabet = 'boldgreek'    } -- mathematical bold italic small pi
  , { code = 0x1D746,  char = '𝝆',  class = 'ord',       cs = 'mbfitrho', alphabet = 'boldgreek'   } -- mathematical bold italic small rho
  , { code = 0x1D747,  char = '𝝇',  class = 'ord',       cs = 'mbfitvarsigma', alphabet = 'boldgreek'} -- mathematical bold italic small final sigma
  , { code = 0x1D748,  char = '𝝈',  class = 'ord',       cs = 'mbfitsigma', alphabet = 'boldgreek' } -- mathematical bold italic small sigma
  , { code = 0x1D749,  char = '𝝉',  class = 'ord',       cs = 'mbfittau', alphabet = 'boldgreek'   } -- mathematical bold italic small tau
  , { code = 0x1D74A,  char = '𝝊',  class = 'ord',       cs = 'mbfitupsilon', alphabet = 'boldgreek'} -- mathematical bold italic small upsilon
  , { code = 0x1D74B,  char = '𝝋',  class = 'ord',       cs = 'mbfitphi', alphabet = 'boldgreek'   } -- mathematical bold italic small phi
  , { code = 0x1D74C,  char = '𝝌',  class = 'ord',       cs = 'mbfitchi', alphabet = 'boldgreek'   } -- mathematical bold italic small chi
  , { code = 0x1D74D,  char = '𝝍',  class = 'ord',       cs = 'mbfitpsi', alphabet = 'boldgreek'   } -- mathematical bold italic small psi
  , { code = 0x1D74E,  char = '𝝎',  class = 'ord',       cs = 'mbfitomega', alphabet = 'boldgreek' } -- mathematical bold italic small omega
  , { code = 0x1D74F,  char = '𝝏',  class = 'ord',       cs = 'mbfitpartial'                       } -- mathematical bold italic partial differential
  , { code = 0x1D750,  char = '𝝐',  class = 'ord',       cs = 'mbfitvarepsilon', alphabet = 'boldgreek'} -- mathematical bold italic epsilon symbol
  , { code = 0x1D751,  char = '𝝑',  class = 'ord',       cs = 'mbfitvartheta', alphabet = 'boldgreek'} -- mathematical bold italic theta symbol
  , { code = 0x1D752,  char = '𝝒',  class = 'ord',       cs = 'mbfitvarkappa', alphabet = 'boldgreek'} -- mathematical bold italic kappa symbol
  , { code = 0x1D753,  char = '𝝓',  class = 'ord',       cs = 'mbfitvarphi', alphabet = 'boldgreek'} -- mathematical bold italic phi symbol
  , { code = 0x1D754,  char = '𝝔',  class = 'ord',       cs = 'mbfitvarrho', alphabet = 'boldgreek'} -- mathematical bold italic rho symbol
  , { code = 0x1D755,  char = '𝝕',  class = 'ord',       cs = 'mbfitvarpi', alphabet = 'boldgreek' } -- mathematical bold italic pi symbol
  , { code = 0x1D756,  char = '𝝖',  class = 'ord',       cs = 'mbfsansAlpha', alphabet = 'sansgreek'     } -- mathematical sans-serif bold capital alpha
  , { code = 0x1D757,  char = '𝝗',  class = 'ord',       cs = 'mbfsansBeta', alphabet = 'sansgreek'      } -- mathematical sans-serif bold capital beta
  , { code = 0x1D758,  char = '𝝘',  class = 'ord',       cs = 'mbfsansGamma', alphabet = 'sansgreek'     } -- mathematical sans-serif bold capital gamma
  , { code = 0x1D759,  char = '𝝙',  class = 'ord',       cs = 'mbfsansDelta', alphabet = 'sansgreek'     } -- mathematical sans-serif bold capital delta
  , { code = 0x1D75A,  char = '𝝚',  class = 'ord',       cs = 'mbfsansEpsilon', alphabet = 'sansgreek'   } -- mathematical sans-serif bold capital epsilon
  , { code = 0x1D75B,  char = '𝝛',  class = 'ord',       cs = 'mbfsansZeta', alphabet = 'sansgreek'      } -- mathematical sans-serif bold capital zeta
  , { code = 0x1D75C,  char = '𝝜',  class = 'ord',       cs = 'mbfsansEta', alphabet = 'sansgreek'       } -- mathematical sans-serif bold capital eta
  , { code = 0x1D75D,  char = '𝝝',  class = 'ord',       cs = 'mbfsansTheta', alphabet = 'sansgreek'     } -- mathematical sans-serif bold capital theta
  , { code = 0x1D75E,  char = '𝝞',  class = 'ord',       cs = 'mbfsansIota', alphabet = 'sansgreek'      } -- mathematical sans-serif bold capital iota
  , { code = 0x1D75F,  char = '𝝟',  class = 'ord',       cs = 'mbfsansKappa', alphabet = 'sansgreek'     } -- mathematical sans-serif bold capital kappa
  , { code = 0x1D760,  char = '𝝠',  class = 'ord',       cs = 'mbfsansLambda', alphabet = 'sansgreek'    } -- mathematical sans-serif bold capital lamda
  , { code = 0x1D761,  char = '𝝡',  class = 'ord',       cs = 'mbfsansMu', alphabet = 'sansgreek'        } -- mathematical sans-serif bold capital mu
  , { code = 0x1D762,  char = '𝝢',  class = 'ord',       cs = 'mbfsansNu', alphabet = 'sansgreek'        } -- mathematical sans-serif bold capital nu
  , { code = 0x1D763,  char = '𝝣',  class = 'ord',       cs = 'mbfsansXi', alphabet = 'sansgreek'        } -- mathematical sans-serif bold capital xi
  , { code = 0x1D764,  char = '𝝤',  class = 'ord',       cs = 'mbfsansOmicron', alphabet = 'sansgreek'   } -- mathematical sans-serif bold capital omicron
  , { code = 0x1D765,  char = '𝝥',  class = 'ord',       cs = 'mbfsansPi', alphabet = 'sansgreek'        } -- mathematical sans-serif bold capital pi
  , { code = 0x1D766,  char = '𝝦',  class = 'ord',       cs = 'mbfsansRho', alphabet = 'sansgreek'       } -- mathematical sans-serif bold capital rho
  , { code = 0x1D767,  char = '𝝧',  class = 'ord',       cs = 'mbfsansvarTheta', alphabet = 'sansgreek'  } -- mathematical sans-serif bold capital theta symbol
  , { code = 0x1D768,  char = '𝝨',  class = 'ord',       cs = 'mbfsansSigma', alphabet = 'sansgreek'     } -- mathematical sans-serif bold capital sigma
  , { code = 0x1D769,  char = '𝝩',  class = 'ord',       cs = 'mbfsansTau', alphabet = 'sansgreek'       } -- mathematical sans-serif bold capital tau
  , { code = 0x1D76A,  char = '𝝪',  class = 'ord',       cs = 'mbfsansUpsilon', alphabet = 'sansgreek'   } -- mathematical sans-serif bold capital upsilon
  , { code = 0x1D76B,  char = '𝝫',  class = 'ord',       cs = 'mbfsansPhi', alphabet = 'sansgreek'       } -- mathematical sans-serif bold capital phi
  , { code = 0x1D76C,  char = '𝝬',  class = 'ord',       cs = 'mbfsansChi', alphabet = 'sansgreek'       } -- mathematical sans-serif bold capital chi
  , { code = 0x1D76D,  char = '𝝭',  class = 'ord',       cs = 'mbfsansPsi', alphabet = 'sansgreek'       } -- mathematical sans-serif bold capital psi
  , { code = 0x1D76E,  char = '𝝮',  class = 'ord',       cs = 'mbfsansOmega', alphabet = 'sansgreek'     } -- mathematical sans-serif bold capital omega
  , { code = 0x1D76F,  char = '𝝯',  class = 'ord',       cs = 'mbfsansnabla'                             } -- mathematical sans-serif bold nabla
  , { code = 0x1D770,  char = '𝝰',  class = 'ord',       cs = 'mbfsansalpha', alphabet = 'sansgreek'     } -- mathematical sans-serif bold small alpha
  , { code = 0x1D771,  char = '𝝱',  class = 'ord',       cs = 'mbfsansbeta', alphabet = 'sansgreek'      } -- mathematical sans-serif bold small beta
  , { code = 0x1D772,  char = '𝝲',  class = 'ord',       cs = 'mbfsansgamma', alphabet = 'sansgreek'     } -- mathematical sans-serif bold small gamma
  , { code = 0x1D773,  char = '𝝳',  class = 'ord',       cs = 'mbfsansdelta', alphabet = 'sansgreek'     } -- mathematical sans-serif bold small delta
  , { code = 0x1D774,  char = '𝝴',  class = 'ord',       cs = 'mbfsansepsilon', alphabet = 'sansgreek'   } -- mathematical sans-serif bold small epsilon
  , { code = 0x1D775,  char = '𝝵',  class = 'ord',       cs = 'mbfsanszeta', alphabet = 'sansgreek'      } -- mathematical sans-serif bold small zeta
  , { code = 0x1D776,  char = '𝝶',  class = 'ord',       cs = 'mbfsanseta', alphabet = 'sansgreek'       } -- mathematical sans-serif bold small eta
  , { code = 0x1D777,  char = '𝝷',  class = 'ord',       cs = 'mbfsanstheta', alphabet = 'sansgreek'     } -- mathematical sans-serif bold small theta
  , { code = 0x1D778,  char = '𝝸',  class = 'ord',       cs = 'mbfsansiota', alphabet = 'sansgreek'      } -- mathematical sans-serif bold small iota
  , { code = 0x1D779,  char = '𝝹',  class = 'ord',       cs = 'mbfsanskappa', alphabet = 'sansgreek'     } -- mathematical sans-serif bold small kappa
  , { code = 0x1D77A,  char = '𝝺',  class = 'ord',       cs = 'mbfsanslambda', alphabet = 'sansgreek'    } -- mathematical sans-serif bold small lamda
  , { code = 0x1D77B,  char = '𝝻',  class = 'ord',       cs = 'mbfsansmu', alphabet = 'sansgreek'        } -- mathematical sans-serif bold small mu
  , { code = 0x1D77C,  char = '𝝼',  class = 'ord',       cs = 'mbfsansnu', alphabet = 'sansgreek'        } -- mathematical sans-serif bold small nu
  , { code = 0x1D77D,  char = '𝝽',  class = 'ord',       cs = 'mbfsansxi', alphabet = 'sansgreek'        } -- mathematical sans-serif bold small xi
  , { code = 0x1D77E,  char = '𝝾',  class = 'ord',       cs = 'mbfsansomicron', alphabet = 'sansgreek'   } -- mathematical sans-serif bold small omicron
  , { code = 0x1D77F,  char = '𝝿',  class = 'ord',       cs = 'mbfsanspi', alphabet = 'sansgreek'        } -- mathematical sans-serif bold small pi
  , { code = 0x1D780,  char = '𝞀',  class = 'ord',       cs = 'mbfsansrho', alphabet = 'sansgreek'       } -- mathematical sans-serif bold small rho
  , { code = 0x1D781,  char = '𝞁',  class = 'ord',       cs = 'mbfsansvarsigma', alphabet = 'sansgreek'  } -- mathematical sans-serif bold small final sigma
  , { code = 0x1D782,  char = '𝞂',  class = 'ord',       cs = 'mbfsanssigma', alphabet = 'sansgreek'     } -- mathematical sans-serif bold small sigma
  , { code = 0x1D783,  char = '𝞃',  class = 'ord',       cs = 'mbfsanstau', alphabet = 'sansgreek'       } -- mathematical sans-serif bold small tau
  , { code = 0x1D784,  char = '𝞄',  class = 'ord',       cs = 'mbfsansupsilon', alphabet = 'sansgreek'   } -- mathematical sans-serif bold small upsilon
  , { code = 0x1D785,  char = '𝞅',  class = 'ord',       cs = 'mbfsansphi', alphabet = 'sansgreek'       } -- mathematical sans-serif bold small phi
  , { code = 0x1D786,  char = '𝞆',  class = 'ord',       cs = 'mbfsanschi', alphabet = 'sansgreek'       } -- mathematical sans-serif bold small chi
  , { code = 0x1D787,  char = '𝞇',  class = 'ord',       cs = 'mbfsanspsi', alphabet = 'sansgreek'       } -- mathematical sans-serif bold small psi
  , { code = 0x1D788,  char = '𝞈',  class = 'ord',       cs = 'mbfsansomega', alphabet = 'sansgreek'     } -- mathematical sans-serif bold small omega
  , { code = 0x1D789,  char = '𝞉',  class = 'ord',       cs = 'mbfsanspartial'                           } -- mathematical sans-serif bold partial differential
  , { code = 0x1D78A,  char = '𝞊',  class = 'ord',       cs = 'mbfsansvarepsilon', alphabet = 'sansgreek'} -- mathematical sans-serif bold epsilon symbol
  , { code = 0x1D78B,  char = '𝞋',  class = 'ord',       cs = 'mbfsansvartheta', alphabet = 'sansgreek'  } -- mathematical sans-serif bold theta symbol
  , { code = 0x1D78C,  char = '𝞌',  class = 'ord',       cs = 'mbfsansvarkappa', alphabet = 'sansgreek'  } -- mathematical sans-serif bold kappa symbol
  , { code = 0x1D78D,  char = '𝞍',  class = 'ord',       cs = 'mbfsansvarphi', alphabet = 'sansgreek'    } -- mathematical sans-serif bold phi symbol
  , { code = 0x1D78E,  char = '𝞎',  class = 'ord',       cs = 'mbfsansvarrho', alphabet = 'sansgreek'    } -- mathematical sans-serif bold rho symbol
  , { code = 0x1D78F,  char = '𝞏',  class = 'ord',       cs = 'mbfsansvarpi', alphabet = 'sansgreek'     } -- mathematical sans-serif bold pi symbol
  , { code = 0x1D790,  char = '𝞐',  class = 'ord',       cs = 'mbfitsansAlpha', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic capital alpha
  , { code = 0x1D791,  char = '𝞑',  class = 'ord',       cs = 'mbfitsansBeta', alphabet = 'sansgreek'    } -- mathematical sans-serif bold italic capital beta
  , { code = 0x1D792,  char = '𝞒',  class = 'ord',       cs = 'mbfitsansGamma', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic capital gamma
  , { code = 0x1D793,  char = '𝞓',  class = 'ord',       cs = 'mbfitsansDelta', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic capital delta
  , { code = 0x1D794,  char = '𝞔',  class = 'ord',       cs = 'mbfitsansEpsilon', alphabet = 'sansgreek' } -- mathematical sans-serif bold italic capital epsilon
  , { code = 0x1D795,  char = '𝞕',  class = 'ord',       cs = 'mbfitsansZeta', alphabet = 'sansgreek'    } -- mathematical sans-serif bold italic capital zeta
  , { code = 0x1D796,  char = '𝞖',  class = 'ord',       cs = 'mbfitsansEta', alphabet = 'sansgreek'     } -- mathematical sans-serif bold italic capital eta
  , { code = 0x1D797,  char = '𝞗',  class = 'ord',       cs = 'mbfitsansTheta', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic capital theta
  , { code = 0x1D798,  char = '𝞘',  class = 'ord',       cs = 'mbfitsansIota', alphabet = 'sansgreek'    } -- mathematical sans-serif bold italic capital iota
  , { code = 0x1D799,  char = '𝞙',  class = 'ord',       cs = 'mbfitsansKappa', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic capital kappa
  , { code = 0x1D79A,  char = '𝞚',  class = 'ord',       cs = 'mbfitsansLambda', alphabet = 'sansgreek'  } -- mathematical sans-serif bold italic capital lamda
  , { code = 0x1D79B,  char = '𝞛',  class = 'ord',       cs = 'mbfitsansMu', alphabet = 'sansgreek'      } -- mathematical sans-serif bold italic capital mu
  , { code = 0x1D79C,  char = '𝞜',  class = 'ord',       cs = 'mbfitsansNu', alphabet = 'sansgreek'      } -- mathematical sans-serif bold italic capital nu
  , { code = 0x1D79D,  char = '𝞝',  class = 'ord',       cs = 'mbfitsansXi', alphabet = 'sansgreek'      } -- mathematical sans-serif bold italic capital xi
  , { code = 0x1D79E,  char = '𝞞',  class = 'ord',       cs = 'mbfitsansOmicron', alphabet = 'sansgreek' } -- mathematical sans-serif bold italic capital omicron
  , { code = 0x1D79F,  char = '𝞟',  class = 'ord',       cs = 'mbfitsansPi', alphabet = 'sansgreek'      } -- mathematical sans-serif bold italic capital pi
  , { code = 0x1D7A0,  char = '𝞠',  class = 'ord',       cs = 'mbfitsansRho', alphabet = 'sansgreek'     } -- mathematical sans-serif bold italic capital rho
  , { code = 0x1D7A1,  char = '𝞡',  class = 'ord',       cs = 'mbfitsansvarTheta', alphabet = 'sansgreek'} -- mathematical sans-serif bold italic capital theta symbol
  , { code = 0x1D7A2,  char = '𝞢',  class = 'ord',       cs = 'mbfitsansSigma', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic capital sigma
  , { code = 0x1D7A3,  char = '𝞣',  class = 'ord',       cs = 'mbfitsansTau', alphabet = 'sansgreek'     } -- mathematical sans-serif bold italic capital tau
  , { code = 0x1D7A4,  char = '𝞤',  class = 'ord',       cs = 'mbfitsansUpsilon', alphabet = 'sansgreek' } -- mathematical sans-serif bold italic capital upsilon
  , { code = 0x1D7A5,  char = '𝞥',  class = 'ord',       cs = 'mbfitsansPhi', alphabet = 'sansgreek'     } -- mathematical sans-serif bold italic capital phi
  , { code = 0x1D7A6,  char = '𝞦',  class = 'ord',       cs = 'mbfitsansChi', alphabet = 'sansgreek'     } -- mathematical sans-serif bold italic capital chi
  , { code = 0x1D7A7,  char = '𝞧',  class = 'ord',       cs = 'mbfitsansPsi', alphabet = 'sansgreek'     } -- mathematical sans-serif bold italic capital psi
  , { code = 0x1D7A8,  char = '𝞨',  class = 'ord',       cs = 'mbfitsansOmega', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic capital omega
  , { code = 0x1D7A9,  char = '𝞩',  class = 'ord',       cs = 'mbfitsansnabla'                           } -- mathematical sans-serif bold italic nabla
  , { code = 0x1D7AA,  char = '𝞪',  class = 'ord',       cs = 'mbfitsansalpha', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic small alpha
  , { code = 0x1D7AB,  char = '𝞫',  class = 'ord',       cs = 'mbfitsansbeta', alphabet = 'sansgreek'    } -- mathematical sans-serif bold italic small beta
  , { code = 0x1D7AC,  char = '𝞬',  class = 'ord',       cs = 'mbfitsansgamma', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic small gamma
  , { code = 0x1D7AD,  char = '𝞭',  class = 'ord',       cs = 'mbfitsansdelta', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic small delta
  , { code = 0x1D7AE,  char = '𝞮',  class = 'ord',       cs = 'mbfitsansepsilon', alphabet = 'sansgreek' } -- mathematical sans-serif bold italic small epsilon
  , { code = 0x1D7AF,  char = '𝞯',  class = 'ord',       cs = 'mbfitsanszeta', alphabet = 'sansgreek'    } -- mathematical sans-serif bold italic small zeta
  , { code = 0x1D7B0,  char = '𝞰',  class = 'ord',       cs = 'mbfitsanseta', alphabet = 'sansgreek'     } -- mathematical sans-serif bold italic small eta
  , { code = 0x1D7B1,  char = '𝞱',  class = 'ord',       cs = 'mbfitsanstheta', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic small theta
  , { code = 0x1D7B2,  char = '𝞲',  class = 'ord',       cs = 'mbfitsansiota', alphabet = 'sansgreek'    } -- mathematical sans-serif bold italic small iota
  , { code = 0x1D7B3,  char = '𝞳',  class = 'ord',       cs = 'mbfitsanskappa', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic small kappa
  , { code = 0x1D7B4,  char = '𝞴',  class = 'ord',       cs = 'mbfitsanslambda', alphabet = 'sansgreek'  } -- mathematical sans-serif bold italic small lamda
  , { code = 0x1D7B5,  char = '𝞵',  class = 'ord',       cs = 'mbfitsansmu', alphabet = 'sansgreek'      } -- mathematical sans-serif bold italic small mu
  , { code = 0x1D7B6,  char = '𝞶',  class = 'ord',       cs = 'mbfitsansnu', alphabet = 'sansgreek'      } -- mathematical sans-serif bold italic small nu
  , { code = 0x1D7B7,  char = '𝞷',  class = 'ord',       cs = 'mbfitsansxi', alphabet = 'sansgreek'      } -- mathematical sans-serif bold italic small xi
  , { code = 0x1D7B8,  char = '𝞸',  class = 'ord',       cs = 'mbfitsansomicron', alphabet = 'sansgreek' } -- mathematical sans-serif bold italic small omicron
  , { code = 0x1D7B9,  char = '𝞹',  class = 'ord',       cs = 'mbfitsanspi', alphabet = 'sansgreek'      } -- mathematical sans-serif bold italic small pi
  , { code = 0x1D7BA,  char = '𝞺',  class = 'ord',       cs = 'mbfitsansrho', alphabet = 'sansgreek'     } -- mathematical sans-serif bold italic small rho
  , { code = 0x1D7BB,  char = '𝞻',  class = 'ord',       cs = 'mbfitsansvarsigma', alphabet = 'sansgreek'} -- mathematical sans-serif bold italic small final sigma
  , { code = 0x1D7BC,  char = '𝞼',  class = 'ord',       cs = 'mbfitsanssigma', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic small sigma
  , { code = 0x1D7BD,  char = '𝞽',  class = 'ord',       cs = 'mbfitsanstau', alphabet = 'sansgreek'     } -- mathematical sans-serif bold italic small tau
  , { code = 0x1D7BE,  char = '𝞾',  class = 'ord',       cs = 'mbfitsansupsilon', alphabet = 'sansgreek' } -- mathematical sans-serif bold italic small upsilon
  , { code = 0x1D7BF,  char = '𝞿',  class = 'ord',       cs = 'mbfitsansphi', alphabet = 'sansgreek'     } -- mathematical sans-serif bold italic small phi
  , { code = 0x1D7C0,  char = '𝟀',  class = 'ord',       cs = 'mbfitsanschi', alphabet = 'sansgreek'     } -- mathematical sans-serif bold italic small chi
  , { code = 0x1D7C1,  char = '𝟁',  class = 'ord',       cs = 'mbfitsanspsi', alphabet = 'sansgreek'     } -- mathematical sans-serif bold italic small psi
  , { code = 0x1D7C2,  char = '𝟂',  class = 'ord',       cs = 'mbfitsansomega', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic small omega
  , { code = 0x1D7C3,  char = '𝟃',  class = 'ord',       cs = 'mbfitsanspartial'                         } -- mathematical sans-serif bold italic partial differential
  , { code = 0x1D7C4,  char = '𝟄',  class = 'ord',       cs = 'mbfitsansvarepsilon', alphabet = 'sansgreek'} -- mathematical sans-serif bold italic epsilon symbol
  , { code = 0x1D7C5,  char = '𝟅',  class = 'ord',       cs = 'mbfitsansvartheta', alphabet = 'sansgreek'} -- mathematical sans-serif bold italic theta symbol
  , { code = 0x1D7C6,  char = '𝟆',  class = 'ord',       cs = 'mbfitsansvarkappa', alphabet = 'sansgreek'} -- mathematical sans-serif bold italic kappa symbol
  , { code = 0x1D7C7,  char = '𝟇',  class = 'ord',       cs = 'mbfitsansvarphi', alphabet = 'sansgreek'  } -- mathematical sans-serif bold italic phi symbol
  , { code = 0x1D7C8,  char = '𝟈',  class = 'ord',       cs = 'mbfitsansvarrho', alphabet = 'sansgreek'  } -- mathematical sans-serif bold italic rho symbol
  , { code = 0x1D7C9,  char = '𝟉',  class = 'ord',       cs = 'mbfitsansvarpi', alphabet = 'sansgreek'   } -- mathematical sans-serif bold italic pi symbol
  , { code = 0x1D7CA,  char = '𝟊',  class = 'ord',       cs = 'mbfDigamma', alphabet = 'boldgreek'} -- mathematical bold capital digamma
  , { code = 0x1D7CB,  char = '𝟋',  class = 'ord',       cs = 'mbfdigamma', alphabet = 'boldgreek'} -- mathematical bold small digamma
  , { code = 0x1D7CE,  char = '𝟎',  class = 'ord',       cs = 'mbfzero', alphabet = 'bold'        } -- mathematical bold digit zero
  , { code = 0x1D7CF,  char = '𝟏',  class = 'ord',       cs = 'mbfone', alphabet = 'bold'         } -- mathematical bold digit one
  , { code = 0x1D7D0,  char = '𝟐',  class = 'ord',       cs = 'mbftwo', alphabet = 'bold'         } -- mathematical bold digit two
  , { code = 0x1D7D1,  char = '𝟑',  class = 'ord',       cs = 'mbfthree', alphabet = 'bold'       } -- mathematical bold digit three
  , { code = 0x1D7D2,  char = '𝟒',  class = 'ord',       cs = 'mbffour', alphabet = 'bold'        } -- mathematical bold digit four
  , { code = 0x1D7D3,  char = '𝟓',  class = 'ord',       cs = 'mbffive', alphabet = 'bold'        } -- mathematical bold digit five
  , { code = 0x1D7D4,  char = '𝟔',  class = 'ord',       cs = 'mbfsix', alphabet = 'bold'         } -- mathematical bold digit six
  , { code = 0x1D7D5,  char = '𝟕',  class = 'ord',       cs = 'mbfseven', alphabet = 'bold'       } -- mathematical bold digit seven
  , { code = 0x1D7D6,  char = '𝟖',  class = 'ord',       cs = 'mbfeight', alphabet = 'bold'       } -- mathematical bold digit eight
  , { code = 0x1D7D7,  char = '𝟗',  class = 'ord',       cs = 'mbfnine', alphabet = 'bold'        } -- mathematical bold digit nine
  , { code = 0x1D7D8,  char = '𝟘',  class = 'ord',       cs = 'Bbbzero', alphabet = 'blackboard'  } -- mathematical double-struck digit zero
  , { code = 0x1D7D9,  char = '𝟙',  class = 'ord',       cs = 'Bbbone', alphabet = 'blackboard'   } -- mathematical double-struck digit one
  , { code = 0x1D7DA,  char = '𝟚',  class = 'ord',       cs = 'Bbbtwo', alphabet = 'blackboard'   } -- mathematical double-struck digit two
  , { code = 0x1D7DB,  char = '𝟛',  class = 'ord',       cs = 'Bbbthree', alphabet = 'blackboard' } -- mathematical double-struck digit three
  , { code = 0x1D7DC,  char = '𝟜',  class = 'ord',       cs = 'Bbbfour', alphabet = 'blackboard'  } -- mathematical double-struck digit four
  , { code = 0x1D7DD,  char = '𝟝',  class = 'ord',       cs = 'Bbbfive', alphabet = 'blackboard'  } -- mathematical double-struck digit five
  , { code = 0x1D7DE,  char = '𝟞',  class = 'ord',       cs = 'Bbbsix', alphabet = 'blackboard'   } -- mathematical double-struck digit six
  , { code = 0x1D7DF,  char = '𝟟',  class = 'ord',       cs = 'Bbbseven', alphabet = 'blackboard' } -- mathematical double-struck digit seven
  , { code = 0x1D7E0,  char = '𝟠',  class = 'ord',       cs = 'Bbbeight', alphabet = 'blackboard' } -- mathematical double-struck digit eight
  , { code = 0x1D7E1,  char = '𝟡',  class = 'ord',       cs = 'Bbbnine', alphabet = 'blackboard'  } -- mathematical double-struck digit nine
  , { code = 0x1D7E2,  char = '𝟢',  class = 'ord',       cs = 'msanszero', alphabet = 'sans'      } -- mathematical sans-serif digit zero
  , { code = 0x1D7E3,  char = '𝟣',  class = 'ord',       cs = 'msansone', alphabet = 'sans'       } -- mathematical sans-serif digit one
  , { code = 0x1D7E4,  char = '𝟤',  class = 'ord',       cs = 'msanstwo', alphabet = 'sans'       } -- mathematical sans-serif digit two
  , { code = 0x1D7E5,  char = '𝟥',  class = 'ord',       cs = 'msansthree', alphabet = 'sans'     } -- mathematical sans-serif digit three
  , { code = 0x1D7E6,  char = '𝟦',  class = 'ord',       cs = 'msansfour', alphabet = 'sans'      } -- mathematical sans-serif digit four
  , { code = 0x1D7E7,  char = '𝟧',  class = 'ord',       cs = 'msansfive', alphabet = 'sans'      } -- mathematical sans-serif digit five
  , { code = 0x1D7E8,  char = '𝟨',  class = 'ord',       cs = 'msanssix', alphabet = 'sans'       } -- mathematical sans-serif digit six
  , { code = 0x1D7E9,  char = '𝟩',  class = 'ord',       cs = 'msansseven', alphabet = 'sans'     } -- mathematical sans-serif digit seven
  , { code = 0x1D7EA,  char = '𝟪',  class = 'ord',       cs = 'msanseight', alphabet = 'sans'     } -- mathematical sans-serif digit eight
  , { code = 0x1D7EB,  char = '𝟫',  class = 'ord',       cs = 'msansnine', alphabet = 'sans'      } -- mathematical sans-serif digit nine
  , { code = 0x1D7EC,  char = '𝟬',  class = 'ord',       cs = 'mbfsanszero', alphabet = 'sans'    } -- mathematical sans-serif bold digit zero
  , { code = 0x1D7ED,  char = '𝟭',  class = 'ord',       cs = 'mbfsansone', alphabet = 'sans'     } -- mathematical sans-serif bold digit one
  , { code = 0x1D7EE,  char = '𝟮',  class = 'ord',       cs = 'mbfsanstwo', alphabet = 'sans'     } -- mathematical sans-serif bold digit two
  , { code = 0x1D7EF,  char = '𝟯',  class = 'ord',       cs = 'mbfsansthree', alphabet = 'sans'   } -- mathematical sans-serif bold digit three
  , { code = 0x1D7F0,  char = '𝟰',  class = 'ord',       cs = 'mbfsansfour', alphabet = 'sans'    } -- mathematical sans-serif bold digit four
  , { code = 0x1D7F1,  char = '𝟱',  class = 'ord',       cs = 'mbfsansfive', alphabet = 'sans'    } -- mathematical sans-serif bold digit five
  , { code = 0x1D7F2,  char = '𝟲',  class = 'ord',       cs = 'mbfsanssix', alphabet = 'sans'     } -- mathematical sans-serif bold digit six
  , { code = 0x1D7F3,  char = '𝟳',  class = 'ord',       cs = 'mbfsansseven', alphabet = 'sans'   } -- mathematical sans-serif bold digit seven
  , { code = 0x1D7F4,  char = '𝟴',  class = 'ord',       cs = 'mbfsanseight', alphabet = 'sans'   } -- mathematical sans-serif bold digit eight
  , { code = 0x1D7F5,  char = '𝟵',  class = 'ord',       cs = 'mbfsansnine', alphabet = 'sans'    } -- mathematical sans-serif bold digit nine
  , { code = 0x1D7F6,  char = '𝟶',  class = 'ord',       cs = 'mttzero', alphabet = 'mono'        } -- mathematical monospace digit zero
  , { code = 0x1D7F7,  char = '𝟷',  class = 'ord',       cs = 'mttone', alphabet = 'mono'         } -- mathematical monospace digit one
  , { code = 0x1D7F8,  char = '𝟸',  class = 'ord',       cs = 'mtttwo', alphabet = 'mono'         } -- mathematical monospace digit two
  , { code = 0x1D7F9,  char = '𝟹',  class = 'ord',       cs = 'mttthree', alphabet = 'mono'       } -- mathematical monospace digit three
  , { code = 0x1D7FA,  char = '𝟺',  class = 'ord',       cs = 'mttfour', alphabet = 'mono'        } -- mathematical monospace digit four
  , { code = 0x1D7FB,  char = '𝟻',  class = 'ord',       cs = 'mttfive', alphabet = 'mono'        } -- mathematical monospace digit five
  , { code = 0x1D7FC,  char = '𝟼',  class = 'ord',       cs = 'mttsix', alphabet = 'mono'         } -- mathematical monospace digit six
  , { code = 0x1D7FD,  char = '𝟽',  class = 'ord',       cs = 'mttseven', alphabet = 'mono'       } -- mathematical monospace digit seven
  , { code = 0x1D7FE,  char = '𝟾',  class = 'ord',       cs = 'mtteight', alphabet = 'mono'       } -- mathematical monospace digit eight
  , { code = 0x1D7FF,  char = '𝟿',  class = 'ord',       cs = 'mttnine', alphabet = 'mono'        } -- mathematical monospace digit nine
}
