%% Copyright (c) 2008-2009 Tim Fletcher <http://tfletcher.com/>
%% Copyright (c) 2015      Christoher Meng <http://cicku.me/>
%% 
%% Permission is hereby granted, free of charge, to any person
%% obtaining a copy of this software and associated documentation
%% files (the "Software"), to deal in the Software without
%% restriction, including without limitation the rights to use,
%% copy, modify, merge, publish, distribute, sublicense, and/or sell
%% copies of the Software, and to permit persons to whom the
%% Software is furnished to do so, subject to the following
%% conditions:
%% 
%% The above copyright notice and this permission notice shall be
%% included in all copies or substantial portions of the Software.
%% 
%% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
%% EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
%% OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
%% NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
%% HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
%% WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
%% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
%% OTHER DEALINGS IN THE SOFTWARE.

-module(oauth_hmac_sha1).

-export([signature/3, verify/4]).

-spec signature(string(), string(), string()) -> string().
signature(BaseString, CS, TS) ->
  Key = oauth_uri:calate("&", [CS, TS]),
  base64:encode_to_string(sha2hmac(Key, BaseString)).

sha2hmac(Key, Data) ->
  case erlang:function_exported(crypto, hmac, 3) of
    true ->
      crypto:hmac(sha, Key, Data);
    false ->
      crypto:sha_mac(Key, Data)
  end.

-spec verify(string(), string(), string(), string()) -> boolean().
verify(Signature, BaseString, CS, TS) ->
  Signature =:= signature(BaseString, CS, TS).
