/*
    Tucnak - VHF contest log
    Copyright (C) 2002-20011  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Interface for MSVC compiler
*/

#ifdef __MSVC2
#ifndef __MSVC2_H
#define fopen(file, mode) fopen(wokna(file), mode)
#endif
#endif

#ifndef __MSVC_H
#define __MSVC_H

#include "stdafx.h"
#pragma warning(disable : 4018)
#pragma warning(disable : 4101)
#pragma warning(disable : 4244)
#pragma warning(disable : 4996)

//todo remove
#pragma warning(disable : 4028)
#pragma warning(disable : 4030)

#define _CRT_SECURE_NO_WARNINGS

#define WINVER 0x0500
#define _WIN32_WINNT 0x0500

#include <WinSock2.h>
#include <Windows.h>
#include <sys/timeb.h>
#include <time.h>				  
#include <direct.h>
#include <process.h>
#include <io.h>

#include "regex_.h"


#define PACKAGE "tucnak2"
#define VERSION "2.41"
#define PACKAGE_NAME PACKAGE
#define PACKAGE_VERSION VERSION
#define SHAREDIR 
#define HAVE_STDINT_H
#define HAVE_UINT32_T
#define HAVE_SDL
#define HAVE_ICONV_H
#define HAVE_PNG_H
#define HAVE_LIBPNG

#ifndef HAVE_MATH_H
#define HAVE_MATH_H
#endif


#define strcasecmp _stricmp
#define strncasecmp _strnicmp
#define tmkdir(dir, mode) mkdir(dir)
#define dup(fd) _dup(fd)
#define dup2(oldfd, newfd) _dup2(oldfd, newfd)
#define getpid _getpid
#define SO4 (char *)
#define __attribute__(attr)

typedef int mode_t;
typedef int pid_t;
typedef int socklen_t;
typedef int speed_t;
typedef int iconv_t;


extern char *txt_settings;


/*typedef struct timeval{
	int tv_sec, tv_usec;
};
*/
int gettimeofday(struct timeval *tv, void *zone);
int settimeofday(const struct timeval *tv, const void *zone);



#define  B50    0000001
#define  B75    0000002
#define  B110   0000003
#define  B134   0000004
#define  B150   0000005
#define  B200   0000006
#define  B300   0000007
#define  B600   0000010
#define  B1200  0000011
#define  B1800  0000012
#define  B2400  0000013
#define  B4800  0000014
#define  B9600  0000015
#define  B19200 0000016
#define  B38400 0000017

#define IGNBRK  0000001
#define BRKINT  0000002
#define IGNPAR  0000004
#define PARMRK  0000010
#define INPCK   0000020
#define ISTRIP  0000040
#define INLCR   0000100
#define IGNCR   0000200
#define ICRNL   0000400
#define IXON    0002000

#define OPOST   0000001

#define ISIG    0000001
#define ICANON  0000002
#define ECHO    0000010
#define ECHOE   0000020
#define ECHONL  0000100
#define IEXTEN  0100000

#define CSIZE   0000060
#define   CS8   0000060
#define CSTOPB  0000100
#define CREAD   0000200
#define PARENB  0000400
#define PARODD  0001000
#define CLOCAL  0004000
#define TCSANOW         0
#define INPCK   0000020
#define CRTSCTS  020000000000
#define VTIME 5
#define VMIN 6
#define WNOHANG         1

#define TCIFLUSH        0

#define NCCS 32
typedef struct termios{
	int c_iflag, c_oflag, c_cflag, c_lflag;
	char c_cc[NCCS];
		
};

/* file */

#define O_RDONLY             00
#define O_WRONLY             01
#define O_RDWR               02
#define O_CREAT            0100
#define O_EXCL             0200
#define O_NOCTTY           0400
#define O_SYNC           010000


char *wokna(char *file);
int open(const char *pathname, int flags);
int close(int fd);
int read(int fd, void *buf, int count);
int write(int fd, const void *buf, int count);
int pipe(int *fds);
int fsync(int fd);
int lockf(int fd, int cmd, off_t len);
int ftruncate(int fd, off_t length);
int tcgetattr(int fd, struct termios *termios_p);
int tcsetattr(int fd, int optional_actions, const struct termios *termios_p);
int tcflush(int fd, int queue_selector);
int cfsetispeed(struct termios *termios_p, speed_t speed);
int cfsetospeed(struct termios *termios_p, speed_t speed);
void cfmakeraw(struct termios *termios_p);
int _dup(int fd);
int _dup2(int oldfd, int newfd);


/* ioctl */

#define TIOCM_DTR       0x002
#define TIOCM_RTS       0x004
#define TIOCGWINSZ      0x5413
#define TIOCSWINSZ      0x5414
#define TIOCMBIS        0x5416
#define TIOCMBIC        0x5417
#define TIOCLINUX       0x541C

int ioctl(int d, int request, ...);

/* fcntl */

#define F_SETFL         4 
#define O_NONBLOCK        04000

int fcntl(int fd, int cmd, long arg);

/* signal */

#define SIGHUP          1
#define SIGPIPE         13
#define SIGCHLD         17

typedef struct siginfo_t {
	int dommy;
}siginfo_t;

typedef int sigset_t;

struct sigaction {
    void     (*sa_handler)(int);
    void     (*sa_sigaction)(int, siginfo_t *, void *);
    sigset_t   sa_mask;
    int        sa_flags;
    void     (*sa_restorer)(void);
};

int sigaction(int signum, const struct sigaction *act, struct sigaction *oldact);
int sigfillset(sigset_t *set);


/* misc */

#define strtok_r strtok_s
int main(int argc, char *argv[]);
int CALLBACK WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow);

void sleep(int sec);
void usleep(int usec);
struct tm *gmtime_r(time_t *timep, struct tm *result);
void *sbrk(int increment);
char *strerror_r(int err_no, char *buf, int size);
int setenv(const char *name, const char *value, int overwrite);

/* socket */
#define sock_errno WSAGetLastError()
char *sock_strerror_r(int err, char *errstr, int size);
int inet_aton(const char *cp, struct in_addr *inp);


/* process */
pid_t fork(void);
int kill(pid_t pid, int sig);
pid_t waitpid(pid_t pid, int *status, int options);


/* directory */

#define __S_IFMT        0170000 
#define __S_IFDIR       0040000
#define __S_IFREG       0100000

#define __S_ISTYPE(mode, mask)  (((mode) & __S_IFMT) == (mask))
#define S_ISDIR(mode)    __S_ISTYPE((mode), __S_IFDIR)
#define S_ISREG(mode)    __S_ISTYPE((mode), __S_IFREG)

typedef struct dirent{
	char d_name[_MAX_PATH];
};

typedef struct DIR{
	long                handle; /* -1 for failed rewind */
    struct _finddata_t  info;
    struct dirent       result; /* d_name null iff first time */
    char                *name;  /* null-terminated char string */
}DIR;


DIR *opendir(char *name);
struct dirent *readdir(DIR *dir);
int closedir(DIR *dir);

#endif
