/*	############################################################
	# @(#) chr_next.h
	# @(#)
	# @(#) Copyright (c) 1995-2001 by Dirk Hagedorn
	# @(#) Dirk Hagedorn (udo@dirk-hagedorn.de)
	#
	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.
	# 
	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.
	# 
	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	# 
	# @(#) Uebersetzungstabellen fuer NeXTStep
	############################################################	*/

#include	"portab.h"

#ifndef ID_CHARSET_H
#define	ID_CHARSET_H
const char *id_charset_h= "@(#) chr_next.h  07.12.1997";
#endif

#ifndef	THIS_CHARSET
#define	THIS_CHARSET	"NeXTStep"
#endif


/*	------------------------------------------------------------	*/

/*	############################################################
	# ISO-Zeichensatz in System-Zeichensatz umsetzen
	############################################################	*/
typedef struct _iso2sys
{	unsigned char	iso;
	unsigned char	sys;
}	ISO2SYS;


LOCAL const ISO2SYS iso2sys_item[128]=
{
	{ 128, 0 },					/* null		*/
	{ 129, 0 },					/* null		*/
	{ 130, 184 },				/* '' (9u)	*/
	{ 131, 166 },				/* #f		*/
	{ 132, 185 },				/* "" (99u)	*/
	{ 133, 188 },				/* !..		*/
	{ 134, 178 },				/* #dag		*/
	{ 135, 179 },				/* 2x#dag	*/
	{ 136, 195 },				/* #circ	*/
	{ 137, 189 },				/* #promill	*/
	{ 138, 0 },					/* vS		*/	/* !!!! */
	{ 139, 172 },				/* <		*/
	{ 140, 234 },				/* &OE		*/
	{ 141, 0 },					/* null		*/
	{ 142, 0 },					/* null		*/
	{ 143, 0 },					/* null		*/
	{ 144, 0 },					/* null		*/
	{ 145, 169 },				/* ` (6o)	*/
	{ 146, 169 },				/* '' (9o)	*/
	{ 147, 170 },				/* "" (66o)	*/
	{ 148, 185 },				/* "" (99o)	*/
	{ 149, 183 },				/* #bullet	*/
	{ 150, 177 },				/* --		*/
	{ 151, 208 },				/* ---		*/
	{ 152, 196 },				/* !~		*/
	{ 153, 0 },					/* #tm		*/	/* !!!! */
	{ 154, 0 },					/* vs		*/	/* !!!! */
	{ 155, 173 },				/* >		*/
	{ 156, 250 },				/* &oe		*/
	{ 157, 0 },					/* null		*/
	{ 158, 0 },					/* null		*/
	{ 159, 0 },					/* "Y		*/	/* !!!! */
	{ 160, 0 },					/* null		*/
	{ 161, 161 },				/* #!		*/
	{ 162, 162 },				/* #cent	*/
	{ 163, 163 },				/* #pound	*/
	{ 164, 168 },				/* general currency	*/
	{ 165, 165 },				/* #yen		*/
	{ 166, 181 },				/* broken dash	*/
	{ 167, 157 },				/* #sect	*/
	{ 168, 200 },				/* #"		*/
	{ 169, 160 },				/* #copy	*/
	{ 170, 227 },				/* _a		*/
	{ 171, 171 },				/* #<		*/
	{ 172, 190 },				/* #neg		*/
	{ 173, 0 },					/* strich	*/	/* !!!! */
	{ 174, 176 },				/* #reg		*/
	{ 175, 0 },					/* #macron	*/	/* !!!! */
	{ 176, 202 },				/* #degree	*/
	{ 177, 209 },				/* #pm		*/
	{ 178, 201 },				/* #^2		*/
	{ 179, 204 },				/* #^3		*/
	{ 180, 194 },				/* #'		*/
	{ 181, 157 },				/* #mu		*/
	{ 182, 182 },				/* #p		*/
	{ 183, 180 },				/* #cdot	*/
	{ 184, 203 },				/* cedille	*/
	{ 185, 192 },				/* #^1		*/
	{ 186, 235 },				/* _o		*/
	{ 187, 187 },				/* #>		*/
	{ 188, 210 },				/* #1/4		*/
	{ 189, 211 },				/* #1/2		*/
	{ 190, 212 },				/* #3/4		*/
	{ 191, 191 },				/* #?		*/
	{ 192, 129 },				/* `A		*/
	{ 193, 130 },				/* 'A		*/
	{ 194, 131 },				/* ^A		*/
	{ 195, 132 },				/* ~A		*/
	{ 196, 133 },				/* "A		*/
	{ 197, 134 },				/* .A		*/
	{ 198, 225 },				/* &AE		*/
	{ 199, 135 },				/* ,C		*/
	{ 200, 136 },				/* `E		*/
	{ 201, 137 },				/* 'E		*/
	{ 202, 138 },				/* ^E		*/
	{ 203, 139 },				/* "E		*/
	{ 204, 140 },				/* `I		*/
	{ 205, 141 },				/* 'I		*/
	{ 206, 142 },				/* ^I		*/
	{ 207, 143 },				/* "I		*/
	{ 208, 144 },				/* -D		*/
	{ 209, 145 },				/* ~N		*/
	{ 210, 146 },				/* `O		*/
	{ 211, 147 },				/* 'O		*/
	{ 212, 148 },				/* ^O		*/
	{ 213, 149 },				/* ~O		*/
	{ 214, 150 },				/* "O		*/
	{ 215, 158 },				/* #times	*/
	{ 216, 233 },				/* /O		*/
	{ 217, 151 },				/* `U		*/
	{ 218, 152 },				/* 'U		*/
	{ 219, 153 },				/* ^U		*/
	{ 220, 154 },				/* "U		*/
	{ 221, 155 },				/* 'Y		*/
	{ 222, 156 },				/* |b		*/
	{ 223, 251 },				/* "s (sz)	*/
	{ 224, 213 },				/* `a		*/
	{ 225, 214 },				/* 'a		*/
	{ 226, 215 },				/* ^a		*/
	{ 227, 216 },				/* ~a		*/
	{ 228, 217 },				/* "a		*/
	{ 229, 218 },				/* .a		*/
	{ 230, 241 },				/* &ae		*/
	{ 231, 219 },				/* ,c		*/
	{ 232, 220 },				/* `e		*/
	{ 233, 221 },				/* 'e		*/
	{ 234, 222 },				/* ^e		*/
	{ 235, 223 },				/* "e		*/
	{ 236, 224 },				/* `i		*/
	{ 237, 226 },				/* 'i		*/
	{ 238, 228 },				/* ^i		*/
	{ 239, 229 },				/* "i		*/
	{ 240, 230 },				/* o|''		*/
	{ 241, 231 },				/* ~n		*/
	{ 242, 236 },				/* `o		*/
	{ 243, 237 },				/* 'o		*/
	{ 244, 238 },				/* ^o		*/
	{ 245, 239 },				/* ~o		*/
	{ 246, 240 },				/* "o		*/
	{ 247, 159 },				/* #div		*/
	{ 248, 249 },				/* /o		*/
	{ 249, 242 },				/* `u		*/
	{ 250, 243 },				/* 'u		*/
	{ 251, 244 },				/* ^u		*/
	{ 252, 246 },				/* "u		*/
	{ 253, 247 },				/* 'y		*/
	{ 254, 252 },				/* |B		*/
	{ 255, 253 },				/* "y		*/
};

/*	------------------------------------------------------------	*/

/*	############################################################
	# Systemzeichensatz in andere Zeichensaetze umwandeln
	############################################################	*/

typedef struct _chartable
{
	unsigned char	system;
	char ascii[16];
	char ansi[16];
	char tex[16];
	char html[10];
}	CHARTABLE;

LOCAL /* const */ CHARTABLE chrtab[128]=
{
	{	'\200', "",		"",				"",					""			},
	{	'\201',	"A",	"\\'C0",		"\\`{A}",			"&Agrave;"	},
	{	'\202',	"A",	"\\'C1",		"\\'{A}",			"&Aacute;"	},
	{	'\203',	"A",	"\\'C2",		"\\^{A}",			"&Acirc;"	},
	{	'\204',	"A",	"\\'C3",		"\\~{A}",			"&Atilde;"	},
	{	'\205',	"Ae",	"\\'C4",		"{\\\"A}",			"&Auml;"	},
	{	'\206',	"A",	"\\'C5",		"{\\AA}",			"&Aring;"	},
	{	'\207',	"C",	"\\'C7",		"\\c{C}",			"&Ccedil;"	},
	
	{	'\210',	"E",	"\\'C8",		"\\`{E}",			"&Egrave;"	},
	{	'\211',	"E",	"\\'C9",		"\\'{E}",			"&Eacute;"	},
	{	'\212',	"E",	"\\'CA",		"\\^{E}",			"&Ecirc;"	},
	{	'\213',	"E",	"\\'CB",		"\\\"{E}",			"&Euml;"	},
	{	'\214',	"I",	"\\'CC",		"\\`{I}",			"&Igrave;"	},
	{	'\215',	"I",	"\\'CD",		"\\'{I}",			"&Iacute;"	},
	{	'\216',	"I",	"\\'CE",		"\\^{I}",			"&Icirc;"	},
	{	'\217',	"I",	"\\'CF",		"\\\"{I}",			"&Iuml;"	},

	{	'\220', "D",	"\\'D0",		"",					"&#208;"	},	/* -D */
	{	'\221',	"N",	"\\'D1",		"\\~{N}",			"&Ntilde;"	},
	{	'\222',	"O",	"\\'D2",		"\\`{O}",			"&Ograve;"	},
	{	'\223',	"O",	"\\'D3",		"\\'{O}",			"&Oacute;"	},
	{	'\224',	"O",	"\\'D4",		"\\^{O}",			"&Ocirc;"	},
	{	'\225',	"O",	"\\'D5",		"\\~{O}",			"&Otilde;"	},
	{	'\226',	"Oe",	"\\'D6",		"{\\\"O}",			"&Ouml;"	},
	{	'\227',	"U",	"\\'D9",		"\\`{U}",			"&Ugrave;"	},

	{	'\230',	"U",	"\\'DA",		"\\'{U}",			"&Uacute;"	},
	{	'\231',	"U",	"\\'DB",		"\\^{U}",			"&Ucirc;"	},
	{	'\232',	"Ue",	"\\'DC",		"{\\\"U}",			"&Uuml;"	},
	{	'\233', "Y",	"\\'DD",		"\\'{Y}",			"&Yacute;"	},
	{	'\234', "",		"\\'DE",		"",					"&#222;"	},	/* |o */
	{	'\235', "",		"\\'B5",		"$\\mu$",			"&#181;"	},
	{	'\236', "x",	"\\'D7",		"$\\times$",		"&#215;"	},
	{	'\237', "",		"\\'F7",		"$\\div$",			"&#247;"	},

	{	'\240', "(C)",	"\\'A9",		"\\copyright{}",	"&copy;"	},
	{	'\241', "!",	"\\'A1",		"!`",				"&#161;"	},
	{	'\242',	"",		"\\'A2",		"cent",				"&#162;"	},
	{	'\243',	"",		"\\'A3",		"\\pounds{}",		"&#163;"	},
	{	'\244',	"/",	"{\\f2 \\'A4}",	"/",				"/"			},
	{	'\245',	"",		"\\'A5",		"yen",				"&#165;"	},
	{	'\246',	"f",	"\\'83",		"$f$",				"&#131;"	},
	{	'\247',	"",		"\\'A7",		"\\S{}",			"&sect;"	},

	{	'\250',	"",		"\\'A4",		"",					"&#164;"	},	/* gcs */
	{	'\251',	"",		"\\'B4",		"\\'{ }",			"&#180;"	},
	{	'\252',	"",		"\\'94",		"''",				"&#148;"	},
	{	'\253',	"<<",	"\\'AB",		"\"<",				"&#171;"	},
	{	'\254',	"<",	"<",			"$<$",				"&lt;"		},
	{	'\255',	">",	">",			"$>$",				"&gt;"		},
	{	'\256',	"fi",	"fi",			"fi",				"fi"		},
	{	'\257',	"fl",	"fl",			"fl",				"fl"		},

	{	'\260',	"(R)",	"\\'AE",		"(R)",				"&#174;"	},
	{	'\261',	"--",	"\\'96",		"--",				"&#150;"	},
	{	'\262',	"",		"\\'86",		"\\dag{}",			"&#134;"	},
	{	'\263',	"",		"\\'87",		"$\\ddagger$",		"&#135;"	},
	{	'\264',	"",		"\\'B7",		"\\.{ }",			"&#183;"	},
	{	'\265', "|",	"\\'A6",		"$\\mid$",			"&#166;"	},	/* broken-vertical-line */
	{	'\266',	"",		"\\'B6",		"\\P{}",			"&#182;"	},
	{	'\267',	"",		"\\'95",		"$\\bullet$",		"&#149;"	},

	{	'\270',	"",		"\\'B8",		"\\c{ }",			"&#184;"	},
	{	'\271',	"",		"\\'84",		"``",				"&#132;"	},
	{	'\272',	"",		"\\'94",		"''",				"&#148;"	},
	{	'\273',	">>",	"\\'BB",		"\">",				"&#187;"	},
	{	'\274',	"...",	"\\'85",		"\\ldots{}",		"&#133;"	},
	{	'\275',	"",		"\\'89",		"",					"&#137;"	},
	{	'\276',	"",		"\\'AC",		"$\\neg$",			"&#172;"	},
	{	'\277',	"?",	"\\'BF",		"?`",				"&#191;"	},

	{	'\300',	"",		"\\'B9",		"$^1$",				"&#185;"	},
	{	'\301',	"",		"\\'91",		"`",				"&#145;"	},
	{	'\302',	"",		"\\'92",		"'",				"&#146;"	},
	{	'\303',	"",		"\\'F7",		"\\^{ }",			"^"			},
	{	'\304',	"",		"~",			"\\~{ }",			"~"			},
	{	'\305',	"",		"",				"\\={ }",			""			},
	{	'\306',	"",		"",				"\\u{ }",			""			},
	{	'\307',	"",		"\\'B7",		"\\.{ }",			"&#183;"	},

	{	'\300',	"",		"\\'A8",		"\\\"{ }",			"&#168;"	},
	{	'\311', "",		"\\'B2",		"$^2$",				"&#178;"	},
	{	'\312',	"",		"\\'B0",		"$\\circ$",			"&#176;"	},
	{	'\313',	"",		"\\'B8",		"\\c{ }",			"&#184;"	},
	{	'\314', "",		"\\'B3",		"$^3$",				"&#179;"	},
	{	'\315',	"",		"{\\f2 \\'B2}",	"\\H{ }",			""			},
	{	'\316',	"",		"",				"",					""			},	/* <???> */
	{	'\317',	"",		"",				"\\v{ }",			""			},

	{	'\320',	"---",	"\\'97",		"---",				"&#151;"	},
	{	'\321',	"",		"\\'B1",		"$\\pm$",			"&#177;"	},
	{	'\322', "1/4",	"\\'BC",		"$\\frac{1}{4}$",	"&#188;"	},
	{	'\323', "1/2",	"\\'BD",		"$\\frac{1}{2}$",	"&#189;"	},
	{	'\324', "3/4",	"\\'BE",		"$\\frac{3}{4}$",	"&#180;"	},
	{	'\325',	"a",	"\\'E0",		"\\`{a}",			"&agrave;"	},
	{	'\326',	"a",	"\\'E1",		"\\'{a}",			"&aacute;"	},
	{	'\327',	"a",	"\\'E2",		"\\^{a}",			"&acirc;"	},

	{	'\330',	"a",	"\\'E3",		"\\~{a}",			"&atilde;"	},
	{	'\331',	"ae",	"\\'E4",		"{\\\"a}",			"&auml;"	},
	{	'\332',	"a",	"\\'E5",		"{\\aa}",			"&aring;"	},
	{	'\333',	"c",	"\\'E7",		"\\c{c}",			"&ccedil;"	},
	{	'\334',	"e",	"\\'E8",		"\\`{e}",			"&egrave;"	},
	{	'\335',	"e",	"\\'E9",		"\\'{e}",			"&eacute;"	},
	{	'\336',	"e",	"\\'EA",		"\\^{e}",			"&ecirc;"	},
	{	'\337',	"e",	"\\'EB",		"\\\"{e}",			"&euml;"	},

	{	'\340',	"i",	"\\'EC",		"\\`{i}",			"&igrave;"	},
	{	'\341',	"AE",	"\\'C6",		"{\\AE}",			"&AElig;"	},
	{	'\342',	"i",	"\\'ED",		"\\'{i}",			"&iacute;"	},
	{	'\343',	"",		"\\'AA",		"\\b{a}",			"&#170;"	},
	{	'\344',	"i",	"\\'EE",		"\\^{i}",			"&icirc;"	},
	{	'\345',	"i",	"\\'EF",		"\\\"{i}",			"&iuml;"	},
	{	'\346', "",		"\\'F0",		"",					"&#240;"	},	/* THORN */
	{	'\347',	"n",	"\\'F1",		"\\~{n}",			"&ntilde;"	},

	{	'\350',	"L",	"",				"",					""			}, /* L/ <???> */
	{	'\351',	"O",	"\\'D8",		"{\\O}",			"&Oslash;"	},
	{	'\352',	"OE",	"\\'8C",		"{\\OE}",			"&#140;"	},
	{	'\353', "",		"\\'BA",		"\\b{o}",			"&#186;"	},
	{	'\354',	"o",	"\\'F2",		"\\`{o}",			"&ograve;"	},
	{	'\355',	"o",	"\\'F3",		"\\'{o}",			"&oacute;"	},
	{	'\356',	"o",	"\\'F4",		"\\^{o}",			"&ocirc;"	},
	{	'\357',	"o",	"\\'F5",		"\\~{o}",			"&otilde;"	},

	{	'\360',	"oe",	"\\'F6",		"{\\\"o}",			"&ouml;"	},
	{	'\361',	"ae",	"\\'E6",		"{\\ae}",			"&aelig;"	},
	{	'\362',	"u",	"\\'F9",		"\\`{u}",			"&ugrave;"	},
	{	'\363',	"u",	"\\'FA",		"\\'{u}",			"&uacute;"	},
	{	'\364',	"u",	"\\'FB",		"\\^{u}",			"&ucirc;"	},
	{	'\365',	"i",	"i",			"i",				"i"			},	/* <???> */
	{	'\366',	"ue",	"\\'FC",		"{\\\"u}",			"&uuml;"	},
	{	'\367', "y",	"\\'FD",		"\\'{y}",			"&yacute;"	},

	{	'\370',	"l",	"",				"",					""			},	/* l/ <???> */
	{	'\371',	"o",	"\\'F8",		"{\\o}",			"&oslash;"	},
	{	'\372',	"oe",	"\\'9C",		"{\\oe}",			"&#156;"	},
	{	'\373',	"ss",	"\\'DF",		"{\\ss}",			"&szlig;"	},
	{	'\374',	"",		"",				"",					""			},
	{	'\375',	"y",	"\\'FF",		"\\\"{y}",			"&yuml;"	},
	{	'\376',	"",		"",				"",					""			},
	{	'\377',	"",		"",				"",					""			},
};

/*	------------------------------------------------------------	*/

/*	############################################################
	# universellen Zeichensatz in ASCII-Zeichensatz umsetzen
	############################################################	*/
typedef struct _uni2systab
{
	char			uni[8];
	unsigned char	system[2];
}	UNI2SYSTAB;

#define	UNI2SYSTABSIZE	64

LOCAL const UNI2SYSTAB uni2sys[UNI2SYSTABSIZE]=
{
	{	"(!\"a)",	"\331"	},
	{	"(!\"e)",	"\337"	},
	{	"(!\"i)",	"\345"	},
	{	"(!\"o)",	"\360"	},
	{	"(!\"u)",	"\366"	},
	{	"(!\"y)",	"\375"	},
	{	"(!\"s)",	"\373"	},
	{	"(!\"A)",	"\205"	},
	{	"(!\"E)",	"\213"	},
	{	"(!\"I)",	"\217"	},
	{	"(!\"O)",	"\226"	},
	{	"(!\"U)",	"\232"	},
	{	"(!\"Y)",	"Y"		},	/* 13 */

	{	"(!'a)",	"\326"	},
	{	"(!'e)",	"\335"	},
	{	"(!'i)",	"\342"	},
	{	"(!'o)",	"\355"	},
	{	"(!'u)",	"\363"	},
	{	"(!'y)",	"\367"	},
	{	"(!'A)",	"\202"	},
	{	"(!'E)",	"\211"	},
	{	"(!'I)",	"\215"	},
	{	"(!'O)",	"\223"	},
	{	"(!'U)",	"\230"	},
	{	"(!'Y)",	"\233"	},	/* 12 */

	{	"(!`a)",	"\325"	},
	{	"(!`e)",	"\334"	},
	{	"(!`i)",	"\340"	},
	{	"(!`o)",	"\354"	},
	{	"(!`u)",	"\362"	},
	{	"(!`A)",	"\201"	},
	{	"(!`E)",	"\210"	},
	{	"(!`I)",	"\214"	},
	{	"(!`O)",	"\222"	},
	{	"(!`U)",	"\227"	},	/* 10 */

	{	"(!^a)",	"\327"	},
	{	"(!^e)",	"\336"	},
	{	"(!^i)",	"\344"	},
	{	"(!^o)",	"\356"	},
	{	"(!^u)",	"\364"	},
	{	"(!^A)",	"\203"	},
	{	"(!^E)",	"\212"	},
	{	"(!^I)",	"\216"	},
	{	"(!^O)",	"\224"	},
	{	"(!^U)",	"\231"	},	/* 10 */

	{	"(!~a)",	"\330"	},
	{	"(!~n)",	"\347"	},
	{	"(!~o)",	"\357"	},
	{	"(!~A)",	"\204"	},
	{	"(!~N)",	"\221"	},
	{	"(!~O)",	"\225"	},	/*  6 */

	{	"(!.a)",	"\332"	},
	{	"(!.A)",	"\206"	},	/*  2 */

	{	"(!&ae)",	"\361"	},
	{	"(!&AE)",	"\341"	},
	{	"(!&oe)",	"\372"	},
	{	"(!&OE)",	"\352"	},	/*  4 */

	{	"(!,c)",	"\333"	},
	{	"(!,C)",	"\207"	},	/*  2 */

	{	"(!_a)",	"\343"	},
	{	"(!_o)",	"\353"	},	/*  2 */

	{	"(!\\o)",	"\371"	},
	{	"(!\\O)",	"\351"	},	/*  2 */

	{	"(!#S)",	"\235"	},
};


/*	############################################################
	# chr_next.h
	############################################################	*/
