/*---------------------------------------------------------------------------*\

    FILE....: threads.cpp
    TYPE....: Win32 C Functions
    AUTHOR..: David Rowe
    DATE....: 26/2/02

    This module enables the VPB test programs to be compiled
    under Unix or Win32 using the same (unix) pthread function calls.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <windows.h>
#include <process.h>
#include "threads.h"

void pthread_mutex_init(pthread_mutex_t *mutex, void *arg2) {
	CRITICAL_SECTION *crit;

	crit = new CRITICAL_SECTION;
	assert(crit != NULL);
	InitializeCriticalSection(crit);
	mutex->v = crit;
}

void pthread_mutex_destroy(pthread_mutex_t *mutex) {
	CRITICAL_SECTION *crit = (CRITICAL_SECTION*)mutex->v;
	DeleteCriticalSection(crit);
	delete crit;
}

void pthread_mutex_lock(pthread_mutex_t *mutex) {
	CRITICAL_SECTION *crit = (CRITICAL_SECTION*)mutex->v;
	EnterCriticalSection(crit);
}

void pthread_mutex_unlock(pthread_mutex_t *mutex) {
	CRITICAL_SECTION *crit = (CRITICAL_SECTION*)mutex->v;
	LeaveCriticalSection(crit);
}

void pthread_create(pthread_t *athrd, void *arg2, void*(*func)(void*), void *data)
{
	_beginthread((void(*)(void*))func, 0, data);
	athrd->v = NULL;
}

void pthread_detach()
{	//pthread_detach(pthread_self());
	_endthread();
}